#include "encoding_japanese.h"

#include "core/encoding.h"
#include "core/image.h"
#include "core/log.h"

#include <stdlib.h>
#include <string.h>

#define HALF_WIDTH_START 0
#define NUM_HALF_WIDTH 63
#define FULL_WIDTH_START NUM_HALF_WIDTH

typedef struct {
    uint16_t cp932;
    uint8_t utf8[3];
} japanese_entry;

typedef struct {
    uint16_t cp932;
    int image_id;
} japanese_image_entry;

static const japanese_entry codepage_to_utf8[] = {
    {0x8140, {0xe3, 0x80, 0x80}},
    {0x8141, {0xe3, 0x80, 0x81}},
    {0x8142, {0xe3, 0x80, 0x82}},
    {0x8143, {0xef, 0xbc, 0x8c}},
    {0x8144, {0xef, 0xbc, 0x8e}},
    {0x8145, {0xe3, 0x83, 0xbb}},
    {0x8146, {0xef, 0xbc, 0x9a}},
    {0x8147, {0xef, 0xbc, 0x9b}},
    {0x8148, {0xef, 0xbc, 0x9f}},
    {0x8149, {0xef, 0xbc, 0x81}},
    {0x814a, {0xe3, 0x82, 0x9b}},
    {0x814b, {0xe3, 0x82, 0x9c}},
    {0x814c, {0xc2, 0xb4, 0x0}},
    {0x814d, {0xef, 0xbd, 0x80}},
    {0x814e, {0xc2, 0xa8, 0x0}},
    {0x814f, {0xef, 0xbc, 0xbe}},
    {0x8150, {0xef, 0xbf, 0xa3}},
    {0x8151, {0xef, 0xbc, 0xbf}},
    {0x8152, {0xe3, 0x83, 0xbd}},
    {0x8153, {0xe3, 0x83, 0xbe}},
    {0x8154, {0xe3, 0x82, 0x9d}},
    {0x8155, {0xe3, 0x82, 0x9e}},
    {0x8156, {0xe3, 0x80, 0x83}},
    {0x8157, {0xe4, 0xbb, 0x9d}},
    {0x8158, {0xe3, 0x80, 0x85}},
    {0x8159, {0xe3, 0x80, 0x86}},
    {0x815a, {0xe3, 0x80, 0x87}},
    {0x815b, {0xe3, 0x83, 0xbc}},
    {0x815c, {0xe2, 0x80, 0x95}},
    {0x815d, {0xe2, 0x80, 0x90}},
    {0x815e, {0xef, 0xbc, 0x8f}},
    {0x815f, {0xef, 0xbc, 0xbc}},
    {0x8160, {0xef, 0xbd, 0x9e}},
    {0x8161, {0xe2, 0x88, 0xa5}},
    {0x8162, {0xef, 0xbd, 0x9c}},
    {0x8163, {0xe2, 0x80, 0xa6}},
    {0x8164, {0xe2, 0x80, 0xa5}},
    {0x8165, {0xe2, 0x80, 0x98}},
    {0x8166, {0xe2, 0x80, 0x99}},
    {0x8167, {0xe2, 0x80, 0x9c}},
    {0x8168, {0xe2, 0x80, 0x9d}},
    {0x8169, {0xef, 0xbc, 0x88}},
    {0x816a, {0xef, 0xbc, 0x89}},
    {0x816b, {0xe3, 0x80, 0x94}},
    {0x816c, {0xe3, 0x80, 0x95}},
    {0x816d, {0xef, 0xbc, 0xbb}},
    {0x816e, {0xef, 0xbc, 0xbd}},
    {0x816f, {0xef, 0xbd, 0x9b}},
    {0x8170, {0xef, 0xbd, 0x9d}},
    {0x8171, {0xe3, 0x80, 0x88}},
    {0x8172, {0xe3, 0x80, 0x89}},
    {0x8173, {0xe3, 0x80, 0x8a}},
    {0x8174, {0xe3, 0x80, 0x8b}},
    {0x8175, {0xe3, 0x80, 0x8c}},
    {0x8176, {0xe3, 0x80, 0x8d}},
    {0x8177, {0xe3, 0x80, 0x8e}},
    {0x8178, {0xe3, 0x80, 0x8f}},
    {0x8179, {0xe3, 0x80, 0x90}},
    {0x817a, {0xe3, 0x80, 0x91}},
    {0x817b, {0xef, 0xbc, 0x8b}},
    {0x817c, {0xef, 0xbc, 0x8d}},
    {0x817d, {0xc2, 0xb1, 0x0}},
    {0x817e, {0xc3, 0x97, 0x0}},
    {0x8180, {0xc3, 0xb7, 0x0}},
    {0x8181, {0xef, 0xbc, 0x9d}},
    {0x8182, {0xe2, 0x89, 0xa0}},
    {0x8183, {0xef, 0xbc, 0x9c}},
    {0x8184, {0xef, 0xbc, 0x9e}},
    {0x8185, {0xe2, 0x89, 0xa6}},
    {0x8186, {0xe2, 0x89, 0xa7}},
    {0x8187, {0xe2, 0x88, 0x9e}},
    {0x8188, {0xe2, 0x88, 0xb4}},
    {0x8189, {0xe2, 0x99, 0x82}},
    {0x818a, {0xe2, 0x99, 0x80}},
    {0x818b, {0xc2, 0xb0, 0x0}},
    {0x818c, {0xe2, 0x80, 0xb2}},
    {0x818d, {0xe2, 0x80, 0xb3}},
    {0x818e, {0xe2, 0x84, 0x83}},
    {0x818f, {0xef, 0xbf, 0xa5}},
    {0x8190, {0xef, 0xbc, 0x84}},
    {0x8191, {0xef, 0xbf, 0xa0}},
    {0x8192, {0xef, 0xbf, 0xa1}},
    {0x8193, {0xef, 0xbc, 0x85}},
    {0x8194, {0xef, 0xbc, 0x83}},
    {0x8195, {0xef, 0xbc, 0x86}},
    {0x8196, {0xef, 0xbc, 0x8a}},
    {0x8197, {0xef, 0xbc, 0xa0}},
    {0x8198, {0xc2, 0xa7, 0x0}},
    {0x8199, {0xe2, 0x98, 0x86}},
    {0x819a, {0xe2, 0x98, 0x85}},
    {0x819b, {0xe2, 0x97, 0x8b}},
    {0x819c, {0xe2, 0x97, 0x8f}},
    {0x819d, {0xe2, 0x97, 0x8e}},
    {0x819e, {0xe2, 0x97, 0x87}},
    {0x819f, {0xe2, 0x97, 0x86}},
    {0x81a0, {0xe2, 0x96, 0xa1}},
    {0x81a1, {0xe2, 0x96, 0xa0}},
    {0x81a2, {0xe2, 0x96, 0xb3}},
    {0x81a3, {0xe2, 0x96, 0xb2}},
    {0x81a4, {0xe2, 0x96, 0xbd}},
    {0x81a5, {0xe2, 0x96, 0xbc}},
    {0x81a6, {0xe2, 0x80, 0xbb}},
    {0x81a7, {0xe3, 0x80, 0x92}},
    {0x81a8, {0xe2, 0x86, 0x92}},
    {0x81a9, {0xe2, 0x86, 0x90}},
    {0x81aa, {0xe2, 0x86, 0x91}},
    {0x81ab, {0xe2, 0x86, 0x93}},
    {0x81ac, {0xe3, 0x80, 0x93}},
    {0x81b8, {0xe2, 0x88, 0x88}},
    {0x81b9, {0xe2, 0x88, 0x8b}},
    {0x81ba, {0xe2, 0x8a, 0x86}},
    {0x81bb, {0xe2, 0x8a, 0x87}},
    {0x81bc, {0xe2, 0x8a, 0x82}},
    {0x81bd, {0xe2, 0x8a, 0x83}},
    {0x81be, {0xe2, 0x88, 0xaa}},
    {0x81bf, {0xe2, 0x88, 0xa9}},
    {0x81c8, {0xe2, 0x88, 0xa7}},
    {0x81c9, {0xe2, 0x88, 0xa8}},
    {0x81ca, {0xef, 0xbf, 0xa2}},
    {0x81cb, {0xe2, 0x87, 0x92}},
    {0x81cc, {0xe2, 0x87, 0x94}},
    {0x81cd, {0xe2, 0x88, 0x80}},
    {0x81ce, {0xe2, 0x88, 0x83}},
    {0x81da, {0xe2, 0x88, 0xa0}},
    {0x81db, {0xe2, 0x8a, 0xa5}},
    {0x81dc, {0xe2, 0x8c, 0x92}},
    {0x81dd, {0xe2, 0x88, 0x82}},
    {0x81de, {0xe2, 0x88, 0x87}},
    {0x81df, {0xe2, 0x89, 0xa1}},
    {0x81e0, {0xe2, 0x89, 0x92}},
    {0x81e1, {0xe2, 0x89, 0xaa}},
    {0x81e2, {0xe2, 0x89, 0xab}},
    {0x81e3, {0xe2, 0x88, 0x9a}},
    {0x81e4, {0xe2, 0x88, 0xbd}},
    {0x81e5, {0xe2, 0x88, 0x9d}},
    {0x81e6, {0xe2, 0x88, 0xb5}},
    {0x81e7, {0xe2, 0x88, 0xab}},
    {0x81e8, {0xe2, 0x88, 0xac}},
    {0x81f0, {0xe2, 0x84, 0xab}},
    {0x81f1, {0xe2, 0x80, 0xb0}},
    {0x81f2, {0xe2, 0x99, 0xaf}},
    {0x81f3, {0xe2, 0x99, 0xad}},
    {0x81f4, {0xe2, 0x99, 0xaa}},
    {0x81f5, {0xe2, 0x80, 0xa0}},
    {0x81f6, {0xe2, 0x80, 0xa1}},
    {0x81f7, {0xc2, 0xb6, 0x0}},
    {0x81fc, {0xe2, 0x97, 0xaf}},
    {0x824f, {0xef, 0xbc, 0x90}},
    {0x8250, {0xef, 0xbc, 0x91}},
    {0x8251, {0xef, 0xbc, 0x92}},
    {0x8252, {0xef, 0xbc, 0x93}},
    {0x8253, {0xef, 0xbc, 0x94}},
    {0x8254, {0xef, 0xbc, 0x95}},
    {0x8255, {0xef, 0xbc, 0x96}},
    {0x8256, {0xef, 0xbc, 0x97}},
    {0x8257, {0xef, 0xbc, 0x98}},
    {0x8258, {0xef, 0xbc, 0x99}},
    {0x8260, {0xef, 0xbc, 0xa1}},
    {0x8261, {0xef, 0xbc, 0xa2}},
    {0x8262, {0xef, 0xbc, 0xa3}},
    {0x8263, {0xef, 0xbc, 0xa4}},
    {0x8264, {0xef, 0xbc, 0xa5}},
    {0x8265, {0xef, 0xbc, 0xa6}},
    {0x8266, {0xef, 0xbc, 0xa7}},
    {0x8267, {0xef, 0xbc, 0xa8}},
    {0x8268, {0xef, 0xbc, 0xa9}},
    {0x8269, {0xef, 0xbc, 0xaa}},
    {0x826a, {0xef, 0xbc, 0xab}},
    {0x826b, {0xef, 0xbc, 0xac}},
    {0x826c, {0xef, 0xbc, 0xad}},
    {0x826d, {0xef, 0xbc, 0xae}},
    {0x826e, {0xef, 0xbc, 0xaf}},
    {0x826f, {0xef, 0xbc, 0xb0}},
    {0x8270, {0xef, 0xbc, 0xb1}},
    {0x8271, {0xef, 0xbc, 0xb2}},
    {0x8272, {0xef, 0xbc, 0xb3}},
    {0x8273, {0xef, 0xbc, 0xb4}},
    {0x8274, {0xef, 0xbc, 0xb5}},
    {0x8275, {0xef, 0xbc, 0xb6}},
    {0x8276, {0xef, 0xbc, 0xb7}},
    {0x8277, {0xef, 0xbc, 0xb8}},
    {0x8278, {0xef, 0xbc, 0xb9}},
    {0x8279, {0xef, 0xbc, 0xba}},
    {0x8281, {0xef, 0xbd, 0x81}},
    {0x8282, {0xef, 0xbd, 0x82}},
    {0x8283, {0xef, 0xbd, 0x83}},
    {0x8284, {0xef, 0xbd, 0x84}},
    {0x8285, {0xef, 0xbd, 0x85}},
    {0x8286, {0xef, 0xbd, 0x86}},
    {0x8287, {0xef, 0xbd, 0x87}},
    {0x8288, {0xef, 0xbd, 0x88}},
    {0x8289, {0xef, 0xbd, 0x89}},
    {0x828a, {0xef, 0xbd, 0x8a}},
    {0x828b, {0xef, 0xbd, 0x8b}},
    {0x828c, {0xef, 0xbd, 0x8c}},
    {0x828d, {0xef, 0xbd, 0x8d}},
    {0x828e, {0xef, 0xbd, 0x8e}},
    {0x828f, {0xef, 0xbd, 0x8f}},
    {0x8290, {0xef, 0xbd, 0x90}},
    {0x8291, {0xef, 0xbd, 0x91}},
    {0x8292, {0xef, 0xbd, 0x92}},
    {0x8293, {0xef, 0xbd, 0x93}},
    {0x8294, {0xef, 0xbd, 0x94}},
    {0x8295, {0xef, 0xbd, 0x95}},
    {0x8296, {0xef, 0xbd, 0x96}},
    {0x8297, {0xef, 0xbd, 0x97}},
    {0x8298, {0xef, 0xbd, 0x98}},
    {0x8299, {0xef, 0xbd, 0x99}},
    {0x829a, {0xef, 0xbd, 0x9a}},
    {0x829f, {0xe3, 0x81, 0x81}},
    {0x82a0, {0xe3, 0x81, 0x82}},
    {0x82a1, {0xe3, 0x81, 0x83}},
    {0x82a2, {0xe3, 0x81, 0x84}},
    {0x82a3, {0xe3, 0x81, 0x85}},
    {0x82a4, {0xe3, 0x81, 0x86}},
    {0x82a5, {0xe3, 0x81, 0x87}},
    {0x82a6, {0xe3, 0x81, 0x88}},
    {0x82a7, {0xe3, 0x81, 0x89}},
    {0x82a8, {0xe3, 0x81, 0x8a}},
    {0x82a9, {0xe3, 0x81, 0x8b}},
    {0x82aa, {0xe3, 0x81, 0x8c}},
    {0x82ab, {0xe3, 0x81, 0x8d}},
    {0x82ac, {0xe3, 0x81, 0x8e}},
    {0x82ad, {0xe3, 0x81, 0x8f}},
    {0x82ae, {0xe3, 0x81, 0x90}},
    {0x82af, {0xe3, 0x81, 0x91}},
    {0x82b0, {0xe3, 0x81, 0x92}},
    {0x82b1, {0xe3, 0x81, 0x93}},
    {0x82b2, {0xe3, 0x81, 0x94}},
    {0x82b3, {0xe3, 0x81, 0x95}},
    {0x82b4, {0xe3, 0x81, 0x96}},
    {0x82b5, {0xe3, 0x81, 0x97}},
    {0x82b6, {0xe3, 0x81, 0x98}},
    {0x82b7, {0xe3, 0x81, 0x99}},
    {0x82b8, {0xe3, 0x81, 0x9a}},
    {0x82b9, {0xe3, 0x81, 0x9b}},
    {0x82ba, {0xe3, 0x81, 0x9c}},
    {0x82bb, {0xe3, 0x81, 0x9d}},
    {0x82bc, {0xe3, 0x81, 0x9e}},
    {0x82bd, {0xe3, 0x81, 0x9f}},
    {0x82be, {0xe3, 0x81, 0xa0}},
    {0x82bf, {0xe3, 0x81, 0xa1}},
    {0x82c0, {0xe3, 0x81, 0xa2}},
    {0x82c1, {0xe3, 0x81, 0xa3}},
    {0x82c2, {0xe3, 0x81, 0xa4}},
    {0x82c3, {0xe3, 0x81, 0xa5}},
    {0x82c4, {0xe3, 0x81, 0xa6}},
    {0x82c5, {0xe3, 0x81, 0xa7}},
    {0x82c6, {0xe3, 0x81, 0xa8}},
    {0x82c7, {0xe3, 0x81, 0xa9}},
    {0x82c8, {0xe3, 0x81, 0xaa}},
    {0x82c9, {0xe3, 0x81, 0xab}},
    {0x82ca, {0xe3, 0x81, 0xac}},
    {0x82cb, {0xe3, 0x81, 0xad}},
    {0x82cc, {0xe3, 0x81, 0xae}},
    {0x82cd, {0xe3, 0x81, 0xaf}},
    {0x82ce, {0xe3, 0x81, 0xb0}},
    {0x82cf, {0xe3, 0x81, 0xb1}},
    {0x82d0, {0xe3, 0x81, 0xb2}},
    {0x82d1, {0xe3, 0x81, 0xb3}},
    {0x82d2, {0xe3, 0x81, 0xb4}},
    {0x82d3, {0xe3, 0x81, 0xb5}},
    {0x82d4, {0xe3, 0x81, 0xb6}},
    {0x82d5, {0xe3, 0x81, 0xb7}},
    {0x82d6, {0xe3, 0x81, 0xb8}},
    {0x82d7, {0xe3, 0x81, 0xb9}},
    {0x82d8, {0xe3, 0x81, 0xba}},
    {0x82d9, {0xe3, 0x81, 0xbb}},
    {0x82da, {0xe3, 0x81, 0xbc}},
    {0x82db, {0xe3, 0x81, 0xbd}},
    {0x82dc, {0xe3, 0x81, 0xbe}},
    {0x82dd, {0xe3, 0x81, 0xbf}},
    {0x82de, {0xe3, 0x82, 0x80}},
    {0x82df, {0xe3, 0x82, 0x81}},
    {0x82e0, {0xe3, 0x82, 0x82}},
    {0x82e1, {0xe3, 0x82, 0x83}},
    {0x82e2, {0xe3, 0x82, 0x84}},
    {0x82e3, {0xe3, 0x82, 0x85}},
    {0x82e4, {0xe3, 0x82, 0x86}},
    {0x82e5, {0xe3, 0x82, 0x87}},
    {0x82e6, {0xe3, 0x82, 0x88}},
    {0x82e7, {0xe3, 0x82, 0x89}},
    {0x82e8, {0xe3, 0x82, 0x8a}},
    {0x82e9, {0xe3, 0x82, 0x8b}},
    {0x82ea, {0xe3, 0x82, 0x8c}},
    {0x82eb, {0xe3, 0x82, 0x8d}},
    {0x82ec, {0xe3, 0x82, 0x8e}},
    {0x82ed, {0xe3, 0x82, 0x8f}},
    {0x82ee, {0xe3, 0x82, 0x90}},
    {0x82ef, {0xe3, 0x82, 0x91}},
    {0x82f0, {0xe3, 0x82, 0x92}},
    {0x82f1, {0xe3, 0x82, 0x93}},
    {0x8340, {0xe3, 0x82, 0xa1}},
    {0x8341, {0xe3, 0x82, 0xa2}},
    {0x8342, {0xe3, 0x82, 0xa3}},
    {0x8343, {0xe3, 0x82, 0xa4}},
    {0x8344, {0xe3, 0x82, 0xa5}},
    {0x8345, {0xe3, 0x82, 0xa6}},
    {0x8346, {0xe3, 0x82, 0xa7}},
    {0x8347, {0xe3, 0x82, 0xa8}},
    {0x8348, {0xe3, 0x82, 0xa9}},
    {0x8349, {0xe3, 0x82, 0xaa}},
    {0x834a, {0xe3, 0x82, 0xab}},
    {0x834b, {0xe3, 0x82, 0xac}},
    {0x834c, {0xe3, 0x82, 0xad}},
    {0x834d, {0xe3, 0x82, 0xae}},
    {0x834e, {0xe3, 0x82, 0xaf}},
    {0x834f, {0xe3, 0x82, 0xb0}},
    {0x8350, {0xe3, 0x82, 0xb1}},
    {0x8351, {0xe3, 0x82, 0xb2}},
    {0x8352, {0xe3, 0x82, 0xb3}},
    {0x8353, {0xe3, 0x82, 0xb4}},
    {0x8354, {0xe3, 0x82, 0xb5}},
    {0x8355, {0xe3, 0x82, 0xb6}},
    {0x8356, {0xe3, 0x82, 0xb7}},
    {0x8357, {0xe3, 0x82, 0xb8}},
    {0x8358, {0xe3, 0x82, 0xb9}},
    {0x8359, {0xe3, 0x82, 0xba}},
    {0x835a, {0xe3, 0x82, 0xbb}},
    {0x835b, {0xe3, 0x82, 0xbc}},
    {0x835c, {0xe3, 0x82, 0xbd}},
    {0x835d, {0xe3, 0x82, 0xbe}},
    {0x835e, {0xe3, 0x82, 0xbf}},
    {0x835f, {0xe3, 0x83, 0x80}},
    {0x8360, {0xe3, 0x83, 0x81}},
    {0x8361, {0xe3, 0x83, 0x82}},
    {0x8362, {0xe3, 0x83, 0x83}},
    {0x8363, {0xe3, 0x83, 0x84}},
    {0x8364, {0xe3, 0x83, 0x85}},
    {0x8365, {0xe3, 0x83, 0x86}},
    {0x8366, {0xe3, 0x83, 0x87}},
    {0x8367, {0xe3, 0x83, 0x88}},
    {0x8368, {0xe3, 0x83, 0x89}},
    {0x8369, {0xe3, 0x83, 0x8a}},
    {0x836a, {0xe3, 0x83, 0x8b}},
    {0x836b, {0xe3, 0x83, 0x8c}},
    {0x836c, {0xe3, 0x83, 0x8d}},
    {0x836d, {0xe3, 0x83, 0x8e}},
    {0x836e, {0xe3, 0x83, 0x8f}},
    {0x836f, {0xe3, 0x83, 0x90}},
    {0x8370, {0xe3, 0x83, 0x91}},
    {0x8371, {0xe3, 0x83, 0x92}},
    {0x8372, {0xe3, 0x83, 0x93}},
    {0x8373, {0xe3, 0x83, 0x94}},
    {0x8374, {0xe3, 0x83, 0x95}},
    {0x8375, {0xe3, 0x83, 0x96}},
    {0x8376, {0xe3, 0x83, 0x97}},
    {0x8377, {0xe3, 0x83, 0x98}},
    {0x8378, {0xe3, 0x83, 0x99}},
    {0x8379, {0xe3, 0x83, 0x9a}},
    {0x837a, {0xe3, 0x83, 0x9b}},
    {0x837b, {0xe3, 0x83, 0x9c}},
    {0x837c, {0xe3, 0x83, 0x9d}},
    {0x837d, {0xe3, 0x83, 0x9e}},
    {0x837e, {0xe3, 0x83, 0x9f}},
    {0x8380, {0xe3, 0x83, 0xa0}},
    {0x8381, {0xe3, 0x83, 0xa1}},
    {0x8382, {0xe3, 0x83, 0xa2}},
    {0x8383, {0xe3, 0x83, 0xa3}},
    {0x8384, {0xe3, 0x83, 0xa4}},
    {0x8385, {0xe3, 0x83, 0xa5}},
    {0x8386, {0xe3, 0x83, 0xa6}},
    {0x8387, {0xe3, 0x83, 0xa7}},
    {0x8388, {0xe3, 0x83, 0xa8}},
    {0x8389, {0xe3, 0x83, 0xa9}},
    {0x838a, {0xe3, 0x83, 0xaa}},
    {0x838b, {0xe3, 0x83, 0xab}},
    {0x838c, {0xe3, 0x83, 0xac}},
    {0x838d, {0xe3, 0x83, 0xad}},
    {0x838e, {0xe3, 0x83, 0xae}},
    {0x838f, {0xe3, 0x83, 0xaf}},
    {0x8390, {0xe3, 0x83, 0xb0}},
    {0x8391, {0xe3, 0x83, 0xb1}},
    {0x8392, {0xe3, 0x83, 0xb2}},
    {0x8393, {0xe3, 0x83, 0xb3}},
    {0x8394, {0xe3, 0x83, 0xb4}},
    {0x8395, {0xe3, 0x83, 0xb5}},
    {0x8396, {0xe3, 0x83, 0xb6}},
    {0x8740, {0xe2, 0x91, 0xa0}},
    {0x8741, {0xe2, 0x91, 0xa1}},
    {0x8742, {0xe2, 0x91, 0xa2}},
    {0x8743, {0xe2, 0x91, 0xa3}},
    {0x8744, {0xe2, 0x91, 0xa4}},
    {0x8745, {0xe2, 0x91, 0xa5}},
    {0x8746, {0xe2, 0x91, 0xa6}},
    {0x8747, {0xe2, 0x91, 0xa7}},
    {0x8748, {0xe2, 0x91, 0xa8}},
    {0x8749, {0xe2, 0x91, 0xa9}},
    {0x874a, {0xe2, 0x91, 0xaa}},
    {0x874b, {0xe2, 0x91, 0xab}},
    {0x874c, {0xe2, 0x91, 0xac}},
    {0x874d, {0xe2, 0x91, 0xad}},
    {0x874e, {0xe2, 0x91, 0xae}},
    {0x874f, {0xe2, 0x91, 0xaf}},
    {0x8750, {0xe2, 0x91, 0xb0}},
    {0x8751, {0xe2, 0x91, 0xb1}},
    {0x8752, {0xe2, 0x91, 0xb2}},
    {0x8753, {0xe2, 0x91, 0xb3}},
    {0x8754, {0xe2, 0x85, 0xa0}},
    {0x8755, {0xe2, 0x85, 0xa1}},
    {0x8756, {0xe2, 0x85, 0xa2}},
    {0x8757, {0xe2, 0x85, 0xa3}},
    {0x8758, {0xe2, 0x85, 0xa4}},
    {0x8759, {0xe2, 0x85, 0xa5}},
    {0x875a, {0xe2, 0x85, 0xa6}},
    {0x875b, {0xe2, 0x85, 0xa7}},
    {0x875c, {0xe2, 0x85, 0xa8}},
    {0x875d, {0xe2, 0x85, 0xa9}},
    {0x875f, {0xe3, 0x8d, 0x89}},
    {0x8760, {0xe3, 0x8c, 0x94}},
    {0x8761, {0xe3, 0x8c, 0xa2}},
    {0x8762, {0xe3, 0x8d, 0x8d}},
    {0x8763, {0xe3, 0x8c, 0x98}},
    {0x8764, {0xe3, 0x8c, 0xa7}},
    {0x8765, {0xe3, 0x8c, 0x83}},
    {0x8766, {0xe3, 0x8c, 0xb6}},
    {0x8767, {0xe3, 0x8d, 0x91}},
    {0x8768, {0xe3, 0x8d, 0x97}},
    {0x8769, {0xe3, 0x8c, 0x8d}},
    {0x876a, {0xe3, 0x8c, 0xa6}},
    {0x876b, {0xe3, 0x8c, 0xa3}},
    {0x876c, {0xe3, 0x8c, 0xab}},
    {0x876d, {0xe3, 0x8d, 0x8a}},
    {0x876e, {0xe3, 0x8c, 0xbb}},
    {0x876f, {0xe3, 0x8e, 0x9c}},
    {0x8770, {0xe3, 0x8e, 0x9d}},
    {0x8771, {0xe3, 0x8e, 0x9e}},
    {0x8772, {0xe3, 0x8e, 0x8e}},
    {0x8773, {0xe3, 0x8e, 0x8f}},
    {0x8774, {0xe3, 0x8f, 0x84}},
    {0x8775, {0xe3, 0x8e, 0xa1}},
    {0x877e, {0xe3, 0x8d, 0xbb}},
    {0x8780, {0xe3, 0x80, 0x9d}},
    {0x8781, {0xe3, 0x80, 0x9f}},
    {0x8782, {0xe2, 0x84, 0x96}},
    {0x8783, {0xe3, 0x8f, 0x8d}},
    {0x8784, {0xe2, 0x84, 0xa1}},
    {0x8785, {0xe3, 0x8a, 0xa4}},
    {0x8786, {0xe3, 0x8a, 0xa5}},
    {0x8787, {0xe3, 0x8a, 0xa6}},
    {0x8788, {0xe3, 0x8a, 0xa7}},
    {0x8789, {0xe3, 0x8a, 0xa8}},
    {0x878a, {0xe3, 0x88, 0xb1}},
    {0x878b, {0xe3, 0x88, 0xb2}},
    {0x878c, {0xe3, 0x88, 0xb9}},
    {0x878d, {0xe3, 0x8d, 0xbe}},
    {0x878e, {0xe3, 0x8d, 0xbd}},
    {0x878f, {0xe3, 0x8d, 0xbc}},
    {0x8790, {0xe2, 0x89, 0x92}},
    {0x8791, {0xe2, 0x89, 0xa1}},
    {0x8792, {0xe2, 0x88, 0xab}},
    {0x8793, {0xe2, 0x88, 0xae}},
    {0x8794, {0xe2, 0x88, 0x91}},
    {0x8795, {0xe2, 0x88, 0x9a}},
    {0x8796, {0xe2, 0x8a, 0xa5}},
    {0x8797, {0xe2, 0x88, 0xa0}},
    {0x8798, {0xe2, 0x88, 0x9f}},
    {0x8799, {0xe2, 0x8a, 0xbf}},
    {0x879a, {0xe2, 0x88, 0xb5}},
    {0x879b, {0xe2, 0x88, 0xa9}},
    {0x879c, {0xe2, 0x88, 0xaa}},
    {0x889f, {0xe4, 0xba, 0x9c}},
    {0x88a0, {0xe5, 0x94, 0x96}},
    {0x88a1, {0xe5, 0xa8, 0x83}},
    {0x88a2, {0xe9, 0x98, 0xbf}},
    {0x88a3, {0xe5, 0x93, 0x80}},
    {0x88a4, {0xe6, 0x84, 0x9b}},
    {0x88a5, {0xe6, 0x8c, 0xa8}},
    {0x88a6, {0xe5, 0xa7, 0xb6}},
    {0x88a7, {0xe9, 0x80, 0xa2}},
    {0x88a8, {0xe8, 0x91, 0xb5}},
    {0x88a9, {0xe8, 0x8c, 0x9c}},
    {0x88aa, {0xe7, 0xa9, 0x90}},
    {0x88ab, {0xe6, 0x82, 0xaa}},
    {0x88ac, {0xe6, 0x8f, 0xa1}},
    {0x88ad, {0xe6, 0xb8, 0xa5}},
    {0x88ae, {0xe6, 0x97, 0xad}},
    {0x88af, {0xe8, 0x91, 0xa6}},
    {0x88b0, {0xe8, 0x8a, 0xa6}},
    {0x88b1, {0xe9, 0xaf, 0xb5}},
    {0x88b2, {0xe6, 0xa2, 0x93}},
    {0x88b3, {0xe5, 0x9c, 0xa7}},
    {0x88b4, {0xe6, 0x96, 0xa1}},
    {0x88b5, {0xe6, 0x89, 0xb1}},
    {0x88b6, {0xe5, 0xae, 0x9b}},
    {0x88b7, {0xe5, 0xa7, 0x90}},
    {0x88b8, {0xe8, 0x99, 0xbb}},
    {0x88b9, {0xe9, 0xa3, 0xb4}},
    {0x88ba, {0xe7, 0xb5, 0xa2}},
    {0x88bb, {0xe7, 0xb6, 0xbe}},
    {0x88bc, {0xe9, 0xae, 0x8e}},
    {0x88bd, {0xe6, 0x88, 0x96}},
    {0x88be, {0xe7, 0xb2, 0x9f}},
    {0x88bf, {0xe8, 0xa2, 0xb7}},
    {0x88c0, {0xe5, 0xae, 0x89}},
    {0x88c1, {0xe5, 0xba, 0xb5}},
    {0x88c2, {0xe6, 0x8c, 0x89}},
    {0x88c3, {0xe6, 0x9a, 0x97}},
    {0x88c4, {0xe6, 0xa1, 0x88}},
    {0x88c5, {0xe9, 0x97, 0x87}},
    {0x88c6, {0xe9, 0x9e, 0x8d}},
    {0x88c7, {0xe6, 0x9d, 0x8f}},
    {0x88c8, {0xe4, 0xbb, 0xa5}},
    {0x88c9, {0xe4, 0xbc, 0x8a}},
    {0x88ca, {0xe4, 0xbd, 0x8d}},
    {0x88cb, {0xe4, 0xbe, 0x9d}},
    {0x88cc, {0xe5, 0x81, 0x89}},
    {0x88cd, {0xe5, 0x9b, 0xb2}},
    {0x88ce, {0xe5, 0xa4, 0xb7}},
    {0x88cf, {0xe5, 0xa7, 0x94}},
    {0x88d0, {0xe5, 0xa8, 0x81}},
    {0x88d1, {0xe5, 0xb0, 0x89}},
    {0x88d2, {0xe6, 0x83, 0x9f}},
    {0x88d3, {0xe6, 0x84, 0x8f}},
    {0x88d4, {0xe6, 0x85, 0xb0}},
    {0x88d5, {0xe6, 0x98, 0x93}},
    {0x88d6, {0xe6, 0xa4, 0x85}},
    {0x88d7, {0xe7, 0x82, 0xba}},
    {0x88d8, {0xe7, 0x95, 0x8f}},
    {0x88d9, {0xe7, 0x95, 0xb0}},
    {0x88da, {0xe7, 0xa7, 0xbb}},
    {0x88db, {0xe7, 0xb6, 0xad}},
    {0x88dc, {0xe7, 0xb7, 0xaf}},
    {0x88dd, {0xe8, 0x83, 0x83}},
    {0x88de, {0xe8, 0x90, 0x8e}},
    {0x88df, {0xe8, 0xa1, 0xa3}},
    {0x88e0, {0xe8, 0xac, 0x82}},
    {0x88e1, {0xe9, 0x81, 0x95}},
    {0x88e2, {0xe9, 0x81, 0xba}},
    {0x88e3, {0xe5, 0x8c, 0xbb}},
    {0x88e4, {0xe4, 0xba, 0x95}},
    {0x88e5, {0xe4, 0xba, 0xa5}},
    {0x88e6, {0xe5, 0x9f, 0x9f}},
    {0x88e7, {0xe8, 0x82, 0xb2}},
    {0x88e8, {0xe9, 0x83, 0x81}},
    {0x88e9, {0xe7, 0xa3, 0xaf}},
    {0x88ea, {0xe4, 0xb8, 0x80}},
    {0x88eb, {0xe5, 0xa3, 0xb1}},
    {0x88ec, {0xe6, 0xba, 0xa2}},
    {0x88ed, {0xe9, 0x80, 0xb8}},
    {0x88ee, {0xe7, 0xa8, 0xb2}},
    {0x88ef, {0xe8, 0x8c, 0xa8}},
    {0x88f0, {0xe8, 0x8a, 0x8b}},
    {0x88f1, {0xe9, 0xb0, 0xaf}},
    {0x88f2, {0xe5, 0x85, 0x81}},
    {0x88f3, {0xe5, 0x8d, 0xb0}},
    {0x88f4, {0xe5, 0x92, 0xbd}},
    {0x88f5, {0xe5, 0x93, 0xa1}},
    {0x88f6, {0xe5, 0x9b, 0xa0}},
    {0x88f7, {0xe5, 0xa7, 0xbb}},
    {0x88f8, {0xe5, 0xbc, 0x95}},
    {0x88f9, {0xe9, 0xa3, 0xb2}},
    {0x88fa, {0xe6, 0xb7, 0xab}},
    {0x88fb, {0xe8, 0x83, 0xa4}},
    {0x88fc, {0xe8, 0x94, 0xad}},
    {0x8940, {0xe9, 0x99, 0xa2}},
    {0x8941, {0xe9, 0x99, 0xb0}},
    {0x8942, {0xe9, 0x9a, 0xa0}},
    {0x8943, {0xe9, 0x9f, 0xbb}},
    {0x8944, {0xe5, 0x90, 0x8b}},
    {0x8945, {0xe5, 0x8f, 0xb3}},
    {0x8946, {0xe5, 0xae, 0x87}},
    {0x8947, {0xe7, 0x83, 0x8f}},
    {0x8948, {0xe7, 0xbe, 0xbd}},
    {0x8949, {0xe8, 0xbf, 0x82}},
    {0x894a, {0xe9, 0x9b, 0xa8}},
    {0x894b, {0xe5, 0x8d, 0xaf}},
    {0x894c, {0xe9, 0xb5, 0x9c}},
    {0x894d, {0xe7, 0xaa, 0xba}},
    {0x894e, {0xe4, 0xb8, 0x91}},
    {0x894f, {0xe7, 0xa2, 0x93}},
    {0x8950, {0xe8, 0x87, 0xbc}},
    {0x8951, {0xe6, 0xb8, 0xa6}},
    {0x8952, {0xe5, 0x98, 0x98}},
    {0x8953, {0xe5, 0x94, 0x84}},
    {0x8954, {0xe6, 0xac, 0x9d}},
    {0x8955, {0xe8, 0x94, 0x9a}},
    {0x8956, {0xe9, 0xb0, 0xbb}},
    {0x8957, {0xe5, 0xa7, 0xa5}},
    {0x8958, {0xe5, 0x8e, 0xa9}},
    {0x8959, {0xe6, 0xb5, 0xa6}},
    {0x895a, {0xe7, 0x93, 0x9c}},
    {0x895b, {0xe9, 0x96, 0x8f}},
    {0x895c, {0xe5, 0x99, 0x82}},
    {0x895d, {0xe4, 0xba, 0x91}},
    {0x895e, {0xe9, 0x81, 0x8b}},
    {0x895f, {0xe9, 0x9b, 0xb2}},
    {0x8960, {0xe8, 0x8d, 0x8f}},
    {0x8961, {0xe9, 0xa4, 0x8c}},
    {0x8962, {0xe5, 0x8f, 0xa1}},
    {0x8963, {0xe5, 0x96, 0xb6}},
    {0x8964, {0xe5, 0xac, 0xb0}},
    {0x8965, {0xe5, 0xbd, 0xb1}},
    {0x8966, {0xe6, 0x98, 0xa0}},
    {0x8967, {0xe6, 0x9b, 0xb3}},
    {0x8968, {0xe6, 0xa0, 0x84}},
    {0x8969, {0xe6, 0xb0, 0xb8}},
    {0x896a, {0xe6, 0xb3, 0xb3}},
    {0x896b, {0xe6, 0xb4, 0xa9}},
    {0x896c, {0xe7, 0x91, 0x9b}},
    {0x896d, {0xe7, 0x9b, 0x88}},
    {0x896e, {0xe7, 0xa9, 0x8e}},
    {0x896f, {0xe9, 0xa0, 0xb4}},
    {0x8970, {0xe8, 0x8b, 0xb1}},
    {0x8971, {0xe8, 0xa1, 0x9b}},
    {0x8972, {0xe8, 0xa9, 0xa0}},
    {0x8973, {0xe9, 0x8b, 0xad}},
    {0x8974, {0xe6, 0xb6, 0xb2}},
    {0x8975, {0xe7, 0x96, 0xab}},
    {0x8976, {0xe7, 0x9b, 0x8a}},
    {0x8977, {0xe9, 0xa7, 0x85}},
    {0x8978, {0xe6, 0x82, 0xa6}},
    {0x8979, {0xe8, 0xac, 0x81}},
    {0x897a, {0xe8, 0xb6, 0x8a}},
    {0x897b, {0xe9, 0x96, 0xb2}},
    {0x897c, {0xe6, 0xa6, 0x8e}},
    {0x897d, {0xe5, 0x8e, 0xad}},
    {0x897e, {0xe5, 0x86, 0x86}},
    {0x8980, {0xe5, 0x9c, 0x92}},
    {0x8981, {0xe5, 0xa0, 0xb0}},
    {0x8982, {0xe5, 0xa5, 0x84}},
    {0x8983, {0xe5, 0xae, 0xb4}},
    {0x8984, {0xe5, 0xbb, 0xb6}},
    {0x8985, {0xe6, 0x80, 0xa8}},
    {0x8986, {0xe6, 0x8e, 0xa9}},
    {0x8987, {0xe6, 0x8f, 0xb4}},
    {0x8988, {0xe6, 0xb2, 0xbf}},
    {0x8989, {0xe6, 0xbc, 0x94}},
    {0x898a, {0xe7, 0x82, 0x8e}},
    {0x898b, {0xe7, 0x84, 0x94}},
    {0x898c, {0xe7, 0x85, 0x99}},
    {0x898d, {0xe7, 0x87, 0x95}},
    {0x898e, {0xe7, 0x8c, 0xbf}},
    {0x898f, {0xe7, 0xb8, 0x81}},
    {0x8990, {0xe8, 0x89, 0xb6}},
    {0x8991, {0xe8, 0x8b, 0x91}},
    {0x8992, {0xe8, 0x96, 0x97}},
    {0x8993, {0xe9, 0x81, 0xa0}},
    {0x8994, {0xe9, 0x89, 0x9b}},
    {0x8995, {0xe9, 0xb4, 0x9b}},
    {0x8996, {0xe5, 0xa1, 0xa9}},
    {0x8997, {0xe6, 0x96, 0xbc}},
    {0x8998, {0xe6, 0xb1, 0x9a}},
    {0x8999, {0xe7, 0x94, 0xa5}},
    {0x899a, {0xe5, 0x87, 0xb9}},
    {0x899b, {0xe5, 0xa4, 0xae}},
    {0x899c, {0xe5, 0xa5, 0xa5}},
    {0x899d, {0xe5, 0xbe, 0x80}},
    {0x899e, {0xe5, 0xbf, 0x9c}},
    {0x899f, {0xe6, 0x8a, 0xbc}},
    {0x89a0, {0xe6, 0x97, 0xba}},
    {0x89a1, {0xe6, 0xa8, 0xaa}},
    {0x89a2, {0xe6, 0xac, 0xa7}},
    {0x89a3, {0xe6, 0xae, 0xb4}},
    {0x89a4, {0xe7, 0x8e, 0x8b}},
    {0x89a5, {0xe7, 0xbf, 0x81}},
    {0x89a6, {0xe8, 0xa5, 0x96}},
    {0x89a7, {0xe9, 0xb4, 0xac}},
    {0x89a8, {0xe9, 0xb4, 0x8e}},
    {0x89a9, {0xe9, 0xbb, 0x84}},
    {0x89aa, {0xe5, 0xb2, 0xa1}},
    {0x89ab, {0xe6, 0xb2, 0x96}},
    {0x89ac, {0xe8, 0x8d, 0xbb}},
    {0x89ad, {0xe5, 0x84, 0x84}},
    {0x89ae, {0xe5, 0xb1, 0x8b}},
    {0x89af, {0xe6, 0x86, 0xb6}},
    {0x89b0, {0xe8, 0x87, 0x86}},
    {0x89b1, {0xe6, 0xa1, 0xb6}},
    {0x89b2, {0xe7, 0x89, 0xa1}},
    {0x89b3, {0xe4, 0xb9, 0x99}},
    {0x89b4, {0xe4, 0xbf, 0xba}},
    {0x89b5, {0xe5, 0x8d, 0xb8}},
    {0x89b6, {0xe6, 0x81, 0xa9}},
    {0x89b7, {0xe6, 0xb8, 0xa9}},
    {0x89b8, {0xe7, 0xa9, 0x8f}},
    {0x89b9, {0xe9, 0x9f, 0xb3}},
    {0x89ba, {0xe4, 0xb8, 0x8b}},
    {0x89bb, {0xe5, 0x8c, 0x96}},
    {0x89bc, {0xe4, 0xbb, 0xae}},
    {0x89bd, {0xe4, 0xbd, 0x95}},
    {0x89be, {0xe4, 0xbc, 0xbd}},
    {0x89bf, {0xe4, 0xbe, 0xa1}},
    {0x89c0, {0xe4, 0xbd, 0xb3}},
    {0x89c1, {0xe5, 0x8a, 0xa0}},
    {0x89c2, {0xe5, 0x8f, 0xaf}},
    {0x89c3, {0xe5, 0x98, 0x89}},
    {0x89c4, {0xe5, 0xa4, 0x8f}},
    {0x89c5, {0xe5, 0xab, 0x81}},
    {0x89c6, {0xe5, 0xae, 0xb6}},
    {0x89c7, {0xe5, 0xaf, 0xa1}},
    {0x89c8, {0xe7, 0xa7, 0x91}},
    {0x89c9, {0xe6, 0x9a, 0x87}},
    {0x89ca, {0xe6, 0x9e, 0x9c}},
    {0x89cb, {0xe6, 0x9e, 0xb6}},
    {0x89cc, {0xe6, 0xad, 0x8c}},
    {0x89cd, {0xe6, 0xb2, 0xb3}},
    {0x89ce, {0xe7, 0x81, 0xab}},
    {0x89cf, {0xe7, 0x8f, 0x82}},
    {0x89d0, {0xe7, 0xa6, 0x8d}},
    {0x89d1, {0xe7, 0xa6, 0xbe}},
    {0x89d2, {0xe7, 0xa8, 0xbc}},
    {0x89d3, {0xe7, 0xae, 0x87}},
    {0x89d4, {0xe8, 0x8a, 0xb1}},
    {0x89d5, {0xe8, 0x8b, 0x9b}},
    {0x89d6, {0xe8, 0x8c, 0x84}},
    {0x89d7, {0xe8, 0x8d, 0xb7}},
    {0x89d8, {0xe8, 0x8f, 0xaf}},
    {0x89d9, {0xe8, 0x8f, 0x93}},
    {0x89da, {0xe8, 0x9d, 0xa6}},
    {0x89db, {0xe8, 0xaa, 0xb2}},
    {0x89dc, {0xe5, 0x98, 0xa9}},
    {0x89dd, {0xe8, 0xb2, 0xa8}},
    {0x89de, {0xe8, 0xbf, 0xa6}},
    {0x89df, {0xe9, 0x81, 0x8e}},
    {0x89e0, {0xe9, 0x9c, 0x9e}},
    {0x89e1, {0xe8, 0x9a, 0x8a}},
    {0x89e2, {0xe4, 0xbf, 0x84}},
    {0x89e3, {0xe5, 0xb3, 0xa8}},
    {0x89e4, {0xe6, 0x88, 0x91}},
    {0x89e5, {0xe7, 0x89, 0x99}},
    {0x89e6, {0xe7, 0x94, 0xbb}},
    {0x89e7, {0xe8, 0x87, 0xa5}},
    {0x89e8, {0xe8, 0x8a, 0xbd}},
    {0x89e9, {0xe8, 0x9b, 0xbe}},
    {0x89ea, {0xe8, 0xb3, 0x80}},
    {0x89eb, {0xe9, 0x9b, 0x85}},
    {0x89ec, {0xe9, 0xa4, 0x93}},
    {0x89ed, {0xe9, 0xa7, 0x95}},
    {0x89ee, {0xe4, 0xbb, 0x8b}},
    {0x89ef, {0xe4, 0xbc, 0x9a}},
    {0x89f0, {0xe8, 0xa7, 0xa3}},
    {0x89f1, {0xe5, 0x9b, 0x9e}},
    {0x89f2, {0xe5, 0xa1, 0x8a}},
    {0x89f3, {0xe5, 0xa3, 0x8a}},
    {0x89f4, {0xe5, 0xbb, 0xbb}},
    {0x89f5, {0xe5, 0xbf, 0xab}},
    {0x89f6, {0xe6, 0x80, 0xaa}},
    {0x89f7, {0xe6, 0x82, 0x94}},
    {0x89f8, {0xe6, 0x81, 0xa2}},
    {0x89f9, {0xe6, 0x87, 0x90}},
    {0x89fa, {0xe6, 0x88, 0x92}},
    {0x89fb, {0xe6, 0x8b, 0x90}},
    {0x89fc, {0xe6, 0x94, 0xb9}},
    {0x8a40, {0xe9, 0xad, 0x81}},
    {0x8a41, {0xe6, 0x99, 0xa6}},
    {0x8a42, {0xe6, 0xa2, 0xb0}},
    {0x8a43, {0xe6, 0xb5, 0xb7}},
    {0x8a44, {0xe7, 0x81, 0xb0}},
    {0x8a45, {0xe7, 0x95, 0x8c}},
    {0x8a46, {0xe7, 0x9a, 0x86}},
    {0x8a47, {0xe7, 0xb5, 0xb5}},
    {0x8a48, {0xe8, 0x8a, 0xa5}},
    {0x8a49, {0xe8, 0x9f, 0xb9}},
    {0x8a4a, {0xe9, 0x96, 0x8b}},
    {0x8a4b, {0xe9, 0x9a, 0x8e}},
    {0x8a4c, {0xe8, 0xb2, 0x9d}},
    {0x8a4d, {0xe5, 0x87, 0xb1}},
    {0x8a4e, {0xe5, 0x8a, 0xbe}},
    {0x8a4f, {0xe5, 0xa4, 0x96}},
    {0x8a50, {0xe5, 0x92, 0xb3}},
    {0x8a51, {0xe5, 0xae, 0xb3}},
    {0x8a52, {0xe5, 0xb4, 0x96}},
    {0x8a53, {0xe6, 0x85, 0xa8}},
    {0x8a54, {0xe6, 0xa6, 0x82}},
    {0x8a55, {0xe6, 0xb6, 0xaf}},
    {0x8a56, {0xe7, 0xa2, 0x8d}},
    {0x8a57, {0xe8, 0x93, 0x8b}},
    {0x8a58, {0xe8, 0xa1, 0x97}},
    {0x8a59, {0xe8, 0xa9, 0xb2}},
    {0x8a5a, {0xe9, 0x8e, 0xa7}},
    {0x8a5b, {0xe9, 0xaa, 0xb8}},
    {0x8a5c, {0xe6, 0xb5, 0xac}},
    {0x8a5d, {0xe9, 0xa6, 0xa8}},
    {0x8a5e, {0xe8, 0x9b, 0x99}},
    {0x8a5f, {0xe5, 0x9e, 0xa3}},
    {0x8a60, {0xe6, 0x9f, 0xbf}},
    {0x8a61, {0xe8, 0x9b, 0x8e}},
    {0x8a62, {0xe9, 0x88, 0x8e}},
    {0x8a63, {0xe5, 0x8a, 0x83}},
    {0x8a64, {0xe5, 0x9a, 0x87}},
    {0x8a65, {0xe5, 0x90, 0x84}},
    {0x8a66, {0xe5, 0xbb, 0x93}},
    {0x8a67, {0xe6, 0x8b, 0xa1}},
    {0x8a68, {0xe6, 0x92, 0xb9}},
    {0x8a69, {0xe6, 0xa0, 0xbc}},
    {0x8a6a, {0xe6, 0xa0, 0xb8}},
    {0x8a6b, {0xe6, 0xae, 0xbb}},
    {0x8a6c, {0xe7, 0x8d, 0xb2}},
    {0x8a6d, {0xe7, 0xa2, 0xba}},
    {0x8a6e, {0xe7, 0xa9, 0xab}},
    {0x8a6f, {0xe8, 0xa6, 0x9a}},
    {0x8a70, {0xe8, 0xa7, 0x92}},
    {0x8a71, {0xe8, 0xb5, 0xab}},
    {0x8a72, {0xe8, 0xbc, 0x83}},
    {0x8a73, {0xe9, 0x83, 0xad}},
    {0x8a74, {0xe9, 0x96, 0xa3}},
    {0x8a75, {0xe9, 0x9a, 0x94}},
    {0x8a76, {0xe9, 0x9d, 0xa9}},
    {0x8a77, {0xe5, 0xad, 0xa6}},
    {0x8a78, {0xe5, 0xb2, 0xb3}},
    {0x8a79, {0xe6, 0xa5, 0xbd}},
    {0x8a7a, {0xe9, 0xa1, 0x8d}},
    {0x8a7b, {0xe9, 0xa1, 0x8e}},
    {0x8a7c, {0xe6, 0x8e, 0x9b}},
    {0x8a7d, {0xe7, 0xac, 0xa0}},
    {0x8a7e, {0xe6, 0xa8, 0xab}},
    {0x8a80, {0xe6, 0xa9, 0xbf}},
    {0x8a81, {0xe6, 0xa2, 0xb6}},
    {0x8a82, {0xe9, 0xb0, 0x8d}},
    {0x8a83, {0xe6, 0xbd, 0x9f}},
    {0x8a84, {0xe5, 0x89, 0xb2}},
    {0x8a85, {0xe5, 0x96, 0x9d}},
    {0x8a86, {0xe6, 0x81, 0xb0}},
    {0x8a87, {0xe6, 0x8b, 0xac}},
    {0x8a88, {0xe6, 0xb4, 0xbb}},
    {0x8a89, {0xe6, 0xb8, 0x87}},
    {0x8a8a, {0xe6, 0xbb, 0x91}},
    {0x8a8b, {0xe8, 0x91, 0x9b}},
    {0x8a8c, {0xe8, 0xa4, 0x90}},
    {0x8a8d, {0xe8, 0xbd, 0x84}},
    {0x8a8e, {0xe4, 0xb8, 0x94}},
    {0x8a8f, {0xe9, 0xb0, 0xb9}},
    {0x8a90, {0xe5, 0x8f, 0xb6}},
    {0x8a91, {0xe6, 0xa4, 0x9b}},
    {0x8a92, {0xe6, 0xa8, 0xba}},
    {0x8a93, {0xe9, 0x9e, 0x84}},
    {0x8a94, {0xe6, 0xa0, 0xaa}},
    {0x8a95, {0xe5, 0x85, 0x9c}},
    {0x8a96, {0xe7, 0xab, 0x83}},
    {0x8a97, {0xe8, 0x92, 0xb2}},
    {0x8a98, {0xe9, 0x87, 0x9c}},
    {0x8a99, {0xe9, 0x8e, 0x8c}},
    {0x8a9a, {0xe5, 0x99, 0x9b}},
    {0x8a9b, {0xe9, 0xb4, 0xa8}},
    {0x8a9c, {0xe6, 0xa0, 0xa2}},
    {0x8a9d, {0xe8, 0x8c, 0x85}},
    {0x8a9e, {0xe8, 0x90, 0xb1}},
    {0x8a9f, {0xe7, 0xb2, 0xa5}},
    {0x8aa0, {0xe5, 0x88, 0x88}},
    {0x8aa1, {0xe8, 0x8b, 0x85}},
    {0x8aa2, {0xe7, 0x93, 0xa6}},
    {0x8aa3, {0xe4, 0xb9, 0xbe}},
    {0x8aa4, {0xe4, 0xbe, 0x83}},
    {0x8aa5, {0xe5, 0x86, 0xa0}},
    {0x8aa6, {0xe5, 0xaf, 0x92}},
    {0x8aa7, {0xe5, 0x88, 0x8a}},
    {0x8aa8, {0xe5, 0x8b, 0x98}},
    {0x8aa9, {0xe5, 0x8b, 0xa7}},
    {0x8aaa, {0xe5, 0xb7, 0xbb}},
    {0x8aab, {0xe5, 0x96, 0x9a}},
    {0x8aac, {0xe5, 0xa0, 0xaa}},
    {0x8aad, {0xe5, 0xa7, 0xa6}},
    {0x8aae, {0xe5, 0xae, 0x8c}},
    {0x8aaf, {0xe5, 0xae, 0x98}},
    {0x8ab0, {0xe5, 0xaf, 0x9b}},
    {0x8ab1, {0xe5, 0xb9, 0xb2}},
    {0x8ab2, {0xe5, 0xb9, 0xb9}},
    {0x8ab3, {0xe6, 0x82, 0xa3}},
    {0x8ab4, {0xe6, 0x84, 0x9f}},
    {0x8ab5, {0xe6, 0x85, 0xa3}},
    {0x8ab6, {0xe6, 0x86, 0xbe}},
    {0x8ab7, {0xe6, 0x8f, 0x9b}},
    {0x8ab8, {0xe6, 0x95, 0xa2}},
    {0x8ab9, {0xe6, 0x9f, 0x91}},
    {0x8aba, {0xe6, 0xa1, 0x93}},
    {0x8abb, {0xe6, 0xa3, 0xba}},
    {0x8abc, {0xe6, 0xac, 0xbe}},
    {0x8abd, {0xe6, 0xad, 0x93}},
    {0x8abe, {0xe6, 0xb1, 0x97}},
    {0x8abf, {0xe6, 0xbc, 0xa2}},
    {0x8ac0, {0xe6, 0xbe, 0x97}},
    {0x8ac1, {0xe6, 0xbd, 0x85}},
    {0x8ac2, {0xe7, 0x92, 0xb0}},
    {0x8ac3, {0xe7, 0x94, 0x98}},
    {0x8ac4, {0xe7, 0x9b, 0xa3}},
    {0x8ac5, {0xe7, 0x9c, 0x8b}},
    {0x8ac6, {0xe7, 0xab, 0xbf}},
    {0x8ac7, {0xe7, 0xae, 0xa1}},
    {0x8ac8, {0xe7, 0xb0, 0xa1}},
    {0x8ac9, {0xe7, 0xb7, 0xa9}},
    {0x8aca, {0xe7, 0xbc, 0xb6}},
    {0x8acb, {0xe7, 0xbf, 0xb0}},
    {0x8acc, {0xe8, 0x82, 0x9d}},
    {0x8acd, {0xe8, 0x89, 0xa6}},
    {0x8ace, {0xe8, 0x8e, 0x9e}},
    {0x8acf, {0xe8, 0xa6, 0xb3}},
    {0x8ad0, {0xe8, 0xab, 0x8c}},
    {0x8ad1, {0xe8, 0xb2, 0xab}},
    {0x8ad2, {0xe9, 0x82, 0x84}},
    {0x8ad3, {0xe9, 0x91, 0x91}},
    {0x8ad4, {0xe9, 0x96, 0x93}},
    {0x8ad5, {0xe9, 0x96, 0x91}},
    {0x8ad6, {0xe9, 0x96, 0xa2}},
    {0x8ad7, {0xe9, 0x99, 0xa5}},
    {0x8ad8, {0xe9, 0x9f, 0x93}},
    {0x8ad9, {0xe9, 0xa4, 0xa8}},
    {0x8ada, {0xe8, 0x88, 0x98}},
    {0x8adb, {0xe4, 0xb8, 0xb8}},
    {0x8adc, {0xe5, 0x90, 0xab}},
    {0x8add, {0xe5, 0xb2, 0xb8}},
    {0x8ade, {0xe5, 0xb7, 0x8c}},
    {0x8adf, {0xe7, 0x8e, 0xa9}},
    {0x8ae0, {0xe7, 0x99, 0x8c}},
    {0x8ae1, {0xe7, 0x9c, 0xbc}},
    {0x8ae2, {0xe5, 0xb2, 0xa9}},
    {0x8ae3, {0xe7, 0xbf, 0xab}},
    {0x8ae4, {0xe8, 0xb4, 0x8b}},
    {0x8ae5, {0xe9, 0x9b, 0x81}},
    {0x8ae6, {0xe9, 0xa0, 0x91}},
    {0x8ae7, {0xe9, 0xa1, 0x94}},
    {0x8ae8, {0xe9, 0xa1, 0x98}},
    {0x8ae9, {0xe4, 0xbc, 0x81}},
    {0x8aea, {0xe4, 0xbc, 0x8e}},
    {0x8aeb, {0xe5, 0x8d, 0xb1}},
    {0x8aec, {0xe5, 0x96, 0x9c}},
    {0x8aed, {0xe5, 0x99, 0xa8}},
    {0x8aee, {0xe5, 0x9f, 0xba}},
    {0x8aef, {0xe5, 0xa5, 0x87}},
    {0x8af0, {0xe5, 0xac, 0x89}},
    {0x8af1, {0xe5, 0xaf, 0x84}},
    {0x8af2, {0xe5, 0xb2, 0x90}},
    {0x8af3, {0xe5, 0xb8, 0x8c}},
    {0x8af4, {0xe5, 0xb9, 0xbe}},
    {0x8af5, {0xe5, 0xbf, 0x8c}},
    {0x8af6, {0xe6, 0x8f, 0xae}},
    {0x8af7, {0xe6, 0x9c, 0xba}},
    {0x8af8, {0xe6, 0x97, 0x97}},
    {0x8af9, {0xe6, 0x97, 0xa2}},
    {0x8afa, {0xe6, 0x9c, 0x9f}},
    {0x8afb, {0xe6, 0xa3, 0x8b}},
    {0x8afc, {0xe6, 0xa3, 0x84}},
    {0x8b40, {0xe6, 0xa9, 0x9f}},
    {0x8b41, {0xe5, 0xb8, 0xb0}},
    {0x8b42, {0xe6, 0xaf, 0x85}},
    {0x8b43, {0xe6, 0xb0, 0x97}},
    {0x8b44, {0xe6, 0xb1, 0xbd}},
    {0x8b45, {0xe7, 0x95, 0xbf}},
    {0x8b46, {0xe7, 0xa5, 0x88}},
    {0x8b47, {0xe5, 0xad, 0xa3}},
    {0x8b48, {0xe7, 0xa8, 0x80}},
    {0x8b49, {0xe7, 0xb4, 0x80}},
    {0x8b4a, {0xe5, 0xbe, 0xbd}},
    {0x8b4b, {0xe8, 0xa6, 0x8f}},
    {0x8b4c, {0xe8, 0xa8, 0x98}},
    {0x8b4d, {0xe8, 0xb2, 0xb4}},
    {0x8b4e, {0xe8, 0xb5, 0xb7}},
    {0x8b4f, {0xe8, 0xbb, 0x8c}},
    {0x8b50, {0xe8, 0xbc, 0x9d}},
    {0x8b51, {0xe9, 0xa3, 0xa2}},
    {0x8b52, {0xe9, 0xa8, 0x8e}},
    {0x8b53, {0xe9, 0xac, 0xbc}},
    {0x8b54, {0xe4, 0xba, 0x80}},
    {0x8b55, {0xe5, 0x81, 0xbd}},
    {0x8b56, {0xe5, 0x84, 0x80}},
    {0x8b57, {0xe5, 0xa6, 0x93}},
    {0x8b58, {0xe5, 0xae, 0x9c}},
    {0x8b59, {0xe6, 0x88, 0xaf}},
    {0x8b5a, {0xe6, 0x8a, 0x80}},
    {0x8b5b, {0xe6, 0x93, 0xac}},
    {0x8b5c, {0xe6, 0xac, 0xba}},
    {0x8b5d, {0xe7, 0x8a, 0xa0}},
    {0x8b5e, {0xe7, 0x96, 0x91}},
    {0x8b5f, {0xe7, 0xa5, 0x87}},
    {0x8b60, {0xe7, 0xbe, 0xa9}},
    {0x8b61, {0xe8, 0x9f, 0xbb}},
    {0x8b62, {0xe8, 0xaa, 0xbc}},
    {0x8b63, {0xe8, 0xad, 0xb0}},
    {0x8b64, {0xe6, 0x8e, 0xac}},
    {0x8b65, {0xe8, 0x8f, 0x8a}},
    {0x8b66, {0xe9, 0x9e, 0xa0}},
    {0x8b67, {0xe5, 0x90, 0x89}},
    {0x8b68, {0xe5, 0x90, 0x83}},
    {0x8b69, {0xe5, 0x96, 0xab}},
    {0x8b6a, {0xe6, 0xa1, 0x94}},
    {0x8b6b, {0xe6, 0xa9, 0x98}},
    {0x8b6c, {0xe8, 0xa9, 0xb0}},
    {0x8b6d, {0xe7, 0xa0, 0xa7}},
    {0x8b6e, {0xe6, 0x9d, 0xb5}},
    {0x8b6f, {0xe9, 0xbb, 0x8d}},
    {0x8b70, {0xe5, 0x8d, 0xb4}},
    {0x8b71, {0xe5, 0xae, 0xa2}},
    {0x8b72, {0xe8, 0x84, 0x9a}},
    {0x8b73, {0xe8, 0x99, 0x90}},
    {0x8b74, {0xe9, 0x80, 0x86}},
    {0x8b75, {0xe4, 0xb8, 0x98}},
    {0x8b76, {0xe4, 0xb9, 0x85}},
    {0x8b77, {0xe4, 0xbb, 0x87}},
    {0x8b78, {0xe4, 0xbc, 0x91}},
    {0x8b79, {0xe5, 0x8f, 0x8a}},
    {0x8b7a, {0xe5, 0x90, 0xb8}},
    {0x8b7b, {0xe5, 0xae, 0xae}},
    {0x8b7c, {0xe5, 0xbc, 0x93}},
    {0x8b7d, {0xe6, 0x80, 0xa5}},
    {0x8b7e, {0xe6, 0x95, 0x91}},
    {0x8b80, {0xe6, 0x9c, 0xbd}},
    {0x8b81, {0xe6, 0xb1, 0x82}},
    {0x8b82, {0xe6, 0xb1, 0xb2}},
    {0x8b83, {0xe6, 0xb3, 0xa3}},
    {0x8b84, {0xe7, 0x81, 0xb8}},
    {0x8b85, {0xe7, 0x90, 0x83}},
    {0x8b86, {0xe7, 0xa9, 0xb6}},
    {0x8b87, {0xe7, 0xaa, 0xae}},
    {0x8b88, {0xe7, 0xac, 0x88}},
    {0x8b89, {0xe7, 0xb4, 0x9a}},
    {0x8b8a, {0xe7, 0xb3, 0xbe}},
    {0x8b8b, {0xe7, 0xb5, 0xa6}},
    {0x8b8c, {0xe6, 0x97, 0xa7}},
    {0x8b8d, {0xe7, 0x89, 0x9b}},
    {0x8b8e, {0xe5, 0x8e, 0xbb}},
    {0x8b8f, {0xe5, 0xb1, 0x85}},
    {0x8b90, {0xe5, 0xb7, 0xa8}},
    {0x8b91, {0xe6, 0x8b, 0x92}},
    {0x8b92, {0xe6, 0x8b, 0xa0}},
    {0x8b93, {0xe6, 0x8c, 0x99}},
    {0x8b94, {0xe6, 0xb8, 0xa0}},
    {0x8b95, {0xe8, 0x99, 0x9a}},
    {0x8b96, {0xe8, 0xa8, 0xb1}},
    {0x8b97, {0xe8, 0xb7, 0x9d}},
    {0x8b98, {0xe9, 0x8b, 0xb8}},
    {0x8b99, {0xe6, 0xbc, 0x81}},
    {0x8b9a, {0xe7, 0xa6, 0xa6}},
    {0x8b9b, {0xe9, 0xad, 0x9a}},
    {0x8b9c, {0xe4, 0xba, 0xa8}},
    {0x8b9d, {0xe4, 0xba, 0xab}},
    {0x8b9e, {0xe4, 0xba, 0xac}},
    {0x8b9f, {0xe4, 0xbe, 0x9b}},
    {0x8ba0, {0xe4, 0xbe, 0xa0}},
    {0x8ba1, {0xe5, 0x83, 0x91}},
    {0x8ba2, {0xe5, 0x85, 0x87}},
    {0x8ba3, {0xe7, 0xab, 0xb6}},
    {0x8ba4, {0xe5, 0x85, 0xb1}},
    {0x8ba5, {0xe5, 0x87, 0xb6}},
    {0x8ba6, {0xe5, 0x8d, 0x94}},
    {0x8ba7, {0xe5, 0x8c, 0xa1}},
    {0x8ba8, {0xe5, 0x8d, 0xbf}},
    {0x8ba9, {0xe5, 0x8f, 0xab}},
    {0x8baa, {0xe5, 0x96, 0xac}},
    {0x8bab, {0xe5, 0xa2, 0x83}},
    {0x8bac, {0xe5, 0xb3, 0xa1}},
    {0x8bad, {0xe5, 0xbc, 0xb7}},
    {0x8bae, {0xe5, 0xbd, 0x8a}},
    {0x8baf, {0xe6, 0x80, 0xaf}},
    {0x8bb0, {0xe6, 0x81, 0x90}},
    {0x8bb1, {0xe6, 0x81, 0xad}},
    {0x8bb2, {0xe6, 0x8c, 0x9f}},
    {0x8bb3, {0xe6, 0x95, 0x99}},
    {0x8bb4, {0xe6, 0xa9, 0x8b}},
    {0x8bb5, {0xe6, 0xb3, 0x81}},
    {0x8bb6, {0xe7, 0x8b, 0x82}},
    {0x8bb7, {0xe7, 0x8b, 0xad}},
    {0x8bb8, {0xe7, 0x9f, 0xaf}},
    {0x8bb9, {0xe8, 0x83, 0xb8}},
    {0x8bba, {0xe8, 0x84, 0x85}},
    {0x8bbb, {0xe8, 0x88, 0x88}},
    {0x8bbc, {0xe8, 0x95, 0x8e}},
    {0x8bbd, {0xe9, 0x83, 0xb7}},
    {0x8bbe, {0xe9, 0x8f, 0xa1}},
    {0x8bbf, {0xe9, 0x9f, 0xbf}},
    {0x8bc0, {0xe9, 0xa5, 0x97}},
    {0x8bc1, {0xe9, 0xa9, 0x9a}},
    {0x8bc2, {0xe4, 0xbb, 0xb0}},
    {0x8bc3, {0xe5, 0x87, 0x9d}},
    {0x8bc4, {0xe5, 0xb0, 0xad}},
    {0x8bc5, {0xe6, 0x9a, 0x81}},
    {0x8bc6, {0xe6, 0xa5, 0xad}},
    {0x8bc7, {0xe5, 0xb1, 0x80}},
    {0x8bc8, {0xe6, 0x9b, 0xb2}},
    {0x8bc9, {0xe6, 0xa5, 0xb5}},
    {0x8bca, {0xe7, 0x8e, 0x89}},
    {0x8bcb, {0xe6, 0xa1, 0x90}},
    {0x8bcc, {0xe7, 0xb2, 0x81}},
    {0x8bcd, {0xe5, 0x83, 0x85}},
    {0x8bce, {0xe5, 0x8b, 0xa4}},
    {0x8bcf, {0xe5, 0x9d, 0x87}},
    {0x8bd0, {0xe5, 0xb7, 0xbe}},
    {0x8bd1, {0xe9, 0x8c, 0xa6}},
    {0x8bd2, {0xe6, 0x96, 0xa4}},
    {0x8bd3, {0xe6, 0xac, 0xa3}},
    {0x8bd4, {0xe6, 0xac, 0xbd}},
    {0x8bd5, {0xe7, 0x90, 0xb4}},
    {0x8bd6, {0xe7, 0xa6, 0x81}},
    {0x8bd7, {0xe7, 0xa6, 0xbd}},
    {0x8bd8, {0xe7, 0xad, 0x8b}},
    {0x8bd9, {0xe7, 0xb7, 0x8a}},
    {0x8bda, {0xe8, 0x8a, 0xb9}},
    {0x8bdb, {0xe8, 0x8f, 0x8c}},
    {0x8bdc, {0xe8, 0xa1, 0xbf}},
    {0x8bdd, {0xe8, 0xa5, 0x9f}},
    {0x8bde, {0xe8, 0xac, 0xb9}},
    {0x8bdf, {0xe8, 0xbf, 0x91}},
    {0x8be0, {0xe9, 0x87, 0x91}},
    {0x8be1, {0xe5, 0x90, 0x9f}},
    {0x8be2, {0xe9, 0x8a, 0x80}},
    {0x8be3, {0xe4, 0xb9, 0x9d}},
    {0x8be4, {0xe5, 0x80, 0xb6}},
    {0x8be5, {0xe5, 0x8f, 0xa5}},
    {0x8be6, {0xe5, 0x8c, 0xba}},
    {0x8be7, {0xe7, 0x8b, 0x97}},
    {0x8be8, {0xe7, 0x8e, 0x96}},
    {0x8be9, {0xe7, 0x9f, 0xa9}},
    {0x8bea, {0xe8, 0x8b, 0xa6}},
    {0x8beb, {0xe8, 0xba, 0xaf}},
    {0x8bec, {0xe9, 0xa7, 0x86}},
    {0x8bed, {0xe9, 0xa7, 0x88}},
    {0x8bee, {0xe9, 0xa7, 0x92}},
    {0x8bef, {0xe5, 0x85, 0xb7}},
    {0x8bf0, {0xe6, 0x84, 0x9a}},
    {0x8bf1, {0xe8, 0x99, 0x9e}},
    {0x8bf2, {0xe5, 0x96, 0xb0}},
    {0x8bf3, {0xe7, 0xa9, 0xba}},
    {0x8bf4, {0xe5, 0x81, 0xb6}},
    {0x8bf5, {0xe5, 0xaf, 0x93}},
    {0x8bf6, {0xe9, 0x81, 0x87}},
    {0x8bf7, {0xe9, 0x9a, 0x85}},
    {0x8bf8, {0xe4, 0xb8, 0xb2}},
    {0x8bf9, {0xe6, 0xab, 0x9b}},
    {0x8bfa, {0xe9, 0x87, 0xa7}},
    {0x8bfb, {0xe5, 0xb1, 0x91}},
    {0x8bfc, {0xe5, 0xb1, 0x88}},
    {0x8c40, {0xe6, 0x8e, 0x98}},
    {0x8c41, {0xe7, 0xaa, 0x9f}},
    {0x8c42, {0xe6, 0xb2, 0x93}},
    {0x8c43, {0xe9, 0x9d, 0xb4}},
    {0x8c44, {0xe8, 0xbd, 0xa1}},
    {0x8c45, {0xe7, 0xaa, 0xaa}},
    {0x8c46, {0xe7, 0x86, 0x8a}},
    {0x8c47, {0xe9, 0x9a, 0x88}},
    {0x8c48, {0xe7, 0xb2, 0x82}},
    {0x8c49, {0xe6, 0xa0, 0x97}},
    {0x8c4a, {0xe7, 0xb9, 0xb0}},
    {0x8c4b, {0xe6, 0xa1, 0x91}},
    {0x8c4c, {0xe9, 0x8d, 0xac}},
    {0x8c4d, {0xe5, 0x8b, 0xb2}},
    {0x8c4e, {0xe5, 0x90, 0x9b}},
    {0x8c4f, {0xe8, 0x96, 0xab}},
    {0x8c50, {0xe8, 0xa8, 0x93}},
    {0x8c51, {0xe7, 0xbe, 0xa4}},
    {0x8c52, {0xe8, 0xbb, 0x8d}},
    {0x8c53, {0xe9, 0x83, 0xa1}},
    {0x8c54, {0xe5, 0x8d, 0xa6}},
    {0x8c55, {0xe8, 0xa2, 0x88}},
    {0x8c56, {0xe7, 0xa5, 0x81}},
    {0x8c57, {0xe4, 0xbf, 0x82}},
    {0x8c58, {0xe5, 0x82, 0xbe}},
    {0x8c59, {0xe5, 0x88, 0x91}},
    {0x8c5a, {0xe5, 0x85, 0x84}},
    {0x8c5b, {0xe5, 0x95, 0x93}},
    {0x8c5c, {0xe5, 0x9c, 0xad}},
    {0x8c5d, {0xe7, 0x8f, 0xaa}},
    {0x8c5e, {0xe5, 0x9e, 0x8b}},
    {0x8c5f, {0xe5, 0xa5, 0x91}},
    {0x8c60, {0xe5, 0xbd, 0xa2}},
    {0x8c61, {0xe5, 0xbe, 0x84}},
    {0x8c62, {0xe6, 0x81, 0xb5}},
    {0x8c63, {0xe6, 0x85, 0xb6}},
    {0x8c64, {0xe6, 0x85, 0xa7}},
    {0x8c65, {0xe6, 0x86, 0xa9}},
    {0x8c66, {0xe6, 0x8e, 0xb2}},
    {0x8c67, {0xe6, 0x90, 0xba}},
    {0x8c68, {0xe6, 0x95, 0xac}},
    {0x8c69, {0xe6, 0x99, 0xaf}},
    {0x8c6a, {0xe6, 0xa1, 0x82}},
    {0x8c6b, {0xe6, 0xb8, 0x93}},
    {0x8c6c, {0xe7, 0x95, 0xa6}},
    {0x8c6d, {0xe7, 0xa8, 0xbd}},
    {0x8c6e, {0xe7, 0xb3, 0xbb}},
    {0x8c6f, {0xe7, 0xb5, 0x8c}},
    {0x8c70, {0xe7, 0xb6, 0x99}},
    {0x8c71, {0xe7, 0xb9, 0x8b}},
    {0x8c72, {0xe7, 0xbd, 0xab}},
    {0x8c73, {0xe8, 0x8c, 0x8e}},
    {0x8c74, {0xe8, 0x8d, 0x8a}},
    {0x8c75, {0xe8, 0x9b, 0x8d}},
    {0x8c76, {0xe8, 0xa8, 0x88}},
    {0x8c77, {0xe8, 0xa9, 0xa3}},
    {0x8c78, {0xe8, 0xad, 0xa6}},
    {0x8c79, {0xe8, 0xbb, 0xbd}},
    {0x8c7a, {0xe9, 0xa0, 0x9a}},
    {0x8c7b, {0xe9, 0xb6, 0x8f}},
    {0x8c7c, {0xe8, 0x8a, 0xb8}},
    {0x8c7d, {0xe8, 0xbf, 0x8e}},
    {0x8c7e, {0xe9, 0xaf, 0xa8}},
    {0x8c80, {0xe5, 0x8a, 0x87}},
    {0x8c81, {0xe6, 0x88, 0x9f}},
    {0x8c82, {0xe6, 0x92, 0x83}},
    {0x8c83, {0xe6, 0xbf, 0x80}},
    {0x8c84, {0xe9, 0x9a, 0x99}},
    {0x8c85, {0xe6, 0xa1, 0x81}},
    {0x8c86, {0xe5, 0x82, 0x91}},
    {0x8c87, {0xe6, 0xac, 0xa0}},
    {0x8c88, {0xe6, 0xb1, 0xba}},
    {0x8c89, {0xe6, 0xbd, 0x94}},
    {0x8c8a, {0xe7, 0xa9, 0xb4}},
    {0x8c8b, {0xe7, 0xb5, 0x90}},
    {0x8c8c, {0xe8, 0xa1, 0x80}},
    {0x8c8d, {0xe8, 0xa8, 0xa3}},
    {0x8c8e, {0xe6, 0x9c, 0x88}},
    {0x8c8f, {0xe4, 0xbb, 0xb6}},
    {0x8c90, {0xe5, 0x80, 0xb9}},
    {0x8c91, {0xe5, 0x80, 0xa6}},
    {0x8c92, {0xe5, 0x81, 0xa5}},
    {0x8c93, {0xe5, 0x85, 0xbc}},
    {0x8c94, {0xe5, 0x88, 0xb8}},
    {0x8c95, {0xe5, 0x89, 0xa3}},
    {0x8c96, {0xe5, 0x96, 0xa7}},
    {0x8c97, {0xe5, 0x9c, 0x8f}},
    {0x8c98, {0xe5, 0xa0, 0x85}},
    {0x8c99, {0xe5, 0xab, 0x8c}},
    {0x8c9a, {0xe5, 0xbb, 0xba}},
    {0x8c9b, {0xe6, 0x86, 0xb2}},
    {0x8c9c, {0xe6, 0x87, 0xb8}},
    {0x8c9d, {0xe6, 0x8b, 0xb3}},
    {0x8c9e, {0xe6, 0x8d, 0xb2}},
    {0x8c9f, {0xe6, 0xa4, 0x9c}},
    {0x8ca0, {0xe6, 0xa8, 0xa9}},
    {0x8ca1, {0xe7, 0x89, 0xbd}},
    {0x8ca2, {0xe7, 0x8a, 0xac}},
    {0x8ca3, {0xe7, 0x8c, 0xae}},
    {0x8ca4, {0xe7, 0xa0, 0x94}},
    {0x8ca5, {0xe7, 0xa1, 0xaf}},
    {0x8ca6, {0xe7, 0xb5, 0xb9}},
    {0x8ca7, {0xe7, 0x9c, 0x8c}},
    {0x8ca8, {0xe8, 0x82, 0xa9}},
    {0x8ca9, {0xe8, 0xa6, 0x8b}},
    {0x8caa, {0xe8, 0xac, 0x99}},
    {0x8cab, {0xe8, 0xb3, 0xa2}},
    {0x8cac, {0xe8, 0xbb, 0x92}},
    {0x8cad, {0xe9, 0x81, 0xa3}},
    {0x8cae, {0xe9, 0x8d, 0xb5}},
    {0x8caf, {0xe9, 0x99, 0xba}},
    {0x8cb0, {0xe9, 0xa1, 0x95}},
    {0x8cb1, {0xe9, 0xa8, 0x93}},
    {0x8cb2, {0xe9, 0xb9, 0xb8}},
    {0x8cb3, {0xe5, 0x85, 0x83}},
    {0x8cb4, {0xe5, 0x8e, 0x9f}},
    {0x8cb5, {0xe5, 0x8e, 0xb3}},
    {0x8cb6, {0xe5, 0xb9, 0xbb}},
    {0x8cb7, {0xe5, 0xbc, 0xa6}},
    {0x8cb8, {0xe6, 0xb8, 0x9b}},
    {0x8cb9, {0xe6, 0xba, 0x90}},
    {0x8cba, {0xe7, 0x8e, 0x84}},
    {0x8cbb, {0xe7, 0x8f, 0xbe}},
    {0x8cbc, {0xe7, 0xb5, 0x83}},
    {0x8cbd, {0xe8, 0x88, 0xb7}},
    {0x8cbe, {0xe8, 0xa8, 0x80}},
    {0x8cbf, {0xe8, 0xab, 0xba}},
    {0x8cc0, {0xe9, 0x99, 0x90}},
    {0x8cc1, {0xe4, 0xb9, 0x8e}},
    {0x8cc2, {0xe5, 0x80, 0x8b}},
    {0x8cc3, {0xe5, 0x8f, 0xa4}},
    {0x8cc4, {0xe5, 0x91, 0xbc}},
    {0x8cc5, {0xe5, 0x9b, 0xba}},
    {0x8cc6, {0xe5, 0xa7, 0x91}},
    {0x8cc7, {0xe5, 0xad, 0xa4}},
    {0x8cc8, {0xe5, 0xb7, 0xb1}},
    {0x8cc9, {0xe5, 0xba, 0xab}},
    {0x8cca, {0xe5, 0xbc, 0xa7}},
    {0x8ccb, {0xe6, 0x88, 0xb8}},
    {0x8ccc, {0xe6, 0x95, 0x85}},
    {0x8ccd, {0xe6, 0x9e, 0xaf}},
    {0x8cce, {0xe6, 0xb9, 0x96}},
    {0x8ccf, {0xe7, 0x8b, 0x90}},
    {0x8cd0, {0xe7, 0xb3, 0x8a}},
    {0x8cd1, {0xe8, 0xa2, 0xb4}},
    {0x8cd2, {0xe8, 0x82, 0xa1}},
    {0x8cd3, {0xe8, 0x83, 0xa1}},
    {0x8cd4, {0xe8, 0x8f, 0xb0}},
    {0x8cd5, {0xe8, 0x99, 0x8e}},
    {0x8cd6, {0xe8, 0xaa, 0x87}},
    {0x8cd7, {0xe8, 0xb7, 0xa8}},
    {0x8cd8, {0xe9, 0x88, 0xb7}},
    {0x8cd9, {0xe9, 0x9b, 0x87}},
    {0x8cda, {0xe9, 0xa1, 0xa7}},
    {0x8cdb, {0xe9, 0xbc, 0x93}},
    {0x8cdc, {0xe4, 0xba, 0x94}},
    {0x8cdd, {0xe4, 0xba, 0x92}},
    {0x8cde, {0xe4, 0xbc, 0x8d}},
    {0x8cdf, {0xe5, 0x8d, 0x88}},
    {0x8ce0, {0xe5, 0x91, 0x89}},
    {0x8ce1, {0xe5, 0x90, 0xbe}},
    {0x8ce2, {0xe5, 0xa8, 0xaf}},
    {0x8ce3, {0xe5, 0xbe, 0x8c}},
    {0x8ce4, {0xe5, 0xbe, 0xa1}},
    {0x8ce5, {0xe6, 0x82, 0x9f}},
    {0x8ce6, {0xe6, 0xa2, 0xa7}},
    {0x8ce7, {0xe6, 0xaa, 0x8e}},
    {0x8ce8, {0xe7, 0x91, 0x9a}},
    {0x8ce9, {0xe7, 0xa2, 0x81}},
    {0x8cea, {0xe8, 0xaa, 0x9e}},
    {0x8ceb, {0xe8, 0xaa, 0xa4}},
    {0x8cec, {0xe8, 0xad, 0xb7}},
    {0x8ced, {0xe9, 0x86, 0x90}},
    {0x8cee, {0xe4, 0xb9, 0x9e}},
    {0x8cef, {0xe9, 0xaf, 0x89}},
    {0x8cf0, {0xe4, 0xba, 0xa4}},
    {0x8cf1, {0xe4, 0xbd, 0xbc}},
    {0x8cf2, {0xe4, 0xbe, 0xaf}},
    {0x8cf3, {0xe5, 0x80, 0x99}},
    {0x8cf4, {0xe5, 0x80, 0x96}},
    {0x8cf5, {0xe5, 0x85, 0x89}},
    {0x8cf6, {0xe5, 0x85, 0xac}},
    {0x8cf7, {0xe5, 0x8a, 0x9f}},
    {0x8cf8, {0xe5, 0x8a, 0xb9}},
    {0x8cf9, {0xe5, 0x8b, 0xbe}},
    {0x8cfa, {0xe5, 0x8e, 0x9a}},
    {0x8cfb, {0xe5, 0x8f, 0xa3}},
    {0x8cfc, {0xe5, 0x90, 0x91}},
    {0x8d40, {0xe5, 0x90, 0x8e}},
    {0x8d41, {0xe5, 0x96, 0x89}},
    {0x8d42, {0xe5, 0x9d, 0x91}},
    {0x8d43, {0xe5, 0x9e, 0xa2}},
    {0x8d44, {0xe5, 0xa5, 0xbd}},
    {0x8d45, {0xe5, 0xad, 0x94}},
    {0x8d46, {0xe5, 0xad, 0x9d}},
    {0x8d47, {0xe5, 0xae, 0x8f}},
    {0x8d48, {0xe5, 0xb7, 0xa5}},
    {0x8d49, {0xe5, 0xb7, 0xa7}},
    {0x8d4a, {0xe5, 0xb7, 0xb7}},
    {0x8d4b, {0xe5, 0xb9, 0xb8}},
    {0x8d4c, {0xe5, 0xba, 0x83}},
    {0x8d4d, {0xe5, 0xba, 0x9a}},
    {0x8d4e, {0xe5, 0xba, 0xb7}},
    {0x8d4f, {0xe5, 0xbc, 0x98}},
    {0x8d50, {0xe6, 0x81, 0x92}},
    {0x8d51, {0xe6, 0x85, 0x8c}},
    {0x8d52, {0xe6, 0x8a, 0x97}},
    {0x8d53, {0xe6, 0x8b, 0x98}},
    {0x8d54, {0xe6, 0x8e, 0xa7}},
    {0x8d55, {0xe6, 0x94, 0xbb}},
    {0x8d56, {0xe6, 0x98, 0x82}},
    {0x8d57, {0xe6, 0x99, 0x83}},
    {0x8d58, {0xe6, 0x9b, 0xb4}},
    {0x8d59, {0xe6, 0x9d, 0xad}},
    {0x8d5a, {0xe6, 0xa0, 0xa1}},
    {0x8d5b, {0xe6, 0xa2, 0x97}},
    {0x8d5c, {0xe6, 0xa7, 0x8b}},
    {0x8d5d, {0xe6, 0xb1, 0x9f}},
    {0x8d5e, {0xe6, 0xb4, 0xaa}},
    {0x8d5f, {0xe6, 0xb5, 0xa9}},
    {0x8d60, {0xe6, 0xb8, 0xaf}},
    {0x8d61, {0xe6, 0xba, 0x9d}},
    {0x8d62, {0xe7, 0x94, 0xb2}},
    {0x8d63, {0xe7, 0x9a, 0x87}},
    {0x8d64, {0xe7, 0xa1, 0xac}},
    {0x8d65, {0xe7, 0xa8, 0xbf}},
    {0x8d66, {0xe7, 0xb3, 0xa0}},
    {0x8d67, {0xe7, 0xb4, 0x85}},
    {0x8d68, {0xe7, 0xb4, 0x98}},
    {0x8d69, {0xe7, 0xb5, 0x9e}},
    {0x8d6a, {0xe7, 0xb6, 0xb1}},
    {0x8d6b, {0xe8, 0x80, 0x95}},
    {0x8d6c, {0xe8, 0x80, 0x83}},
    {0x8d6d, {0xe8, 0x82, 0xaf}},
    {0x8d6e, {0xe8, 0x82, 0xb1}},
    {0x8d6f, {0xe8, 0x85, 0x94}},
    {0x8d70, {0xe8, 0x86, 0x8f}},
    {0x8d71, {0xe8, 0x88, 0xaa}},
    {0x8d72, {0xe8, 0x8d, 0x92}},
    {0x8d73, {0xe8, 0xa1, 0x8c}},
    {0x8d74, {0xe8, 0xa1, 0xa1}},
    {0x8d75, {0xe8, 0xac, 0x9b}},
    {0x8d76, {0xe8, 0xb2, 0xa2}},
    {0x8d77, {0xe8, 0xb3, 0xbc}},
    {0x8d78, {0xe9, 0x83, 0x8a}},
    {0x8d79, {0xe9, 0x85, 0xb5}},
    {0x8d7a, {0xe9, 0x89, 0xb1}},
    {0x8d7b, {0xe7, 0xa0, 0xbf}},
    {0x8d7c, {0xe9, 0x8b, 0xbc}},
    {0x8d7d, {0xe9, 0x96, 0xa4}},
    {0x8d7e, {0xe9, 0x99, 0x8d}},
    {0x8d80, {0xe9, 0xa0, 0x85}},
    {0x8d81, {0xe9, 0xa6, 0x99}},
    {0x8d82, {0xe9, 0xab, 0x98}},
    {0x8d83, {0xe9, 0xb4, 0xbb}},
    {0x8d84, {0xe5, 0x89, 0x9b}},
    {0x8d85, {0xe5, 0x8a, 0xab}},
    {0x8d86, {0xe5, 0x8f, 0xb7}},
    {0x8d87, {0xe5, 0x90, 0x88}},
    {0x8d88, {0xe5, 0xa3, 0x95}},
    {0x8d89, {0xe6, 0x8b, 0xb7}},
    {0x8d8a, {0xe6, 0xbf, 0xa0}},
    {0x8d8b, {0xe8, 0xb1, 0xaa}},
    {0x8d8c, {0xe8, 0xbd, 0x9f}},
    {0x8d8d, {0xe9, 0xba, 0xb9}},
    {0x8d8e, {0xe5, 0x85, 0x8b}},
    {0x8d8f, {0xe5, 0x88, 0xbb}},
    {0x8d90, {0xe5, 0x91, 0x8a}},
    {0x8d91, {0xe5, 0x9b, 0xbd}},
    {0x8d92, {0xe7, 0xa9, 0x80}},
    {0x8d93, {0xe9, 0x85, 0xb7}},
    {0x8d94, {0xe9, 0xb5, 0xa0}},
    {0x8d95, {0xe9, 0xbb, 0x92}},
    {0x8d96, {0xe7, 0x8d, 0x84}},
    {0x8d97, {0xe6, 0xbc, 0x89}},
    {0x8d98, {0xe8, 0x85, 0xb0}},
    {0x8d99, {0xe7, 0x94, 0x91}},
    {0x8d9a, {0xe5, 0xbf, 0xbd}},
    {0x8d9b, {0xe6, 0x83, 0x9a}},
    {0x8d9c, {0xe9, 0xaa, 0xa8}},
    {0x8d9d, {0xe7, 0x8b, 0x9b}},
    {0x8d9e, {0xe8, 0xbe, 0xbc}},
    {0x8d9f, {0xe6, 0xad, 0xa4}},
    {0x8da0, {0xe9, 0xa0, 0x83}},
    {0x8da1, {0xe4, 0xbb, 0x8a}},
    {0x8da2, {0xe5, 0x9b, 0xb0}},
    {0x8da3, {0xe5, 0x9d, 0xa4}},
    {0x8da4, {0xe5, 0xa2, 0xbe}},
    {0x8da5, {0xe5, 0xa9, 0x9a}},
    {0x8da6, {0xe6, 0x81, 0xa8}},
    {0x8da7, {0xe6, 0x87, 0x87}},
    {0x8da8, {0xe6, 0x98, 0x8f}},
    {0x8da9, {0xe6, 0x98, 0x86}},
    {0x8daa, {0xe6, 0xa0, 0xb9}},
    {0x8dab, {0xe6, 0xa2, 0xb1}},
    {0x8dac, {0xe6, 0xb7, 0xb7}},
    {0x8dad, {0xe7, 0x97, 0x95}},
    {0x8dae, {0xe7, 0xb4, 0xba}},
    {0x8daf, {0xe8, 0x89, 0xae}},
    {0x8db0, {0xe9, 0xad, 0x82}},
    {0x8db1, {0xe4, 0xba, 0x9b}},
    {0x8db2, {0xe4, 0xbd, 0x90}},
    {0x8db3, {0xe5, 0x8f, 0x89}},
    {0x8db4, {0xe5, 0x94, 0x86}},
    {0x8db5, {0xe5, 0xb5, 0xaf}},
    {0x8db6, {0xe5, 0xb7, 0xa6}},
    {0x8db7, {0xe5, 0xb7, 0xae}},
    {0x8db8, {0xe6, 0x9f, 0xbb}},
    {0x8db9, {0xe6, 0xb2, 0x99}},
    {0x8dba, {0xe7, 0x91, 0xb3}},
    {0x8dbb, {0xe7, 0xa0, 0x82}},
    {0x8dbc, {0xe8, 0xa9, 0x90}},
    {0x8dbd, {0xe9, 0x8e, 0x96}},
    {0x8dbe, {0xe8, 0xa3, 0x9f}},
    {0x8dbf, {0xe5, 0x9d, 0x90}},
    {0x8dc0, {0xe5, 0xba, 0xa7}},
    {0x8dc1, {0xe6, 0x8c, 0xab}},
    {0x8dc2, {0xe5, 0x82, 0xb5}},
    {0x8dc3, {0xe5, 0x82, 0xac}},
    {0x8dc4, {0xe5, 0x86, 0x8d}},
    {0x8dc5, {0xe6, 0x9c, 0x80}},
    {0x8dc6, {0xe5, 0x93, 0x89}},
    {0x8dc7, {0xe5, 0xa1, 0x9e}},
    {0x8dc8, {0xe5, 0xa6, 0xbb}},
    {0x8dc9, {0xe5, 0xae, 0xb0}},
    {0x8dca, {0xe5, 0xbd, 0xa9}},
    {0x8dcb, {0xe6, 0x89, 0x8d}},
    {0x8dcc, {0xe6, 0x8e, 0xa1}},
    {0x8dcd, {0xe6, 0xa0, 0xbd}},
    {0x8dce, {0xe6, 0xad, 0xb3}},
    {0x8dcf, {0xe6, 0xb8, 0x88}},
    {0x8dd0, {0xe7, 0x81, 0xbd}},
    {0x8dd1, {0xe9, 0x87, 0x87}},
    {0x8dd2, {0xe7, 0x8a, 0x80}},
    {0x8dd3, {0xe7, 0xa0, 0x95}},
    {0x8dd4, {0xe7, 0xa0, 0xa6}},
    {0x8dd5, {0xe7, 0xa5, 0xad}},
    {0x8dd6, {0xe6, 0x96, 0x8e}},
    {0x8dd7, {0xe7, 0xb4, 0xb0}},
    {0x8dd8, {0xe8, 0x8f, 0x9c}},
    {0x8dd9, {0xe8, 0xa3, 0x81}},
    {0x8dda, {0xe8, 0xbc, 0x89}},
    {0x8ddb, {0xe9, 0x9a, 0x9b}},
    {0x8ddc, {0xe5, 0x89, 0xa4}},
    {0x8ddd, {0xe5, 0x9c, 0xa8}},
    {0x8dde, {0xe6, 0x9d, 0x90}},
    {0x8ddf, {0xe7, 0xbd, 0xaa}},
    {0x8de0, {0xe8, 0xb2, 0xa1}},
    {0x8de1, {0xe5, 0x86, 0xb4}},
    {0x8de2, {0xe5, 0x9d, 0x82}},
    {0x8de3, {0xe9, 0x98, 0xaa}},
    {0x8de4, {0xe5, 0xa0, 0xba}},
    {0x8de5, {0xe6, 0xa6, 0x8a}},
    {0x8de6, {0xe8, 0x82, 0xb4}},
    {0x8de7, {0xe5, 0x92, 0xb2}},
    {0x8de8, {0xe5, 0xb4, 0x8e}},
    {0x8de9, {0xe5, 0x9f, 0xbc}},
    {0x8dea, {0xe7, 0xa2, 0x95}},
    {0x8deb, {0xe9, 0xb7, 0xba}},
    {0x8dec, {0xe4, 0xbd, 0x9c}},
    {0x8ded, {0xe5, 0x89, 0x8a}},
    {0x8dee, {0xe5, 0x92, 0x8b}},
    {0x8def, {0xe6, 0x90, 0xbe}},
    {0x8df0, {0xe6, 0x98, 0xa8}},
    {0x8df1, {0xe6, 0x9c, 0x94}},
    {0x8df2, {0xe6, 0x9f, 0xb5}},
    {0x8df3, {0xe7, 0xaa, 0x84}},
    {0x8df4, {0xe7, 0xad, 0x96}},
    {0x8df5, {0xe7, 0xb4, 0xa2}},
    {0x8df6, {0xe9, 0x8c, 0xaf}},
    {0x8df7, {0xe6, 0xa1, 0x9c}},
    {0x8df8, {0xe9, 0xae, 0xad}},
    {0x8df9, {0xe7, 0xac, 0xb9}},
    {0x8dfa, {0xe5, 0x8c, 0x99}},
    {0x8dfb, {0xe5, 0x86, 0x8a}},
    {0x8dfc, {0xe5, 0x88, 0xb7}},
    {0x8e40, {0xe5, 0xaf, 0x9f}},
    {0x8e41, {0xe6, 0x8b, 0xb6}},
    {0x8e42, {0xe6, 0x92, 0xae}},
    {0x8e43, {0xe6, 0x93, 0xa6}},
    {0x8e44, {0xe6, 0x9c, 0xad}},
    {0x8e45, {0xe6, 0xae, 0xba}},
    {0x8e46, {0xe8, 0x96, 0xa9}},
    {0x8e47, {0xe9, 0x9b, 0x91}},
    {0x8e48, {0xe7, 0x9a, 0x90}},
    {0x8e49, {0xe9, 0xaf, 0x96}},
    {0x8e4a, {0xe6, 0x8d, 0x8c}},
    {0x8e4b, {0xe9, 0x8c, 0x86}},
    {0x8e4c, {0xe9, 0xae, 0xab}},
    {0x8e4d, {0xe7, 0x9a, 0xbf}},
    {0x8e4e, {0xe6, 0x99, 0x92}},
    {0x8e4f, {0xe4, 0xb8, 0x89}},
    {0x8e50, {0xe5, 0x82, 0x98}},
    {0x8e51, {0xe5, 0x8f, 0x82}},
    {0x8e52, {0xe5, 0xb1, 0xb1}},
    {0x8e53, {0xe6, 0x83, 0xa8}},
    {0x8e54, {0xe6, 0x92, 0x92}},
    {0x8e55, {0xe6, 0x95, 0xa3}},
    {0x8e56, {0xe6, 0xa1, 0x9f}},
    {0x8e57, {0xe7, 0x87, 0xa6}},
    {0x8e58, {0xe7, 0x8f, 0x8a}},
    {0x8e59, {0xe7, 0x94, 0xa3}},
    {0x8e5a, {0xe7, 0xae, 0x97}},
    {0x8e5b, {0xe7, 0xba, 0x82}},
    {0x8e5c, {0xe8, 0x9a, 0x95}},
    {0x8e5d, {0xe8, 0xae, 0x83}},
    {0x8e5e, {0xe8, 0xb3, 0x9b}},
    {0x8e5f, {0xe9, 0x85, 0xb8}},
    {0x8e60, {0xe9, 0xa4, 0x90}},
    {0x8e61, {0xe6, 0x96, 0xac}},
    {0x8e62, {0xe6, 0x9a, 0xab}},
    {0x8e63, {0xe6, 0xae, 0x8b}},
    {0x8e64, {0xe4, 0xbb, 0x95}},
    {0x8e65, {0xe4, 0xbb, 0x94}},
    {0x8e66, {0xe4, 0xbc, 0xba}},
    {0x8e67, {0xe4, 0xbd, 0xbf}},
    {0x8e68, {0xe5, 0x88, 0xba}},
    {0x8e69, {0xe5, 0x8f, 0xb8}},
    {0x8e6a, {0xe5, 0x8f, 0xb2}},
    {0x8e6b, {0xe5, 0x97, 0xa3}},
    {0x8e6c, {0xe5, 0x9b, 0x9b}},
    {0x8e6d, {0xe5, 0xa3, 0xab}},
    {0x8e6e, {0xe5, 0xa7, 0x8b}},
    {0x8e6f, {0xe5, 0xa7, 0x89}},
    {0x8e70, {0xe5, 0xa7, 0xbf}},
    {0x8e71, {0xe5, 0xad, 0x90}},
    {0x8e72, {0xe5, 0xb1, 0x8d}},
    {0x8e73, {0xe5, 0xb8, 0x82}},
    {0x8e74, {0xe5, 0xb8, 0xab}},
    {0x8e75, {0xe5, 0xbf, 0x97}},
    {0x8e76, {0xe6, 0x80, 0x9d}},
    {0x8e77, {0xe6, 0x8c, 0x87}},
    {0x8e78, {0xe6, 0x94, 0xaf}},
    {0x8e79, {0xe5, 0xad, 0x9c}},
    {0x8e7a, {0xe6, 0x96, 0xaf}},
    {0x8e7b, {0xe6, 0x96, 0xbd}},
    {0x8e7c, {0xe6, 0x97, 0xa8}},
    {0x8e7d, {0xe6, 0x9e, 0x9d}},
    {0x8e7e, {0xe6, 0xad, 0xa2}},
    {0x8e80, {0xe6, 0xad, 0xbb}},
    {0x8e81, {0xe6, 0xb0, 0x8f}},
    {0x8e82, {0xe7, 0x8d, 0x85}},
    {0x8e83, {0xe7, 0xa5, 0x89}},
    {0x8e84, {0xe7, 0xa7, 0x81}},
    {0x8e85, {0xe7, 0xb3, 0xb8}},
    {0x8e86, {0xe7, 0xb4, 0x99}},
    {0x8e87, {0xe7, 0xb4, 0xab}},
    {0x8e88, {0xe8, 0x82, 0xa2}},
    {0x8e89, {0xe8, 0x84, 0x82}},
    {0x8e8a, {0xe8, 0x87, 0xb3}},
    {0x8e8b, {0xe8, 0xa6, 0x96}},
    {0x8e8c, {0xe8, 0xa9, 0x9e}},
    {0x8e8d, {0xe8, 0xa9, 0xa9}},
    {0x8e8e, {0xe8, 0xa9, 0xa6}},
    {0x8e8f, {0xe8, 0xaa, 0x8c}},
    {0x8e90, {0xe8, 0xab, 0xae}},
    {0x8e91, {0xe8, 0xb3, 0x87}},
    {0x8e92, {0xe8, 0xb3, 0x9c}},
    {0x8e93, {0xe9, 0x9b, 0x8c}},
    {0x8e94, {0xe9, 0xa3, 0xbc}},
    {0x8e95, {0xe6, 0xad, 0xaf}},
    {0x8e96, {0xe4, 0xba, 0x8b}},
    {0x8e97, {0xe4, 0xbc, 0xbc}},
    {0x8e98, {0xe4, 0xbe, 0x8d}},
    {0x8e99, {0xe5, 0x85, 0x90}},
    {0x8e9a, {0xe5, 0xad, 0x97}},
    {0x8e9b, {0xe5, 0xaf, 0xba}},
    {0x8e9c, {0xe6, 0x85, 0x88}},
    {0x8e9d, {0xe6, 0x8c, 0x81}},
    {0x8e9e, {0xe6, 0x99, 0x82}},
    {0x8e9f, {0xe6, 0xac, 0xa1}},
    {0x8ea0, {0xe6, 0xbb, 0x8b}},
    {0x8ea1, {0xe6, 0xb2, 0xbb}},
    {0x8ea2, {0xe7, 0x88, 0xbe}},
    {0x8ea3, {0xe7, 0x92, 0xbd}},
    {0x8ea4, {0xe7, 0x97, 0x94}},
    {0x8ea5, {0xe7, 0xa3, 0x81}},
    {0x8ea6, {0xe7, 0xa4, 0xba}},
    {0x8ea7, {0xe8, 0x80, 0x8c}},
    {0x8ea8, {0xe8, 0x80, 0xb3}},
    {0x8ea9, {0xe8, 0x87, 0xaa}},
    {0x8eaa, {0xe8, 0x92, 0x94}},
    {0x8eab, {0xe8, 0xbe, 0x9e}},
    {0x8eac, {0xe6, 0xb1, 0x90}},
    {0x8ead, {0xe9, 0xb9, 0xbf}},
    {0x8eae, {0xe5, 0xbc, 0x8f}},
    {0x8eaf, {0xe8, 0xad, 0x98}},
    {0x8eb0, {0xe9, 0xb4, 0xab}},
    {0x8eb1, {0xe7, 0xab, 0xba}},
    {0x8eb2, {0xe8, 0xbb, 0xb8}},
    {0x8eb3, {0xe5, 0xae, 0x8d}},
    {0x8eb4, {0xe9, 0x9b, 0xab}},
    {0x8eb5, {0xe4, 0xb8, 0x83}},
    {0x8eb6, {0xe5, 0x8f, 0xb1}},
    {0x8eb7, {0xe5, 0x9f, 0xb7}},
    {0x8eb8, {0xe5, 0xa4, 0xb1}},
    {0x8eb9, {0xe5, 0xab, 0x89}},
    {0x8eba, {0xe5, 0xae, 0xa4}},
    {0x8ebb, {0xe6, 0x82, 0x89}},
    {0x8ebc, {0xe6, 0xb9, 0xbf}},
    {0x8ebd, {0xe6, 0xbc, 0x86}},
    {0x8ebe, {0xe7, 0x96, 0xbe}},
    {0x8ebf, {0xe8, 0xb3, 0xaa}},
    {0x8ec0, {0xe5, 0xae, 0x9f}},
    {0x8ec1, {0xe8, 0x94, 0x80}},
    {0x8ec2, {0xe7, 0xaf, 0xa0}},
    {0x8ec3, {0xe5, 0x81, 0xb2}},
    {0x8ec4, {0xe6, 0x9f, 0xb4}},
    {0x8ec5, {0xe8, 0x8a, 0x9d}},
    {0x8ec6, {0xe5, 0xb1, 0xa1}},
    {0x8ec7, {0xe8, 0x95, 0x8a}},
    {0x8ec8, {0xe7, 0xb8, 0x9e}},
    {0x8ec9, {0xe8, 0x88, 0x8e}},
    {0x8eca, {0xe5, 0x86, 0x99}},
    {0x8ecb, {0xe5, 0xb0, 0x84}},
    {0x8ecc, {0xe6, 0x8d, 0xa8}},
    {0x8ecd, {0xe8, 0xb5, 0xa6}},
    {0x8ece, {0xe6, 0x96, 0x9c}},
    {0x8ecf, {0xe7, 0x85, 0xae}},
    {0x8ed0, {0xe7, 0xa4, 0xbe}},
    {0x8ed1, {0xe7, 0xb4, 0x97}},
    {0x8ed2, {0xe8, 0x80, 0x85}},
    {0x8ed3, {0xe8, 0xac, 0x9d}},
    {0x8ed4, {0xe8, 0xbb, 0x8a}},
    {0x8ed5, {0xe9, 0x81, 0xae}},
    {0x8ed6, {0xe8, 0x9b, 0x87}},
    {0x8ed7, {0xe9, 0x82, 0xaa}},
    {0x8ed8, {0xe5, 0x80, 0x9f}},
    {0x8ed9, {0xe5, 0x8b, 0xba}},
    {0x8eda, {0xe5, 0xb0, 0xba}},
    {0x8edb, {0xe6, 0x9d, 0x93}},
    {0x8edc, {0xe7, 0x81, 0xbc}},
    {0x8edd, {0xe7, 0x88, 0xb5}},
    {0x8ede, {0xe9, 0x85, 0x8c}},
    {0x8edf, {0xe9, 0x87, 0x88}},
    {0x8ee0, {0xe9, 0x8c, 0xab}},
    {0x8ee1, {0xe8, 0x8b, 0xa5}},
    {0x8ee2, {0xe5, 0xaf, 0x82}},
    {0x8ee3, {0xe5, 0xbc, 0xb1}},
    {0x8ee4, {0xe6, 0x83, 0xb9}},
    {0x8ee5, {0xe4, 0xb8, 0xbb}},
    {0x8ee6, {0xe5, 0x8f, 0x96}},
    {0x8ee7, {0xe5, 0xae, 0x88}},
    {0x8ee8, {0xe6, 0x89, 0x8b}},
    {0x8ee9, {0xe6, 0x9c, 0xb1}},
    {0x8eea, {0xe6, 0xae, 0x8a}},
    {0x8eeb, {0xe7, 0x8b, 0xa9}},
    {0x8eec, {0xe7, 0x8f, 0xa0}},
    {0x8eed, {0xe7, 0xa8, 0xae}},
    {0x8eee, {0xe8, 0x85, 0xab}},
    {0x8eef, {0xe8, 0xb6, 0xa3}},
    {0x8ef0, {0xe9, 0x85, 0x92}},
    {0x8ef1, {0xe9, 0xa6, 0x96}},
    {0x8ef2, {0xe5, 0x84, 0x92}},
    {0x8ef3, {0xe5, 0x8f, 0x97}},
    {0x8ef4, {0xe5, 0x91, 0xaa}},
    {0x8ef5, {0xe5, 0xaf, 0xbf}},
    {0x8ef6, {0xe6, 0x8e, 0x88}},
    {0x8ef7, {0xe6, 0xa8, 0xb9}},
    {0x8ef8, {0xe7, 0xb6, 0xac}},
    {0x8ef9, {0xe9, 0x9c, 0x80}},
    {0x8efa, {0xe5, 0x9b, 0x9a}},
    {0x8efb, {0xe5, 0x8f, 0x8e}},
    {0x8efc, {0xe5, 0x91, 0xa8}},
    {0x8f40, {0xe5, 0xae, 0x97}},
    {0x8f41, {0xe5, 0xb0, 0xb1}},
    {0x8f42, {0xe5, 0xb7, 0x9e}},
    {0x8f43, {0xe4, 0xbf, 0xae}},
    {0x8f44, {0xe6, 0x84, 0x81}},
    {0x8f45, {0xe6, 0x8b, 0xbe}},
    {0x8f46, {0xe6, 0xb4, 0xb2}},
    {0x8f47, {0xe7, 0xa7, 0x80}},
    {0x8f48, {0xe7, 0xa7, 0x8b}},
    {0x8f49, {0xe7, 0xb5, 0x82}},
    {0x8f4a, {0xe7, 0xb9, 0x8d}},
    {0x8f4b, {0xe7, 0xbf, 0x92}},
    {0x8f4c, {0xe8, 0x87, 0xad}},
    {0x8f4d, {0xe8, 0x88, 0x9f}},
    {0x8f4e, {0xe8, 0x92, 0x90}},
    {0x8f4f, {0xe8, 0xa1, 0x86}},
    {0x8f50, {0xe8, 0xa5, 0xb2}},
    {0x8f51, {0xe8, 0xae, 0x90}},
    {0x8f52, {0xe8, 0xb9, 0xb4}},
    {0x8f53, {0xe8, 0xbc, 0xaf}},
    {0x8f54, {0xe9, 0x80, 0xb1}},
    {0x8f55, {0xe9, 0x85, 0x8b}},
    {0x8f56, {0xe9, 0x85, 0xac}},
    {0x8f57, {0xe9, 0x9b, 0x86}},
    {0x8f58, {0xe9, 0x86, 0x9c}},
    {0x8f59, {0xe4, 0xbb, 0x80}},
    {0x8f5a, {0xe4, 0xbd, 0x8f}},
    {0x8f5b, {0xe5, 0x85, 0x85}},
    {0x8f5c, {0xe5, 0x8d, 0x81}},
    {0x8f5d, {0xe5, 0xbe, 0x93}},
    {0x8f5e, {0xe6, 0x88, 0x8e}},
    {0x8f5f, {0xe6, 0x9f, 0x94}},
    {0x8f60, {0xe6, 0xb1, 0x81}},
    {0x8f61, {0xe6, 0xb8, 0x8b}},
    {0x8f62, {0xe7, 0x8d, 0xa3}},
    {0x8f63, {0xe7, 0xb8, 0xa6}},
    {0x8f64, {0xe9, 0x87, 0x8d}},
    {0x8f65, {0xe9, 0x8a, 0x83}},
    {0x8f66, {0xe5, 0x8f, 0x94}},
    {0x8f67, {0xe5, 0xa4, 0x99}},
    {0x8f68, {0xe5, 0xae, 0xbf}},
    {0x8f69, {0xe6, 0xb7, 0x91}},
    {0x8f6a, {0xe7, 0xa5, 0x9d}},
    {0x8f6b, {0xe7, 0xb8, 0xae}},
    {0x8f6c, {0xe7, 0xb2, 0x9b}},
    {0x8f6d, {0xe5, 0xa1, 0xbe}},
    {0x8f6e, {0xe7, 0x86, 0x9f}},
    {0x8f6f, {0xe5, 0x87, 0xba}},
    {0x8f70, {0xe8, 0xa1, 0x93}},
    {0x8f71, {0xe8, 0xbf, 0xb0}},
    {0x8f72, {0xe4, 0xbf, 0x8a}},
    {0x8f73, {0xe5, 0xb3, 0xbb}},
    {0x8f74, {0xe6, 0x98, 0xa5}},
    {0x8f75, {0xe7, 0x9e, 0xac}},
    {0x8f76, {0xe7, 0xab, 0xa3}},
    {0x8f77, {0xe8, 0x88, 0x9c}},
    {0x8f78, {0xe9, 0xa7, 0xbf}},
    {0x8f79, {0xe5, 0x87, 0x86}},
    {0x8f7a, {0xe5, 0xbe, 0xaa}},
    {0x8f7b, {0xe6, 0x97, 0xac}},
    {0x8f7c, {0xe6, 0xa5, 0xaf}},
    {0x8f7d, {0xe6, 0xae, 0x89}},
    {0x8f7e, {0xe6, 0xb7, 0xb3}},
    {0x8f80, {0xe6, 0xba, 0x96}},
    {0x8f81, {0xe6, 0xbd, 0xa4}},
    {0x8f82, {0xe7, 0x9b, 0xbe}},
    {0x8f83, {0xe7, 0xb4, 0x94}},
    {0x8f84, {0xe5, 0xb7, 0xa1}},
    {0x8f85, {0xe9, 0x81, 0xb5}},
    {0x8f86, {0xe9, 0x86, 0x87}},
    {0x8f87, {0xe9, 0xa0, 0x86}},
    {0x8f88, {0xe5, 0x87, 0xa6}},
    {0x8f89, {0xe5, 0x88, 0x9d}},
    {0x8f8a, {0xe6, 0x89, 0x80}},
    {0x8f8b, {0xe6, 0x9a, 0x91}},
    {0x8f8c, {0xe6, 0x9b, 0x99}},
    {0x8f8d, {0xe6, 0xb8, 0x9a}},
    {0x8f8e, {0xe5, 0xba, 0xb6}},
    {0x8f8f, {0xe7, 0xb7, 0x92}},
    {0x8f90, {0xe7, 0xbd, 0xb2}},
    {0x8f91, {0xe6, 0x9b, 0xb8}},
    {0x8f92, {0xe8, 0x96, 0xaf}},
    {0x8f93, {0xe8, 0x97, 0xb7}},
    {0x8f94, {0xe8, 0xab, 0xb8}},
    {0x8f95, {0xe5, 0x8a, 0xa9}},
    {0x8f96, {0xe5, 0x8f, 0x99}},
    {0x8f97, {0xe5, 0xa5, 0xb3}},
    {0x8f98, {0xe5, 0xba, 0x8f}},
    {0x8f99, {0xe5, 0xbe, 0x90}},
    {0x8f9a, {0xe6, 0x81, 0x95}},
    {0x8f9b, {0xe9, 0x8b, 0xa4}},
    {0x8f9c, {0xe9, 0x99, 0xa4}},
    {0x8f9d, {0xe5, 0x82, 0xb7}},
    {0x8f9e, {0xe5, 0x84, 0x9f}},
    {0x8f9f, {0xe5, 0x8b, 0x9d}},
    {0x8fa0, {0xe5, 0x8c, 0xa0}},
    {0x8fa1, {0xe5, 0x8d, 0x87}},
    {0x8fa2, {0xe5, 0x8f, 0xac}},
    {0x8fa3, {0xe5, 0x93, 0xa8}},
    {0x8fa4, {0xe5, 0x95, 0x86}},
    {0x8fa5, {0xe5, 0x94, 0xb1}},
    {0x8fa6, {0xe5, 0x98, 0x97}},
    {0x8fa7, {0xe5, 0xa5, 0xa8}},
    {0x8fa8, {0xe5, 0xa6, 0xbe}},
    {0x8fa9, {0xe5, 0xa8, 0xbc}},
    {0x8faa, {0xe5, 0xae, 0xb5}},
    {0x8fab, {0xe5, 0xb0, 0x86}},
    {0x8fac, {0xe5, 0xb0, 0x8f}},
    {0x8fad, {0xe5, 0xb0, 0x91}},
    {0x8fae, {0xe5, 0xb0, 0x9a}},
    {0x8faf, {0xe5, 0xba, 0x84}},
    {0x8fb0, {0xe5, 0xba, 0x8a}},
    {0x8fb1, {0xe5, 0xbb, 0xa0}},
    {0x8fb2, {0xe5, 0xbd, 0xb0}},
    {0x8fb3, {0xe6, 0x89, 0xbf}},
    {0x8fb4, {0xe6, 0x8a, 0x84}},
    {0x8fb5, {0xe6, 0x8b, 0x9b}},
    {0x8fb6, {0xe6, 0x8e, 0x8c}},
    {0x8fb7, {0xe6, 0x8d, 0xb7}},
    {0x8fb8, {0xe6, 0x98, 0x87}},
    {0x8fb9, {0xe6, 0x98, 0x8c}},
    {0x8fba, {0xe6, 0x98, 0xad}},
    {0x8fbb, {0xe6, 0x99, 0xb6}},
    {0x8fbc, {0xe6, 0x9d, 0xbe}},
    {0x8fbd, {0xe6, 0xa2, 0xa2}},
    {0x8fbe, {0xe6, 0xa8, 0x9f}},
    {0x8fbf, {0xe6, 0xa8, 0xb5}},
    {0x8fc0, {0xe6, 0xb2, 0xbc}},
    {0x8fc1, {0xe6, 0xb6, 0x88}},
    {0x8fc2, {0xe6, 0xb8, 0x89}},
    {0x8fc3, {0xe6, 0xb9, 0x98}},
    {0x8fc4, {0xe7, 0x84, 0xbc}},
    {0x8fc5, {0xe7, 0x84, 0xa6}},
    {0x8fc6, {0xe7, 0x85, 0xa7}},
    {0x8fc7, {0xe7, 0x97, 0x87}},
    {0x8fc8, {0xe7, 0x9c, 0x81}},
    {0x8fc9, {0xe7, 0xa1, 0x9d}},
    {0x8fca, {0xe7, 0xa4, 0x81}},
    {0x8fcb, {0xe7, 0xa5, 0xa5}},
    {0x8fcc, {0xe7, 0xa7, 0xb0}},
    {0x8fcd, {0xe7, 0xab, 0xa0}},
    {0x8fce, {0xe7, 0xac, 0x91}},
    {0x8fcf, {0xe7, 0xb2, 0xa7}},
    {0x8fd0, {0xe7, 0xb4, 0xb9}},
    {0x8fd1, {0xe8, 0x82, 0x96}},
    {0x8fd2, {0xe8, 0x8f, 0x96}},
    {0x8fd3, {0xe8, 0x92, 0x8b}},
    {0x8fd4, {0xe8, 0x95, 0x89}},
    {0x8fd5, {0xe8, 0xa1, 0x9d}},
    {0x8fd6, {0xe8, 0xa3, 0xb3}},
    {0x8fd7, {0xe8, 0xa8, 0x9f}},
    {0x8fd8, {0xe8, 0xa8, 0xbc}},
    {0x8fd9, {0xe8, 0xa9, 0x94}},
    {0x8fda, {0xe8, 0xa9, 0xb3}},
    {0x8fdb, {0xe8, 0xb1, 0xa1}},
    {0x8fdc, {0xe8, 0xb3, 0x9e}},
    {0x8fdd, {0xe9, 0x86, 0xa4}},
    {0x8fde, {0xe9, 0x89, 0xa6}},
    {0x8fdf, {0xe9, 0x8d, 0xbe}},
    {0x8fe0, {0xe9, 0x90, 0x98}},
    {0x8fe1, {0xe9, 0x9a, 0x9c}},
    {0x8fe2, {0xe9, 0x9e, 0x98}},
    {0x8fe3, {0xe4, 0xb8, 0x8a}},
    {0x8fe4, {0xe4, 0xb8, 0x88}},
    {0x8fe5, {0xe4, 0xb8, 0x9e}},
    {0x8fe6, {0xe4, 0xb9, 0x97}},
    {0x8fe7, {0xe5, 0x86, 0x97}},
    {0x8fe8, {0xe5, 0x89, 0xb0}},
    {0x8fe9, {0xe5, 0x9f, 0x8e}},
    {0x8fea, {0xe5, 0xa0, 0xb4}},
    {0x8feb, {0xe5, 0xa3, 0x8c}},
    {0x8fec, {0xe5, 0xac, 0xa2}},
    {0x8fed, {0xe5, 0xb8, 0xb8}},
    {0x8fee, {0xe6, 0x83, 0x85}},
    {0x8fef, {0xe6, 0x93, 0xbe}},
    {0x8ff0, {0xe6, 0x9d, 0xa1}},
    {0x8ff1, {0xe6, 0x9d, 0x96}},
    {0x8ff2, {0xe6, 0xb5, 0x84}},
    {0x8ff3, {0xe7, 0x8a, 0xb6}},
    {0x8ff4, {0xe7, 0x95, 0xb3}},
    {0x8ff5, {0xe7, 0xa9, 0xa3}},
    {0x8ff6, {0xe8, 0x92, 0xb8}},
    {0x8ff7, {0xe8, 0xad, 0xb2}},
    {0x8ff8, {0xe9, 0x86, 0xb8}},
    {0x8ff9, {0xe9, 0x8c, 0xa0}},
    {0x8ffa, {0xe5, 0x98, 0xb1}},
    {0x8ffb, {0xe5, 0x9f, 0xb4}},
    {0x8ffc, {0xe9, 0xa3, 0xbe}},
    {0x9040, {0xe6, 0x8b, 0xad}},
    {0x9041, {0xe6, 0xa4, 0x8d}},
    {0x9042, {0xe6, 0xae, 0x96}},
    {0x9043, {0xe7, 0x87, 0xad}},
    {0x9044, {0xe7, 0xb9, 0x94}},
    {0x9045, {0xe8, 0x81, 0xb7}},
    {0x9046, {0xe8, 0x89, 0xb2}},
    {0x9047, {0xe8, 0xa7, 0xa6}},
    {0x9048, {0xe9, 0xa3, 0x9f}},
    {0x9049, {0xe8, 0x9d, 0x95}},
    {0x904a, {0xe8, 0xbe, 0xb1}},
    {0x904b, {0xe5, 0xb0, 0xbb}},
    {0x904c, {0xe4, 0xbc, 0xb8}},
    {0x904d, {0xe4, 0xbf, 0xa1}},
    {0x904e, {0xe4, 0xbe, 0xb5}},
    {0x904f, {0xe5, 0x94, 0x87}},
    {0x9050, {0xe5, 0xa8, 0xa0}},
    {0x9051, {0xe5, 0xaf, 0x9d}},
    {0x9052, {0xe5, 0xaf, 0xa9}},
    {0x9053, {0xe5, 0xbf, 0x83}},
    {0x9054, {0xe6, 0x85, 0x8e}},
    {0x9055, {0xe6, 0x8c, 0xaf}},
    {0x9056, {0xe6, 0x96, 0xb0}},
    {0x9057, {0xe6, 0x99, 0x8b}},
    {0x9058, {0xe6, 0xa3, 0xae}},
    {0x9059, {0xe6, 0xa6, 0x9b}},
    {0x905a, {0xe6, 0xb5, 0xb8}},
    {0x905b, {0xe6, 0xb7, 0xb1}},
    {0x905c, {0xe7, 0x94, 0xb3}},
    {0x905d, {0xe7, 0x96, 0xb9}},
    {0x905e, {0xe7, 0x9c, 0x9f}},
    {0x905f, {0xe7, 0xa5, 0x9e}},
    {0x9060, {0xe7, 0xa7, 0xa6}},
    {0x9061, {0xe7, 0xb4, 0xb3}},
    {0x9062, {0xe8, 0x87, 0xa3}},
    {0x9063, {0xe8, 0x8a, 0xaf}},
    {0x9064, {0xe8, 0x96, 0xaa}},
    {0x9065, {0xe8, 0xa6, 0xaa}},
    {0x9066, {0xe8, 0xa8, 0xba}},
    {0x9067, {0xe8, 0xba, 0xab}},
    {0x9068, {0xe8, 0xbe, 0x9b}},
    {0x9069, {0xe9, 0x80, 0xb2}},
    {0x906a, {0xe9, 0x87, 0x9d}},
    {0x906b, {0xe9, 0x9c, 0x87}},
    {0x906c, {0xe4, 0xba, 0xba}},
    {0x906d, {0xe4, 0xbb, 0x81}},
    {0x906e, {0xe5, 0x88, 0x83}},
    {0x906f, {0xe5, 0xa1, 0xb5}},
    {0x9070, {0xe5, 0xa3, 0xac}},
    {0x9071, {0xe5, 0xb0, 0x8b}},
    {0x9072, {0xe7, 0x94, 0x9a}},
    {0x9073, {0xe5, 0xb0, 0xbd}},
    {0x9074, {0xe8, 0x85, 0x8e}},
    {0x9075, {0xe8, 0xa8, 0x8a}},
    {0x9076, {0xe8, 0xbf, 0x85}},
    {0x9077, {0xe9, 0x99, 0xa3}},
    {0x9078, {0xe9, 0x9d, 0xad}},
    {0x9079, {0xe7, 0xac, 0xa5}},
    {0x907a, {0xe8, 0xab, 0x8f}},
    {0x907b, {0xe9, 0xa0, 0x88}},
    {0x907c, {0xe9, 0x85, 0xa2}},
    {0x907d, {0xe5, 0x9b, 0xb3}},
    {0x907e, {0xe5, 0x8e, 0xa8}},
    {0x9080, {0xe9, 0x80, 0x97}},
    {0x9081, {0xe5, 0x90, 0xb9}},
    {0x9082, {0xe5, 0x9e, 0x82}},
    {0x9083, {0xe5, 0xb8, 0xa5}},
    {0x9084, {0xe6, 0x8e, 0xa8}},
    {0x9085, {0xe6, 0xb0, 0xb4}},
    {0x9086, {0xe7, 0x82, 0x8a}},
    {0x9087, {0xe7, 0x9d, 0xa1}},
    {0x9088, {0xe7, 0xb2, 0x8b}},
    {0x9089, {0xe7, 0xbf, 0xa0}},
    {0x908a, {0xe8, 0xa1, 0xb0}},
    {0x908b, {0xe9, 0x81, 0x82}},
    {0x908c, {0xe9, 0x85, 0x94}},
    {0x908d, {0xe9, 0x8c, 0x90}},
    {0x908e, {0xe9, 0x8c, 0x98}},
    {0x908f, {0xe9, 0x9a, 0x8f}},
    {0x9090, {0xe7, 0x91, 0x9e}},
    {0x9091, {0xe9, 0xab, 0x84}},
    {0x9092, {0xe5, 0xb4, 0x87}},
    {0x9093, {0xe5, 0xb5, 0xa9}},
    {0x9094, {0xe6, 0x95, 0xb0}},
    {0x9095, {0xe6, 0x9e, 0xa2}},
    {0x9096, {0xe8, 0xb6, 0xa8}},
    {0x9097, {0xe9, 0x9b, 0x9b}},
    {0x9098, {0xe6, 0x8d, 0xae}},
    {0x9099, {0xe6, 0x9d, 0x89}},
    {0x909a, {0xe6, 0xa4, 0x99}},
    {0x909b, {0xe8, 0x8f, 0x85}},
    {0x909c, {0xe9, 0xa0, 0x97}},
    {0x909d, {0xe9, 0x9b, 0x80}},
    {0x909e, {0xe8, 0xa3, 0xbe}},
    {0x909f, {0xe6, 0xbe, 0x84}},
    {0x90a0, {0xe6, 0x91, 0xba}},
    {0x90a1, {0xe5, 0xaf, 0xb8}},
    {0x90a2, {0xe4, 0xb8, 0x96}},
    {0x90a3, {0xe7, 0x80, 0xac}},
    {0x90a4, {0xe7, 0x95, 0x9d}},
    {0x90a5, {0xe6, 0x98, 0xaf}},
    {0x90a6, {0xe5, 0x87, 0x84}},
    {0x90a7, {0xe5, 0x88, 0xb6}},
    {0x90a8, {0xe5, 0x8b, 0xa2}},
    {0x90a9, {0xe5, 0xa7, 0x93}},
    {0x90aa, {0xe5, 0xbe, 0x81}},
    {0x90ab, {0xe6, 0x80, 0xa7}},
    {0x90ac, {0xe6, 0x88, 0x90}},
    {0x90ad, {0xe6, 0x94, 0xbf}},
    {0x90ae, {0xe6, 0x95, 0xb4}},
    {0x90af, {0xe6, 0x98, 0x9f}},
    {0x90b0, {0xe6, 0x99, 0xb4}},
    {0x90b1, {0xe6, 0xa3, 0xb2}},
    {0x90b2, {0xe6, 0xa0, 0x96}},
    {0x90b3, {0xe6, 0xad, 0xa3}},
    {0x90b4, {0xe6, 0xb8, 0x85}},
    {0x90b5, {0xe7, 0x89, 0xb2}},
    {0x90b6, {0xe7, 0x94, 0x9f}},
    {0x90b7, {0xe7, 0x9b, 0x9b}},
    {0x90b8, {0xe7, 0xb2, 0xbe}},
    {0x90b9, {0xe8, 0x81, 0x96}},
    {0x90ba, {0xe5, 0xa3, 0xb0}},
    {0x90bb, {0xe8, 0xa3, 0xbd}},
    {0x90bc, {0xe8, 0xa5, 0xbf}},
    {0x90bd, {0xe8, 0xaa, 0xa0}},
    {0x90be, {0xe8, 0xaa, 0x93}},
    {0x90bf, {0xe8, 0xab, 0x8b}},
    {0x90c0, {0xe9, 0x80, 0x9d}},
    {0x90c1, {0xe9, 0x86, 0x92}},
    {0x90c2, {0xe9, 0x9d, 0x92}},
    {0x90c3, {0xe9, 0x9d, 0x99}},
    {0x90c4, {0xe6, 0x96, 0x89}},
    {0x90c5, {0xe7, 0xa8, 0x8e}},
    {0x90c6, {0xe8, 0x84, 0x86}},
    {0x90c7, {0xe9, 0x9a, 0xbb}},
    {0x90c8, {0xe5, 0xb8, 0xad}},
    {0x90c9, {0xe6, 0x83, 0x9c}},
    {0x90ca, {0xe6, 0x88, 0x9a}},
    {0x90cb, {0xe6, 0x96, 0xa5}},
    {0x90cc, {0xe6, 0x98, 0x94}},
    {0x90cd, {0xe6, 0x9e, 0x90}},
    {0x90ce, {0xe7, 0x9f, 0xb3}},
    {0x90cf, {0xe7, 0xa9, 0x8d}},
    {0x90d0, {0xe7, 0xb1, 0x8d}},
    {0x90d1, {0xe7, 0xb8, 0xbe}},
    {0x90d2, {0xe8, 0x84, 0x8a}},
    {0x90d3, {0xe8, 0xb2, 0xac}},
    {0x90d4, {0xe8, 0xb5, 0xa4}},
    {0x90d5, {0xe8, 0xb7, 0xa1}},
    {0x90d6, {0xe8, 0xb9, 0x9f}},
    {0x90d7, {0xe7, 0xa2, 0xa9}},
    {0x90d8, {0xe5, 0x88, 0x87}},
    {0x90d9, {0xe6, 0x8b, 0x99}},
    {0x90da, {0xe6, 0x8e, 0xa5}},
    {0x90db, {0xe6, 0x91, 0x82}},
    {0x90dc, {0xe6, 0x8a, 0x98}},
    {0x90dd, {0xe8, 0xa8, 0xad}},
    {0x90de, {0xe7, 0xaa, 0x83}},
    {0x90df, {0xe7, 0xaf, 0x80}},
    {0x90e0, {0xe8, 0xaa, 0xac}},
    {0x90e1, {0xe9, 0x9b, 0xaa}},
    {0x90e2, {0xe7, 0xb5, 0xb6}},
    {0x90e3, {0xe8, 0x88, 0x8c}},
    {0x90e4, {0xe8, 0x9d, 0x89}},
    {0x90e5, {0xe4, 0xbb, 0x99}},
    {0x90e6, {0xe5, 0x85, 0x88}},
    {0x90e7, {0xe5, 0x8d, 0x83}},
    {0x90e8, {0xe5, 0x8d, 0xa0}},
    {0x90e9, {0xe5, 0xae, 0xa3}},
    {0x90ea, {0xe5, 0xb0, 0x82}},
    {0x90eb, {0xe5, 0xb0, 0x96}},
    {0x90ec, {0xe5, 0xb7, 0x9d}},
    {0x90ed, {0xe6, 0x88, 0xa6}},
    {0x90ee, {0xe6, 0x89, 0x87}},
    {0x90ef, {0xe6, 0x92, 0xb0}},
    {0x90f0, {0xe6, 0xa0, 0x93}},
    {0x90f1, {0xe6, 0xa0, 0xb4}},
    {0x90f2, {0xe6, 0xb3, 0x89}},
    {0x90f3, {0xe6, 0xb5, 0x85}},
    {0x90f4, {0xe6, 0xb4, 0x97}},
    {0x90f5, {0xe6, 0x9f, 0x93}},
    {0x90f6, {0xe6, 0xbd, 0x9c}},
    {0x90f7, {0xe7, 0x85, 0x8e}},
    {0x90f8, {0xe7, 0x85, 0xbd}},
    {0x90f9, {0xe6, 0x97, 0x8b}},
    {0x90fa, {0xe7, 0xa9, 0xbf}},
    {0x90fb, {0xe7, 0xae, 0xad}},
    {0x90fc, {0xe7, 0xb7, 0x9a}},
    {0x9140, {0xe7, 0xb9, 0x8a}},
    {0x9141, {0xe7, 0xbe, 0xa8}},
    {0x9142, {0xe8, 0x85, 0xba}},
    {0x9143, {0xe8, 0x88, 0x9b}},
    {0x9144, {0xe8, 0x88, 0xb9}},
    {0x9145, {0xe8, 0x96, 0xa6}},
    {0x9146, {0xe8, 0xa9, 0xae}},
    {0x9147, {0xe8, 0xb3, 0x8e}},
    {0x9148, {0xe8, 0xb7, 0xb5}},
    {0x9149, {0xe9, 0x81, 0xb8}},
    {0x914a, {0xe9, 0x81, 0xb7}},
    {0x914b, {0xe9, 0x8a, 0xad}},
    {0x914c, {0xe9, 0x8a, 0x91}},
    {0x914d, {0xe9, 0x96, 0x83}},
    {0x914e, {0xe9, 0xae, 0xae}},
    {0x914f, {0xe5, 0x89, 0x8d}},
    {0x9150, {0xe5, 0x96, 0x84}},
    {0x9151, {0xe6, 0xbc, 0xb8}},
    {0x9152, {0xe7, 0x84, 0xb6}},
    {0x9153, {0xe5, 0x85, 0xa8}},
    {0x9154, {0xe7, 0xa6, 0x85}},
    {0x9155, {0xe7, 0xb9, 0x95}},
    {0x9156, {0xe8, 0x86, 0xb3}},
    {0x9157, {0xe7, 0xb3, 0x8e}},
    {0x9158, {0xe5, 0x99, 0x8c}},
    {0x9159, {0xe5, 0xa1, 0x91}},
    {0x915a, {0xe5, 0xb2, 0xa8}},
    {0x915b, {0xe6, 0x8e, 0xaa}},
    {0x915c, {0xe6, 0x9b, 0xbe}},
    {0x915d, {0xe6, 0x9b, 0xbd}},
    {0x915e, {0xe6, 0xa5, 0x9a}},
    {0x915f, {0xe7, 0x8b, 0x99}},
    {0x9160, {0xe7, 0x96, 0x8f}},
    {0x9161, {0xe7, 0x96, 0x8e}},
    {0x9162, {0xe7, 0xa4, 0x8e}},
    {0x9163, {0xe7, 0xa5, 0x96}},
    {0x9164, {0xe7, 0xa7, 0x9f}},
    {0x9165, {0xe7, 0xb2, 0x97}},
    {0x9166, {0xe7, 0xb4, 0xa0}},
    {0x9167, {0xe7, 0xb5, 0x84}},
    {0x9168, {0xe8, 0x98, 0x87}},
    {0x9169, {0xe8, 0xa8, 0xb4}},
    {0x916a, {0xe9, 0x98, 0xbb}},
    {0x916b, {0xe9, 0x81, 0xa1}},
    {0x916c, {0xe9, 0xbc, 0xa0}},
    {0x916d, {0xe5, 0x83, 0xa7}},
    {0x916e, {0xe5, 0x89, 0xb5}},
    {0x916f, {0xe5, 0x8f, 0x8c}},
    {0x9170, {0xe5, 0x8f, 0xa2}},
    {0x9171, {0xe5, 0x80, 0x89}},
    {0x9172, {0xe5, 0x96, 0xaa}},
    {0x9173, {0xe5, 0xa3, 0xae}},
    {0x9174, {0xe5, 0xa5, 0x8f}},
    {0x9175, {0xe7, 0x88, 0xbd}},
    {0x9176, {0xe5, 0xae, 0x8b}},
    {0x9177, {0xe5, 0xb1, 0xa4}},
    {0x9178, {0xe5, 0x8c, 0x9d}},
    {0x9179, {0xe6, 0x83, 0xa3}},
    {0x917a, {0xe6, 0x83, 0xb3}},
    {0x917b, {0xe6, 0x8d, 0x9c}},
    {0x917c, {0xe6, 0x8e, 0x83}},
    {0x917d, {0xe6, 0x8c, 0xbf}},
    {0x917e, {0xe6, 0x8e, 0xbb}},
    {0x9180, {0xe6, 0x93, 0x8d}},
    {0x9181, {0xe6, 0x97, 0xa9}},
    {0x9182, {0xe6, 0x9b, 0xb9}},
    {0x9183, {0xe5, 0xb7, 0xa3}},
    {0x9184, {0xe6, 0xa7, 0x8d}},
    {0x9185, {0xe6, 0xa7, 0xbd}},
    {0x9186, {0xe6, 0xbc, 0x95}},
    {0x9187, {0xe7, 0x87, 0xa5}},
    {0x9188, {0xe4, 0xba, 0x89}},
    {0x9189, {0xe7, 0x97, 0xa9}},
    {0x918a, {0xe7, 0x9b, 0xb8}},
    {0x918b, {0xe7, 0xaa, 0x93}},
    {0x918c, {0xe7, 0xb3, 0x9f}},
    {0x918d, {0xe7, 0xb7, 0x8f}},
    {0x918e, {0xe7, 0xb6, 0x9c}},
    {0x918f, {0xe8, 0x81, 0xa1}},
    {0x9190, {0xe8, 0x8d, 0x89}},
    {0x9191, {0xe8, 0x8d, 0x98}},
    {0x9192, {0xe8, 0x91, 0xac}},
    {0x9193, {0xe8, 0x92, 0xbc}},
    {0x9194, {0xe8, 0x97, 0xbb}},
    {0x9195, {0xe8, 0xa3, 0x85}},
    {0x9196, {0xe8, 0xb5, 0xb0}},
    {0x9197, {0xe9, 0x80, 0x81}},
    {0x9198, {0xe9, 0x81, 0xad}},
    {0x9199, {0xe9, 0x8e, 0x97}},
    {0x919a, {0xe9, 0x9c, 0x9c}},
    {0x919b, {0xe9, 0xa8, 0x92}},
    {0x919c, {0xe5, 0x83, 0x8f}},
    {0x919d, {0xe5, 0xa2, 0x97}},
    {0x919e, {0xe6, 0x86, 0x8e}},
    {0x919f, {0xe8, 0x87, 0x93}},
    {0x91a0, {0xe8, 0x94, 0xb5}},
    {0x91a1, {0xe8, 0xb4, 0x88}},
    {0x91a2, {0xe9, 0x80, 0xa0}},
    {0x91a3, {0xe4, 0xbf, 0x83}},
    {0x91a4, {0xe5, 0x81, 0xb4}},
    {0x91a5, {0xe5, 0x89, 0x87}},
    {0x91a6, {0xe5, 0x8d, 0xb3}},
    {0x91a7, {0xe6, 0x81, 0xaf}},
    {0x91a8, {0xe6, 0x8d, 0x89}},
    {0x91a9, {0xe6, 0x9d, 0x9f}},
    {0x91aa, {0xe6, 0xb8, 0xac}},
    {0x91ab, {0xe8, 0xb6, 0xb3}},
    {0x91ac, {0xe9, 0x80, 0x9f}},
    {0x91ad, {0xe4, 0xbf, 0x97}},
    {0x91ae, {0xe5, 0xb1, 0x9e}},
    {0x91af, {0xe8, 0xb3, 0x8a}},
    {0x91b0, {0xe6, 0x97, 0x8f}},
    {0x91b1, {0xe7, 0xb6, 0x9a}},
    {0x91b2, {0xe5, 0x8d, 0x92}},
    {0x91b3, {0xe8, 0xa2, 0x96}},
    {0x91b4, {0xe5, 0x85, 0xb6}},
    {0x91b5, {0xe6, 0x8f, 0x83}},
    {0x91b6, {0xe5, 0xad, 0x98}},
    {0x91b7, {0xe5, 0xad, 0xab}},
    {0x91b8, {0xe5, 0xb0, 0x8a}},
    {0x91b9, {0xe6, 0x90, 0x8d}},
    {0x91ba, {0xe6, 0x9d, 0x91}},
    {0x91bb, {0xe9, 0x81, 0x9c}},
    {0x91bc, {0xe4, 0xbb, 0x96}},
    {0x91bd, {0xe5, 0xa4, 0x9a}},
    {0x91be, {0xe5, 0xa4, 0xaa}},
    {0x91bf, {0xe6, 0xb1, 0xb0}},
    {0x91c0, {0xe8, 0xa9, 0x91}},
    {0x91c1, {0xe5, 0x94, 0xbe}},
    {0x91c2, {0xe5, 0xa0, 0x95}},
    {0x91c3, {0xe5, 0xa6, 0xa5}},
    {0x91c4, {0xe6, 0x83, 0xb0}},
    {0x91c5, {0xe6, 0x89, 0x93}},
    {0x91c6, {0xe6, 0x9f, 0x81}},
    {0x91c7, {0xe8, 0x88, 0xb5}},
    {0x91c8, {0xe6, 0xa5, 0x95}},
    {0x91c9, {0xe9, 0x99, 0x80}},
    {0x91ca, {0xe9, 0xa7, 0x84}},
    {0x91cb, {0xe9, 0xa8, 0xa8}},
    {0x91cc, {0xe4, 0xbd, 0x93}},
    {0x91cd, {0xe5, 0xa0, 0x86}},
    {0x91ce, {0xe5, 0xaf, 0xbe}},
    {0x91cf, {0xe8, 0x80, 0x90}},
    {0x91d0, {0xe5, 0xb2, 0xb1}},
    {0x91d1, {0xe5, 0xb8, 0xaf}},
    {0x91d2, {0xe5, 0xbe, 0x85}},
    {0x91d3, {0xe6, 0x80, 0xa0}},
    {0x91d4, {0xe6, 0x85, 0x8b}},
    {0x91d5, {0xe6, 0x88, 0xb4}},
    {0x91d6, {0xe6, 0x9b, 0xbf}},
    {0x91d7, {0xe6, 0xb3, 0xb0}},
    {0x91d8, {0xe6, 0xbb, 0x9e}},
    {0x91d9, {0xe8, 0x83, 0x8e}},
    {0x91da, {0xe8, 0x85, 0xbf}},
    {0x91db, {0xe8, 0x8b, 0x94}},
    {0x91dc, {0xe8, 0xa2, 0x8b}},
    {0x91dd, {0xe8, 0xb2, 0xb8}},
    {0x91de, {0xe9, 0x80, 0x80}},
    {0x91df, {0xe9, 0x80, 0xae}},
    {0x91e0, {0xe9, 0x9a, 0x8a}},
    {0x91e1, {0xe9, 0xbb, 0x9b}},
    {0x91e2, {0xe9, 0xaf, 0x9b}},
    {0x91e3, {0xe4, 0xbb, 0xa3}},
    {0x91e4, {0xe5, 0x8f, 0xb0}},
    {0x91e5, {0xe5, 0xa4, 0xa7}},
    {0x91e6, {0xe7, 0xac, 0xac}},
    {0x91e7, {0xe9, 0x86, 0x8d}},
    {0x91e8, {0xe9, 0xa1, 0x8c}},
    {0x91e9, {0xe9, 0xb7, 0xb9}},
    {0x91ea, {0xe6, 0xbb, 0x9d}},
    {0x91eb, {0xe7, 0x80, 0xa7}},
    {0x91ec, {0xe5, 0x8d, 0x93}},
    {0x91ed, {0xe5, 0x95, 0x84}},
    {0x91ee, {0xe5, 0xae, 0x85}},
    {0x91ef, {0xe6, 0x89, 0x98}},
    {0x91f0, {0xe6, 0x8a, 0x9e}},
    {0x91f1, {0xe6, 0x8b, 0x93}},
    {0x91f2, {0xe6, 0xb2, 0xa2}},
    {0x91f3, {0xe6, 0xbf, 0xaf}},
    {0x91f4, {0xe7, 0x90, 0xa2}},
    {0x91f5, {0xe8, 0xa8, 0x97}},
    {0x91f6, {0xe9, 0x90, 0xb8}},
    {0x91f7, {0xe6, 0xbf, 0x81}},
    {0x91f8, {0xe8, 0xab, 0xbe}},
    {0x91f9, {0xe8, 0x8c, 0xb8}},
    {0x91fa, {0xe5, 0x87, 0xa7}},
    {0x91fb, {0xe8, 0x9b, 0xb8}},
    {0x91fc, {0xe5, 0x8f, 0xaa}},
    {0x9240, {0xe5, 0x8f, 0xa9}},
    {0x9241, {0xe4, 0xbd, 0x86}},
    {0x9242, {0xe9, 0x81, 0x94}},
    {0x9243, {0xe8, 0xbe, 0xb0}},
    {0x9244, {0xe5, 0xa5, 0xaa}},
    {0x9245, {0xe8, 0x84, 0xb1}},
    {0x9246, {0xe5, 0xb7, 0xbd}},
    {0x9247, {0xe7, 0xab, 0xaa}},
    {0x9248, {0xe8, 0xbe, 0xbf}},
    {0x9249, {0xe6, 0xa3, 0x9a}},
    {0x924a, {0xe8, 0xb0, 0xb7}},
    {0x924b, {0xe7, 0x8b, 0xb8}},
    {0x924c, {0xe9, 0xb1, 0x88}},
    {0x924d, {0xe6, 0xa8, 0xbd}},
    {0x924e, {0xe8, 0xaa, 0xb0}},
    {0x924f, {0xe4, 0xb8, 0xb9}},
    {0x9250, {0xe5, 0x8d, 0x98}},
    {0x9251, {0xe5, 0x98, 0x86}},
    {0x9252, {0xe5, 0x9d, 0xa6}},
    {0x9253, {0xe6, 0x8b, 0x85}},
    {0x9254, {0xe6, 0x8e, 0xa2}},
    {0x9255, {0xe6, 0x97, 0xa6}},
    {0x9256, {0xe6, 0xad, 0x8e}},
    {0x9257, {0xe6, 0xb7, 0xa1}},
    {0x9258, {0xe6, 0xb9, 0x9b}},
    {0x9259, {0xe7, 0x82, 0xad}},
    {0x925a, {0xe7, 0x9f, 0xad}},
    {0x925b, {0xe7, 0xab, 0xaf}},
    {0x925c, {0xe7, 0xae, 0xaa}},
    {0x925d, {0xe7, 0xb6, 0xbb}},
    {0x925e, {0xe8, 0x80, 0xbd}},
    {0x925f, {0xe8, 0x83, 0x86}},
    {0x9260, {0xe8, 0x9b, 0x8b}},
    {0x9261, {0xe8, 0xaa, 0x95}},
    {0x9262, {0xe9, 0x8d, 0x9b}},
    {0x9263, {0xe5, 0x9b, 0xa3}},
    {0x9264, {0xe5, 0xa3, 0x87}},
    {0x9265, {0xe5, 0xbc, 0xbe}},
    {0x9266, {0xe6, 0x96, 0xad}},
    {0x9267, {0xe6, 0x9a, 0x96}},
    {0x9268, {0xe6, 0xaa, 0x80}},
    {0x9269, {0xe6, 0xae, 0xb5}},
    {0x926a, {0xe7, 0x94, 0xb7}},
    {0x926b, {0xe8, 0xab, 0x87}},
    {0x926c, {0xe5, 0x80, 0xa4}},
    {0x926d, {0xe7, 0x9f, 0xa5}},
    {0x926e, {0xe5, 0x9c, 0xb0}},
    {0x926f, {0xe5, 0xbc, 0x9b}},
    {0x9270, {0xe6, 0x81, 0xa5}},
    {0x9271, {0xe6, 0x99, 0xba}},
    {0x9272, {0xe6, 0xb1, 0xa0}},
    {0x9273, {0xe7, 0x97, 0xb4}},
    {0x9274, {0xe7, 0xa8, 0x9a}},
    {0x9275, {0xe7, 0xbd, 0xae}},
    {0x9276, {0xe8, 0x87, 0xb4}},
    {0x9277, {0xe8, 0x9c, 0x98}},
    {0x9278, {0xe9, 0x81, 0x85}},
    {0x9279, {0xe9, 0xa6, 0xb3}},
    {0x927a, {0xe7, 0xaf, 0x89}},
    {0x927b, {0xe7, 0x95, 0x9c}},
    {0x927c, {0xe7, 0xab, 0xb9}},
    {0x927d, {0xe7, 0xad, 0x91}},
    {0x927e, {0xe8, 0x93, 0x84}},
    {0x9280, {0xe9, 0x80, 0x90}},
    {0x9281, {0xe7, 0xa7, 0xa9}},
    {0x9282, {0xe7, 0xaa, 0x92}},
    {0x9283, {0xe8, 0x8c, 0xb6}},
    {0x9284, {0xe5, 0xab, 0xa1}},
    {0x9285, {0xe7, 0x9d, 0x80}},
    {0x9286, {0xe4, 0xb8, 0xad}},
    {0x9287, {0xe4, 0xbb, 0xb2}},
    {0x9288, {0xe5, 0xae, 0x99}},
    {0x9289, {0xe5, 0xbf, 0xa0}},
    {0x928a, {0xe6, 0x8a, 0xbd}},
    {0x928b, {0xe6, 0x98, 0xbc}},
    {0x928c, {0xe6, 0x9f, 0xb1}},
    {0x928d, {0xe6, 0xb3, 0xa8}},
    {0x928e, {0xe8, 0x99, 0xab}},
    {0x928f, {0xe8, 0xa1, 0xb7}},
    {0x9290, {0xe8, 0xa8, 0xbb}},
    {0x9291, {0xe9, 0x85, 0x8e}},
    {0x9292, {0xe9, 0x8b, 0xb3}},
    {0x9293, {0xe9, 0xa7, 0x90}},
    {0x9294, {0xe6, 0xa8, 0x97}},
    {0x9295, {0xe7, 0x80, 0xa6}},
    {0x9296, {0xe7, 0x8c, 0xaa}},
    {0x9297, {0xe8, 0x8b, 0xa7}},
    {0x9298, {0xe8, 0x91, 0x97}},
    {0x9299, {0xe8, 0xb2, 0xaf}},
    {0x929a, {0xe4, 0xb8, 0x81}},
    {0x929b, {0xe5, 0x85, 0x86}},
    {0x929c, {0xe5, 0x87, 0x8b}},
    {0x929d, {0xe5, 0x96, 0x8b}},
    {0x929e, {0xe5, 0xaf, 0xb5}},
    {0x929f, {0xe5, 0xb8, 0x96}},
    {0x92a0, {0xe5, 0xb8, 0xb3}},
    {0x92a1, {0xe5, 0xba, 0x81}},
    {0x92a2, {0xe5, 0xbc, 0x94}},
    {0x92a3, {0xe5, 0xbc, 0xb5}},
    {0x92a4, {0xe5, 0xbd, 0xab}},
    {0x92a5, {0xe5, 0xbe, 0xb4}},
    {0x92a6, {0xe6, 0x87, 0xb2}},
    {0x92a7, {0xe6, 0x8c, 0x91}},
    {0x92a8, {0xe6, 0x9a, 0xa2}},
    {0x92a9, {0xe6, 0x9c, 0x9d}},
    {0x92aa, {0xe6, 0xbd, 0xae}},
    {0x92ab, {0xe7, 0x89, 0x92}},
    {0x92ac, {0xe7, 0x94, 0xba}},
    {0x92ad, {0xe7, 0x9c, 0xba}},
    {0x92ae, {0xe8, 0x81, 0xb4}},
    {0x92af, {0xe8, 0x84, 0xb9}},
    {0x92b0, {0xe8, 0x85, 0xb8}},
    {0x92b1, {0xe8, 0x9d, 0xb6}},
    {0x92b2, {0xe8, 0xaa, 0xbf}},
    {0x92b3, {0xe8, 0xab, 0x9c}},
    {0x92b4, {0xe8, 0xb6, 0x85}},
    {0x92b5, {0xe8, 0xb7, 0xb3}},
    {0x92b6, {0xe9, 0x8a, 0x9a}},
    {0x92b7, {0xe9, 0x95, 0xb7}},
    {0x92b8, {0xe9, 0xa0, 0x82}},
    {0x92b9, {0xe9, 0xb3, 0xa5}},
    {0x92ba, {0xe5, 0x8b, 0x85}},
    {0x92bb, {0xe6, 0x8d, 0x97}},
    {0x92bc, {0xe7, 0x9b, 0xb4}},
    {0x92bd, {0xe6, 0x9c, 0x95}},
    {0x92be, {0xe6, 0xb2, 0x88}},
    {0x92bf, {0xe7, 0x8f, 0x8d}},
    {0x92c0, {0xe8, 0xb3, 0x83}},
    {0x92c1, {0xe9, 0x8e, 0xae}},
    {0x92c2, {0xe9, 0x99, 0xb3}},
    {0x92c3, {0xe6, 0xb4, 0xa5}},
    {0x92c4, {0xe5, 0xa2, 0x9c}},
    {0x92c5, {0xe6, 0xa4, 0x8e}},
    {0x92c6, {0xe6, 0xa7, 0x8c}},
    {0x92c7, {0xe8, 0xbf, 0xbd}},
    {0x92c8, {0xe9, 0x8e, 0x9a}},
    {0x92c9, {0xe7, 0x97, 0x9b}},
    {0x92ca, {0xe9, 0x80, 0x9a}},
    {0x92cb, {0xe5, 0xa1, 0x9a}},
    {0x92cc, {0xe6, 0xa0, 0x82}},
    {0x92cd, {0xe6, 0x8e, 0xb4}},
    {0x92ce, {0xe6, 0xa7, 0xbb}},
    {0x92cf, {0xe4, 0xbd, 0x83}},
    {0x92d0, {0xe6, 0xbc, 0xac}},
    {0x92d1, {0xe6, 0x9f, 0x98}},
    {0x92d2, {0xe8, 0xbe, 0xbb}},
    {0x92d3, {0xe8, 0x94, 0xa6}},
    {0x92d4, {0xe7, 0xb6, 0xb4}},
    {0x92d5, {0xe9, 0x8d, 0x94}},
    {0x92d6, {0xe6, 0xa4, 0xbf}},
    {0x92d7, {0xe6, 0xbd, 0xb0}},
    {0x92d8, {0xe5, 0x9d, 0xaa}},
    {0x92d9, {0xe5, 0xa3, 0xb7}},
    {0x92da, {0xe5, 0xac, 0xac}},
    {0x92db, {0xe7, 0xb4, 0xac}},
    {0x92dc, {0xe7, 0x88, 0xaa}},
    {0x92dd, {0xe5, 0x90, 0x8a}},
    {0x92de, {0xe9, 0x87, 0xa3}},
    {0x92df, {0xe9, 0xb6, 0xb4}},
    {0x92e0, {0xe4, 0xba, 0xad}},
    {0x92e1, {0xe4, 0xbd, 0x8e}},
    {0x92e2, {0xe5, 0x81, 0x9c}},
    {0x92e3, {0xe5, 0x81, 0xb5}},
    {0x92e4, {0xe5, 0x89, 0x83}},
    {0x92e5, {0xe8, 0xb2, 0x9e}},
    {0x92e6, {0xe5, 0x91, 0x88}},
    {0x92e7, {0xe5, 0xa0, 0xa4}},
    {0x92e8, {0xe5, 0xae, 0x9a}},
    {0x92e9, {0xe5, 0xb8, 0x9d}},
    {0x92ea, {0xe5, 0xba, 0x95}},
    {0x92eb, {0xe5, 0xba, 0xad}},
    {0x92ec, {0xe5, 0xbb, 0xb7}},
    {0x92ed, {0xe5, 0xbc, 0x9f}},
    {0x92ee, {0xe6, 0x82, 0x8c}},
    {0x92ef, {0xe6, 0x8a, 0xb5}},
    {0x92f0, {0xe6, 0x8c, 0xba}},
    {0x92f1, {0xe6, 0x8f, 0x90}},
    {0x92f2, {0xe6, 0xa2, 0xaf}},
    {0x92f3, {0xe6, 0xb1, 0x80}},
    {0x92f4, {0xe7, 0xa2, 0x87}},
    {0x92f5, {0xe7, 0xa6, 0x8e}},
    {0x92f6, {0xe7, 0xa8, 0x8b}},
    {0x92f7, {0xe7, 0xb7, 0xa0}},
    {0x92f8, {0xe8, 0x89, 0x87}},
    {0x92f9, {0xe8, 0xa8, 0x82}},
    {0x92fa, {0xe8, 0xab, 0xa6}},
    {0x92fb, {0xe8, 0xb9, 0x84}},
    {0x92fc, {0xe9, 0x80, 0x93}},
    {0x9340, {0xe9, 0x82, 0xb8}},
    {0x9341, {0xe9, 0x84, 0xad}},
    {0x9342, {0xe9, 0x87, 0x98}},
    {0x9343, {0xe9, 0xbc, 0x8e}},
    {0x9344, {0xe6, 0xb3, 0xa5}},
    {0x9345, {0xe6, 0x91, 0x98}},
    {0x9346, {0xe6, 0x93, 0xa2}},
    {0x9347, {0xe6, 0x95, 0xb5}},
    {0x9348, {0xe6, 0xbb, 0xb4}},
    {0x9349, {0xe7, 0x9a, 0x84}},
    {0x934a, {0xe7, 0xac, 0x9b}},
    {0x934b, {0xe9, 0x81, 0xa9}},
    {0x934c, {0xe9, 0x8f, 0x91}},
    {0x934d, {0xe6, 0xba, 0xba}},
    {0x934e, {0xe5, 0x93, 0xb2}},
    {0x934f, {0xe5, 0xbe, 0xb9}},
    {0x9350, {0xe6, 0x92, 0xa4}},
    {0x9351, {0xe8, 0xbd, 0x8d}},
    {0x9352, {0xe8, 0xbf, 0xad}},
    {0x9353, {0xe9, 0x89, 0x84}},
    {0x9354, {0xe5, 0x85, 0xb8}},
    {0x9355, {0xe5, 0xa1, 0xab}},
    {0x9356, {0xe5, 0xa4, 0xa9}},
    {0x9357, {0xe5, 0xb1, 0x95}},
    {0x9358, {0xe5, 0xba, 0x97}},
    {0x9359, {0xe6, 0xb7, 0xbb}},
    {0x935a, {0xe7, 0xba, 0x8f}},
    {0x935b, {0xe7, 0x94, 0x9c}},
    {0x935c, {0xe8, 0xb2, 0xbc}},
    {0x935d, {0xe8, 0xbb, 0xa2}},
    {0x935e, {0xe9, 0xa1, 0x9b}},
    {0x935f, {0xe7, 0x82, 0xb9}},
    {0x9360, {0xe4, 0xbc, 0x9d}},
    {0x9361, {0xe6, 0xae, 0xbf}},
    {0x9362, {0xe6, 0xbe, 0xb1}},
    {0x9363, {0xe7, 0x94, 0xb0}},
    {0x9364, {0xe9, 0x9b, 0xbb}},
    {0x9365, {0xe5, 0x85, 0x8e}},
    {0x9366, {0xe5, 0x90, 0x90}},
    {0x9367, {0xe5, 0xa0, 0xb5}},
    {0x9368, {0xe5, 0xa1, 0x97}},
    {0x9369, {0xe5, 0xa6, 0xac}},
    {0x936a, {0xe5, 0xb1, 0xa0}},
    {0x936b, {0xe5, 0xbe, 0x92}},
    {0x936c, {0xe6, 0x96, 0x97}},
    {0x936d, {0xe6, 0x9d, 0x9c}},
    {0x936e, {0xe6, 0xb8, 0xa1}},
    {0x936f, {0xe7, 0x99, 0xbb}},
    {0x9370, {0xe8, 0x8f, 0x9f}},
    {0x9371, {0xe8, 0xb3, 0xad}},
    {0x9372, {0xe9, 0x80, 0x94}},
    {0x9373, {0xe9, 0x83, 0xbd}},
    {0x9374, {0xe9, 0x8d, 0x8d}},
    {0x9375, {0xe7, 0xa0, 0xa5}},
    {0x9376, {0xe7, 0xa0, 0xba}},
    {0x9377, {0xe5, 0x8a, 0xaa}},
    {0x9378, {0xe5, 0xba, 0xa6}},
    {0x9379, {0xe5, 0x9c, 0x9f}},
    {0x937a, {0xe5, 0xa5, 0xb4}},
    {0x937b, {0xe6, 0x80, 0x92}},
    {0x937c, {0xe5, 0x80, 0x92}},
    {0x937d, {0xe5, 0x85, 0x9a}},
    {0x937e, {0xe5, 0x86, 0xac}},
    {0x9380, {0xe5, 0x87, 0x8d}},
    {0x9381, {0xe5, 0x88, 0x80}},
    {0x9382, {0xe5, 0x94, 0x90}},
    {0x9383, {0xe5, 0xa1, 0x94}},
    {0x9384, {0xe5, 0xa1, 0x98}},
    {0x9385, {0xe5, 0xa5, 0x97}},
    {0x9386, {0xe5, 0xae, 0x95}},
    {0x9387, {0xe5, 0xb3, 0xb6}},
    {0x9388, {0xe5, 0xb6, 0x8b}},
    {0x9389, {0xe6, 0x82, 0xbc}},
    {0x938a, {0xe6, 0x8a, 0x95}},
    {0x938b, {0xe6, 0x90, 0xad}},
    {0x938c, {0xe6, 0x9d, 0xb1}},
    {0x938d, {0xe6, 0xa1, 0x83}},
    {0x938e, {0xe6, 0xa2, 0xbc}},
    {0x938f, {0xe6, 0xa3, 0x9f}},
    {0x9390, {0xe7, 0x9b, 0x97}},
    {0x9391, {0xe6, 0xb7, 0x98}},
    {0x9392, {0xe6, 0xb9, 0xaf}},
    {0x9393, {0xe6, 0xb6, 0x9b}},
    {0x9394, {0xe7, 0x81, 0xaf}},
    {0x9395, {0xe7, 0x87, 0x88}},
    {0x9396, {0xe5, 0xbd, 0x93}},
    {0x9397, {0xe7, 0x97, 0x98}},
    {0x9398, {0xe7, 0xa5, 0xb7}},
    {0x9399, {0xe7, 0xad, 0x89}},
    {0x939a, {0xe7, 0xad, 0x94}},
    {0x939b, {0xe7, 0xad, 0x92}},
    {0x939c, {0xe7, 0xb3, 0x96}},
    {0x939d, {0xe7, 0xb5, 0xb1}},
    {0x939e, {0xe5, 0x88, 0xb0}},
    {0x939f, {0xe8, 0x91, 0xa3}},
    {0x93a0, {0xe8, 0x95, 0xa9}},
    {0x93a1, {0xe8, 0x97, 0xa4}},
    {0x93a2, {0xe8, 0xa8, 0x8e}},
    {0x93a3, {0xe8, 0xac, 0x84}},
    {0x93a4, {0xe8, 0xb1, 0x86}},
    {0x93a5, {0xe8, 0xb8, 0x8f}},
    {0x93a6, {0xe9, 0x80, 0x83}},
    {0x93a7, {0xe9, 0x80, 0x8f}},
    {0x93a8, {0xe9, 0x90, 0x99}},
    {0x93a9, {0xe9, 0x99, 0xb6}},
    {0x93aa, {0xe9, 0xa0, 0xad}},
    {0x93ab, {0xe9, 0xa8, 0xb0}},
    {0x93ac, {0xe9, 0x97, 0x98}},
    {0x93ad, {0xe5, 0x83, 0x8d}},
    {0x93ae, {0xe5, 0x8b, 0x95}},
    {0x93af, {0xe5, 0x90, 0x8c}},
    {0x93b0, {0xe5, 0xa0, 0x82}},
    {0x93b1, {0xe5, 0xb0, 0x8e}},
    {0x93b2, {0xe6, 0x86, 0xa7}},
    {0x93b3, {0xe6, 0x92, 0x9e}},
    {0x93b4, {0xe6, 0xb4, 0x9e}},
    {0x93b5, {0xe7, 0x9e, 0xb3}},
    {0x93b6, {0xe7, 0xab, 0xa5}},
    {0x93b7, {0xe8, 0x83, 0xb4}},
    {0x93b8, {0xe8, 0x90, 0x84}},
    {0x93b9, {0xe9, 0x81, 0x93}},
    {0x93ba, {0xe9, 0x8a, 0x85}},
    {0x93bb, {0xe5, 0xb3, 0xa0}},
    {0x93bc, {0xe9, 0xb4, 0x87}},
    {0x93bd, {0xe5, 0x8c, 0xbf}},
    {0x93be, {0xe5, 0xbe, 0x97}},
    {0x93bf, {0xe5, 0xbe, 0xb3}},
    {0x93c0, {0xe6, 0xb6, 0x9c}},
    {0x93c1, {0xe7, 0x89, 0xb9}},
    {0x93c2, {0xe7, 0x9d, 0xa3}},
    {0x93c3, {0xe7, 0xa6, 0xbf}},
    {0x93c4, {0xe7, 0xaf, 0xa4}},
    {0x93c5, {0xe6, 0xaf, 0x92}},
    {0x93c6, {0xe7, 0x8b, 0xac}},
    {0x93c7, {0xe8, 0xaa, 0xad}},
    {0x93c8, {0xe6, 0xa0, 0x83}},
    {0x93c9, {0xe6, 0xa9, 0xa1}},
    {0x93ca, {0xe5, 0x87, 0xb8}},
    {0x93cb, {0xe7, 0xaa, 0x81}},
    {0x93cc, {0xe6, 0xa4, 0xb4}},
    {0x93cd, {0xe5, 0xb1, 0x8a}},
    {0x93ce, {0xe9, 0xb3, 0xb6}},
    {0x93cf, {0xe8, 0x8b, 0xab}},
    {0x93d0, {0xe5, 0xaf, 0x85}},
    {0x93d1, {0xe9, 0x85, 0x89}},
    {0x93d2, {0xe7, 0x80, 0x9e}},
    {0x93d3, {0xe5, 0x99, 0xb8}},
    {0x93d4, {0xe5, 0xb1, 0xaf}},
    {0x93d5, {0xe6, 0x83, 0x87}},
    {0x93d6, {0xe6, 0x95, 0xa6}},
    {0x93d7, {0xe6, 0xb2, 0x8c}},
    {0x93d8, {0xe8, 0xb1, 0x9a}},
    {0x93d9, {0xe9, 0x81, 0x81}},
    {0x93da, {0xe9, 0xa0, 0x93}},
    {0x93db, {0xe5, 0x91, 0x91}},
    {0x93dc, {0xe6, 0x9b, 0x87}},
    {0x93dd, {0xe9, 0x88, 0x8d}},
    {0x93de, {0xe5, 0xa5, 0x88}},
    {0x93df, {0xe9, 0x82, 0xa3}},
    {0x93e0, {0xe5, 0x86, 0x85}},
    {0x93e1, {0xe4, 0xb9, 0x8d}},
    {0x93e2, {0xe5, 0x87, 0xaa}},
    {0x93e3, {0xe8, 0x96, 0x99}},
    {0x93e4, {0xe8, 0xac, 0x8e}},
    {0x93e5, {0xe7, 0x81, 0x98}},
    {0x93e6, {0xe6, 0x8d, 0xba}},
    {0x93e7, {0xe9, 0x8d, 0x8b}},
    {0x93e8, {0xe6, 0xa5, 0xa2}},
    {0x93e9, {0xe9, 0xa6, 0xb4}},
    {0x93ea, {0xe7, 0xb8, 0x84}},
    {0x93eb, {0xe7, 0x95, 0xb7}},
    {0x93ec, {0xe5, 0x8d, 0x97}},
    {0x93ed, {0xe6, 0xa5, 0xa0}},
    {0x93ee, {0xe8, 0xbb, 0x9f}},
    {0x93ef, {0xe9, 0x9b, 0xa3}},
    {0x93f0, {0xe6, 0xb1, 0x9d}},
    {0x93f1, {0xe4, 0xba, 0x8c}},
    {0x93f2, {0xe5, 0xb0, 0xbc}},
    {0x93f3, {0xe5, 0xbc, 0x90}},
    {0x93f4, {0xe8, 0xbf, 0xa9}},
    {0x93f5, {0xe5, 0x8c, 0x82}},
    {0x93f6, {0xe8, 0xb3, 0x91}},
    {0x93f7, {0xe8, 0x82, 0x89}},
    {0x93f8, {0xe8, 0x99, 0xb9}},
    {0x93f9, {0xe5, 0xbb, 0xbf}},
    {0x93fa, {0xe6, 0x97, 0xa5}},
    {0x93fb, {0xe4, 0xb9, 0xb3}},
    {0x93fc, {0xe5, 0x85, 0xa5}},
    {0x9440, {0xe5, 0xa6, 0x82}},
    {0x9441, {0xe5, 0xb0, 0xbf}},
    {0x9442, {0xe9, 0x9f, 0xae}},
    {0x9443, {0xe4, 0xbb, 0xbb}},
    {0x9444, {0xe5, 0xa6, 0x8a}},
    {0x9445, {0xe5, 0xbf, 0x8d}},
    {0x9446, {0xe8, 0xaa, 0x8d}},
    {0x9447, {0xe6, 0xbf, 0xa1}},
    {0x9448, {0xe7, 0xa6, 0xb0}},
    {0x9449, {0xe7, 0xa5, 0xa2}},
    {0x944a, {0xe5, 0xaf, 0xa7}},
    {0x944b, {0xe8, 0x91, 0xb1}},
    {0x944c, {0xe7, 0x8c, 0xab}},
    {0x944d, {0xe7, 0x86, 0xb1}},
    {0x944e, {0xe5, 0xb9, 0xb4}},
    {0x944f, {0xe5, 0xbf, 0xb5}},
    {0x9450, {0xe6, 0x8d, 0xbb}},
    {0x9451, {0xe6, 0x92, 0x9a}},
    {0x9452, {0xe7, 0x87, 0x83}},
    {0x9453, {0xe7, 0xb2, 0x98}},
    {0x9454, {0xe4, 0xb9, 0x83}},
    {0x9455, {0xe5, 0xbb, 0xbc}},
    {0x9456, {0xe4, 0xb9, 0x8b}},
    {0x9457, {0xe5, 0x9f, 0x9c}},
    {0x9458, {0xe5, 0x9a, 0xa2}},
    {0x9459, {0xe6, 0x82, 0xa9}},
    {0x945a, {0xe6, 0xbf, 0x83}},
    {0x945b, {0xe7, 0xb4, 0x8d}},
    {0x945c, {0xe8, 0x83, 0xbd}},
    {0x945d, {0xe8, 0x84, 0xb3}},
    {0x945e, {0xe8, 0x86, 0xbf}},
    {0x945f, {0xe8, 0xbe, 0xb2}},
    {0x9460, {0xe8, 0xa6, 0x97}},
    {0x9461, {0xe8, 0x9a, 0xa4}},
    {0x9462, {0xe5, 0xb7, 0xb4}},
    {0x9463, {0xe6, 0x8a, 0x8a}},
    {0x9464, {0xe6, 0x92, 0xad}},
    {0x9465, {0xe8, 0xa6, 0x87}},
    {0x9466, {0xe6, 0x9d, 0xb7}},
    {0x9467, {0xe6, 0xb3, 0xa2}},
    {0x9468, {0xe6, 0xb4, 0xbe}},
    {0x9469, {0xe7, 0x90, 0xb6}},
    {0x946a, {0xe7, 0xa0, 0xb4}},
    {0x946b, {0xe5, 0xa9, 0x86}},
    {0x946c, {0xe7, 0xbd, 0xb5}},
    {0x946d, {0xe8, 0x8a, 0xad}},
    {0x946e, {0xe9, 0xa6, 0xac}},
    {0x946f, {0xe4, 0xbf, 0xb3}},
    {0x9470, {0xe5, 0xbb, 0x83}},
    {0x9471, {0xe6, 0x8b, 0x9d}},
    {0x9472, {0xe6, 0x8e, 0x92}},
    {0x9473, {0xe6, 0x95, 0x97}},
    {0x9474, {0xe6, 0x9d, 0xaf}},
    {0x9475, {0xe7, 0x9b, 0x83}},
    {0x9476, {0xe7, 0x89, 0x8c}},
    {0x9477, {0xe8, 0x83, 0x8c}},
    {0x9478, {0xe8, 0x82, 0xba}},
    {0x9479, {0xe8, 0xbc, 0xa9}},
    {0x947a, {0xe9, 0x85, 0x8d}},
    {0x947b, {0xe5, 0x80, 0x8d}},
    {0x947c, {0xe5, 0x9f, 0xb9}},
    {0x947d, {0xe5, 0xaa, 0x92}},
    {0x947e, {0xe6, 0xa2, 0x85}},
    {0x9480, {0xe6, 0xa5, 0xb3}},
    {0x9481, {0xe7, 0x85, 0xa4}},
    {0x9482, {0xe7, 0x8b, 0xbd}},
    {0x9483, {0xe8, 0xb2, 0xb7}},
    {0x9484, {0xe5, 0xa3, 0xb2}},
    {0x9485, {0xe8, 0xb3, 0xa0}},
    {0x9486, {0xe9, 0x99, 0xaa}},
    {0x9487, {0xe9, 0x80, 0x99}},
    {0x9488, {0xe8, 0x9d, 0xbf}},
    {0x9489, {0xe7, 0xa7, 0xa4}},
    {0x948a, {0xe7, 0x9f, 0xa7}},
    {0x948b, {0xe8, 0x90, 0xa9}},
    {0x948c, {0xe4, 0xbc, 0xaf}},
    {0x948d, {0xe5, 0x89, 0xa5}},
    {0x948e, {0xe5, 0x8d, 0x9a}},
    {0x948f, {0xe6, 0x8b, 0x8d}},
    {0x9490, {0xe6, 0x9f, 0x8f}},
    {0x9491, {0xe6, 0xb3, 0x8a}},
    {0x9492, {0xe7, 0x99, 0xbd}},
    {0x9493, {0xe7, 0xae, 0x94}},
    {0x9494, {0xe7, 0xb2, 0x95}},
    {0x9495, {0xe8, 0x88, 0xb6}},
    {0x9496, {0xe8, 0x96, 0x84}},
    {0x9497, {0xe8, 0xbf, 0xab}},
    {0x9498, {0xe6, 0x9b, 0x9d}},
    {0x9499, {0xe6, 0xbc, 0xa0}},
    {0x949a, {0xe7, 0x88, 0x86}},
    {0x949b, {0xe7, 0xb8, 0x9b}},
    {0x949c, {0xe8, 0x8e, 0xab}},
    {0x949d, {0xe9, 0xa7, 0x81}},
    {0x949e, {0xe9, 0xba, 0xa6}},
    {0x949f, {0xe5, 0x87, 0xbd}},
    {0x94a0, {0xe7, 0xae, 0xb1}},
    {0x94a1, {0xe7, 0xa1, 0xb2}},
    {0x94a2, {0xe7, 0xae, 0xb8}},
    {0x94a3, {0xe8, 0x82, 0x87}},
    {0x94a4, {0xe7, 0xad, 0x88}},
    {0x94a5, {0xe6, 0xab, 0xa8}},
    {0x94a6, {0xe5, 0xb9, 0xa1}},
    {0x94a7, {0xe8, 0x82, 0x8c}},
    {0x94a8, {0xe7, 0x95, 0x91}},
    {0x94a9, {0xe7, 0x95, 0xa0}},
    {0x94aa, {0xe5, 0x85, 0xab}},
    {0x94ab, {0xe9, 0x89, 0xa2}},
    {0x94ac, {0xe6, 0xba, 0x8c}},
    {0x94ad, {0xe7, 0x99, 0xba}},
    {0x94ae, {0xe9, 0x86, 0x97}},
    {0x94af, {0xe9, 0xab, 0xaa}},
    {0x94b0, {0xe4, 0xbc, 0x90}},
    {0x94b1, {0xe7, 0xbd, 0xb0}},
    {0x94b2, {0xe6, 0x8a, 0x9c}},
    {0x94b3, {0xe7, 0xad, 0x8f}},
    {0x94b4, {0xe9, 0x96, 0xa5}},
    {0x94b5, {0xe9, 0xb3, 0xa9}},
    {0x94b6, {0xe5, 0x99, 0xba}},
    {0x94b7, {0xe5, 0xa1, 0x99}},
    {0x94b8, {0xe8, 0x9b, 0xa4}},
    {0x94b9, {0xe9, 0x9a, 0xbc}},
    {0x94ba, {0xe4, 0xbc, 0xb4}},
    {0x94bb, {0xe5, 0x88, 0xa4}},
    {0x94bc, {0xe5, 0x8d, 0x8a}},
    {0x94bd, {0xe5, 0x8f, 0x8d}},
    {0x94be, {0xe5, 0x8f, 0x9b}},
    {0x94bf, {0xe5, 0xb8, 0x86}},
    {0x94c0, {0xe6, 0x90, 0xac}},
    {0x94c1, {0xe6, 0x96, 0x91}},
    {0x94c2, {0xe6, 0x9d, 0xbf}},
    {0x94c3, {0xe6, 0xb0, 0xbe}},
    {0x94c4, {0xe6, 0xb1, 0x8e}},
    {0x94c5, {0xe7, 0x89, 0x88}},
    {0x94c6, {0xe7, 0x8a, 0xaf}},
    {0x94c7, {0xe7, 0x8f, 0xad}},
    {0x94c8, {0xe7, 0x95, 0x94}},
    {0x94c9, {0xe7, 0xb9, 0x81}},
    {0x94ca, {0xe8, 0x88, 0xac}},
    {0x94cb, {0xe8, 0x97, 0xa9}},
    {0x94cc, {0xe8, 0xb2, 0xa9}},
    {0x94cd, {0xe7, 0xaf, 0x84}},
    {0x94ce, {0xe9, 0x87, 0x86}},
    {0x94cf, {0xe7, 0x85, 0xa9}},
    {0x94d0, {0xe9, 0xa0, 0x92}},
    {0x94d1, {0xe9, 0xa3, 0xaf}},
    {0x94d2, {0xe6, 0x8c, 0xbd}},
    {0x94d3, {0xe6, 0x99, 0xa9}},
    {0x94d4, {0xe7, 0x95, 0xaa}},
    {0x94d5, {0xe7, 0x9b, 0xa4}},
    {0x94d6, {0xe7, 0xa3, 0x90}},
    {0x94d7, {0xe8, 0x95, 0x83}},
    {0x94d8, {0xe8, 0x9b, 0xae}},
    {0x94d9, {0xe5, 0x8c, 0xaa}},
    {0x94da, {0xe5, 0x8d, 0x91}},
    {0x94db, {0xe5, 0x90, 0xa6}},
    {0x94dc, {0xe5, 0xa6, 0x83}},
    {0x94dd, {0xe5, 0xba, 0x87}},
    {0x94de, {0xe5, 0xbd, 0xbc}},
    {0x94df, {0xe6, 0x82, 0xb2}},
    {0x94e0, {0xe6, 0x89, 0x89}},
    {0x94e1, {0xe6, 0x89, 0xb9}},
    {0x94e2, {0xe6, 0x8a, 0xab}},
    {0x94e3, {0xe6, 0x96, 0x90}},
    {0x94e4, {0xe6, 0xaf, 0x94}},
    {0x94e5, {0xe6, 0xb3, 0x8c}},
    {0x94e6, {0xe7, 0x96, 0xb2}},
    {0x94e7, {0xe7, 0x9a, 0xae}},
    {0x94e8, {0xe7, 0xa2, 0x91}},
    {0x94e9, {0xe7, 0xa7, 0x98}},
    {0x94ea, {0xe7, 0xb7, 0x8b}},
    {0x94eb, {0xe7, 0xbd, 0xb7}},
    {0x94ec, {0xe8, 0x82, 0xa5}},
    {0x94ed, {0xe8, 0xa2, 0xab}},
    {0x94ee, {0xe8, 0xaa, 0xb9}},
    {0x94ef, {0xe8, 0xb2, 0xbb}},
    {0x94f0, {0xe9, 0x81, 0xbf}},
    {0x94f1, {0xe9, 0x9d, 0x9e}},
    {0x94f2, {0xe9, 0xa3, 0x9b}},
    {0x94f3, {0xe6, 0xa8, 0x8b}},
    {0x94f4, {0xe7, 0xb0, 0xb8}},
    {0x94f5, {0xe5, 0x82, 0x99}},
    {0x94f6, {0xe5, 0xb0, 0xbe}},
    {0x94f7, {0xe5, 0xbe, 0xae}},
    {0x94f8, {0xe6, 0x9e, 0x87}},
    {0x94f9, {0xe6, 0xaf, 0x98}},
    {0x94fa, {0xe7, 0x90, 0xb5}},
    {0x94fb, {0xe7, 0x9c, 0x89}},
    {0x94fc, {0xe7, 0xbe, 0x8e}},
    {0x9540, {0xe9, 0xbc, 0xbb}},
    {0x9541, {0xe6, 0x9f, 0x8a}},
    {0x9542, {0xe7, 0xa8, 0x97}},
    {0x9543, {0xe5, 0x8c, 0xb9}},
    {0x9544, {0xe7, 0x96, 0x8b}},
    {0x9545, {0xe9, 0xab, 0xad}},
    {0x9546, {0xe5, 0xbd, 0xa6}},
    {0x9547, {0xe8, 0x86, 0x9d}},
    {0x9548, {0xe8, 0x8f, 0xb1}},
    {0x9549, {0xe8, 0x82, 0x98}},
    {0x954a, {0xe5, 0xbc, 0xbc}},
    {0x954b, {0xe5, 0xbf, 0x85}},
    {0x954c, {0xe7, 0x95, 0xa2}},
    {0x954d, {0xe7, 0xad, 0x86}},
    {0x954e, {0xe9, 0x80, 0xbc}},
    {0x954f, {0xe6, 0xa1, 0xa7}},
    {0x9550, {0xe5, 0xa7, 0xab}},
    {0x9551, {0xe5, 0xaa, 0x9b}},
    {0x9552, {0xe7, 0xb4, 0x90}},
    {0x9553, {0xe7, 0x99, 0xbe}},
    {0x9554, {0xe8, 0xac, 0xac}},
    {0x9555, {0xe4, 0xbf, 0xb5}},
    {0x9556, {0xe5, 0xbd, 0xaa}},
    {0x9557, {0xe6, 0xa8, 0x99}},
    {0x9558, {0xe6, 0xb0, 0xb7}},
    {0x9559, {0xe6, 0xbc, 0x82}},
    {0x955a, {0xe7, 0x93, 0xa2}},
    {0x955b, {0xe7, 0xa5, 0xa8}},
    {0x955c, {0xe8, 0xa1, 0xa8}},
    {0x955d, {0xe8, 0xa9, 0x95}},
    {0x955e, {0xe8, 0xb1, 0xb9}},
    {0x955f, {0xe5, 0xbb, 0x9f}},
    {0x9560, {0xe6, 0x8f, 0x8f}},
    {0x9561, {0xe7, 0x97, 0x85}},
    {0x9562, {0xe7, 0xa7, 0x92}},
    {0x9563, {0xe8, 0x8b, 0x97}},
    {0x9564, {0xe9, 0x8c, 0xa8}},
    {0x9565, {0xe9, 0x8b, 0xb2}},
    {0x9566, {0xe8, 0x92, 0x9c}},
    {0x9567, {0xe8, 0x9b, 0xad}},
    {0x9568, {0xe9, 0xb0, 0xad}},
    {0x9569, {0xe5, 0x93, 0x81}},
    {0x956a, {0xe5, 0xbd, 0xac}},
    {0x956b, {0xe6, 0x96, 0x8c}},
    {0x956c, {0xe6, 0xb5, 0x9c}},
    {0x956d, {0xe7, 0x80, 0x95}},
    {0x956e, {0xe8, 0xb2, 0xa7}},
    {0x956f, {0xe8, 0xb3, 0x93}},
    {0x9570, {0xe9, 0xa0, 0xbb}},
    {0x9571, {0xe6, 0x95, 0x8f}},
    {0x9572, {0xe7, 0x93, 0xb6}},
    {0x9573, {0xe4, 0xb8, 0x8d}},
    {0x9574, {0xe4, 0xbb, 0x98}},
    {0x9575, {0xe5, 0x9f, 0xa0}},
    {0x9576, {0xe5, 0xa4, 0xab}},
    {0x9577, {0xe5, 0xa9, 0xa6}},
    {0x9578, {0xe5, 0xaf, 0x8c}},
    {0x9579, {0xe5, 0x86, 0xa8}},
    {0x957a, {0xe5, 0xb8, 0x83}},
    {0x957b, {0xe5, 0xba, 0x9c}},
    {0x957c, {0xe6, 0x80, 0x96}},
    {0x957d, {0xe6, 0x89, 0xb6}},
    {0x957e, {0xe6, 0x95, 0xb7}},
    {0x9580, {0xe6, 0x96, 0xa7}},
    {0x9581, {0xe6, 0x99, 0xae}},
    {0x9582, {0xe6, 0xb5, 0xae}},
    {0x9583, {0xe7, 0x88, 0xb6}},
    {0x9584, {0xe7, 0xac, 0xa6}},
    {0x9585, {0xe8, 0x85, 0x90}},
    {0x9586, {0xe8, 0x86, 0x9a}},
    {0x9587, {0xe8, 0x8a, 0x99}},
    {0x9588, {0xe8, 0xad, 0x9c}},
    {0x9589, {0xe8, 0xb2, 0xa0}},
    {0x958a, {0xe8, 0xb3, 0xa6}},
    {0x958b, {0xe8, 0xb5, 0xb4}},
    {0x958c, {0xe9, 0x98, 0x9c}},
    {0x958d, {0xe9, 0x99, 0x84}},
    {0x958e, {0xe4, 0xbe, 0xae}},
    {0x958f, {0xe6, 0x92, 0xab}},
    {0x9590, {0xe6, 0xad, 0xa6}},
    {0x9591, {0xe8, 0x88, 0x9e}},
    {0x9592, {0xe8, 0x91, 0xa1}},
    {0x9593, {0xe8, 0x95, 0xaa}},
    {0x9594, {0xe9, 0x83, 0xa8}},
    {0x9595, {0xe5, 0xb0, 0x81}},
    {0x9596, {0xe6, 0xa5, 0x93}},
    {0x9597, {0xe9, 0xa2, 0xa8}},
    {0x9598, {0xe8, 0x91, 0xba}},
    {0x9599, {0xe8, 0x95, 0x97}},
    {0x959a, {0xe4, 0xbc, 0x8f}},
    {0x959b, {0xe5, 0x89, 0xaf}},
    {0x959c, {0xe5, 0xbe, 0xa9}},
    {0x959d, {0xe5, 0xb9, 0x85}},
    {0x959e, {0xe6, 0x9c, 0x8d}},
    {0x959f, {0xe7, 0xa6, 0x8f}},
    {0x95a0, {0xe8, 0x85, 0xb9}},
    {0x95a1, {0xe8, 0xa4, 0x87}},
    {0x95a2, {0xe8, 0xa6, 0x86}},
    {0x95a3, {0xe6, 0xb7, 0xb5}},
    {0x95a4, {0xe5, 0xbc, 0x97}},
    {0x95a5, {0xe6, 0x89, 0x95}},
    {0x95a6, {0xe6, 0xb2, 0xb8}},
    {0x95a7, {0xe4, 0xbb, 0x8f}},
    {0x95a8, {0xe7, 0x89, 0xa9}},
    {0x95a9, {0xe9, 0xae, 0x92}},
    {0x95aa, {0xe5, 0x88, 0x86}},
    {0x95ab, {0xe5, 0x90, 0xbb}},
    {0x95ac, {0xe5, 0x99, 0xb4}},
    {0x95ad, {0xe5, 0xa2, 0xb3}},
    {0x95ae, {0xe6, 0x86, 0xa4}},
    {0x95af, {0xe6, 0x89, 0xae}},
    {0x95b0, {0xe7, 0x84, 0x9a}},
    {0x95b1, {0xe5, 0xa5, 0xae}},
    {0x95b2, {0xe7, 0xb2, 0x89}},
    {0x95b3, {0xe7, 0xb3, 0x9e}},
    {0x95b4, {0xe7, 0xb4, 0x9b}},
    {0x95b5, {0xe9, 0x9b, 0xb0}},
    {0x95b6, {0xe6, 0x96, 0x87}},
    {0x95b7, {0xe8, 0x81, 0x9e}},
    {0x95b8, {0xe4, 0xb8, 0x99}},
    {0x95b9, {0xe4, 0xbd, 0xb5}},
    {0x95ba, {0xe5, 0x85, 0xb5}},
    {0x95bb, {0xe5, 0xa1, 0x80}},
    {0x95bc, {0xe5, 0xb9, 0xa3}},
    {0x95bd, {0xe5, 0xb9, 0xb3}},
    {0x95be, {0xe5, 0xbc, 0x8a}},
    {0x95bf, {0xe6, 0x9f, 0x84}},
    {0x95c0, {0xe4, 0xb8, 0xa6}},
    {0x95c1, {0xe8, 0x94, 0xbd}},
    {0x95c2, {0xe9, 0x96, 0x89}},
    {0x95c3, {0xe9, 0x99, 0x9b}},
    {0x95c4, {0xe7, 0xb1, 0xb3}},
    {0x95c5, {0xe9, 0xa0, 0x81}},
    {0x95c6, {0xe5, 0x83, 0xbb}},
    {0x95c7, {0xe5, 0xa3, 0x81}},
    {0x95c8, {0xe7, 0x99, 0x96}},
    {0x95c9, {0xe7, 0xa2, 0xa7}},
    {0x95ca, {0xe5, 0x88, 0xa5}},
    {0x95cb, {0xe7, 0x9e, 0xa5}},
    {0x95cc, {0xe8, 0x94, 0x91}},
    {0x95cd, {0xe7, 0xae, 0x86}},
    {0x95ce, {0xe5, 0x81, 0x8f}},
    {0x95cf, {0xe5, 0xa4, 0x89}},
    {0x95d0, {0xe7, 0x89, 0x87}},
    {0x95d1, {0xe7, 0xaf, 0x87}},
    {0x95d2, {0xe7, 0xb7, 0xa8}},
    {0x95d3, {0xe8, 0xbe, 0xba}},
    {0x95d4, {0xe8, 0xbf, 0x94}},
    {0x95d5, {0xe9, 0x81, 0x8d}},
    {0x95d6, {0xe4, 0xbe, 0xbf}},
    {0x95d7, {0xe5, 0x8b, 0x89}},
    {0x95d8, {0xe5, 0xa8, 0xa9}},
    {0x95d9, {0xe5, 0xbc, 0x81}},
    {0x95da, {0xe9, 0x9e, 0xad}},
    {0x95db, {0xe4, 0xbf, 0x9d}},
    {0x95dc, {0xe8, 0x88, 0x97}},
    {0x95dd, {0xe9, 0x8b, 0xaa}},
    {0x95de, {0xe5, 0x9c, 0x83}},
    {0x95df, {0xe6, 0x8d, 0x95}},
    {0x95e0, {0xe6, 0xad, 0xa9}},
    {0x95e1, {0xe7, 0x94, 0xab}},
    {0x95e2, {0xe8, 0xa3, 0x9c}},
    {0x95e3, {0xe8, 0xbc, 0x94}},
    {0x95e4, {0xe7, 0xa9, 0x82}},
    {0x95e5, {0xe5, 0x8b, 0x9f}},
    {0x95e6, {0xe5, 0xa2, 0x93}},
    {0x95e7, {0xe6, 0x85, 0x95}},
    {0x95e8, {0xe6, 0x88, 0x8a}},
    {0x95e9, {0xe6, 0x9a, 0xae}},
    {0x95ea, {0xe6, 0xaf, 0x8d}},
    {0x95eb, {0xe7, 0xb0, 0xbf}},
    {0x95ec, {0xe8, 0x8f, 0xa9}},
    {0x95ed, {0xe5, 0x80, 0xa3}},
    {0x95ee, {0xe4, 0xbf, 0xb8}},
    {0x95ef, {0xe5, 0x8c, 0x85}},
    {0x95f0, {0xe5, 0x91, 0x86}},
    {0x95f1, {0xe5, 0xa0, 0xb1}},
    {0x95f2, {0xe5, 0xa5, 0x89}},
    {0x95f3, {0xe5, 0xae, 0x9d}},
    {0x95f4, {0xe5, 0xb3, 0xb0}},
    {0x95f5, {0xe5, 0xb3, 0xaf}},
    {0x95f6, {0xe5, 0xb4, 0xa9}},
    {0x95f7, {0xe5, 0xba, 0x96}},
    {0x95f8, {0xe6, 0x8a, 0xb1}},
    {0x95f9, {0xe6, 0x8d, 0xa7}},
    {0x95fa, {0xe6, 0x94, 0xbe}},
    {0x95fb, {0xe6, 0x96, 0xb9}},
    {0x95fc, {0xe6, 0x9c, 0x8b}},
    {0x9640, {0xe6, 0xb3, 0x95}},
    {0x9641, {0xe6, 0xb3, 0xa1}},
    {0x9642, {0xe7, 0x83, 0xb9}},
    {0x9643, {0xe7, 0xa0, 0xb2}},
    {0x9644, {0xe7, 0xb8, 0xab}},
    {0x9645, {0xe8, 0x83, 0x9e}},
    {0x9646, {0xe8, 0x8a, 0xb3}},
    {0x9647, {0xe8, 0x90, 0x8c}},
    {0x9648, {0xe8, 0x93, 0xac}},
    {0x9649, {0xe8, 0x9c, 0x82}},
    {0x964a, {0xe8, 0xa4, 0x92}},
    {0x964b, {0xe8, 0xa8, 0xaa}},
    {0x964c, {0xe8, 0xb1, 0x8a}},
    {0x964d, {0xe9, 0x82, 0xa6}},
    {0x964e, {0xe9, 0x8b, 0x92}},
    {0x964f, {0xe9, 0xa3, 0xbd}},
    {0x9650, {0xe9, 0xb3, 0xb3}},
    {0x9651, {0xe9, 0xb5, 0xac}},
    {0x9652, {0xe4, 0xb9, 0x8f}},
    {0x9653, {0xe4, 0xba, 0xa1}},
    {0x9654, {0xe5, 0x82, 0x8d}},
    {0x9655, {0xe5, 0x89, 0x96}},
    {0x9656, {0xe5, 0x9d, 0x8a}},
    {0x9657, {0xe5, 0xa6, 0xa8}},
    {0x9658, {0xe5, 0xb8, 0xbd}},
    {0x9659, {0xe5, 0xbf, 0x98}},
    {0x965a, {0xe5, 0xbf, 0x99}},
    {0x965b, {0xe6, 0x88, 0xbf}},
    {0x965c, {0xe6, 0x9a, 0xb4}},
    {0x965d, {0xe6, 0x9c, 0x9b}},
    {0x965e, {0xe6, 0x9f, 0x90}},
    {0x965f, {0xe6, 0xa3, 0x92}},
    {0x9660, {0xe5, 0x86, 0x92}},
    {0x9661, {0xe7, 0xb4, 0xa1}},
    {0x9662, {0xe8, 0x82, 0xaa}},
    {0x9663, {0xe8, 0x86, 0xa8}},
    {0x9664, {0xe8, 0xac, 0x80}},
    {0x9665, {0xe8, 0xb2, 0x8c}},
    {0x9666, {0xe8, 0xb2, 0xbf}},
    {0x9667, {0xe9, 0x89, 0xbe}},
    {0x9668, {0xe9, 0x98, 0xb2}},
    {0x9669, {0xe5, 0x90, 0xa0}},
    {0x966a, {0xe9, 0xa0, 0xac}},
    {0x966b, {0xe5, 0x8c, 0x97}},
    {0x966c, {0xe5, 0x83, 0x95}},
    {0x966d, {0xe5, 0x8d, 0x9c}},
    {0x966e, {0xe5, 0xa2, 0xa8}},
    {0x966f, {0xe6, 0x92, 0xb2}},
    {0x9670, {0xe6, 0x9c, 0xb4}},
    {0x9671, {0xe7, 0x89, 0xa7}},
    {0x9672, {0xe7, 0x9d, 0xa6}},
    {0x9673, {0xe7, 0xa9, 0x86}},
    {0x9674, {0xe9, 0x87, 0xa6}},
    {0x9675, {0xe5, 0x8b, 0x83}},
    {0x9676, {0xe6, 0xb2, 0xa1}},
    {0x9677, {0xe6, 0xae, 0x86}},
    {0x9678, {0xe5, 0xa0, 0x80}},
    {0x9679, {0xe5, 0xb9, 0x8c}},
    {0x967a, {0xe5, 0xa5, 0x94}},
    {0x967b, {0xe6, 0x9c, 0xac}},
    {0x967c, {0xe7, 0xbf, 0xbb}},
    {0x967d, {0xe5, 0x87, 0xa1}},
    {0x967e, {0xe7, 0x9b, 0x86}},
    {0x9680, {0xe6, 0x91, 0xa9}},
    {0x9681, {0xe7, 0xa3, 0xa8}},
    {0x9682, {0xe9, 0xad, 0x94}},
    {0x9683, {0xe9, 0xba, 0xbb}},
    {0x9684, {0xe5, 0x9f, 0x8b}},
    {0x9685, {0xe5, 0xa6, 0xb9}},
    {0x9686, {0xe6, 0x98, 0xa7}},
    {0x9687, {0xe6, 0x9e, 0x9a}},
    {0x9688, {0xe6, 0xaf, 0x8e}},
    {0x9689, {0xe5, 0x93, 0xa9}},
    {0x968a, {0xe6, 0xa7, 0x99}},
    {0x968b, {0xe5, 0xb9, 0x95}},
    {0x968c, {0xe8, 0x86, 0x9c}},
    {0x968d, {0xe6, 0x9e, 0x95}},
    {0x968e, {0xe9, 0xae, 0xaa}},
    {0x968f, {0xe6, 0x9f, 0xbe}},
    {0x9690, {0xe9, 0xb1, 0x92}},
    {0x9691, {0xe6, 0xa1, 0x9d}},
    {0x9692, {0xe4, 0xba, 0xa6}},
    {0x9693, {0xe4, 0xbf, 0xa3}},
    {0x9694, {0xe5, 0x8f, 0x88}},
    {0x9695, {0xe6, 0x8a, 0xb9}},
    {0x9696, {0xe6, 0x9c, 0xab}},
    {0x9697, {0xe6, 0xb2, 0xab}},
    {0x9698, {0xe8, 0xbf, 0x84}},
    {0x9699, {0xe4, 0xbe, 0xad}},
    {0x969a, {0xe7, 0xb9, 0xad}},
    {0x969b, {0xe9, 0xba, 0xbf}},
    {0x969c, {0xe4, 0xb8, 0x87}},
    {0x969d, {0xe6, 0x85, 0xa2}},
    {0x969e, {0xe6, 0xba, 0x80}},
    {0x969f, {0xe6, 0xbc, 0xab}},
    {0x96a0, {0xe8, 0x94, 0x93}},
    {0x96a1, {0xe5, 0x91, 0xb3}},
    {0x96a2, {0xe6, 0x9c, 0xaa}},
    {0x96a3, {0xe9, 0xad, 0x85}},
    {0x96a4, {0xe5, 0xb7, 0xb3}},
    {0x96a5, {0xe7, 0xae, 0x95}},
    {0x96a6, {0xe5, 0xb2, 0xac}},
    {0x96a7, {0xe5, 0xaf, 0x86}},
    {0x96a8, {0xe8, 0x9c, 0x9c}},
    {0x96a9, {0xe6, 0xb9, 0x8a}},
    {0x96aa, {0xe8, 0x93, 0x91}},
    {0x96ab, {0xe7, 0xa8, 0x94}},
    {0x96ac, {0xe8, 0x84, 0x88}},
    {0x96ad, {0xe5, 0xa6, 0x99}},
    {0x96ae, {0xe7, 0xb2, 0x8d}},
    {0x96af, {0xe6, 0xb0, 0x91}},
    {0x96b0, {0xe7, 0x9c, 0xa0}},
    {0x96b1, {0xe5, 0x8b, 0x99}},
    {0x96b2, {0xe5, 0xa4, 0xa2}},
    {0x96b3, {0xe7, 0x84, 0xa1}},
    {0x96b4, {0xe7, 0x89, 0x9f}},
    {0x96b5, {0xe7, 0x9f, 0x9b}},
    {0x96b6, {0xe9, 0x9c, 0xa7}},
    {0x96b7, {0xe9, 0xb5, 0xa1}},
    {0x96b8, {0xe6, 0xa4, 0x8b}},
    {0x96b9, {0xe5, 0xa9, 0xbf}},
    {0x96ba, {0xe5, 0xa8, 0x98}},
    {0x96bb, {0xe5, 0x86, 0xa5}},
    {0x96bc, {0xe5, 0x90, 0x8d}},
    {0x96bd, {0xe5, 0x91, 0xbd}},
    {0x96be, {0xe6, 0x98, 0x8e}},
    {0x96bf, {0xe7, 0x9b, 0x9f}},
    {0x96c0, {0xe8, 0xbf, 0xb7}},
    {0x96c1, {0xe9, 0x8a, 0x98}},
    {0x96c2, {0xe9, 0xb3, 0xb4}},
    {0x96c3, {0xe5, 0xa7, 0xaa}},
    {0x96c4, {0xe7, 0x89, 0x9d}},
    {0x96c5, {0xe6, 0xbb, 0x85}},
    {0x96c6, {0xe5, 0x85, 0x8d}},
    {0x96c7, {0xe6, 0xa3, 0x89}},
    {0x96c8, {0xe7, 0xb6, 0xbf}},
    {0x96c9, {0xe7, 0xb7, 0xac}},
    {0x96ca, {0xe9, 0x9d, 0xa2}},
    {0x96cb, {0xe9, 0xba, 0xba}},
    {0x96cc, {0xe6, 0x91, 0xb8}},
    {0x96cd, {0xe6, 0xa8, 0xa1}},
    {0x96ce, {0xe8, 0x8c, 0x82}},
    {0x96cf, {0xe5, 0xa6, 0x84}},
    {0x96d0, {0xe5, 0xad, 0x9f}},
    {0x96d1, {0xe6, 0xaf, 0x9b}},
    {0x96d2, {0xe7, 0x8c, 0x9b}},
    {0x96d3, {0xe7, 0x9b, 0xb2}},
    {0x96d4, {0xe7, 0xb6, 0xb2}},
    {0x96d5, {0xe8, 0x80, 0x97}},
    {0x96d6, {0xe8, 0x92, 0x99}},
    {0x96d7, {0xe5, 0x84, 0xb2}},
    {0x96d8, {0xe6, 0x9c, 0xa8}},
    {0x96d9, {0xe9, 0xbb, 0x99}},
    {0x96da, {0xe7, 0x9b, 0xae}},
    {0x96db, {0xe6, 0x9d, 0xa2}},
    {0x96dc, {0xe5, 0x8b, 0xbf}},
    {0x96dd, {0xe9, 0xa4, 0x85}},
    {0x96de, {0xe5, 0xb0, 0xa4}},
    {0x96df, {0xe6, 0x88, 0xbb}},
    {0x96e0, {0xe7, 0xb1, 0xbe}},
    {0x96e1, {0xe8, 0xb2, 0xb0}},
    {0x96e2, {0xe5, 0x95, 0x8f}},
    {0x96e3, {0xe6, 0x82, 0xb6}},
    {0x96e4, {0xe7, 0xb4, 0x8b}},
    {0x96e5, {0xe9, 0x96, 0x80}},
    {0x96e6, {0xe5, 0x8c, 0x81}},
    {0x96e7, {0xe4, 0xb9, 0x9f}},
    {0x96e8, {0xe5, 0x86, 0xb6}},
    {0x96e9, {0xe5, 0xa4, 0x9c}},
    {0x96ea, {0xe7, 0x88, 0xba}},
    {0x96eb, {0xe8, 0x80, 0xb6}},
    {0x96ec, {0xe9, 0x87, 0x8e}},
    {0x96ed, {0xe5, 0xbc, 0xa5}},
    {0x96ee, {0xe7, 0x9f, 0xa2}},
    {0x96ef, {0xe5, 0x8e, 0x84}},
    {0x96f0, {0xe5, 0xbd, 0xb9}},
    {0x96f1, {0xe7, 0xb4, 0x84}},
    {0x96f2, {0xe8, 0x96, 0xac}},
    {0x96f3, {0xe8, 0xa8, 0xb3}},
    {0x96f4, {0xe8, 0xba, 0x8d}},
    {0x96f5, {0xe9, 0x9d, 0x96}},
    {0x96f6, {0xe6, 0x9f, 0xb3}},
    {0x96f7, {0xe8, 0x96, 0xae}},
    {0x96f8, {0xe9, 0x91, 0x93}},
    {0x96f9, {0xe6, 0x84, 0x89}},
    {0x96fa, {0xe6, 0x84, 0x88}},
    {0x96fb, {0xe6, 0xb2, 0xb9}},
    {0x96fc, {0xe7, 0x99, 0x92}},
    {0x9740, {0xe8, 0xab, 0xad}},
    {0x9741, {0xe8, 0xbc, 0xb8}},
    {0x9742, {0xe5, 0x94, 0xaf}},
    {0x9743, {0xe4, 0xbd, 0x91}},
    {0x9744, {0xe5, 0x84, 0xaa}},
    {0x9745, {0xe5, 0x8b, 0x87}},
    {0x9746, {0xe5, 0x8f, 0x8b}},
    {0x9747, {0xe5, 0xae, 0xa5}},
    {0x9748, {0xe5, 0xb9, 0xbd}},
    {0x9749, {0xe6, 0x82, 0xa0}},
    {0x974a, {0xe6, 0x86, 0x82}},
    {0x974b, {0xe6, 0x8f, 0x96}},
    {0x974c, {0xe6, 0x9c, 0x89}},
    {0x974d, {0xe6, 0x9f, 0x9a}},
    {0x974e, {0xe6, 0xb9, 0xa7}},
    {0x974f, {0xe6, 0xb6, 0x8c}},
    {0x9750, {0xe7, 0x8c, 0xb6}},
    {0x9751, {0xe7, 0x8c, 0xb7}},
    {0x9752, {0xe7, 0x94, 0xb1}},
    {0x9753, {0xe7, 0xa5, 0x90}},
    {0x9754, {0xe8, 0xa3, 0x95}},
    {0x9755, {0xe8, 0xaa, 0x98}},
    {0x9756, {0xe9, 0x81, 0x8a}},
    {0x9757, {0xe9, 0x82, 0x91}},
    {0x9758, {0xe9, 0x83, 0xb5}},
    {0x9759, {0xe9, 0x9b, 0x84}},
    {0x975a, {0xe8, 0x9e, 0x8d}},
    {0x975b, {0xe5, 0xa4, 0x95}},
    {0x975c, {0xe4, 0xba, 0x88}},
    {0x975d, {0xe4, 0xbd, 0x99}},
    {0x975e, {0xe4, 0xb8, 0x8e}},
    {0x975f, {0xe8, 0xaa, 0x89}},
    {0x9760, {0xe8, 0xbc, 0xbf}},
    {0x9761, {0xe9, 0xa0, 0x90}},
    {0x9762, {0xe5, 0x82, 0xad}},
    {0x9763, {0xe5, 0xb9, 0xbc}},
    {0x9764, {0xe5, 0xa6, 0x96}},
    {0x9765, {0xe5, 0xae, 0xb9}},
    {0x9766, {0xe5, 0xba, 0xb8}},
    {0x9767, {0xe6, 0x8f, 0x9a}},
    {0x9768, {0xe6, 0x8f, 0xba}},
    {0x9769, {0xe6, 0x93, 0x81}},
    {0x976a, {0xe6, 0x9b, 0x9c}},
    {0x976b, {0xe6, 0xa5, 0x8a}},
    {0x976c, {0xe6, 0xa7, 0x98}},
    {0x976d, {0xe6, 0xb4, 0x8b}},
    {0x976e, {0xe6, 0xba, 0xb6}},
    {0x976f, {0xe7, 0x86, 0x94}},
    {0x9770, {0xe7, 0x94, 0xa8}},
    {0x9771, {0xe7, 0xaa, 0xaf}},
    {0x9772, {0xe7, 0xbe, 0x8a}},
    {0x9773, {0xe8, 0x80, 0x80}},
    {0x9774, {0xe8, 0x91, 0x89}},
    {0x9775, {0xe8, 0x93, 0x89}},
    {0x9776, {0xe8, 0xa6, 0x81}},
    {0x9777, {0xe8, 0xac, 0xa1}},
    {0x9778, {0xe8, 0xb8, 0x8a}},
    {0x9779, {0xe9, 0x81, 0xa5}},
    {0x977a, {0xe9, 0x99, 0xbd}},
    {0x977b, {0xe9, 0xa4, 0x8a}},
    {0x977c, {0xe6, 0x85, 0xbe}},
    {0x977d, {0xe6, 0x8a, 0x91}},
    {0x977e, {0xe6, 0xac, 0xb2}},
    {0x9780, {0xe6, 0xb2, 0x83}},
    {0x9781, {0xe6, 0xb5, 0xb4}},
    {0x9782, {0xe7, 0xbf, 0x8c}},
    {0x9783, {0xe7, 0xbf, 0xbc}},
    {0x9784, {0xe6, 0xb7, 0x80}},
    {0x9785, {0xe7, 0xbe, 0x85}},
    {0x9786, {0xe8, 0x9e, 0xba}},
    {0x9787, {0xe8, 0xa3, 0xb8}},
    {0x9788, {0xe6, 0x9d, 0xa5}},
    {0x9789, {0xe8, 0x8e, 0xb1}},
    {0x978a, {0xe9, 0xa0, 0xbc}},
    {0x978b, {0xe9, 0x9b, 0xb7}},
    {0x978c, {0xe6, 0xb4, 0x9b}},
    {0x978d, {0xe7, 0xb5, 0xa1}},
    {0x978e, {0xe8, 0x90, 0xbd}},
    {0x978f, {0xe9, 0x85, 0xaa}},
    {0x9790, {0xe4, 0xb9, 0xb1}},
    {0x9791, {0xe5, 0x8d, 0xb5}},
    {0x9792, {0xe5, 0xb5, 0x90}},
    {0x9793, {0xe6, 0xac, 0x84}},
    {0x9794, {0xe6, 0xbf, 0xab}},
    {0x9795, {0xe8, 0x97, 0x8d}},
    {0x9796, {0xe8, 0x98, 0xad}},
    {0x9797, {0xe8, 0xa6, 0xa7}},
    {0x9798, {0xe5, 0x88, 0xa9}},
    {0x9799, {0xe5, 0x90, 0x8f}},
    {0x979a, {0xe5, 0xb1, 0xa5}},
    {0x979b, {0xe6, 0x9d, 0x8e}},
    {0x979c, {0xe6, 0xa2, 0xa8}},
    {0x979d, {0xe7, 0x90, 0x86}},
    {0x979e, {0xe7, 0x92, 0x83}},
    {0x979f, {0xe7, 0x97, 0xa2}},
    {0x97a0, {0xe8, 0xa3, 0x8f}},
    {0x97a1, {0xe8, 0xa3, 0xa1}},
    {0x97a2, {0xe9, 0x87, 0x8c}},
    {0x97a3, {0xe9, 0x9b, 0xa2}},
    {0x97a4, {0xe9, 0x99, 0xb8}},
    {0x97a5, {0xe5, 0xbe, 0x8b}},
    {0x97a6, {0xe7, 0x8e, 0x87}},
    {0x97a7, {0xe7, 0xab, 0x8b}},
    {0x97a8, {0xe8, 0x91, 0x8e}},
    {0x97a9, {0xe6, 0x8e, 0xa0}},
    {0x97aa, {0xe7, 0x95, 0xa5}},
    {0x97ab, {0xe5, 0x8a, 0x89}},
    {0x97ac, {0xe6, 0xb5, 0x81}},
    {0x97ad, {0xe6, 0xba, 0x9c}},
    {0x97ae, {0xe7, 0x90, 0x89}},
    {0x97af, {0xe7, 0x95, 0x99}},
    {0x97b0, {0xe7, 0xa1, 0xab}},
    {0x97b1, {0xe7, 0xb2, 0x92}},
    {0x97b2, {0xe9, 0x9a, 0x86}},
    {0x97b3, {0xe7, 0xab, 0x9c}},
    {0x97b4, {0xe9, 0xbe, 0x8d}},
    {0x97b5, {0xe4, 0xbe, 0xb6}},
    {0x97b6, {0xe6, 0x85, 0xae}},
    {0x97b7, {0xe6, 0x97, 0x85}},
    {0x97b8, {0xe8, 0x99, 0x9c}},
    {0x97b9, {0xe4, 0xba, 0x86}},
    {0x97ba, {0xe4, 0xba, 0xae}},
    {0x97bb, {0xe5, 0x83, 0x9a}},
    {0x97bc, {0xe4, 0xb8, 0xa1}},
    {0x97bd, {0xe5, 0x87, 0x8c}},
    {0x97be, {0xe5, 0xaf, 0xae}},
    {0x97bf, {0xe6, 0x96, 0x99}},
    {0x97c0, {0xe6, 0xa2, 0x81}},
    {0x97c1, {0xe6, 0xb6, 0xbc}},
    {0x97c2, {0xe7, 0x8c, 0x9f}},
    {0x97c3, {0xe7, 0x99, 0x82}},
    {0x97c4, {0xe7, 0x9e, 0xad}},
    {0x97c5, {0xe7, 0xa8, 0x9c}},
    {0x97c6, {0xe7, 0xb3, 0xa7}},
    {0x97c7, {0xe8, 0x89, 0xaf}},
    {0x97c8, {0xe8, 0xab, 0x92}},
    {0x97c9, {0xe9, 0x81, 0xbc}},
    {0x97ca, {0xe9, 0x87, 0x8f}},
    {0x97cb, {0xe9, 0x99, 0xb5}},
    {0x97cc, {0xe9, 0xa0, 0x98}},
    {0x97cd, {0xe5, 0x8a, 0x9b}},
    {0x97ce, {0xe7, 0xb7, 0x91}},
    {0x97cf, {0xe5, 0x80, 0xab}},
    {0x97d0, {0xe5, 0x8e, 0x98}},
    {0x97d1, {0xe6, 0x9e, 0x97}},
    {0x97d2, {0xe6, 0xb7, 0x8b}},
    {0x97d3, {0xe7, 0x87, 0x90}},
    {0x97d4, {0xe7, 0x90, 0xb3}},
    {0x97d5, {0xe8, 0x87, 0xa8}},
    {0x97d6, {0xe8, 0xbc, 0xaa}},
    {0x97d7, {0xe9, 0x9a, 0xa3}},
    {0x97d8, {0xe9, 0xb1, 0x97}},
    {0x97d9, {0xe9, 0xba, 0x9f}},
    {0x97da, {0xe7, 0x91, 0xa0}},
    {0x97db, {0xe5, 0xa1, 0x81}},
    {0x97dc, {0xe6, 0xb6, 0x99}},
    {0x97dd, {0xe7, 0xb4, 0xaf}},
    {0x97de, {0xe9, 0xa1, 0x9e}},
    {0x97df, {0xe4, 0xbb, 0xa4}},
    {0x97e0, {0xe4, 0xbc, 0xb6}},
    {0x97e1, {0xe4, 0xbe, 0x8b}},
    {0x97e2, {0xe5, 0x86, 0xb7}},
    {0x97e3, {0xe5, 0x8a, 0xb1}},
    {0x97e4, {0xe5, 0xb6, 0xba}},
    {0x97e5, {0xe6, 0x80, 0x9c}},
    {0x97e6, {0xe7, 0x8e, 0xb2}},
    {0x97e7, {0xe7, 0xa4, 0xbc}},
    {0x97e8, {0xe8, 0x8b, 0x93}},
    {0x97e9, {0xe9, 0x88, 0xb4}},
    {0x97ea, {0xe9, 0x9a, 0xb7}},
    {0x97eb, {0xe9, 0x9b, 0xb6}},
    {0x97ec, {0xe9, 0x9c, 0x8a}},
    {0x97ed, {0xe9, 0xba, 0x97}},
    {0x97ee, {0xe9, 0xbd, 0xa2}},
    {0x97ef, {0xe6, 0x9a, 0xa6}},
    {0x97f0, {0xe6, 0xad, 0xb4}},
    {0x97f1, {0xe5, 0x88, 0x97}},
    {0x97f2, {0xe5, 0x8a, 0xa3}},
    {0x97f3, {0xe7, 0x83, 0x88}},
    {0x97f4, {0xe8, 0xa3, 0x82}},
    {0x97f5, {0xe5, 0xbb, 0x89}},
    {0x97f6, {0xe6, 0x81, 0x8b}},
    {0x97f7, {0xe6, 0x86, 0x90}},
    {0x97f8, {0xe6, 0xbc, 0xa3}},
    {0x97f9, {0xe7, 0x85, 0x89}},
    {0x97fa, {0xe7, 0xb0, 0xbe}},
    {0x97fb, {0xe7, 0xb7, 0xb4}},
    {0x97fc, {0xe8, 0x81, 0xaf}},
    {0x9840, {0xe8, 0x93, 0xae}},
    {0x9841, {0xe9, 0x80, 0xa3}},
    {0x9842, {0xe9, 0x8c, 0xac}},
    {0x9843, {0xe5, 0x91, 0x82}},
    {0x9844, {0xe9, 0xad, 0xaf}},
    {0x9845, {0xe6, 0xab, 0x93}},
    {0x9846, {0xe7, 0x82, 0x89}},
    {0x9847, {0xe8, 0xb3, 0x82}},
    {0x9848, {0xe8, 0xb7, 0xaf}},
    {0x9849, {0xe9, 0x9c, 0xb2}},
    {0x984a, {0xe5, 0x8a, 0xb4}},
    {0x984b, {0xe5, 0xa9, 0x81}},
    {0x984c, {0xe5, 0xbb, 0x8a}},
    {0x984d, {0xe5, 0xbc, 0x84}},
    {0x984e, {0xe6, 0x9c, 0x97}},
    {0x984f, {0xe6, 0xa5, 0xbc}},
    {0x9850, {0xe6, 0xa6, 0x94}},
    {0x9851, {0xe6, 0xb5, 0xaa}},
    {0x9852, {0xe6, 0xbc, 0x8f}},
    {0x9853, {0xe7, 0x89, 0xa2}},
    {0x9854, {0xe7, 0x8b, 0xbc}},
    {0x9855, {0xe7, 0xaf, 0xad}},
    {0x9856, {0xe8, 0x80, 0x81}},
    {0x9857, {0xe8, 0x81, 0xbe}},
    {0x9858, {0xe8, 0x9d, 0x8b}},
    {0x9859, {0xe9, 0x83, 0x8e}},
    {0x985a, {0xe5, 0x85, 0xad}},
    {0x985b, {0xe9, 0xba, 0x93}},
    {0x985c, {0xe7, 0xa6, 0x84}},
    {0x985d, {0xe8, 0x82, 0x8b}},
    {0x985e, {0xe9, 0x8c, 0xb2}},
    {0x985f, {0xe8, 0xab, 0x96}},
    {0x9860, {0xe5, 0x80, 0xad}},
    {0x9861, {0xe5, 0x92, 0x8c}},
    {0x9862, {0xe8, 0xa9, 0xb1}},
    {0x9863, {0xe6, 0xad, 0xaa}},
    {0x9864, {0xe8, 0xb3, 0x84}},
    {0x9865, {0xe8, 0x84, 0x87}},
    {0x9866, {0xe6, 0x83, 0x91}},
    {0x9867, {0xe6, 0x9e, 0xa0}},
    {0x9868, {0xe9, 0xb7, 0xb2}},
    {0x9869, {0xe4, 0xba, 0x99}},
    {0x986a, {0xe4, 0xba, 0x98}},
    {0x986b, {0xe9, 0xb0, 0x90}},
    {0x986c, {0xe8, 0xa9, 0xab}},
    {0x986d, {0xe8, 0x97, 0x81}},
    {0x986e, {0xe8, 0x95, 0xa8}},
    {0x986f, {0xe6, 0xa4, 0x80}},
    {0x9870, {0xe6, 0xb9, 0xbe}},
    {0x9871, {0xe7, 0xa2, 0x97}},
    {0x9872, {0xe8, 0x85, 0x95}},
    {0x989f, {0xe5, 0xbc, 0x8c}},
    {0x98a0, {0xe4, 0xb8, 0x90}},
    {0x98a1, {0xe4, 0xb8, 0x95}},
    {0x98a2, {0xe4, 0xb8, 0xaa}},
    {0x98a3, {0xe4, 0xb8, 0xb1}},
    {0x98a4, {0xe4, 0xb8, 0xb6}},
    {0x98a5, {0xe4, 0xb8, 0xbc}},
    {0x98a6, {0xe4, 0xb8, 0xbf}},
    {0x98a7, {0xe4, 0xb9, 0x82}},
    {0x98a8, {0xe4, 0xb9, 0x96}},
    {0x98a9, {0xe4, 0xb9, 0x98}},
    {0x98aa, {0xe4, 0xba, 0x82}},
    {0x98ab, {0xe4, 0xba, 0x85}},
    {0x98ac, {0xe8, 0xb1, 0xab}},
    {0x98ad, {0xe4, 0xba, 0x8a}},
    {0x98ae, {0xe8, 0x88, 0x92}},
    {0x98af, {0xe5, 0xbc, 0x8d}},
    {0x98b0, {0xe4, 0xba, 0x8e}},
    {0x98b1, {0xe4, 0xba, 0x9e}},
    {0x98b2, {0xe4, 0xba, 0x9f}},
    {0x98b3, {0xe4, 0xba, 0xa0}},
    {0x98b4, {0xe4, 0xba, 0xa2}},
    {0x98b5, {0xe4, 0xba, 0xb0}},
    {0x98b6, {0xe4, 0xba, 0xb3}},
    {0x98b7, {0xe4, 0xba, 0xb6}},
    {0x98b8, {0xe4, 0xbb, 0x8e}},
    {0x98b9, {0xe4, 0xbb, 0x8d}},
    {0x98ba, {0xe4, 0xbb, 0x84}},
    {0x98bb, {0xe4, 0xbb, 0x86}},
    {0x98bc, {0xe4, 0xbb, 0x82}},
    {0x98bd, {0xe4, 0xbb, 0x97}},
    {0x98be, {0xe4, 0xbb, 0x9e}},
    {0x98bf, {0xe4, 0xbb, 0xad}},
    {0x98c0, {0xe4, 0xbb, 0x9f}},
    {0x98c1, {0xe4, 0xbb, 0xb7}},
    {0x98c2, {0xe4, 0xbc, 0x89}},
    {0x98c3, {0xe4, 0xbd, 0x9a}},
    {0x98c4, {0xe4, 0xbc, 0xb0}},
    {0x98c5, {0xe4, 0xbd, 0x9b}},
    {0x98c6, {0xe4, 0xbd, 0x9d}},
    {0x98c7, {0xe4, 0xbd, 0x97}},
    {0x98c8, {0xe4, 0xbd, 0x87}},
    {0x98c9, {0xe4, 0xbd, 0xb6}},
    {0x98ca, {0xe4, 0xbe, 0x88}},
    {0x98cb, {0xe4, 0xbe, 0x8f}},
    {0x98cc, {0xe4, 0xbe, 0x98}},
    {0x98cd, {0xe4, 0xbd, 0xbb}},
    {0x98ce, {0xe4, 0xbd, 0xa9}},
    {0x98cf, {0xe4, 0xbd, 0xb0}},
    {0x98d0, {0xe4, 0xbe, 0x91}},
    {0x98d1, {0xe4, 0xbd, 0xaf}},
    {0x98d2, {0xe4, 0xbe, 0x86}},
    {0x98d3, {0xe4, 0xbe, 0x96}},
    {0x98d4, {0xe5, 0x84, 0x98}},
    {0x98d5, {0xe4, 0xbf, 0x94}},
    {0x98d6, {0xe4, 0xbf, 0x9f}},
    {0x98d7, {0xe4, 0xbf, 0x8e}},
    {0x98d8, {0xe4, 0xbf, 0x98}},
    {0x98d9, {0xe4, 0xbf, 0x9b}},
    {0x98da, {0xe4, 0xbf, 0x91}},
    {0x98db, {0xe4, 0xbf, 0x9a}},
    {0x98dc, {0xe4, 0xbf, 0x90}},
    {0x98dd, {0xe4, 0xbf, 0xa4}},
    {0x98de, {0xe4, 0xbf, 0xa5}},
    {0x98df, {0xe5, 0x80, 0x9a}},
    {0x98e0, {0xe5, 0x80, 0xa8}},
    {0x98e1, {0xe5, 0x80, 0x94}},
    {0x98e2, {0xe5, 0x80, 0xaa}},
    {0x98e3, {0xe5, 0x80, 0xa5}},
    {0x98e4, {0xe5, 0x80, 0x85}},
    {0x98e5, {0xe4, 0xbc, 0x9c}},
    {0x98e6, {0xe4, 0xbf, 0xb6}},
    {0x98e7, {0xe5, 0x80, 0xa1}},
    {0x98e8, {0xe5, 0x80, 0xa9}},
    {0x98e9, {0xe5, 0x80, 0xac}},
    {0x98ea, {0xe4, 0xbf, 0xbe}},
    {0x98eb, {0xe4, 0xbf, 0xaf}},
    {0x98ec, {0xe5, 0x80, 0x91}},
    {0x98ed, {0xe5, 0x80, 0x86}},
    {0x98ee, {0xe5, 0x81, 0x83}},
    {0x98ef, {0xe5, 0x81, 0x87}},
    {0x98f0, {0xe6, 0x9c, 0x83}},
    {0x98f1, {0xe5, 0x81, 0x95}},
    {0x98f2, {0xe5, 0x81, 0x90}},
    {0x98f3, {0xe5, 0x81, 0x88}},
    {0x98f4, {0xe5, 0x81, 0x9a}},
    {0x98f5, {0xe5, 0x81, 0x96}},
    {0x98f6, {0xe5, 0x81, 0xac}},
    {0x98f7, {0xe5, 0x81, 0xb8}},
    {0x98f8, {0xe5, 0x82, 0x80}},
    {0x98f9, {0xe5, 0x82, 0x9a}},
    {0x98fa, {0xe5, 0x82, 0x85}},
    {0x98fb, {0xe5, 0x82, 0xb4}},
    {0x98fc, {0xe5, 0x82, 0xb2}},
    {0x9940, {0xe5, 0x83, 0x89}},
    {0x9941, {0xe5, 0x83, 0x8a}},
    {0x9942, {0xe5, 0x82, 0xb3}},
    {0x9943, {0xe5, 0x83, 0x82}},
    {0x9944, {0xe5, 0x83, 0x96}},
    {0x9945, {0xe5, 0x83, 0x9e}},
    {0x9946, {0xe5, 0x83, 0xa5}},
    {0x9947, {0xe5, 0x83, 0xad}},
    {0x9948, {0xe5, 0x83, 0xa3}},
    {0x9949, {0xe5, 0x83, 0xae}},
    {0x994a, {0xe5, 0x83, 0xb9}},
    {0x994b, {0xe5, 0x83, 0xb5}},
    {0x994c, {0xe5, 0x84, 0x89}},
    {0x994d, {0xe5, 0x84, 0x81}},
    {0x994e, {0xe5, 0x84, 0x82}},
    {0x994f, {0xe5, 0x84, 0x96}},
    {0x9950, {0xe5, 0x84, 0x95}},
    {0x9951, {0xe5, 0x84, 0x94}},
    {0x9952, {0xe5, 0x84, 0x9a}},
    {0x9953, {0xe5, 0x84, 0xa1}},
    {0x9954, {0xe5, 0x84, 0xba}},
    {0x9955, {0xe5, 0x84, 0xb7}},
    {0x9956, {0xe5, 0x84, 0xbc}},
    {0x9957, {0xe5, 0x84, 0xbb}},
    {0x9958, {0xe5, 0x84, 0xbf}},
    {0x9959, {0xe5, 0x85, 0x80}},
    {0x995a, {0xe5, 0x85, 0x92}},
    {0x995b, {0xe5, 0x85, 0x8c}},
    {0x995c, {0xe5, 0x85, 0x94}},
    {0x995d, {0xe5, 0x85, 0xa2}},
    {0x995e, {0xe7, 0xab, 0xb8}},
    {0x995f, {0xe5, 0x85, 0xa9}},
    {0x9960, {0xe5, 0x85, 0xaa}},
    {0x9961, {0xe5, 0x85, 0xae}},
    {0x9962, {0xe5, 0x86, 0x80}},
    {0x9963, {0xe5, 0x86, 0x82}},
    {0x9964, {0xe5, 0x9b, 0x98}},
    {0x9965, {0xe5, 0x86, 0x8c}},
    {0x9966, {0xe5, 0x86, 0x89}},
    {0x9967, {0xe5, 0x86, 0x8f}},
    {0x9968, {0xe5, 0x86, 0x91}},
    {0x9969, {0xe5, 0x86, 0x93}},
    {0x996a, {0xe5, 0x86, 0x95}},
    {0x996b, {0xe5, 0x86, 0x96}},
    {0x996c, {0xe5, 0x86, 0xa4}},
    {0x996d, {0xe5, 0x86, 0xa6}},
    {0x996e, {0xe5, 0x86, 0xa2}},
    {0x996f, {0xe5, 0x86, 0xa9}},
    {0x9970, {0xe5, 0x86, 0xaa}},
    {0x9971, {0xe5, 0x86, 0xab}},
    {0x9972, {0xe5, 0x86, 0xb3}},
    {0x9973, {0xe5, 0x86, 0xb1}},
    {0x9974, {0xe5, 0x86, 0xb2}},
    {0x9975, {0xe5, 0x86, 0xb0}},
    {0x9976, {0xe5, 0x86, 0xb5}},
    {0x9977, {0xe5, 0x86, 0xbd}},
    {0x9978, {0xe5, 0x87, 0x85}},
    {0x9979, {0xe5, 0x87, 0x89}},
    {0x997a, {0xe5, 0x87, 0x9b}},
    {0x997b, {0xe5, 0x87, 0xa0}},
    {0x997c, {0xe8, 0x99, 0x95}},
    {0x997d, {0xe5, 0x87, 0xa9}},
    {0x997e, {0xe5, 0x87, 0xad}},
    {0x9980, {0xe5, 0x87, 0xb0}},
    {0x9981, {0xe5, 0x87, 0xb5}},
    {0x9982, {0xe5, 0x87, 0xbe}},
    {0x9983, {0xe5, 0x88, 0x84}},
    {0x9984, {0xe5, 0x88, 0x8b}},
    {0x9985, {0xe5, 0x88, 0x94}},
    {0x9986, {0xe5, 0x88, 0x8e}},
    {0x9987, {0xe5, 0x88, 0xa7}},
    {0x9988, {0xe5, 0x88, 0xaa}},
    {0x9989, {0xe5, 0x88, 0xae}},
    {0x998a, {0xe5, 0x88, 0xb3}},
    {0x998b, {0xe5, 0x88, 0xb9}},
    {0x998c, {0xe5, 0x89, 0x8f}},
    {0x998d, {0xe5, 0x89, 0x84}},
    {0x998e, {0xe5, 0x89, 0x8b}},
    {0x998f, {0xe5, 0x89, 0x8c}},
    {0x9990, {0xe5, 0x89, 0x9e}},
    {0x9991, {0xe5, 0x89, 0x94}},
    {0x9992, {0xe5, 0x89, 0xaa}},
    {0x9993, {0xe5, 0x89, 0xb4}},
    {0x9994, {0xe5, 0x89, 0xa9}},
    {0x9995, {0xe5, 0x89, 0xb3}},
    {0x9996, {0xe5, 0x89, 0xbf}},
    {0x9997, {0xe5, 0x89, 0xbd}},
    {0x9998, {0xe5, 0x8a, 0x8d}},
    {0x9999, {0xe5, 0x8a, 0x94}},
    {0x999a, {0xe5, 0x8a, 0x92}},
    {0x999b, {0xe5, 0x89, 0xb1}},
    {0x999c, {0xe5, 0x8a, 0x88}},
    {0x999d, {0xe5, 0x8a, 0x91}},
    {0x999e, {0xe8, 0xbe, 0xa8}},
    {0x999f, {0xe8, 0xbe, 0xa7}},
    {0x99a0, {0xe5, 0x8a, 0xac}},
    {0x99a1, {0xe5, 0x8a, 0xad}},
    {0x99a2, {0xe5, 0x8a, 0xbc}},
    {0x99a3, {0xe5, 0x8a, 0xb5}},
    {0x99a4, {0xe5, 0x8b, 0x81}},
    {0x99a5, {0xe5, 0x8b, 0x8d}},
    {0x99a6, {0xe5, 0x8b, 0x97}},
    {0x99a7, {0xe5, 0x8b, 0x9e}},
    {0x99a8, {0xe5, 0x8b, 0xa3}},
    {0x99a9, {0xe5, 0x8b, 0xa6}},
    {0x99aa, {0xe9, 0xa3, 0xad}},
    {0x99ab, {0xe5, 0x8b, 0xa0}},
    {0x99ac, {0xe5, 0x8b, 0xb3}},
    {0x99ad, {0xe5, 0x8b, 0xb5}},
    {0x99ae, {0xe5, 0x8b, 0xb8}},
    {0x99af, {0xe5, 0x8b, 0xb9}},
    {0x99b0, {0xe5, 0x8c, 0x86}},
    {0x99b1, {0xe5, 0x8c, 0x88}},
    {0x99b2, {0xe7, 0x94, 0xb8}},
    {0x99b3, {0xe5, 0x8c, 0x8d}},
    {0x99b4, {0xe5, 0x8c, 0x90}},
    {0x99b5, {0xe5, 0x8c, 0x8f}},
    {0x99b6, {0xe5, 0x8c, 0x95}},
    {0x99b7, {0xe5, 0x8c, 0x9a}},
    {0x99b8, {0xe5, 0x8c, 0xa3}},
    {0x99b9, {0xe5, 0x8c, 0xaf}},
    {0x99ba, {0xe5, 0x8c, 0xb1}},
    {0x99bb, {0xe5, 0x8c, 0xb3}},
    {0x99bc, {0xe5, 0x8c, 0xb8}},
    {0x99bd, {0xe5, 0x8d, 0x80}},
    {0x99be, {0xe5, 0x8d, 0x86}},
    {0x99bf, {0xe5, 0x8d, 0x85}},
    {0x99c0, {0xe4, 0xb8, 0x97}},
    {0x99c1, {0xe5, 0x8d, 0x89}},
    {0x99c2, {0xe5, 0x8d, 0x8d}},
    {0x99c3, {0xe5, 0x87, 0x96}},
    {0x99c4, {0xe5, 0x8d, 0x9e}},
    {0x99c5, {0xe5, 0x8d, 0xa9}},
    {0x99c6, {0xe5, 0x8d, 0xae}},
    {0x99c7, {0xe5, 0xa4, 0x98}},
    {0x99c8, {0xe5, 0x8d, 0xbb}},
    {0x99c9, {0xe5, 0x8d, 0xb7}},
    {0x99ca, {0xe5, 0x8e, 0x82}},
    {0x99cb, {0xe5, 0x8e, 0x96}},
    {0x99cc, {0xe5, 0x8e, 0xa0}},
    {0x99cd, {0xe5, 0x8e, 0xa6}},
    {0x99ce, {0xe5, 0x8e, 0xa5}},
    {0x99cf, {0xe5, 0x8e, 0xae}},
    {0x99d0, {0xe5, 0x8e, 0xb0}},
    {0x99d1, {0xe5, 0x8e, 0xb6}},
    {0x99d2, {0xe5, 0x8f, 0x83}},
    {0x99d3, {0xe7, 0xb0, 0x92}},
    {0x99d4, {0xe9, 0x9b, 0x99}},
    {0x99d5, {0xe5, 0x8f, 0x9f}},
    {0x99d6, {0xe6, 0x9b, 0xbc}},
    {0x99d7, {0xe7, 0x87, 0xae}},
    {0x99d8, {0xe5, 0x8f, 0xae}},
    {0x99d9, {0xe5, 0x8f, 0xa8}},
    {0x99da, {0xe5, 0x8f, 0xad}},
    {0x99db, {0xe5, 0x8f, 0xba}},
    {0x99dc, {0xe5, 0x90, 0x81}},
    {0x99dd, {0xe5, 0x90, 0xbd}},
    {0x99de, {0xe5, 0x91, 0x80}},
    {0x99df, {0xe5, 0x90, 0xac}},
    {0x99e0, {0xe5, 0x90, 0xad}},
    {0x99e1, {0xe5, 0x90, 0xbc}},
    {0x99e2, {0xe5, 0x90, 0xae}},
    {0x99e3, {0xe5, 0x90, 0xb6}},
    {0x99e4, {0xe5, 0x90, 0xa9}},
    {0x99e5, {0xe5, 0x90, 0x9d}},
    {0x99e6, {0xe5, 0x91, 0x8e}},
    {0x99e7, {0xe5, 0x92, 0x8f}},
    {0x99e8, {0xe5, 0x91, 0xb5}},
    {0x99e9, {0xe5, 0x92, 0x8e}},
    {0x99ea, {0xe5, 0x91, 0x9f}},
    {0x99eb, {0xe5, 0x91, 0xb1}},
    {0x99ec, {0xe5, 0x91, 0xb7}},
    {0x99ed, {0xe5, 0x91, 0xb0}},
    {0x99ee, {0xe5, 0x92, 0x92}},
    {0x99ef, {0xe5, 0x91, 0xbb}},
    {0x99f0, {0xe5, 0x92, 0x80}},
    {0x99f1, {0xe5, 0x91, 0xb6}},
    {0x99f2, {0xe5, 0x92, 0x84}},
    {0x99f3, {0xe5, 0x92, 0x90}},
    {0x99f4, {0xe5, 0x92, 0x86}},
    {0x99f5, {0xe5, 0x93, 0x87}},
    {0x99f6, {0xe5, 0x92, 0xa2}},
    {0x99f7, {0xe5, 0x92, 0xb8}},
    {0x99f8, {0xe5, 0x92, 0xa5}},
    {0x99f9, {0xe5, 0x92, 0xac}},
    {0x99fa, {0xe5, 0x93, 0x84}},
    {0x99fb, {0xe5, 0x93, 0x88}},
    {0x99fc, {0xe5, 0x92, 0xa8}},
    {0x9a40, {0xe5, 0x92, 0xab}},
    {0x9a41, {0xe5, 0x93, 0x82}},
    {0x9a42, {0xe5, 0x92, 0xa4}},
    {0x9a43, {0xe5, 0x92, 0xbe}},
    {0x9a44, {0xe5, 0x92, 0xbc}},
    {0x9a45, {0xe5, 0x93, 0x98}},
    {0x9a46, {0xe5, 0x93, 0xa5}},
    {0x9a47, {0xe5, 0x93, 0xa6}},
    {0x9a48, {0xe5, 0x94, 0x8f}},
    {0x9a49, {0xe5, 0x94, 0x94}},
    {0x9a4a, {0xe5, 0x93, 0xbd}},
    {0x9a4b, {0xe5, 0x93, 0xae}},
    {0x9a4c, {0xe5, 0x93, 0xad}},
    {0x9a4d, {0xe5, 0x93, 0xba}},
    {0x9a4e, {0xe5, 0x93, 0xa2}},
    {0x9a4f, {0xe5, 0x94, 0xb9}},
    {0x9a50, {0xe5, 0x95, 0x80}},
    {0x9a51, {0xe5, 0x95, 0xa3}},
    {0x9a52, {0xe5, 0x95, 0x8c}},
    {0x9a53, {0xe5, 0x94, 0xae}},
    {0x9a54, {0xe5, 0x95, 0x9c}},
    {0x9a55, {0xe5, 0x95, 0x85}},
    {0x9a56, {0xe5, 0x95, 0x96}},
    {0x9a57, {0xe5, 0x95, 0x97}},
    {0x9a58, {0xe5, 0x94, 0xb8}},
    {0x9a59, {0xe5, 0x94, 0xb3}},
    {0x9a5a, {0xe5, 0x95, 0x9d}},
    {0x9a5b, {0xe5, 0x96, 0x99}},
    {0x9a5c, {0xe5, 0x96, 0x80}},
    {0x9a5d, {0xe5, 0x92, 0xaf}},
    {0x9a5e, {0xe5, 0x96, 0x8a}},
    {0x9a5f, {0xe5, 0x96, 0x9f}},
    {0x9a60, {0xe5, 0x95, 0xbb}},
    {0x9a61, {0xe5, 0x95, 0xbe}},
    {0x9a62, {0xe5, 0x96, 0x98}},
    {0x9a63, {0xe5, 0x96, 0x9e}},
    {0x9a64, {0xe5, 0x96, 0xae}},
    {0x9a65, {0xe5, 0x95, 0xbc}},
    {0x9a66, {0xe5, 0x96, 0x83}},
    {0x9a67, {0xe5, 0x96, 0xa9}},
    {0x9a68, {0xe5, 0x96, 0x87}},
    {0x9a69, {0xe5, 0x96, 0xa8}},
    {0x9a6a, {0xe5, 0x97, 0x9a}},
    {0x9a6b, {0xe5, 0x97, 0x85}},
    {0x9a6c, {0xe5, 0x97, 0x9f}},
    {0x9a6d, {0xe5, 0x97, 0x84}},
    {0x9a6e, {0xe5, 0x97, 0x9c}},
    {0x9a6f, {0xe5, 0x97, 0xa4}},
    {0x9a70, {0xe5, 0x97, 0x94}},
    {0x9a71, {0xe5, 0x98, 0x94}},
    {0x9a72, {0xe5, 0x97, 0xb7}},
    {0x9a73, {0xe5, 0x98, 0x96}},
    {0x9a74, {0xe5, 0x97, 0xbe}},
    {0x9a75, {0xe5, 0x97, 0xbd}},
    {0x9a76, {0xe5, 0x98, 0x9b}},
    {0x9a77, {0xe5, 0x97, 0xb9}},
    {0x9a78, {0xe5, 0x99, 0x8e}},
    {0x9a79, {0xe5, 0x99, 0x90}},
    {0x9a7a, {0xe7, 0x87, 0x9f}},
    {0x9a7b, {0xe5, 0x98, 0xb4}},
    {0x9a7c, {0xe5, 0x98, 0xb6}},
    {0x9a7d, {0xe5, 0x98, 0xb2}},
    {0x9a7e, {0xe5, 0x98, 0xb8}},
    {0x9a80, {0xe5, 0x99, 0xab}},
    {0x9a81, {0xe5, 0x99, 0xa4}},
    {0x9a82, {0xe5, 0x98, 0xaf}},
    {0x9a83, {0xe5, 0x99, 0xac}},
    {0x9a84, {0xe5, 0x99, 0xaa}},
    {0x9a85, {0xe5, 0x9a, 0x86}},
    {0x9a86, {0xe5, 0x9a, 0x80}},
    {0x9a87, {0xe5, 0x9a, 0x8a}},
    {0x9a88, {0xe5, 0x9a, 0xa0}},
    {0x9a89, {0xe5, 0x9a, 0x94}},
    {0x9a8a, {0xe5, 0x9a, 0x8f}},
    {0x9a8b, {0xe5, 0x9a, 0xa5}},
    {0x9a8c, {0xe5, 0x9a, 0xae}},
    {0x9a8d, {0xe5, 0x9a, 0xb6}},
    {0x9a8e, {0xe5, 0x9a, 0xb4}},
    {0x9a8f, {0xe5, 0x9b, 0x82}},
    {0x9a90, {0xe5, 0x9a, 0xbc}},
    {0x9a91, {0xe5, 0x9b, 0x81}},
    {0x9a92, {0xe5, 0x9b, 0x83}},
    {0x9a93, {0xe5, 0x9b, 0x80}},
    {0x9a94, {0xe5, 0x9b, 0x88}},
    {0x9a95, {0xe5, 0x9b, 0x8e}},
    {0x9a96, {0xe5, 0x9b, 0x91}},
    {0x9a97, {0xe5, 0x9b, 0x93}},
    {0x9a98, {0xe5, 0x9b, 0x97}},
    {0x9a99, {0xe5, 0x9b, 0xae}},
    {0x9a9a, {0xe5, 0x9b, 0xb9}},
    {0x9a9b, {0xe5, 0x9c, 0x80}},
    {0x9a9c, {0xe5, 0x9b, 0xbf}},
    {0x9a9d, {0xe5, 0x9c, 0x84}},
    {0x9a9e, {0xe5, 0x9c, 0x89}},
    {0x9a9f, {0xe5, 0x9c, 0x88}},
    {0x9aa0, {0xe5, 0x9c, 0x8b}},
    {0x9aa1, {0xe5, 0x9c, 0x8d}},
    {0x9aa2, {0xe5, 0x9c, 0x93}},
    {0x9aa3, {0xe5, 0x9c, 0x98}},
    {0x9aa4, {0xe5, 0x9c, 0x96}},
    {0x9aa5, {0xe5, 0x97, 0x87}},
    {0x9aa6, {0xe5, 0x9c, 0x9c}},
    {0x9aa7, {0xe5, 0x9c, 0xa6}},
    {0x9aa8, {0xe5, 0x9c, 0xb7}},
    {0x9aa9, {0xe5, 0x9c, 0xb8}},
    {0x9aaa, {0xe5, 0x9d, 0x8e}},
    {0x9aab, {0xe5, 0x9c, 0xbb}},
    {0x9aac, {0xe5, 0x9d, 0x80}},
    {0x9aad, {0xe5, 0x9d, 0x8f}},
    {0x9aae, {0xe5, 0x9d, 0xa9}},
    {0x9aaf, {0xe5, 0x9f, 0x80}},
    {0x9ab0, {0xe5, 0x9e, 0x88}},
    {0x9ab1, {0xe5, 0x9d, 0xa1}},
    {0x9ab2, {0xe5, 0x9d, 0xbf}},
    {0x9ab3, {0xe5, 0x9e, 0x89}},
    {0x9ab4, {0xe5, 0x9e, 0x93}},
    {0x9ab5, {0xe5, 0x9e, 0xa0}},
    {0x9ab6, {0xe5, 0x9e, 0xb3}},
    {0x9ab7, {0xe5, 0x9e, 0xa4}},
    {0x9ab8, {0xe5, 0x9e, 0xaa}},
    {0x9ab9, {0xe5, 0x9e, 0xb0}},
    {0x9aba, {0xe5, 0x9f, 0x83}},
    {0x9abb, {0xe5, 0x9f, 0x86}},
    {0x9abc, {0xe5, 0x9f, 0x94}},
    {0x9abd, {0xe5, 0x9f, 0x92}},
    {0x9abe, {0xe5, 0x9f, 0x93}},
    {0x9abf, {0xe5, 0xa0, 0x8a}},
    {0x9ac0, {0xe5, 0x9f, 0x96}},
    {0x9ac1, {0xe5, 0x9f, 0xa3}},
    {0x9ac2, {0xe5, 0xa0, 0x8b}},
    {0x9ac3, {0xe5, 0xa0, 0x99}},
    {0x9ac4, {0xe5, 0xa0, 0x9d}},
    {0x9ac5, {0xe5, 0xa1, 0xb2}},
    {0x9ac6, {0xe5, 0xa0, 0xa1}},
    {0x9ac7, {0xe5, 0xa1, 0xa2}},
    {0x9ac8, {0xe5, 0xa1, 0x8b}},
    {0x9ac9, {0xe5, 0xa1, 0xb0}},
    {0x9aca, {0xe6, 0xaf, 0x80}},
    {0x9acb, {0xe5, 0xa1, 0x92}},
    {0x9acc, {0xe5, 0xa0, 0xbd}},
    {0x9acd, {0xe5, 0xa1, 0xb9}},
    {0x9ace, {0xe5, 0xa2, 0x85}},
    {0x9acf, {0xe5, 0xa2, 0xb9}},
    {0x9ad0, {0xe5, 0xa2, 0x9f}},
    {0x9ad1, {0xe5, 0xa2, 0xab}},
    {0x9ad2, {0xe5, 0xa2, 0xba}},
    {0x9ad3, {0xe5, 0xa3, 0x9e}},
    {0x9ad4, {0xe5, 0xa2, 0xbb}},
    {0x9ad5, {0xe5, 0xa2, 0xb8}},
    {0x9ad6, {0xe5, 0xa2, 0xae}},
    {0x9ad7, {0xe5, 0xa3, 0x85}},
    {0x9ad8, {0xe5, 0xa3, 0x93}},
    {0x9ad9, {0xe5, 0xa3, 0x91}},
    {0x9ada, {0xe5, 0xa3, 0x97}},
    {0x9adb, {0xe5, 0xa3, 0x99}},
    {0x9adc, {0xe5, 0xa3, 0x98}},
    {0x9add, {0xe5, 0xa3, 0xa5}},
    {0x9ade, {0xe5, 0xa3, 0x9c}},
    {0x9adf, {0xe5, 0xa3, 0xa4}},
    {0x9ae0, {0xe5, 0xa3, 0x9f}},
    {0x9ae1, {0xe5, 0xa3, 0xaf}},
    {0x9ae2, {0xe5, 0xa3, 0xba}},
    {0x9ae3, {0xe5, 0xa3, 0xb9}},
    {0x9ae4, {0xe5, 0xa3, 0xbb}},
    {0x9ae5, {0xe5, 0xa3, 0xbc}},
    {0x9ae6, {0xe5, 0xa3, 0xbd}},
    {0x9ae7, {0xe5, 0xa4, 0x82}},
    {0x9ae8, {0xe5, 0xa4, 0x8a}},
    {0x9ae9, {0xe5, 0xa4, 0x90}},
    {0x9aea, {0xe5, 0xa4, 0x9b}},
    {0x9aeb, {0xe6, 0xa2, 0xa6}},
    {0x9aec, {0xe5, 0xa4, 0xa5}},
    {0x9aed, {0xe5, 0xa4, 0xac}},
    {0x9aee, {0xe5, 0xa4, 0xad}},
    {0x9aef, {0xe5, 0xa4, 0xb2}},
    {0x9af0, {0xe5, 0xa4, 0xb8}},
    {0x9af1, {0xe5, 0xa4, 0xbe}},
    {0x9af2, {0xe7, 0xab, 0x92}},
    {0x9af3, {0xe5, 0xa5, 0x95}},
    {0x9af4, {0xe5, 0xa5, 0x90}},
    {0x9af5, {0xe5, 0xa5, 0x8e}},
    {0x9af6, {0xe5, 0xa5, 0x9a}},
    {0x9af7, {0xe5, 0xa5, 0x98}},
    {0x9af8, {0xe5, 0xa5, 0xa2}},
    {0x9af9, {0xe5, 0xa5, 0xa0}},
    {0x9afa, {0xe5, 0xa5, 0xa7}},
    {0x9afb, {0xe5, 0xa5, 0xac}},
    {0x9afc, {0xe5, 0xa5, 0xa9}},
    {0x9b40, {0xe5, 0xa5, 0xb8}},
    {0x9b41, {0xe5, 0xa6, 0x81}},
    {0x9b42, {0xe5, 0xa6, 0x9d}},
    {0x9b43, {0xe4, 0xbd, 0x9e}},
    {0x9b44, {0xe4, 0xbe, 0xab}},
    {0x9b45, {0xe5, 0xa6, 0xa3}},
    {0x9b46, {0xe5, 0xa6, 0xb2}},
    {0x9b47, {0xe5, 0xa7, 0x86}},
    {0x9b48, {0xe5, 0xa7, 0xa8}},
    {0x9b49, {0xe5, 0xa7, 0x9c}},
    {0x9b4a, {0xe5, 0xa6, 0x8d}},
    {0x9b4b, {0xe5, 0xa7, 0x99}},
    {0x9b4c, {0xe5, 0xa7, 0x9a}},
    {0x9b4d, {0xe5, 0xa8, 0xa5}},
    {0x9b4e, {0xe5, 0xa8, 0x9f}},
    {0x9b4f, {0xe5, 0xa8, 0x91}},
    {0x9b50, {0xe5, 0xa8, 0x9c}},
    {0x9b51, {0xe5, 0xa8, 0x89}},
    {0x9b52, {0xe5, 0xa8, 0x9a}},
    {0x9b53, {0xe5, 0xa9, 0x80}},
    {0x9b54, {0xe5, 0xa9, 0xac}},
    {0x9b55, {0xe5, 0xa9, 0x89}},
    {0x9b56, {0xe5, 0xa8, 0xb5}},
    {0x9b57, {0xe5, 0xa8, 0xb6}},
    {0x9b58, {0xe5, 0xa9, 0xa2}},
    {0x9b59, {0xe5, 0xa9, 0xaa}},
    {0x9b5a, {0xe5, 0xaa, 0x9a}},
    {0x9b5b, {0xe5, 0xaa, 0xbc}},
    {0x9b5c, {0xe5, 0xaa, 0xbe}},
    {0x9b5d, {0xe5, 0xab, 0x8b}},
    {0x9b5e, {0xe5, 0xab, 0x82}},
    {0x9b5f, {0xe5, 0xaa, 0xbd}},
    {0x9b60, {0xe5, 0xab, 0xa3}},
    {0x9b61, {0xe5, 0xab, 0x97}},
    {0x9b62, {0xe5, 0xab, 0xa6}},
    {0x9b63, {0xe5, 0xab, 0xa9}},
    {0x9b64, {0xe5, 0xab, 0x96}},
    {0x9b65, {0xe5, 0xab, 0xba}},
    {0x9b66, {0xe5, 0xab, 0xbb}},
    {0x9b67, {0xe5, 0xac, 0x8c}},
    {0x9b68, {0xe5, 0xac, 0x8b}},
    {0x9b69, {0xe5, 0xac, 0x96}},
    {0x9b6a, {0xe5, 0xac, 0xb2}},
    {0x9b6b, {0xe5, 0xab, 0x90}},
    {0x9b6c, {0xe5, 0xac, 0xaa}},
    {0x9b6d, {0xe5, 0xac, 0xb6}},
    {0x9b6e, {0xe5, 0xac, 0xbe}},
    {0x9b6f, {0xe5, 0xad, 0x83}},
    {0x9b70, {0xe5, 0xad, 0x85}},
    {0x9b71, {0xe5, 0xad, 0x80}},
    {0x9b72, {0xe5, 0xad, 0x91}},
    {0x9b73, {0xe5, 0xad, 0x95}},
    {0x9b74, {0xe5, 0xad, 0x9a}},
    {0x9b75, {0xe5, 0xad, 0x9b}},
    {0x9b76, {0xe5, 0xad, 0xa5}},
    {0x9b77, {0xe5, 0xad, 0xa9}},
    {0x9b78, {0xe5, 0xad, 0xb0}},
    {0x9b79, {0xe5, 0xad, 0xb3}},
    {0x9b7a, {0xe5, 0xad, 0xb5}},
    {0x9b7b, {0xe5, 0xad, 0xb8}},
    {0x9b7c, {0xe6, 0x96, 0x88}},
    {0x9b7d, {0xe5, 0xad, 0xba}},
    {0x9b7e, {0xe5, 0xae, 0x80}},
    {0x9b80, {0xe5, 0xae, 0x83}},
    {0x9b81, {0xe5, 0xae, 0xa6}},
    {0x9b82, {0xe5, 0xae, 0xb8}},
    {0x9b83, {0xe5, 0xaf, 0x83}},
    {0x9b84, {0xe5, 0xaf, 0x87}},
    {0x9b85, {0xe5, 0xaf, 0x89}},
    {0x9b86, {0xe5, 0xaf, 0x94}},
    {0x9b87, {0xe5, 0xaf, 0x90}},
    {0x9b88, {0xe5, 0xaf, 0xa4}},
    {0x9b89, {0xe5, 0xaf, 0xa6}},
    {0x9b8a, {0xe5, 0xaf, 0xa2}},
    {0x9b8b, {0xe5, 0xaf, 0x9e}},
    {0x9b8c, {0xe5, 0xaf, 0xa5}},
    {0x9b8d, {0xe5, 0xaf, 0xab}},
    {0x9b8e, {0xe5, 0xaf, 0xb0}},
    {0x9b8f, {0xe5, 0xaf, 0xb6}},
    {0x9b90, {0xe5, 0xaf, 0xb3}},
    {0x9b91, {0xe5, 0xb0, 0x85}},
    {0x9b92, {0xe5, 0xb0, 0x87}},
    {0x9b93, {0xe5, 0xb0, 0x88}},
    {0x9b94, {0xe5, 0xb0, 0x8d}},
    {0x9b95, {0xe5, 0xb0, 0x93}},
    {0x9b96, {0xe5, 0xb0, 0xa0}},
    {0x9b97, {0xe5, 0xb0, 0xa2}},
    {0x9b98, {0xe5, 0xb0, 0xa8}},
    {0x9b99, {0xe5, 0xb0, 0xb8}},
    {0x9b9a, {0xe5, 0xb0, 0xb9}},
    {0x9b9b, {0xe5, 0xb1, 0x81}},
    {0x9b9c, {0xe5, 0xb1, 0x86}},
    {0x9b9d, {0xe5, 0xb1, 0x8e}},
    {0x9b9e, {0xe5, 0xb1, 0x93}},
    {0x9b9f, {0xe5, 0xb1, 0x90}},
    {0x9ba0, {0xe5, 0xb1, 0x8f}},
    {0x9ba1, {0xe5, 0xad, 0xb1}},
    {0x9ba2, {0xe5, 0xb1, 0xac}},
    {0x9ba3, {0xe5, 0xb1, 0xae}},
    {0x9ba4, {0xe4, 0xb9, 0xa2}},
    {0x9ba5, {0xe5, 0xb1, 0xb6}},
    {0x9ba6, {0xe5, 0xb1, 0xb9}},
    {0x9ba7, {0xe5, 0xb2, 0x8c}},
    {0x9ba8, {0xe5, 0xb2, 0x91}},
    {0x9ba9, {0xe5, 0xb2, 0x94}},
    {0x9baa, {0xe5, 0xa6, 0x9b}},
    {0x9bab, {0xe5, 0xb2, 0xab}},
    {0x9bac, {0xe5, 0xb2, 0xbb}},
    {0x9bad, {0xe5, 0xb2, 0xb6}},
    {0x9bae, {0xe5, 0xb2, 0xbc}},
    {0x9baf, {0xe5, 0xb2, 0xb7}},
    {0x9bb0, {0xe5, 0xb3, 0x85}},
    {0x9bb1, {0xe5, 0xb2, 0xbe}},
    {0x9bb2, {0xe5, 0xb3, 0x87}},
    {0x9bb3, {0xe5, 0xb3, 0x99}},
    {0x9bb4, {0xe5, 0xb3, 0xa9}},
    {0x9bb5, {0xe5, 0xb3, 0xbd}},
    {0x9bb6, {0xe5, 0xb3, 0xba}},
    {0x9bb7, {0xe5, 0xb3, 0xad}},
    {0x9bb8, {0xe5, 0xb6, 0x8c}},
    {0x9bb9, {0xe5, 0xb3, 0xaa}},
    {0x9bba, {0xe5, 0xb4, 0x8b}},
    {0x9bbb, {0xe5, 0xb4, 0x95}},
    {0x9bbc, {0xe5, 0xb4, 0x97}},
    {0x9bbd, {0xe5, 0xb5, 0x9c}},
    {0x9bbe, {0xe5, 0xb4, 0x9f}},
    {0x9bbf, {0xe5, 0xb4, 0x9b}},
    {0x9bc0, {0xe5, 0xb4, 0x91}},
    {0x9bc1, {0xe5, 0xb4, 0x94}},
    {0x9bc2, {0xe5, 0xb4, 0xa2}},
    {0x9bc3, {0xe5, 0xb4, 0x9a}},
    {0x9bc4, {0xe5, 0xb4, 0x99}},
    {0x9bc5, {0xe5, 0xb4, 0x98}},
    {0x9bc6, {0xe5, 0xb5, 0x8c}},
    {0x9bc7, {0xe5, 0xb5, 0x92}},
    {0x9bc8, {0xe5, 0xb5, 0x8e}},
    {0x9bc9, {0xe5, 0xb5, 0x8b}},
    {0x9bca, {0xe5, 0xb5, 0xac}},
    {0x9bcb, {0xe5, 0xb5, 0xb3}},
    {0x9bcc, {0xe5, 0xb5, 0xb6}},
    {0x9bcd, {0xe5, 0xb6, 0x87}},
    {0x9bce, {0xe5, 0xb6, 0x84}},
    {0x9bcf, {0xe5, 0xb6, 0x82}},
    {0x9bd0, {0xe5, 0xb6, 0xa2}},
    {0x9bd1, {0xe5, 0xb6, 0x9d}},
    {0x9bd2, {0xe5, 0xb6, 0xac}},
    {0x9bd3, {0xe5, 0xb6, 0xae}},
    {0x9bd4, {0xe5, 0xb6, 0xbd}},
    {0x9bd5, {0xe5, 0xb6, 0x90}},
    {0x9bd6, {0xe5, 0xb6, 0xb7}},
    {0x9bd7, {0xe5, 0xb6, 0xbc}},
    {0x9bd8, {0xe5, 0xb7, 0x89}},
    {0x9bd9, {0xe5, 0xb7, 0x8d}},
    {0x9bda, {0xe5, 0xb7, 0x93}},
    {0x9bdb, {0xe5, 0xb7, 0x92}},
    {0x9bdc, {0xe5, 0xb7, 0x96}},
    {0x9bdd, {0xe5, 0xb7, 0x9b}},
    {0x9bde, {0xe5, 0xb7, 0xab}},
    {0x9bdf, {0xe5, 0xb7, 0xb2}},
    {0x9be0, {0xe5, 0xb7, 0xb5}},
    {0x9be1, {0xe5, 0xb8, 0x8b}},
    {0x9be2, {0xe5, 0xb8, 0x9a}},
    {0x9be3, {0xe5, 0xb8, 0x99}},
    {0x9be4, {0xe5, 0xb8, 0x91}},
    {0x9be5, {0xe5, 0xb8, 0x9b}},
    {0x9be6, {0xe5, 0xb8, 0xb6}},
    {0x9be7, {0xe5, 0xb8, 0xb7}},
    {0x9be8, {0xe5, 0xb9, 0x84}},
    {0x9be9, {0xe5, 0xb9, 0x83}},
    {0x9bea, {0xe5, 0xb9, 0x80}},
    {0x9beb, {0xe5, 0xb9, 0x8e}},
    {0x9bec, {0xe5, 0xb9, 0x97}},
    {0x9bed, {0xe5, 0xb9, 0x94}},
    {0x9bee, {0xe5, 0xb9, 0x9f}},
    {0x9bef, {0xe5, 0xb9, 0xa2}},
    {0x9bf0, {0xe5, 0xb9, 0xa4}},
    {0x9bf1, {0xe5, 0xb9, 0x87}},
    {0x9bf2, {0xe5, 0xb9, 0xb5}},
    {0x9bf3, {0xe5, 0xb9, 0xb6}},
    {0x9bf4, {0xe5, 0xb9, 0xba}},
    {0x9bf5, {0xe9, 0xba, 0xbc}},
    {0x9bf6, {0xe5, 0xb9, 0xbf}},
    {0x9bf7, {0xe5, 0xba, 0xa0}},
    {0x9bf8, {0xe5, 0xbb, 0x81}},
    {0x9bf9, {0xe5, 0xbb, 0x82}},
    {0x9bfa, {0xe5, 0xbb, 0x88}},
    {0x9bfb, {0xe5, 0xbb, 0x90}},
    {0x9bfc, {0xe5, 0xbb, 0x8f}},
    {0x9c40, {0xe5, 0xbb, 0x96}},
    {0x9c41, {0xe5, 0xbb, 0xa3}},
    {0x9c42, {0xe5, 0xbb, 0x9d}},
    {0x9c43, {0xe5, 0xbb, 0x9a}},
    {0x9c44, {0xe5, 0xbb, 0x9b}},
    {0x9c45, {0xe5, 0xbb, 0xa2}},
    {0x9c46, {0xe5, 0xbb, 0xa1}},
    {0x9c47, {0xe5, 0xbb, 0xa8}},
    {0x9c48, {0xe5, 0xbb, 0xa9}},
    {0x9c49, {0xe5, 0xbb, 0xac}},
    {0x9c4a, {0xe5, 0xbb, 0xb1}},
    {0x9c4b, {0xe5, 0xbb, 0xb3}},
    {0x9c4c, {0xe5, 0xbb, 0xb0}},
    {0x9c4d, {0xe5, 0xbb, 0xb4}},
    {0x9c4e, {0xe5, 0xbb, 0xb8}},
    {0x9c4f, {0xe5, 0xbb, 0xbe}},
    {0x9c50, {0xe5, 0xbc, 0x83}},
    {0x9c51, {0xe5, 0xbc, 0x89}},
    {0x9c52, {0xe5, 0xbd, 0x9d}},
    {0x9c53, {0xe5, 0xbd, 0x9c}},
    {0x9c54, {0xe5, 0xbc, 0x8b}},
    {0x9c55, {0xe5, 0xbc, 0x91}},
    {0x9c56, {0xe5, 0xbc, 0x96}},
    {0x9c57, {0xe5, 0xbc, 0xa9}},
    {0x9c58, {0xe5, 0xbc, 0xad}},
    {0x9c59, {0xe5, 0xbc, 0xb8}},
    {0x9c5a, {0xe5, 0xbd, 0x81}},
    {0x9c5b, {0xe5, 0xbd, 0x88}},
    {0x9c5c, {0xe5, 0xbd, 0x8c}},
    {0x9c5d, {0xe5, 0xbd, 0x8e}},
    {0x9c5e, {0xe5, 0xbc, 0xaf}},
    {0x9c5f, {0xe5, 0xbd, 0x91}},
    {0x9c60, {0xe5, 0xbd, 0x96}},
    {0x9c61, {0xe5, 0xbd, 0x97}},
    {0x9c62, {0xe5, 0xbd, 0x99}},
    {0x9c63, {0xe5, 0xbd, 0xa1}},
    {0x9c64, {0xe5, 0xbd, 0xad}},
    {0x9c65, {0xe5, 0xbd, 0xb3}},
    {0x9c66, {0xe5, 0xbd, 0xb7}},
    {0x9c67, {0xe5, 0xbe, 0x83}},
    {0x9c68, {0xe5, 0xbe, 0x82}},
    {0x9c69, {0xe5, 0xbd, 0xbf}},
    {0x9c6a, {0xe5, 0xbe, 0x8a}},
    {0x9c6b, {0xe5, 0xbe, 0x88}},
    {0x9c6c, {0xe5, 0xbe, 0x91}},
    {0x9c6d, {0xe5, 0xbe, 0x87}},
    {0x9c6e, {0xe5, 0xbe, 0x9e}},
    {0x9c6f, {0xe5, 0xbe, 0x99}},
    {0x9c70, {0xe5, 0xbe, 0x98}},
    {0x9c71, {0xe5, 0xbe, 0xa0}},
    {0x9c72, {0xe5, 0xbe, 0xa8}},
    {0x9c73, {0xe5, 0xbe, 0xad}},
    {0x9c74, {0xe5, 0xbe, 0xbc}},
    {0x9c75, {0xe5, 0xbf, 0x96}},
    {0x9c76, {0xe5, 0xbf, 0xbb}},
    {0x9c77, {0xe5, 0xbf, 0xa4}},
    {0x9c78, {0xe5, 0xbf, 0xb8}},
    {0x9c79, {0xe5, 0xbf, 0xb1}},
    {0x9c7a, {0xe5, 0xbf, 0x9d}},
    {0x9c7b, {0xe6, 0x82, 0xb3}},
    {0x9c7c, {0xe5, 0xbf, 0xbf}},
    {0x9c7d, {0xe6, 0x80, 0xa1}},
    {0x9c7e, {0xe6, 0x81, 0xa0}},
    {0x9c80, {0xe6, 0x80, 0x99}},
    {0x9c81, {0xe6, 0x80, 0x90}},
    {0x9c82, {0xe6, 0x80, 0xa9}},
    {0x9c83, {0xe6, 0x80, 0x8e}},
    {0x9c84, {0xe6, 0x80, 0xb1}},
    {0x9c85, {0xe6, 0x80, 0x9b}},
    {0x9c86, {0xe6, 0x80, 0x95}},
    {0x9c87, {0xe6, 0x80, 0xab}},
    {0x9c88, {0xe6, 0x80, 0xa6}},
    {0x9c89, {0xe6, 0x80, 0x8f}},
    {0x9c8a, {0xe6, 0x80, 0xba}},
    {0x9c8b, {0xe6, 0x81, 0x9a}},
    {0x9c8c, {0xe6, 0x81, 0x81}},
    {0x9c8d, {0xe6, 0x81, 0xaa}},
    {0x9c8e, {0xe6, 0x81, 0xb7}},
    {0x9c8f, {0xe6, 0x81, 0x9f}},
    {0x9c90, {0xe6, 0x81, 0x8a}},
    {0x9c91, {0xe6, 0x81, 0x86}},
    {0x9c92, {0xe6, 0x81, 0x8d}},
    {0x9c93, {0xe6, 0x81, 0xa3}},
    {0x9c94, {0xe6, 0x81, 0x83}},
    {0x9c95, {0xe6, 0x81, 0xa4}},
    {0x9c96, {0xe6, 0x81, 0x82}},
    {0x9c97, {0xe6, 0x81, 0xac}},
    {0x9c98, {0xe6, 0x81, 0xab}},
    {0x9c99, {0xe6, 0x81, 0x99}},
    {0x9c9a, {0xe6, 0x82, 0x81}},
    {0x9c9b, {0xe6, 0x82, 0x8d}},
    {0x9c9c, {0xe6, 0x83, 0xa7}},
    {0x9c9d, {0xe6, 0x82, 0x83}},
    {0x9c9e, {0xe6, 0x82, 0x9a}},
    {0x9c9f, {0xe6, 0x82, 0x84}},
    {0x9ca0, {0xe6, 0x82, 0x9b}},
    {0x9ca1, {0xe6, 0x82, 0x96}},
    {0x9ca2, {0xe6, 0x82, 0x97}},
    {0x9ca3, {0xe6, 0x82, 0x92}},
    {0x9ca4, {0xe6, 0x82, 0xa7}},
    {0x9ca5, {0xe6, 0x82, 0x8b}},
    {0x9ca6, {0xe6, 0x83, 0xa1}},
    {0x9ca7, {0xe6, 0x82, 0xb8}},
    {0x9ca8, {0xe6, 0x83, 0xa0}},
    {0x9ca9, {0xe6, 0x83, 0x93}},
    {0x9caa, {0xe6, 0x82, 0xb4}},
    {0x9cab, {0xe5, 0xbf, 0xb0}},
    {0x9cac, {0xe6, 0x82, 0xbd}},
    {0x9cad, {0xe6, 0x83, 0x86}},
    {0x9cae, {0xe6, 0x82, 0xb5}},
    {0x9caf, {0xe6, 0x83, 0x98}},
    {0x9cb0, {0xe6, 0x85, 0x8d}},
    {0x9cb1, {0xe6, 0x84, 0x95}},
    {0x9cb2, {0xe6, 0x84, 0x86}},
    {0x9cb3, {0xe6, 0x83, 0xb6}},
    {0x9cb4, {0xe6, 0x83, 0xb7}},
    {0x9cb5, {0xe6, 0x84, 0x80}},
    {0x9cb6, {0xe6, 0x83, 0xb4}},
    {0x9cb7, {0xe6, 0x83, 0xba}},
    {0x9cb8, {0xe6, 0x84, 0x83}},
    {0x9cb9, {0xe6, 0x84, 0xa1}},
    {0x9cba, {0xe6, 0x83, 0xbb}},
    {0x9cbb, {0xe6, 0x83, 0xb1}},
    {0x9cbc, {0xe6, 0x84, 0x8d}},
    {0x9cbd, {0xe6, 0x84, 0x8e}},
    {0x9cbe, {0xe6, 0x85, 0x87}},
    {0x9cbf, {0xe6, 0x84, 0xbe}},
    {0x9cc0, {0xe6, 0x84, 0xa8}},
    {0x9cc1, {0xe6, 0x84, 0xa7}},
    {0x9cc2, {0xe6, 0x85, 0x8a}},
    {0x9cc3, {0xe6, 0x84, 0xbf}},
    {0x9cc4, {0xe6, 0x84, 0xbc}},
    {0x9cc5, {0xe6, 0x84, 0xac}},
    {0x9cc6, {0xe6, 0x84, 0xb4}},
    {0x9cc7, {0xe6, 0x84, 0xbd}},
    {0x9cc8, {0xe6, 0x85, 0x82}},
    {0x9cc9, {0xe6, 0x85, 0x84}},
    {0x9cca, {0xe6, 0x85, 0xb3}},
    {0x9ccb, {0xe6, 0x85, 0xb7}},
    {0x9ccc, {0xe6, 0x85, 0x98}},
    {0x9ccd, {0xe6, 0x85, 0x99}},
    {0x9cce, {0xe6, 0x85, 0x9a}},
    {0x9ccf, {0xe6, 0x85, 0xab}},
    {0x9cd0, {0xe6, 0x85, 0xb4}},
    {0x9cd1, {0xe6, 0x85, 0xaf}},
    {0x9cd2, {0xe6, 0x85, 0xa5}},
    {0x9cd3, {0xe6, 0x85, 0xb1}},
    {0x9cd4, {0xe6, 0x85, 0x9f}},
    {0x9cd5, {0xe6, 0x85, 0x9d}},
    {0x9cd6, {0xe6, 0x85, 0x93}},
    {0x9cd7, {0xe6, 0x85, 0xb5}},
    {0x9cd8, {0xe6, 0x86, 0x99}},
    {0x9cd9, {0xe6, 0x86, 0x96}},
    {0x9cda, {0xe6, 0x86, 0x87}},
    {0x9cdb, {0xe6, 0x86, 0xac}},
    {0x9cdc, {0xe6, 0x86, 0x94}},
    {0x9cdd, {0xe6, 0x86, 0x9a}},
    {0x9cde, {0xe6, 0x86, 0x8a}},
    {0x9cdf, {0xe6, 0x86, 0x91}},
    {0x9ce0, {0xe6, 0x86, 0xab}},
    {0x9ce1, {0xe6, 0x86, 0xae}},
    {0x9ce2, {0xe6, 0x87, 0x8c}},
    {0x9ce3, {0xe6, 0x87, 0x8a}},
    {0x9ce4, {0xe6, 0x87, 0x89}},
    {0x9ce5, {0xe6, 0x87, 0xb7}},
    {0x9ce6, {0xe6, 0x87, 0x88}},
    {0x9ce7, {0xe6, 0x87, 0x83}},
    {0x9ce8, {0xe6, 0x87, 0x86}},
    {0x9ce9, {0xe6, 0x86, 0xba}},
    {0x9cea, {0xe6, 0x87, 0x8b}},
    {0x9ceb, {0xe7, 0xbd, 0xb9}},
    {0x9cec, {0xe6, 0x87, 0x8d}},
    {0x9ced, {0xe6, 0x87, 0xa6}},
    {0x9cee, {0xe6, 0x87, 0xa3}},
    {0x9cef, {0xe6, 0x87, 0xb6}},
    {0x9cf0, {0xe6, 0x87, 0xba}},
    {0x9cf1, {0xe6, 0x87, 0xb4}},
    {0x9cf2, {0xe6, 0x87, 0xbf}},
    {0x9cf3, {0xe6, 0x87, 0xbd}},
    {0x9cf4, {0xe6, 0x87, 0xbc}},
    {0x9cf5, {0xe6, 0x87, 0xbe}},
    {0x9cf6, {0xe6, 0x88, 0x80}},
    {0x9cf7, {0xe6, 0x88, 0x88}},
    {0x9cf8, {0xe6, 0x88, 0x89}},
    {0x9cf9, {0xe6, 0x88, 0x8d}},
    {0x9cfa, {0xe6, 0x88, 0x8c}},
    {0x9cfb, {0xe6, 0x88, 0x94}},
    {0x9cfc, {0xe6, 0x88, 0x9b}},
    {0x9d40, {0xe6, 0x88, 0x9e}},
    {0x9d41, {0xe6, 0x88, 0xa1}},
    {0x9d42, {0xe6, 0x88, 0xaa}},
    {0x9d43, {0xe6, 0x88, 0xae}},
    {0x9d44, {0xe6, 0x88, 0xb0}},
    {0x9d45, {0xe6, 0x88, 0xb2}},
    {0x9d46, {0xe6, 0x88, 0xb3}},
    {0x9d47, {0xe6, 0x89, 0x81}},
    {0x9d48, {0xe6, 0x89, 0x8e}},
    {0x9d49, {0xe6, 0x89, 0x9e}},
    {0x9d4a, {0xe6, 0x89, 0xa3}},
    {0x9d4b, {0xe6, 0x89, 0x9b}},
    {0x9d4c, {0xe6, 0x89, 0xa0}},
    {0x9d4d, {0xe6, 0x89, 0xa8}},
    {0x9d4e, {0xe6, 0x89, 0xbc}},
    {0x9d4f, {0xe6, 0x8a, 0x82}},
    {0x9d50, {0xe6, 0x8a, 0x89}},
    {0x9d51, {0xe6, 0x89, 0xbe}},
    {0x9d52, {0xe6, 0x8a, 0x92}},
    {0x9d53, {0xe6, 0x8a, 0x93}},
    {0x9d54, {0xe6, 0x8a, 0x96}},
    {0x9d55, {0xe6, 0x8b, 0x94}},
    {0x9d56, {0xe6, 0x8a, 0x83}},
    {0x9d57, {0xe6, 0x8a, 0x94}},
    {0x9d58, {0xe6, 0x8b, 0x97}},
    {0x9d59, {0xe6, 0x8b, 0x91}},
    {0x9d5a, {0xe6, 0x8a, 0xbb}},
    {0x9d5b, {0xe6, 0x8b, 0x8f}},
    {0x9d5c, {0xe6, 0x8b, 0xbf}},
    {0x9d5d, {0xe6, 0x8b, 0x86}},
    {0x9d5e, {0xe6, 0x93, 0x94}},
    {0x9d5f, {0xe6, 0x8b, 0x88}},
    {0x9d60, {0xe6, 0x8b, 0x9c}},
    {0x9d61, {0xe6, 0x8b, 0x8c}},
    {0x9d62, {0xe6, 0x8b, 0x8a}},
    {0x9d63, {0xe6, 0x8b, 0x82}},
    {0x9d64, {0xe6, 0x8b, 0x87}},
    {0x9d65, {0xe6, 0x8a, 0x9b}},
    {0x9d66, {0xe6, 0x8b, 0x89}},
    {0x9d67, {0xe6, 0x8c, 0x8c}},
    {0x9d68, {0xe6, 0x8b, 0xae}},
    {0x9d69, {0xe6, 0x8b, 0xb1}},
    {0x9d6a, {0xe6, 0x8c, 0xa7}},
    {0x9d6b, {0xe6, 0x8c, 0x82}},
    {0x9d6c, {0xe6, 0x8c, 0x88}},
    {0x9d6d, {0xe6, 0x8b, 0xaf}},
    {0x9d6e, {0xe6, 0x8b, 0xb5}},
    {0x9d6f, {0xe6, 0x8d, 0x90}},
    {0x9d70, {0xe6, 0x8c, 0xbe}},
    {0x9d71, {0xe6, 0x8d, 0x8d}},
    {0x9d72, {0xe6, 0x90, 0x9c}},
    {0x9d73, {0xe6, 0x8d, 0x8f}},
    {0x9d74, {0xe6, 0x8e, 0x96}},
    {0x9d75, {0xe6, 0x8e, 0x8e}},
    {0x9d76, {0xe6, 0x8e, 0x80}},
    {0x9d77, {0xe6, 0x8e, 0xab}},
    {0x9d78, {0xe6, 0x8d, 0xb6}},
    {0x9d79, {0xe6, 0x8e, 0xa3}},
    {0x9d7a, {0xe6, 0x8e, 0x8f}},
    {0x9d7b, {0xe6, 0x8e, 0x89}},
    {0x9d7c, {0xe6, 0x8e, 0x9f}},
    {0x9d7d, {0xe6, 0x8e, 0xb5}},
    {0x9d7e, {0xe6, 0x8d, 0xab}},
    {0x9d80, {0xe6, 0x8d, 0xa9}},
    {0x9d81, {0xe6, 0x8e, 0xbe}},
    {0x9d82, {0xe6, 0x8f, 0xa9}},
    {0x9d83, {0xe6, 0x8f, 0x80}},
    {0x9d84, {0xe6, 0x8f, 0x86}},
    {0x9d85, {0xe6, 0x8f, 0xa3}},
    {0x9d86, {0xe6, 0x8f, 0x89}},
    {0x9d87, {0xe6, 0x8f, 0x92}},
    {0x9d88, {0xe6, 0x8f, 0xb6}},
    {0x9d89, {0xe6, 0x8f, 0x84}},
    {0x9d8a, {0xe6, 0x90, 0x96}},
    {0x9d8b, {0xe6, 0x90, 0xb4}},
    {0x9d8c, {0xe6, 0x90, 0x86}},
    {0x9d8d, {0xe6, 0x90, 0x93}},
    {0x9d8e, {0xe6, 0x90, 0xa6}},
    {0x9d8f, {0xe6, 0x90, 0xb6}},
    {0x9d90, {0xe6, 0x94, 0x9d}},
    {0x9d91, {0xe6, 0x90, 0x97}},
    {0x9d92, {0xe6, 0x90, 0xa8}},
    {0x9d93, {0xe6, 0x90, 0x8f}},
    {0x9d94, {0xe6, 0x91, 0xa7}},
    {0x9d95, {0xe6, 0x91, 0xaf}},
    {0x9d96, {0xe6, 0x91, 0xb6}},
    {0x9d97, {0xe6, 0x91, 0x8e}},
    {0x9d98, {0xe6, 0x94, 0xaa}},
    {0x9d99, {0xe6, 0x92, 0x95}},
    {0x9d9a, {0xe6, 0x92, 0x93}},
    {0x9d9b, {0xe6, 0x92, 0xa5}},
    {0x9d9c, {0xe6, 0x92, 0xa9}},
    {0x9d9d, {0xe6, 0x92, 0x88}},
    {0x9d9e, {0xe6, 0x92, 0xbc}},
    {0x9d9f, {0xe6, 0x93, 0x9a}},
    {0x9da0, {0xe6, 0x93, 0x92}},
    {0x9da1, {0xe6, 0x93, 0x85}},
    {0x9da2, {0xe6, 0x93, 0x87}},
    {0x9da3, {0xe6, 0x92, 0xbb}},
    {0x9da4, {0xe6, 0x93, 0x98}},
    {0x9da5, {0xe6, 0x93, 0x82}},
    {0x9da6, {0xe6, 0x93, 0xb1}},
    {0x9da7, {0xe6, 0x93, 0xa7}},
    {0x9da8, {0xe8, 0x88, 0x89}},
    {0x9da9, {0xe6, 0x93, 0xa0}},
    {0x9daa, {0xe6, 0x93, 0xa1}},
    {0x9dab, {0xe6, 0x8a, 0xac}},
    {0x9dac, {0xe6, 0x93, 0xa3}},
    {0x9dad, {0xe6, 0x93, 0xaf}},
    {0x9dae, {0xe6, 0x94, 0xac}},
    {0x9daf, {0xe6, 0x93, 0xb6}},
    {0x9db0, {0xe6, 0x93, 0xb4}},
    {0x9db1, {0xe6, 0x93, 0xb2}},
    {0x9db2, {0xe6, 0x93, 0xba}},
    {0x9db3, {0xe6, 0x94, 0x80}},
    {0x9db4, {0xe6, 0x93, 0xbd}},
    {0x9db5, {0xe6, 0x94, 0x98}},
    {0x9db6, {0xe6, 0x94, 0x9c}},
    {0x9db7, {0xe6, 0x94, 0x85}},
    {0x9db8, {0xe6, 0x94, 0xa4}},
    {0x9db9, {0xe6, 0x94, 0xa3}},
    {0x9dba, {0xe6, 0x94, 0xab}},
    {0x9dbb, {0xe6, 0x94, 0xb4}},
    {0x9dbc, {0xe6, 0x94, 0xb5}},
    {0x9dbd, {0xe6, 0x94, 0xb7}},
    {0x9dbe, {0xe6, 0x94, 0xb6}},
    {0x9dbf, {0xe6, 0x94, 0xb8}},
    {0x9dc0, {0xe7, 0x95, 0x8b}},
    {0x9dc1, {0xe6, 0x95, 0x88}},
    {0x9dc2, {0xe6, 0x95, 0x96}},
    {0x9dc3, {0xe6, 0x95, 0x95}},
    {0x9dc4, {0xe6, 0x95, 0x8d}},
    {0x9dc5, {0xe6, 0x95, 0x98}},
    {0x9dc6, {0xe6, 0x95, 0x9e}},
    {0x9dc7, {0xe6, 0x95, 0x9d}},
    {0x9dc8, {0xe6, 0x95, 0xb2}},
    {0x9dc9, {0xe6, 0x95, 0xb8}},
    {0x9dca, {0xe6, 0x96, 0x82}},
    {0x9dcb, {0xe6, 0x96, 0x83}},
    {0x9dcc, {0xe8, 0xae, 0x8a}},
    {0x9dcd, {0xe6, 0x96, 0x9b}},
    {0x9dce, {0xe6, 0x96, 0x9f}},
    {0x9dcf, {0xe6, 0x96, 0xab}},
    {0x9dd0, {0xe6, 0x96, 0xb7}},
    {0x9dd1, {0xe6, 0x97, 0x83}},
    {0x9dd2, {0xe6, 0x97, 0x86}},
    {0x9dd3, {0xe6, 0x97, 0x81}},
    {0x9dd4, {0xe6, 0x97, 0x84}},
    {0x9dd5, {0xe6, 0x97, 0x8c}},
    {0x9dd6, {0xe6, 0x97, 0x92}},
    {0x9dd7, {0xe6, 0x97, 0x9b}},
    {0x9dd8, {0xe6, 0x97, 0x99}},
    {0x9dd9, {0xe6, 0x97, 0xa0}},
    {0x9dda, {0xe6, 0x97, 0xa1}},
    {0x9ddb, {0xe6, 0x97, 0xb1}},
    {0x9ddc, {0xe6, 0x9d, 0xb2}},
    {0x9ddd, {0xe6, 0x98, 0x8a}},
    {0x9dde, {0xe6, 0x98, 0x83}},
    {0x9ddf, {0xe6, 0x97, 0xbb}},
    {0x9de0, {0xe6, 0x9d, 0xb3}},
    {0x9de1, {0xe6, 0x98, 0xb5}},
    {0x9de2, {0xe6, 0x98, 0xb6}},
    {0x9de3, {0xe6, 0x98, 0xb4}},
    {0x9de4, {0xe6, 0x98, 0x9c}},
    {0x9de5, {0xe6, 0x99, 0x8f}},
    {0x9de6, {0xe6, 0x99, 0x84}},
    {0x9de7, {0xe6, 0x99, 0x89}},
    {0x9de8, {0xe6, 0x99, 0x81}},
    {0x9de9, {0xe6, 0x99, 0x9e}},
    {0x9dea, {0xe6, 0x99, 0x9d}},
    {0x9deb, {0xe6, 0x99, 0xa4}},
    {0x9dec, {0xe6, 0x99, 0xa7}},
    {0x9ded, {0xe6, 0x99, 0xa8}},
    {0x9dee, {0xe6, 0x99, 0x9f}},
    {0x9def, {0xe6, 0x99, 0xa2}},
    {0x9df0, {0xe6, 0x99, 0xb0}},
    {0x9df1, {0xe6, 0x9a, 0x83}},
    {0x9df2, {0xe6, 0x9a, 0x88}},
    {0x9df3, {0xe6, 0x9a, 0x8e}},
    {0x9df4, {0xe6, 0x9a, 0x89}},
    {0x9df5, {0xe6, 0x9a, 0x84}},
    {0x9df6, {0xe6, 0x9a, 0x98}},
    {0x9df7, {0xe6, 0x9a, 0x9d}},
    {0x9df8, {0xe6, 0x9b, 0x81}},
    {0x9df9, {0xe6, 0x9a, 0xb9}},
    {0x9dfa, {0xe6, 0x9b, 0x89}},
    {0x9dfb, {0xe6, 0x9a, 0xbe}},
    {0x9dfc, {0xe6, 0x9a, 0xbc}},
    {0x9e40, {0xe6, 0x9b, 0x84}},
    {0x9e41, {0xe6, 0x9a, 0xb8}},
    {0x9e42, {0xe6, 0x9b, 0x96}},
    {0x9e43, {0xe6, 0x9b, 0x9a}},
    {0x9e44, {0xe6, 0x9b, 0xa0}},
    {0x9e45, {0xe6, 0x98, 0xbf}},
    {0x9e46, {0xe6, 0x9b, 0xa6}},
    {0x9e47, {0xe6, 0x9b, 0xa9}},
    {0x9e48, {0xe6, 0x9b, 0xb0}},
    {0x9e49, {0xe6, 0x9b, 0xb5}},
    {0x9e4a, {0xe6, 0x9b, 0xb7}},
    {0x9e4b, {0xe6, 0x9c, 0x8f}},
    {0x9e4c, {0xe6, 0x9c, 0x96}},
    {0x9e4d, {0xe6, 0x9c, 0x9e}},
    {0x9e4e, {0xe6, 0x9c, 0xa6}},
    {0x9e4f, {0xe6, 0x9c, 0xa7}},
    {0x9e50, {0xe9, 0x9c, 0xb8}},
    {0x9e51, {0xe6, 0x9c, 0xae}},
    {0x9e52, {0xe6, 0x9c, 0xbf}},
    {0x9e53, {0xe6, 0x9c, 0xb6}},
    {0x9e54, {0xe6, 0x9d, 0x81}},
    {0x9e55, {0xe6, 0x9c, 0xb8}},
    {0x9e56, {0xe6, 0x9c, 0xb7}},
    {0x9e57, {0xe6, 0x9d, 0x86}},
    {0x9e58, {0xe6, 0x9d, 0x9e}},
    {0x9e59, {0xe6, 0x9d, 0xa0}},
    {0x9e5a, {0xe6, 0x9d, 0x99}},
    {0x9e5b, {0xe6, 0x9d, 0xa3}},
    {0x9e5c, {0xe6, 0x9d, 0xa4}},
    {0x9e5d, {0xe6, 0x9e, 0x89}},
    {0x9e5e, {0xe6, 0x9d, 0xb0}},
    {0x9e5f, {0xe6, 0x9e, 0xa9}},
    {0x9e60, {0xe6, 0x9d, 0xbc}},
    {0x9e61, {0xe6, 0x9d, 0xaa}},
    {0x9e62, {0xe6, 0x9e, 0x8c}},
    {0x9e63, {0xe6, 0x9e, 0x8b}},
    {0x9e64, {0xe6, 0x9e, 0xa6}},
    {0x9e65, {0xe6, 0x9e, 0xa1}},
    {0x9e66, {0xe6, 0x9e, 0x85}},
    {0x9e67, {0xe6, 0x9e, 0xb7}},
    {0x9e68, {0xe6, 0x9f, 0xaf}},
    {0x9e69, {0xe6, 0x9e, 0xb4}},
    {0x9e6a, {0xe6, 0x9f, 0xac}},
    {0x9e6b, {0xe6, 0x9e, 0xb3}},
    {0x9e6c, {0xe6, 0x9f, 0xa9}},
    {0x9e6d, {0xe6, 0x9e, 0xb8}},
    {0x9e6e, {0xe6, 0x9f, 0xa4}},
    {0x9e6f, {0xe6, 0x9f, 0x9e}},
    {0x9e70, {0xe6, 0x9f, 0x9d}},
    {0x9e71, {0xe6, 0x9f, 0xa2}},
    {0x9e72, {0xe6, 0x9f, 0xae}},
    {0x9e73, {0xe6, 0x9e, 0xb9}},
    {0x9e74, {0xe6, 0x9f, 0x8e}},
    {0x9e75, {0xe6, 0x9f, 0x86}},
    {0x9e76, {0xe6, 0x9f, 0xa7}},
    {0x9e77, {0xe6, 0xaa, 0x9c}},
    {0x9e78, {0xe6, 0xa0, 0x9e}},
    {0x9e79, {0xe6, 0xa1, 0x86}},
    {0x9e7a, {0xe6, 0xa0, 0xa9}},
    {0x9e7b, {0xe6, 0xa1, 0x80}},
    {0x9e7c, {0xe6, 0xa1, 0x8d}},
    {0x9e7d, {0xe6, 0xa0, 0xb2}},
    {0x9e7e, {0xe6, 0xa1, 0x8e}},
    {0x9e80, {0xe6, 0xa2, 0xb3}},
    {0x9e81, {0xe6, 0xa0, 0xab}},
    {0x9e82, {0xe6, 0xa1, 0x99}},
    {0x9e83, {0xe6, 0xa1, 0xa3}},
    {0x9e84, {0xe6, 0xa1, 0xb7}},
    {0x9e85, {0xe6, 0xa1, 0xbf}},
    {0x9e86, {0xe6, 0xa2, 0x9f}},
    {0x9e87, {0xe6, 0xa2, 0x8f}},
    {0x9e88, {0xe6, 0xa2, 0xad}},
    {0x9e89, {0xe6, 0xa2, 0x94}},
    {0x9e8a, {0xe6, 0xa2, 0x9d}},
    {0x9e8b, {0xe6, 0xa2, 0x9b}},
    {0x9e8c, {0xe6, 0xa2, 0x83}},
    {0x9e8d, {0xe6, 0xaa, 0xae}},
    {0x9e8e, {0xe6, 0xa2, 0xb9}},
    {0x9e8f, {0xe6, 0xa1, 0xb4}},
    {0x9e90, {0xe6, 0xa2, 0xb5}},
    {0x9e91, {0xe6, 0xa2, 0xa0}},
    {0x9e92, {0xe6, 0xa2, 0xba}},
    {0x9e93, {0xe6, 0xa4, 0x8f}},
    {0x9e94, {0xe6, 0xa2, 0x8d}},
    {0x9e95, {0xe6, 0xa1, 0xbe}},
    {0x9e96, {0xe6, 0xa4, 0x81}},
    {0x9e97, {0xe6, 0xa3, 0x8a}},
    {0x9e98, {0xe6, 0xa4, 0x88}},
    {0x9e99, {0xe6, 0xa3, 0x98}},
    {0x9e9a, {0xe6, 0xa4, 0xa2}},
    {0x9e9b, {0xe6, 0xa4, 0xa6}},
    {0x9e9c, {0xe6, 0xa3, 0xa1}},
    {0x9e9d, {0xe6, 0xa4, 0x8c}},
    {0x9e9e, {0xe6, 0xa3, 0x8d}},
    {0x9e9f, {0xe6, 0xa3, 0x94}},
    {0x9ea0, {0xe6, 0xa3, 0xa7}},
    {0x9ea1, {0xe6, 0xa3, 0x95}},
    {0x9ea2, {0xe6, 0xa4, 0xb6}},
    {0x9ea3, {0xe6, 0xa4, 0x92}},
    {0x9ea4, {0xe6, 0xa4, 0x84}},
    {0x9ea5, {0xe6, 0xa3, 0x97}},
    {0x9ea6, {0xe6, 0xa3, 0xa3}},
    {0x9ea7, {0xe6, 0xa4, 0xa5}},
    {0x9ea8, {0xe6, 0xa3, 0xb9}},
    {0x9ea9, {0xe6, 0xa3, 0xa0}},
    {0x9eaa, {0xe6, 0xa3, 0xaf}},
    {0x9eab, {0xe6, 0xa4, 0xa8}},
    {0x9eac, {0xe6, 0xa4, 0xaa}},
    {0x9ead, {0xe6, 0xa4, 0x9a}},
    {0x9eae, {0xe6, 0xa4, 0xa3}},
    {0x9eaf, {0xe6, 0xa4, 0xa1}},
    {0x9eb0, {0xe6, 0xa3, 0x86}},
    {0x9eb1, {0xe6, 0xa5, 0xb9}},
    {0x9eb2, {0xe6, 0xa5, 0xb7}},
    {0x9eb3, {0xe6, 0xa5, 0x9c}},
    {0x9eb4, {0xe6, 0xa5, 0xb8}},
    {0x9eb5, {0xe6, 0xa5, 0xab}},
    {0x9eb6, {0xe6, 0xa5, 0x94}},
    {0x9eb7, {0xe6, 0xa5, 0xbe}},
    {0x9eb8, {0xe6, 0xa5, 0xae}},
    {0x9eb9, {0xe6, 0xa4, 0xb9}},
    {0x9eba, {0xe6, 0xa5, 0xb4}},
    {0x9ebb, {0xe6, 0xa4, 0xbd}},
    {0x9ebc, {0xe6, 0xa5, 0x99}},
    {0x9ebd, {0xe6, 0xa4, 0xb0}},
    {0x9ebe, {0xe6, 0xa5, 0xa1}},
    {0x9ebf, {0xe6, 0xa5, 0x9e}},
    {0x9ec0, {0xe6, 0xa5, 0x9d}},
    {0x9ec1, {0xe6, 0xa6, 0x81}},
    {0x9ec2, {0xe6, 0xa5, 0xaa}},
    {0x9ec3, {0xe6, 0xa6, 0xb2}},
    {0x9ec4, {0xe6, 0xa6, 0xae}},
    {0x9ec5, {0xe6, 0xa7, 0x90}},
    {0x9ec6, {0xe6, 0xa6, 0xbf}},
    {0x9ec7, {0xe6, 0xa7, 0x81}},
    {0x9ec8, {0xe6, 0xa7, 0x93}},
    {0x9ec9, {0xe6, 0xa6, 0xbe}},
    {0x9eca, {0xe6, 0xa7, 0x8e}},
    {0x9ecb, {0xe5, 0xaf, 0xa8}},
    {0x9ecc, {0xe6, 0xa7, 0x8a}},
    {0x9ecd, {0xe6, 0xa7, 0x9d}},
    {0x9ece, {0xe6, 0xa6, 0xbb}},
    {0x9ecf, {0xe6, 0xa7, 0x83}},
    {0x9ed0, {0xe6, 0xa6, 0xa7}},
    {0x9ed1, {0xe6, 0xa8, 0xae}},
    {0x9ed2, {0xe6, 0xa6, 0x91}},
    {0x9ed3, {0xe6, 0xa6, 0xa0}},
    {0x9ed4, {0xe6, 0xa6, 0x9c}},
    {0x9ed5, {0xe6, 0xa6, 0x95}},
    {0x9ed6, {0xe6, 0xa6, 0xb4}},
    {0x9ed7, {0xe6, 0xa7, 0x9e}},
    {0x9ed8, {0xe6, 0xa7, 0xa8}},
    {0x9ed9, {0xe6, 0xa8, 0x82}},
    {0x9eda, {0xe6, 0xa8, 0x9b}},
    {0x9edb, {0xe6, 0xa7, 0xbf}},
    {0x9edc, {0xe6, 0xac, 0x8a}},
    {0x9edd, {0xe6, 0xa7, 0xb9}},
    {0x9ede, {0xe6, 0xa7, 0xb2}},
    {0x9edf, {0xe6, 0xa7, 0xa7}},
    {0x9ee0, {0xe6, 0xa8, 0x85}},
    {0x9ee1, {0xe6, 0xa6, 0xb1}},
    {0x9ee2, {0xe6, 0xa8, 0x9e}},
    {0x9ee3, {0xe6, 0xa7, 0xad}},
    {0x9ee4, {0xe6, 0xa8, 0x94}},
    {0x9ee5, {0xe6, 0xa7, 0xab}},
    {0x9ee6, {0xe6, 0xa8, 0x8a}},
    {0x9ee7, {0xe6, 0xa8, 0x92}},
    {0x9ee8, {0xe6, 0xab, 0x81}},
    {0x9ee9, {0xe6, 0xa8, 0xa3}},
    {0x9eea, {0xe6, 0xa8, 0x93}},
    {0x9eeb, {0xe6, 0xa9, 0x84}},
    {0x9eec, {0xe6, 0xa8, 0x8c}},
    {0x9eed, {0xe6, 0xa9, 0xb2}},
    {0x9eee, {0xe6, 0xa8, 0xb6}},
    {0x9eef, {0xe6, 0xa9, 0xb8}},
    {0x9ef0, {0xe6, 0xa9, 0x87}},
    {0x9ef1, {0xe6, 0xa9, 0xa2}},
    {0x9ef2, {0xe6, 0xa9, 0x99}},
    {0x9ef3, {0xe6, 0xa9, 0xa6}},
    {0x9ef4, {0xe6, 0xa9, 0x88}},
    {0x9ef5, {0xe6, 0xa8, 0xb8}},
    {0x9ef6, {0xe6, 0xa8, 0xa2}},
    {0x9ef7, {0xe6, 0xaa, 0x90}},
    {0x9ef8, {0xe6, 0xaa, 0x8d}},
    {0x9ef9, {0xe6, 0xaa, 0xa0}},
    {0x9efa, {0xe6, 0xaa, 0x84}},
    {0x9efb, {0xe6, 0xaa, 0xa2}},
    {0x9efc, {0xe6, 0xaa, 0xa3}},
    {0x9f40, {0xe6, 0xaa, 0x97}},
    {0x9f41, {0xe8, 0x98, 0x97}},
    {0x9f42, {0xe6, 0xaa, 0xbb}},
    {0x9f43, {0xe6, 0xab, 0x83}},
    {0x9f44, {0xe6, 0xab, 0x82}},
    {0x9f45, {0xe6, 0xaa, 0xb8}},
    {0x9f46, {0xe6, 0xaa, 0xb3}},
    {0x9f47, {0xe6, 0xaa, 0xac}},
    {0x9f48, {0xe6, 0xab, 0x9e}},
    {0x9f49, {0xe6, 0xab, 0x91}},
    {0x9f4a, {0xe6, 0xab, 0x9f}},
    {0x9f4b, {0xe6, 0xaa, 0xaa}},
    {0x9f4c, {0xe6, 0xab, 0x9a}},
    {0x9f4d, {0xe6, 0xab, 0xaa}},
    {0x9f4e, {0xe6, 0xab, 0xbb}},
    {0x9f4f, {0xe6, 0xac, 0x85}},
    {0x9f50, {0xe8, 0x98, 0x96}},
    {0x9f51, {0xe6, 0xab, 0xba}},
    {0x9f52, {0xe6, 0xac, 0x92}},
    {0x9f53, {0xe6, 0xac, 0x96}},
    {0x9f54, {0xe9, 0xac, 0xb1}},
    {0x9f55, {0xe6, 0xac, 0x9f}},
    {0x9f56, {0xe6, 0xac, 0xb8}},
    {0x9f57, {0xe6, 0xac, 0xb7}},
    {0x9f58, {0xe7, 0x9b, 0x9c}},
    {0x9f59, {0xe6, 0xac, 0xb9}},
    {0x9f5a, {0xe9, 0xa3, 0xae}},
    {0x9f5b, {0xe6, 0xad, 0x87}},
    {0x9f5c, {0xe6, 0xad, 0x83}},
    {0x9f5d, {0xe6, 0xad, 0x89}},
    {0x9f5e, {0xe6, 0xad, 0x90}},
    {0x9f5f, {0xe6, 0xad, 0x99}},
    {0x9f60, {0xe6, 0xad, 0x94}},
    {0x9f61, {0xe6, 0xad, 0x9b}},
    {0x9f62, {0xe6, 0xad, 0x9f}},
    {0x9f63, {0xe6, 0xad, 0xa1}},
    {0x9f64, {0xe6, 0xad, 0xb8}},
    {0x9f65, {0xe6, 0xad, 0xb9}},
    {0x9f66, {0xe6, 0xad, 0xbf}},
    {0x9f67, {0xe6, 0xae, 0x80}},
    {0x9f68, {0xe6, 0xae, 0x84}},
    {0x9f69, {0xe6, 0xae, 0x83}},
    {0x9f6a, {0xe6, 0xae, 0x8d}},
    {0x9f6b, {0xe6, 0xae, 0x98}},
    {0x9f6c, {0xe6, 0xae, 0x95}},
    {0x9f6d, {0xe6, 0xae, 0x9e}},
    {0x9f6e, {0xe6, 0xae, 0xa4}},
    {0x9f6f, {0xe6, 0xae, 0xaa}},
    {0x9f70, {0xe6, 0xae, 0xab}},
    {0x9f71, {0xe6, 0xae, 0xaf}},
    {0x9f72, {0xe6, 0xae, 0xb2}},
    {0x9f73, {0xe6, 0xae, 0xb1}},
    {0x9f74, {0xe6, 0xae, 0xb3}},
    {0x9f75, {0xe6, 0xae, 0xb7}},
    {0x9f76, {0xe6, 0xae, 0xbc}},
    {0x9f77, {0xe6, 0xaf, 0x86}},
    {0x9f78, {0xe6, 0xaf, 0x8b}},
    {0x9f79, {0xe6, 0xaf, 0x93}},
    {0x9f7a, {0xe6, 0xaf, 0x9f}},
    {0x9f7b, {0xe6, 0xaf, 0xac}},
    {0x9f7c, {0xe6, 0xaf, 0xab}},
    {0x9f7d, {0xe6, 0xaf, 0xb3}},
    {0x9f7e, {0xe6, 0xaf, 0xaf}},
    {0x9f80, {0xe9, 0xba, 0xbe}},
    {0x9f81, {0xe6, 0xb0, 0x88}},
    {0x9f82, {0xe6, 0xb0, 0x93}},
    {0x9f83, {0xe6, 0xb0, 0x94}},
    {0x9f84, {0xe6, 0xb0, 0x9b}},
    {0x9f85, {0xe6, 0xb0, 0xa4}},
    {0x9f86, {0xe6, 0xb0, 0xa3}},
    {0x9f87, {0xe6, 0xb1, 0x9e}},
    {0x9f88, {0xe6, 0xb1, 0x95}},
    {0x9f89, {0xe6, 0xb1, 0xa2}},
    {0x9f8a, {0xe6, 0xb1, 0xaa}},
    {0x9f8b, {0xe6, 0xb2, 0x82}},
    {0x9f8c, {0xe6, 0xb2, 0x8d}},
    {0x9f8d, {0xe6, 0xb2, 0x9a}},
    {0x9f8e, {0xe6, 0xb2, 0x81}},
    {0x9f8f, {0xe6, 0xb2, 0x9b}},
    {0x9f90, {0xe6, 0xb1, 0xbe}},
    {0x9f91, {0xe6, 0xb1, 0xa8}},
    {0x9f92, {0xe6, 0xb1, 0xb3}},
    {0x9f93, {0xe6, 0xb2, 0x92}},
    {0x9f94, {0xe6, 0xb2, 0x90}},
    {0x9f95, {0xe6, 0xb3, 0x84}},
    {0x9f96, {0xe6, 0xb3, 0xb1}},
    {0x9f97, {0xe6, 0xb3, 0x93}},
    {0x9f98, {0xe6, 0xb2, 0xbd}},
    {0x9f99, {0xe6, 0xb3, 0x97}},
    {0x9f9a, {0xe6, 0xb3, 0x85}},
    {0x9f9b, {0xe6, 0xb3, 0x9d}},
    {0x9f9c, {0xe6, 0xb2, 0xae}},
    {0x9f9d, {0xe6, 0xb2, 0xb1}},
    {0x9f9e, {0xe6, 0xb2, 0xbe}},
    {0x9f9f, {0xe6, 0xb2, 0xba}},
    {0x9fa0, {0xe6, 0xb3, 0x9b}},
    {0x9fa1, {0xe6, 0xb3, 0xaf}},
    {0x9fa2, {0xe6, 0xb3, 0x99}},
    {0x9fa3, {0xe6, 0xb3, 0xaa}},
    {0x9fa4, {0xe6, 0xb4, 0x9f}},
    {0x9fa5, {0xe8, 0xa1, 0x8d}},
    {0x9fa6, {0xe6, 0xb4, 0xb6}},
    {0x9fa7, {0xe6, 0xb4, 0xab}},
    {0x9fa8, {0xe6, 0xb4, 0xbd}},
    {0x9fa9, {0xe6, 0xb4, 0xb8}},
    {0x9faa, {0xe6, 0xb4, 0x99}},
    {0x9fab, {0xe6, 0xb4, 0xb5}},
    {0x9fac, {0xe6, 0xb4, 0xb3}},
    {0x9fad, {0xe6, 0xb4, 0x92}},
    {0x9fae, {0xe6, 0xb4, 0x8c}},
    {0x9faf, {0xe6, 0xb5, 0xa3}},
    {0x9fb0, {0xe6, 0xb6, 0x93}},
    {0x9fb1, {0xe6, 0xb5, 0xa4}},
    {0x9fb2, {0xe6, 0xb5, 0x9a}},
    {0x9fb3, {0xe6, 0xb5, 0xb9}},
    {0x9fb4, {0xe6, 0xb5, 0x99}},
    {0x9fb5, {0xe6, 0xb6, 0x8e}},
    {0x9fb6, {0xe6, 0xb6, 0x95}},
    {0x9fb7, {0xe6, 0xbf, 0xa4}},
    {0x9fb8, {0xe6, 0xb6, 0x85}},
    {0x9fb9, {0xe6, 0xb7, 0xb9}},
    {0x9fba, {0xe6, 0xb8, 0x95}},
    {0x9fbb, {0xe6, 0xb8, 0x8a}},
    {0x9fbc, {0xe6, 0xb6, 0xb5}},
    {0x9fbd, {0xe6, 0xb7, 0x87}},
    {0x9fbe, {0xe6, 0xb7, 0xa6}},
    {0x9fbf, {0xe6, 0xb6, 0xb8}},
    {0x9fc0, {0xe6, 0xb7, 0x86}},
    {0x9fc1, {0xe6, 0xb7, 0xac}},
    {0x9fc2, {0xe6, 0xb7, 0x9e}},
    {0x9fc3, {0xe6, 0xb7, 0x8c}},
    {0x9fc4, {0xe6, 0xb7, 0xa8}},
    {0x9fc5, {0xe6, 0xb7, 0x92}},
    {0x9fc6, {0xe6, 0xb7, 0x85}},
    {0x9fc7, {0xe6, 0xb7, 0xba}},
    {0x9fc8, {0xe6, 0xb7, 0x99}},
    {0x9fc9, {0xe6, 0xb7, 0xa4}},
    {0x9fca, {0xe6, 0xb7, 0x95}},
    {0x9fcb, {0xe6, 0xb7, 0xaa}},
    {0x9fcc, {0xe6, 0xb7, 0xae}},
    {0x9fcd, {0xe6, 0xb8, 0xad}},
    {0x9fce, {0xe6, 0xb9, 0xae}},
    {0x9fcf, {0xe6, 0xb8, 0xae}},
    {0x9fd0, {0xe6, 0xb8, 0x99}},
    {0x9fd1, {0xe6, 0xb9, 0xb2}},
    {0x9fd2, {0xe6, 0xb9, 0x9f}},
    {0x9fd3, {0xe6, 0xb8, 0xbe}},
    {0x9fd4, {0xe6, 0xb8, 0xa3}},
    {0x9fd5, {0xe6, 0xb9, 0xab}},
    {0x9fd6, {0xe6, 0xb8, 0xab}},
    {0x9fd7, {0xe6, 0xb9, 0xb6}},
    {0x9fd8, {0xe6, 0xb9, 0x8d}},
    {0x9fd9, {0xe6, 0xb8, 0x9f}},
    {0x9fda, {0xe6, 0xb9, 0x83}},
    {0x9fdb, {0xe6, 0xb8, 0xba}},
    {0x9fdc, {0xe6, 0xb9, 0x8e}},
    {0x9fdd, {0xe6, 0xb8, 0xa4}},
    {0x9fde, {0xe6, 0xbb, 0xbf}},
    {0x9fdf, {0xe6, 0xb8, 0x9d}},
    {0x9fe0, {0xe6, 0xb8, 0xb8}},
    {0x9fe1, {0xe6, 0xba, 0x82}},
    {0x9fe2, {0xe6, 0xba, 0xaa}},
    {0x9fe3, {0xe6, 0xba, 0x98}},
    {0x9fe4, {0xe6, 0xbb, 0x89}},
    {0x9fe5, {0xe6, 0xba, 0xb7}},
    {0x9fe6, {0xe6, 0xbb, 0x93}},
    {0x9fe7, {0xe6, 0xba, 0xbd}},
    {0x9fe8, {0xe6, 0xba, 0xaf}},
    {0x9fe9, {0xe6, 0xbb, 0x84}},
    {0x9fea, {0xe6, 0xba, 0xb2}},
    {0x9feb, {0xe6, 0xbb, 0x94}},
    {0x9fec, {0xe6, 0xbb, 0x95}},
    {0x9fed, {0xe6, 0xba, 0x8f}},
    {0x9fee, {0xe6, 0xba, 0xa5}},
    {0x9fef, {0xe6, 0xbb, 0x82}},
    {0x9ff0, {0xe6, 0xba, 0x9f}},
    {0x9ff1, {0xe6, 0xbd, 0x81}},
    {0x9ff2, {0xe6, 0xbc, 0x91}},
    {0x9ff3, {0xe7, 0x81, 0x8c}},
    {0x9ff4, {0xe6, 0xbb, 0xac}},
    {0x9ff5, {0xe6, 0xbb, 0xb8}},
    {0x9ff6, {0xe6, 0xbb, 0xbe}},
    {0x9ff7, {0xe6, 0xbc, 0xbf}},
    {0x9ff8, {0xe6, 0xbb, 0xb2}},
    {0x9ff9, {0xe6, 0xbc, 0xb1}},
    {0x9ffa, {0xe6, 0xbb, 0xaf}},
    {0x9ffb, {0xe6, 0xbc, 0xb2}},
    {0x9ffc, {0xe6, 0xbb, 0x8c}},
    {0xa100, {0xef, 0xbd, 0xa1}},
    {0xa200, {0xef, 0xbd, 0xa2}},
    {0xa300, {0xef, 0xbd, 0xa3}},
    {0xa400, {0xef, 0xbd, 0xa4}},
    {0xa500, {0xef, 0xbd, 0xa5}},
    {0xa600, {0xef, 0xbd, 0xa6}},
    {0xa700, {0xef, 0xbd, 0xa7}},
    {0xa800, {0xef, 0xbd, 0xa8}},
    {0xa900, {0xef, 0xbd, 0xa9}},
    {0xaa00, {0xef, 0xbd, 0xaa}},
    {0xab00, {0xef, 0xbd, 0xab}},
    {0xac00, {0xef, 0xbd, 0xac}},
    {0xad00, {0xef, 0xbd, 0xad}},
    {0xae00, {0xef, 0xbd, 0xae}},
    {0xaf00, {0xef, 0xbd, 0xaf}},
    {0xb000, {0xef, 0xbd, 0xb0}},
    {0xb100, {0xef, 0xbd, 0xb1}},
    {0xb200, {0xef, 0xbd, 0xb2}},
    {0xb300, {0xef, 0xbd, 0xb3}},
    {0xb400, {0xef, 0xbd, 0xb4}},
    {0xb500, {0xef, 0xbd, 0xb5}},
    {0xb600, {0xef, 0xbd, 0xb6}},
    {0xb700, {0xef, 0xbd, 0xb7}},
    {0xb800, {0xef, 0xbd, 0xb8}},
    {0xb900, {0xef, 0xbd, 0xb9}},
    {0xba00, {0xef, 0xbd, 0xba}},
    {0xbb00, {0xef, 0xbd, 0xbb}},
    {0xbc00, {0xef, 0xbd, 0xbc}},
    {0xbd00, {0xef, 0xbd, 0xbd}},
    {0xbe00, {0xef, 0xbd, 0xbe}},
    {0xbf00, {0xef, 0xbd, 0xbf}},
    {0xc000, {0xef, 0xbe, 0x80}},
    {0xc100, {0xef, 0xbe, 0x81}},
    {0xc200, {0xef, 0xbe, 0x82}},
    {0xc300, {0xef, 0xbe, 0x83}},
    {0xc400, {0xef, 0xbe, 0x84}},
    {0xc500, {0xef, 0xbe, 0x85}},
    {0xc600, {0xef, 0xbe, 0x86}},
    {0xc700, {0xef, 0xbe, 0x87}},
    {0xc800, {0xef, 0xbe, 0x88}},
    {0xc900, {0xef, 0xbe, 0x89}},
    {0xca00, {0xef, 0xbe, 0x8a}},
    {0xcb00, {0xef, 0xbe, 0x8b}},
    {0xcc00, {0xef, 0xbe, 0x8c}},
    {0xcd00, {0xef, 0xbe, 0x8d}},
    {0xce00, {0xef, 0xbe, 0x8e}},
    {0xcf00, {0xef, 0xbe, 0x8f}},
    {0xd000, {0xef, 0xbe, 0x90}},
    {0xd100, {0xef, 0xbe, 0x91}},
    {0xd200, {0xef, 0xbe, 0x92}},
    {0xd300, {0xef, 0xbe, 0x93}},
    {0xd400, {0xef, 0xbe, 0x94}},
    {0xd500, {0xef, 0xbe, 0x95}},
    {0xd600, {0xef, 0xbe, 0x96}},
    {0xd700, {0xef, 0xbe, 0x97}},
    {0xd800, {0xef, 0xbe, 0x98}},
    {0xd900, {0xef, 0xbe, 0x99}},
    {0xda00, {0xef, 0xbe, 0x9a}},
    {0xdb00, {0xef, 0xbe, 0x9b}},
    {0xdc00, {0xef, 0xbe, 0x9c}},
    {0xdd00, {0xef, 0xbe, 0x9d}},
    {0xde00, {0xef, 0xbe, 0x9e}},
    {0xdf00, {0xef, 0xbe, 0x9f}},
    {0xe040, {0xe6, 0xbc, 0xbe}},
    {0xe041, {0xe6, 0xbc, 0x93}},
    {0xe042, {0xe6, 0xbb, 0xb7}},
    {0xe043, {0xe6, 0xbe, 0x86}},
    {0xe044, {0xe6, 0xbd, 0xba}},
    {0xe045, {0xe6, 0xbd, 0xb8}},
    {0xe046, {0xe6, 0xbe, 0x81}},
    {0xe047, {0xe6, 0xbe, 0x80}},
    {0xe048, {0xe6, 0xbd, 0xaf}},
    {0xe049, {0xe6, 0xbd, 0x9b}},
    {0xe04a, {0xe6, 0xbf, 0xb3}},
    {0xe04b, {0xe6, 0xbd, 0xad}},
    {0xe04c, {0xe6, 0xbe, 0x82}},
    {0xe04d, {0xe6, 0xbd, 0xbc}},
    {0xe04e, {0xe6, 0xbd, 0x98}},
    {0xe04f, {0xe6, 0xbe, 0x8e}},
    {0xe050, {0xe6, 0xbe, 0x91}},
    {0xe051, {0xe6, 0xbf, 0x82}},
    {0xe052, {0xe6, 0xbd, 0xa6}},
    {0xe053, {0xe6, 0xbe, 0xb3}},
    {0xe054, {0xe6, 0xbe, 0xa3}},
    {0xe055, {0xe6, 0xbe, 0xa1}},
    {0xe056, {0xe6, 0xbe, 0xa4}},
    {0xe057, {0xe6, 0xbe, 0xb9}},
    {0xe058, {0xe6, 0xbf, 0x86}},
    {0xe059, {0xe6, 0xbe, 0xaa}},
    {0xe05a, {0xe6, 0xbf, 0x9f}},
    {0xe05b, {0xe6, 0xbf, 0x95}},
    {0xe05c, {0xe6, 0xbf, 0xac}},
    {0xe05d, {0xe6, 0xbf, 0x94}},
    {0xe05e, {0xe6, 0xbf, 0x98}},
    {0xe05f, {0xe6, 0xbf, 0xb1}},
    {0xe060, {0xe6, 0xbf, 0xae}},
    {0xe061, {0xe6, 0xbf, 0x9b}},
    {0xe062, {0xe7, 0x80, 0x89}},
    {0xe063, {0xe7, 0x80, 0x8b}},
    {0xe064, {0xe6, 0xbf, 0xba}},
    {0xe065, {0xe7, 0x80, 0x91}},
    {0xe066, {0xe7, 0x80, 0x81}},
    {0xe067, {0xe7, 0x80, 0x8f}},
    {0xe068, {0xe6, 0xbf, 0xbe}},
    {0xe069, {0xe7, 0x80, 0x9b}},
    {0xe06a, {0xe7, 0x80, 0x9a}},
    {0xe06b, {0xe6, 0xbd, 0xb4}},
    {0xe06c, {0xe7, 0x80, 0x9d}},
    {0xe06d, {0xe7, 0x80, 0x98}},
    {0xe06e, {0xe7, 0x80, 0x9f}},
    {0xe06f, {0xe7, 0x80, 0xb0}},
    {0xe070, {0xe7, 0x80, 0xbe}},
    {0xe071, {0xe7, 0x80, 0xb2}},
    {0xe072, {0xe7, 0x81, 0x91}},
    {0xe073, {0xe7, 0x81, 0xa3}},
    {0xe074, {0xe7, 0x82, 0x99}},
    {0xe075, {0xe7, 0x82, 0x92}},
    {0xe076, {0xe7, 0x82, 0xaf}},
    {0xe077, {0xe7, 0x83, 0xb1}},
    {0xe078, {0xe7, 0x82, 0xac}},
    {0xe079, {0xe7, 0x82, 0xb8}},
    {0xe07a, {0xe7, 0x82, 0xb3}},
    {0xe07b, {0xe7, 0x82, 0xae}},
    {0xe07c, {0xe7, 0x83, 0x9f}},
    {0xe07d, {0xe7, 0x83, 0x8b}},
    {0xe07e, {0xe7, 0x83, 0x9d}},
    {0xe080, {0xe7, 0x83, 0x99}},
    {0xe081, {0xe7, 0x84, 0x89}},
    {0xe082, {0xe7, 0x83, 0xbd}},
    {0xe083, {0xe7, 0x84, 0x9c}},
    {0xe084, {0xe7, 0x84, 0x99}},
    {0xe085, {0xe7, 0x85, 0xa5}},
    {0xe086, {0xe7, 0x85, 0x95}},
    {0xe087, {0xe7, 0x86, 0x88}},
    {0xe088, {0xe7, 0x85, 0xa6}},
    {0xe089, {0xe7, 0x85, 0xa2}},
    {0xe08a, {0xe7, 0x85, 0x8c}},
    {0xe08b, {0xe7, 0x85, 0x96}},
    {0xe08c, {0xe7, 0x85, 0xac}},
    {0xe08d, {0xe7, 0x86, 0x8f}},
    {0xe08e, {0xe7, 0x87, 0xbb}},
    {0xe08f, {0xe7, 0x86, 0x84}},
    {0xe090, {0xe7, 0x86, 0x95}},
    {0xe091, {0xe7, 0x86, 0xa8}},
    {0xe092, {0xe7, 0x86, 0xac}},
    {0xe093, {0xe7, 0x87, 0x97}},
    {0xe094, {0xe7, 0x86, 0xb9}},
    {0xe095, {0xe7, 0x86, 0xbe}},
    {0xe096, {0xe7, 0x87, 0x92}},
    {0xe097, {0xe7, 0x87, 0x89}},
    {0xe098, {0xe7, 0x87, 0x94}},
    {0xe099, {0xe7, 0x87, 0x8e}},
    {0xe09a, {0xe7, 0x87, 0xa0}},
    {0xe09b, {0xe7, 0x87, 0xac}},
    {0xe09c, {0xe7, 0x87, 0xa7}},
    {0xe09d, {0xe7, 0x87, 0xb5}},
    {0xe09e, {0xe7, 0x87, 0xbc}},
    {0xe09f, {0xe7, 0x87, 0xb9}},
    {0xe0a0, {0xe7, 0x87, 0xbf}},
    {0xe0a1, {0xe7, 0x88, 0x8d}},
    {0xe0a2, {0xe7, 0x88, 0x90}},
    {0xe0a3, {0xe7, 0x88, 0x9b}},
    {0xe0a4, {0xe7, 0x88, 0xa8}},
    {0xe0a5, {0xe7, 0x88, 0xad}},
    {0xe0a6, {0xe7, 0x88, 0xac}},
    {0xe0a7, {0xe7, 0x88, 0xb0}},
    {0xe0a8, {0xe7, 0x88, 0xb2}},
    {0xe0a9, {0xe7, 0x88, 0xbb}},
    {0xe0aa, {0xe7, 0x88, 0xbc}},
    {0xe0ab, {0xe7, 0x88, 0xbf}},
    {0xe0ac, {0xe7, 0x89, 0x80}},
    {0xe0ad, {0xe7, 0x89, 0x86}},
    {0xe0ae, {0xe7, 0x89, 0x8b}},
    {0xe0af, {0xe7, 0x89, 0x98}},
    {0xe0b0, {0xe7, 0x89, 0xb4}},
    {0xe0b1, {0xe7, 0x89, 0xbe}},
    {0xe0b2, {0xe7, 0x8a, 0x82}},
    {0xe0b3, {0xe7, 0x8a, 0x81}},
    {0xe0b4, {0xe7, 0x8a, 0x87}},
    {0xe0b5, {0xe7, 0x8a, 0x92}},
    {0xe0b6, {0xe7, 0x8a, 0x96}},
    {0xe0b7, {0xe7, 0x8a, 0xa2}},
    {0xe0b8, {0xe7, 0x8a, 0xa7}},
    {0xe0b9, {0xe7, 0x8a, 0xb9}},
    {0xe0ba, {0xe7, 0x8a, 0xb2}},
    {0xe0bb, {0xe7, 0x8b, 0x83}},
    {0xe0bc, {0xe7, 0x8b, 0x86}},
    {0xe0bd, {0xe7, 0x8b, 0x84}},
    {0xe0be, {0xe7, 0x8b, 0x8e}},
    {0xe0bf, {0xe7, 0x8b, 0x92}},
    {0xe0c0, {0xe7, 0x8b, 0xa2}},
    {0xe0c1, {0xe7, 0x8b, 0xa0}},
    {0xe0c2, {0xe7, 0x8b, 0xa1}},
    {0xe0c3, {0xe7, 0x8b, 0xb9}},
    {0xe0c4, {0xe7, 0x8b, 0xb7}},
    {0xe0c5, {0xe5, 0x80, 0x8f}},
    {0xe0c6, {0xe7, 0x8c, 0x97}},
    {0xe0c7, {0xe7, 0x8c, 0x8a}},
    {0xe0c8, {0xe7, 0x8c, 0x9c}},
    {0xe0c9, {0xe7, 0x8c, 0x96}},
    {0xe0ca, {0xe7, 0x8c, 0x9d}},
    {0xe0cb, {0xe7, 0x8c, 0xb4}},
    {0xe0cc, {0xe7, 0x8c, 0xaf}},
    {0xe0cd, {0xe7, 0x8c, 0xa9}},
    {0xe0ce, {0xe7, 0x8c, 0xa5}},
    {0xe0cf, {0xe7, 0x8c, 0xbe}},
    {0xe0d0, {0xe7, 0x8d, 0x8e}},
    {0xe0d1, {0xe7, 0x8d, 0x8f}},
    {0xe0d2, {0xe9, 0xbb, 0x98}},
    {0xe0d3, {0xe7, 0x8d, 0x97}},
    {0xe0d4, {0xe7, 0x8d, 0xaa}},
    {0xe0d5, {0xe7, 0x8d, 0xa8}},
    {0xe0d6, {0xe7, 0x8d, 0xb0}},
    {0xe0d7, {0xe7, 0x8d, 0xb8}},
    {0xe0d8, {0xe7, 0x8d, 0xb5}},
    {0xe0d9, {0xe7, 0x8d, 0xbb}},
    {0xe0da, {0xe7, 0x8d, 0xba}},
    {0xe0db, {0xe7, 0x8f, 0x88}},
    {0xe0dc, {0xe7, 0x8e, 0xb3}},
    {0xe0dd, {0xe7, 0x8f, 0x8e}},
    {0xe0de, {0xe7, 0x8e, 0xbb}},
    {0xe0df, {0xe7, 0x8f, 0x80}},
    {0xe0e0, {0xe7, 0x8f, 0xa5}},
    {0xe0e1, {0xe7, 0x8f, 0xae}},
    {0xe0e2, {0xe7, 0x8f, 0x9e}},
    {0xe0e3, {0xe7, 0x92, 0xa2}},
    {0xe0e4, {0xe7, 0x90, 0x85}},
    {0xe0e5, {0xe7, 0x91, 0xaf}},
    {0xe0e6, {0xe7, 0x90, 0xa5}},
    {0xe0e7, {0xe7, 0x8f, 0xb8}},
    {0xe0e8, {0xe7, 0x90, 0xb2}},
    {0xe0e9, {0xe7, 0x90, 0xba}},
    {0xe0ea, {0xe7, 0x91, 0x95}},
    {0xe0eb, {0xe7, 0x90, 0xbf}},
    {0xe0ec, {0xe7, 0x91, 0x9f}},
    {0xe0ed, {0xe7, 0x91, 0x99}},
    {0xe0ee, {0xe7, 0x91, 0x81}},
    {0xe0ef, {0xe7, 0x91, 0x9c}},
    {0xe0f0, {0xe7, 0x91, 0xa9}},
    {0xe0f1, {0xe7, 0x91, 0xb0}},
    {0xe0f2, {0xe7, 0x91, 0xa3}},
    {0xe0f3, {0xe7, 0x91, 0xaa}},
    {0xe0f4, {0xe7, 0x91, 0xb6}},
    {0xe0f5, {0xe7, 0x91, 0xbe}},
    {0xe0f6, {0xe7, 0x92, 0x8b}},
    {0xe0f7, {0xe7, 0x92, 0x9e}},
    {0xe0f8, {0xe7, 0x92, 0xa7}},
    {0xe0f9, {0xe7, 0x93, 0x8a}},
    {0xe0fa, {0xe7, 0x93, 0x8f}},
    {0xe0fb, {0xe7, 0x93, 0x94}},
    {0xe0fc, {0xe7, 0x8f, 0xb1}},
    {0xe140, {0xe7, 0x93, 0xa0}},
    {0xe141, {0xe7, 0x93, 0xa3}},
    {0xe142, {0xe7, 0x93, 0xa7}},
    {0xe143, {0xe7, 0x93, 0xa9}},
    {0xe144, {0xe7, 0x93, 0xae}},
    {0xe145, {0xe7, 0x93, 0xb2}},
    {0xe146, {0xe7, 0x93, 0xb0}},
    {0xe147, {0xe7, 0x93, 0xb1}},
    {0xe148, {0xe7, 0x93, 0xb8}},
    {0xe149, {0xe7, 0x93, 0xb7}},
    {0xe14a, {0xe7, 0x94, 0x84}},
    {0xe14b, {0xe7, 0x94, 0x83}},
    {0xe14c, {0xe7, 0x94, 0x85}},
    {0xe14d, {0xe7, 0x94, 0x8c}},
    {0xe14e, {0xe7, 0x94, 0x8e}},
    {0xe14f, {0xe7, 0x94, 0x8d}},
    {0xe150, {0xe7, 0x94, 0x95}},
    {0xe151, {0xe7, 0x94, 0x93}},
    {0xe152, {0xe7, 0x94, 0x9e}},
    {0xe153, {0xe7, 0x94, 0xa6}},
    {0xe154, {0xe7, 0x94, 0xac}},
    {0xe155, {0xe7, 0x94, 0xbc}},
    {0xe156, {0xe7, 0x95, 0x84}},
    {0xe157, {0xe7, 0x95, 0x8d}},
    {0xe158, {0xe7, 0x95, 0x8a}},
    {0xe159, {0xe7, 0x95, 0x89}},
    {0xe15a, {0xe7, 0x95, 0x9b}},
    {0xe15b, {0xe7, 0x95, 0x86}},
    {0xe15c, {0xe7, 0x95, 0x9a}},
    {0xe15d, {0xe7, 0x95, 0xa9}},
    {0xe15e, {0xe7, 0x95, 0xa4}},
    {0xe15f, {0xe7, 0x95, 0xa7}},
    {0xe160, {0xe7, 0x95, 0xab}},
    {0xe161, {0xe7, 0x95, 0xad}},
    {0xe162, {0xe7, 0x95, 0xb8}},
    {0xe163, {0xe7, 0x95, 0xb6}},
    {0xe164, {0xe7, 0x96, 0x86}},
    {0xe165, {0xe7, 0x96, 0x87}},
    {0xe166, {0xe7, 0x95, 0xb4}},
    {0xe167, {0xe7, 0x96, 0x8a}},
    {0xe168, {0xe7, 0x96, 0x89}},
    {0xe169, {0xe7, 0x96, 0x82}},
    {0xe16a, {0xe7, 0x96, 0x94}},
    {0xe16b, {0xe7, 0x96, 0x9a}},
    {0xe16c, {0xe7, 0x96, 0x9d}},
    {0xe16d, {0xe7, 0x96, 0xa5}},
    {0xe16e, {0xe7, 0x96, 0xa3}},
    {0xe16f, {0xe7, 0x97, 0x82}},
    {0xe170, {0xe7, 0x96, 0xb3}},
    {0xe171, {0xe7, 0x97, 0x83}},
    {0xe172, {0xe7, 0x96, 0xb5}},
    {0xe173, {0xe7, 0x96, 0xbd}},
    {0xe174, {0xe7, 0x96, 0xb8}},
    {0xe175, {0xe7, 0x96, 0xbc}},
    {0xe176, {0xe7, 0x96, 0xb1}},
    {0xe177, {0xe7, 0x97, 0x8d}},
    {0xe178, {0xe7, 0x97, 0x8a}},
    {0xe179, {0xe7, 0x97, 0x92}},
    {0xe17a, {0xe7, 0x97, 0x99}},
    {0xe17b, {0xe7, 0x97, 0xa3}},
    {0xe17c, {0xe7, 0x97, 0x9e}},
    {0xe17d, {0xe7, 0x97, 0xbe}},
    {0xe17e, {0xe7, 0x97, 0xbf}},
    {0xe180, {0xe7, 0x97, 0xbc}},
    {0xe181, {0xe7, 0x98, 0x81}},
    {0xe182, {0xe7, 0x97, 0xb0}},
    {0xe183, {0xe7, 0x97, 0xba}},
    {0xe184, {0xe7, 0x97, 0xb2}},
    {0xe185, {0xe7, 0x97, 0xb3}},
    {0xe186, {0xe7, 0x98, 0x8b}},
    {0xe187, {0xe7, 0x98, 0x8d}},
    {0xe188, {0xe7, 0x98, 0x89}},
    {0xe189, {0xe7, 0x98, 0x9f}},
    {0xe18a, {0xe7, 0x98, 0xa7}},
    {0xe18b, {0xe7, 0x98, 0xa0}},
    {0xe18c, {0xe7, 0x98, 0xa1}},
    {0xe18d, {0xe7, 0x98, 0xa2}},
    {0xe18e, {0xe7, 0x98, 0xa4}},
    {0xe18f, {0xe7, 0x98, 0xb4}},
    {0xe190, {0xe7, 0x98, 0xb0}},
    {0xe191, {0xe7, 0x98, 0xbb}},
    {0xe192, {0xe7, 0x99, 0x87}},
    {0xe193, {0xe7, 0x99, 0x88}},
    {0xe194, {0xe7, 0x99, 0x86}},
    {0xe195, {0xe7, 0x99, 0x9c}},
    {0xe196, {0xe7, 0x99, 0x98}},
    {0xe197, {0xe7, 0x99, 0xa1}},
    {0xe198, {0xe7, 0x99, 0xa2}},
    {0xe199, {0xe7, 0x99, 0xa8}},
    {0xe19a, {0xe7, 0x99, 0xa9}},
    {0xe19b, {0xe7, 0x99, 0xaa}},
    {0xe19c, {0xe7, 0x99, 0xa7}},
    {0xe19d, {0xe7, 0x99, 0xac}},
    {0xe19e, {0xe7, 0x99, 0xb0}},
    {0xe19f, {0xe7, 0x99, 0xb2}},
    {0xe1a0, {0xe7, 0x99, 0xb6}},
    {0xe1a1, {0xe7, 0x99, 0xb8}},
    {0xe1a2, {0xe7, 0x99, 0xbc}},
    {0xe1a3, {0xe7, 0x9a, 0x80}},
    {0xe1a4, {0xe7, 0x9a, 0x83}},
    {0xe1a5, {0xe7, 0x9a, 0x88}},
    {0xe1a6, {0xe7, 0x9a, 0x8b}},
    {0xe1a7, {0xe7, 0x9a, 0x8e}},
    {0xe1a8, {0xe7, 0x9a, 0x96}},
    {0xe1a9, {0xe7, 0x9a, 0x93}},
    {0xe1aa, {0xe7, 0x9a, 0x99}},
    {0xe1ab, {0xe7, 0x9a, 0x9a}},
    {0xe1ac, {0xe7, 0x9a, 0xb0}},
    {0xe1ad, {0xe7, 0x9a, 0xb4}},
    {0xe1ae, {0xe7, 0x9a, 0xb8}},
    {0xe1af, {0xe7, 0x9a, 0xb9}},
    {0xe1b0, {0xe7, 0x9a, 0xba}},
    {0xe1b1, {0xe7, 0x9b, 0x82}},
    {0xe1b2, {0xe7, 0x9b, 0x8d}},
    {0xe1b3, {0xe7, 0x9b, 0x96}},
    {0xe1b4, {0xe7, 0x9b, 0x92}},
    {0xe1b5, {0xe7, 0x9b, 0x9e}},
    {0xe1b6, {0xe7, 0x9b, 0xa1}},
    {0xe1b7, {0xe7, 0x9b, 0xa5}},
    {0xe1b8, {0xe7, 0x9b, 0xa7}},
    {0xe1b9, {0xe7, 0x9b, 0xaa}},
    {0xe1ba, {0xe8, 0x98, 0xaf}},
    {0xe1bb, {0xe7, 0x9b, 0xbb}},
    {0xe1bc, {0xe7, 0x9c, 0x88}},
    {0xe1bd, {0xe7, 0x9c, 0x87}},
    {0xe1be, {0xe7, 0x9c, 0x84}},
    {0xe1bf, {0xe7, 0x9c, 0xa9}},
    {0xe1c0, {0xe7, 0x9c, 0xa4}},
    {0xe1c1, {0xe7, 0x9c, 0x9e}},
    {0xe1c2, {0xe7, 0x9c, 0xa5}},
    {0xe1c3, {0xe7, 0x9c, 0xa6}},
    {0xe1c4, {0xe7, 0x9c, 0x9b}},
    {0xe1c5, {0xe7, 0x9c, 0xb7}},
    {0xe1c6, {0xe7, 0x9c, 0xb8}},
    {0xe1c7, {0xe7, 0x9d, 0x87}},
    {0xe1c8, {0xe7, 0x9d, 0x9a}},
    {0xe1c9, {0xe7, 0x9d, 0xa8}},
    {0xe1ca, {0xe7, 0x9d, 0xab}},
    {0xe1cb, {0xe7, 0x9d, 0x9b}},
    {0xe1cc, {0xe7, 0x9d, 0xa5}},
    {0xe1cd, {0xe7, 0x9d, 0xbf}},
    {0xe1ce, {0xe7, 0x9d, 0xbe}},
    {0xe1cf, {0xe7, 0x9d, 0xb9}},
    {0xe1d0, {0xe7, 0x9e, 0x8e}},
    {0xe1d1, {0xe7, 0x9e, 0x8b}},
    {0xe1d2, {0xe7, 0x9e, 0x91}},
    {0xe1d3, {0xe7, 0x9e, 0xa0}},
    {0xe1d4, {0xe7, 0x9e, 0x9e}},
    {0xe1d5, {0xe7, 0x9e, 0xb0}},
    {0xe1d6, {0xe7, 0x9e, 0xb6}},
    {0xe1d7, {0xe7, 0x9e, 0xb9}},
    {0xe1d8, {0xe7, 0x9e, 0xbf}},
    {0xe1d9, {0xe7, 0x9e, 0xbc}},
    {0xe1da, {0xe7, 0x9e, 0xbd}},
    {0xe1db, {0xe7, 0x9e, 0xbb}},
    {0xe1dc, {0xe7, 0x9f, 0x87}},
    {0xe1dd, {0xe7, 0x9f, 0x8d}},
    {0xe1de, {0xe7, 0x9f, 0x97}},
    {0xe1df, {0xe7, 0x9f, 0x9a}},
    {0xe1e0, {0xe7, 0x9f, 0x9c}},
    {0xe1e1, {0xe7, 0x9f, 0xa3}},
    {0xe1e2, {0xe7, 0x9f, 0xae}},
    {0xe1e3, {0xe7, 0x9f, 0xbc}},
    {0xe1e4, {0xe7, 0xa0, 0x8c}},
    {0xe1e5, {0xe7, 0xa0, 0x92}},
    {0xe1e6, {0xe7, 0xa4, 0xa6}},
    {0xe1e7, {0xe7, 0xa0, 0xa0}},
    {0xe1e8, {0xe7, 0xa4, 0xaa}},
    {0xe1e9, {0xe7, 0xa1, 0x85}},
    {0xe1ea, {0xe7, 0xa2, 0x8e}},
    {0xe1eb, {0xe7, 0xa1, 0xb4}},
    {0xe1ec, {0xe7, 0xa2, 0x86}},
    {0xe1ed, {0xe7, 0xa1, 0xbc}},
    {0xe1ee, {0xe7, 0xa2, 0x9a}},
    {0xe1ef, {0xe7, 0xa2, 0x8c}},
    {0xe1f0, {0xe7, 0xa2, 0xa3}},
    {0xe1f1, {0xe7, 0xa2, 0xb5}},
    {0xe1f2, {0xe7, 0xa2, 0xaa}},
    {0xe1f3, {0xe7, 0xa2, 0xaf}},
    {0xe1f4, {0xe7, 0xa3, 0x91}},
    {0xe1f5, {0xe7, 0xa3, 0x86}},
    {0xe1f6, {0xe7, 0xa3, 0x8b}},
    {0xe1f7, {0xe7, 0xa3, 0x94}},
    {0xe1f8, {0xe7, 0xa2, 0xbe}},
    {0xe1f9, {0xe7, 0xa2, 0xbc}},
    {0xe1fa, {0xe7, 0xa3, 0x85}},
    {0xe1fb, {0xe7, 0xa3, 0x8a}},
    {0xe1fc, {0xe7, 0xa3, 0xac}},
    {0xe240, {0xe7, 0xa3, 0xa7}},
    {0xe241, {0xe7, 0xa3, 0x9a}},
    {0xe242, {0xe7, 0xa3, 0xbd}},
    {0xe243, {0xe7, 0xa3, 0xb4}},
    {0xe244, {0xe7, 0xa4, 0x87}},
    {0xe245, {0xe7, 0xa4, 0x92}},
    {0xe246, {0xe7, 0xa4, 0x91}},
    {0xe247, {0xe7, 0xa4, 0x99}},
    {0xe248, {0xe7, 0xa4, 0xac}},
    {0xe249, {0xe7, 0xa4, 0xab}},
    {0xe24a, {0xe7, 0xa5, 0x80}},
    {0xe24b, {0xe7, 0xa5, 0xa0}},
    {0xe24c, {0xe7, 0xa5, 0x97}},
    {0xe24d, {0xe7, 0xa5, 0x9f}},
    {0xe24e, {0xe7, 0xa5, 0x9a}},
    {0xe24f, {0xe7, 0xa5, 0x95}},
    {0xe250, {0xe7, 0xa5, 0x93}},
    {0xe251, {0xe7, 0xa5, 0xba}},
    {0xe252, {0xe7, 0xa5, 0xbf}},
    {0xe253, {0xe7, 0xa6, 0x8a}},
    {0xe254, {0xe7, 0xa6, 0x9d}},
    {0xe255, {0xe7, 0xa6, 0xa7}},
    {0xe256, {0xe9, 0xbd, 0x8b}},
    {0xe257, {0xe7, 0xa6, 0xaa}},
    {0xe258, {0xe7, 0xa6, 0xae}},
    {0xe259, {0xe7, 0xa6, 0xb3}},
    {0xe25a, {0xe7, 0xa6, 0xb9}},
    {0xe25b, {0xe7, 0xa6, 0xba}},
    {0xe25c, {0xe7, 0xa7, 0x89}},
    {0xe25d, {0xe7, 0xa7, 0x95}},
    {0xe25e, {0xe7, 0xa7, 0xa7}},
    {0xe25f, {0xe7, 0xa7, 0xac}},
    {0xe260, {0xe7, 0xa7, 0xa1}},
    {0xe261, {0xe7, 0xa7, 0xa3}},
    {0xe262, {0xe7, 0xa8, 0x88}},
    {0xe263, {0xe7, 0xa8, 0x8d}},
    {0xe264, {0xe7, 0xa8, 0x98}},
    {0xe265, {0xe7, 0xa8, 0x99}},
    {0xe266, {0xe7, 0xa8, 0xa0}},
    {0xe267, {0xe7, 0xa8, 0x9f}},
    {0xe268, {0xe7, 0xa6, 0x80}},
    {0xe269, {0xe7, 0xa8, 0xb1}},
    {0xe26a, {0xe7, 0xa8, 0xbb}},
    {0xe26b, {0xe7, 0xa8, 0xbe}},
    {0xe26c, {0xe7, 0xa8, 0xb7}},
    {0xe26d, {0xe7, 0xa9, 0x83}},
    {0xe26e, {0xe7, 0xa9, 0x97}},
    {0xe26f, {0xe7, 0xa9, 0x89}},
    {0xe270, {0xe7, 0xa9, 0xa1}},
    {0xe271, {0xe7, 0xa9, 0xa2}},
    {0xe272, {0xe7, 0xa9, 0xa9}},
    {0xe273, {0xe9, 0xbe, 0x9d}},
    {0xe274, {0xe7, 0xa9, 0xb0}},
    {0xe275, {0xe7, 0xa9, 0xb9}},
    {0xe276, {0xe7, 0xa9, 0xbd}},
    {0xe277, {0xe7, 0xaa, 0x88}},
    {0xe278, {0xe7, 0xaa, 0x97}},
    {0xe279, {0xe7, 0xaa, 0x95}},
    {0xe27a, {0xe7, 0xaa, 0x98}},
    {0xe27b, {0xe7, 0xaa, 0x96}},
    {0xe27c, {0xe7, 0xaa, 0xa9}},
    {0xe27d, {0xe7, 0xab, 0x88}},
    {0xe27e, {0xe7, 0xaa, 0xb0}},
    {0xe280, {0xe7, 0xaa, 0xb6}},
    {0xe281, {0xe7, 0xab, 0x85}},
    {0xe282, {0xe7, 0xab, 0x84}},
    {0xe283, {0xe7, 0xaa, 0xbf}},
    {0xe284, {0xe9, 0x82, 0x83}},
    {0xe285, {0xe7, 0xab, 0x87}},
    {0xe286, {0xe7, 0xab, 0x8a}},
    {0xe287, {0xe7, 0xab, 0x8d}},
    {0xe288, {0xe7, 0xab, 0x8f}},
    {0xe289, {0xe7, 0xab, 0x95}},
    {0xe28a, {0xe7, 0xab, 0x93}},
    {0xe28b, {0xe7, 0xab, 0x99}},
    {0xe28c, {0xe7, 0xab, 0x9a}},
    {0xe28d, {0xe7, 0xab, 0x9d}},
    {0xe28e, {0xe7, 0xab, 0xa1}},
    {0xe28f, {0xe7, 0xab, 0xa2}},
    {0xe290, {0xe7, 0xab, 0xa6}},
    {0xe291, {0xe7, 0xab, 0xad}},
    {0xe292, {0xe7, 0xab, 0xb0}},
    {0xe293, {0xe7, 0xac, 0x82}},
    {0xe294, {0xe7, 0xac, 0x8f}},
    {0xe295, {0xe7, 0xac, 0x8a}},
    {0xe296, {0xe7, 0xac, 0x86}},
    {0xe297, {0xe7, 0xac, 0xb3}},
    {0xe298, {0xe7, 0xac, 0x98}},
    {0xe299, {0xe7, 0xac, 0x99}},
    {0xe29a, {0xe7, 0xac, 0x9e}},
    {0xe29b, {0xe7, 0xac, 0xb5}},
    {0xe29c, {0xe7, 0xac, 0xa8}},
    {0xe29d, {0xe7, 0xac, 0xb6}},
    {0xe29e, {0xe7, 0xad, 0x90}},
    {0xe29f, {0xe7, 0xad, 0xba}},
    {0xe2a0, {0xe7, 0xac, 0x84}},
    {0xe2a1, {0xe7, 0xad, 0x8d}},
    {0xe2a2, {0xe7, 0xac, 0x8b}},
    {0xe2a3, {0xe7, 0xad, 0x8c}},
    {0xe2a4, {0xe7, 0xad, 0x85}},
    {0xe2a5, {0xe7, 0xad, 0xb5}},
    {0xe2a6, {0xe7, 0xad, 0xa5}},
    {0xe2a7, {0xe7, 0xad, 0xb4}},
    {0xe2a8, {0xe7, 0xad, 0xa7}},
    {0xe2a9, {0xe7, 0xad, 0xb0}},
    {0xe2aa, {0xe7, 0xad, 0xb1}},
    {0xe2ab, {0xe7, 0xad, 0xac}},
    {0xe2ac, {0xe7, 0xad, 0xae}},
    {0xe2ad, {0xe7, 0xae, 0x9d}},
    {0xe2ae, {0xe7, 0xae, 0x98}},
    {0xe2af, {0xe7, 0xae, 0x9f}},
    {0xe2b0, {0xe7, 0xae, 0x8d}},
    {0xe2b1, {0xe7, 0xae, 0x9c}},
    {0xe2b2, {0xe7, 0xae, 0x9a}},
    {0xe2b3, {0xe7, 0xae, 0x8b}},
    {0xe2b4, {0xe7, 0xae, 0x92}},
    {0xe2b5, {0xe7, 0xae, 0x8f}},
    {0xe2b6, {0xe7, 0xad, 0x9d}},
    {0xe2b7, {0xe7, 0xae, 0x99}},
    {0xe2b8, {0xe7, 0xaf, 0x8b}},
    {0xe2b9, {0xe7, 0xaf, 0x81}},
    {0xe2ba, {0xe7, 0xaf, 0x8c}},
    {0xe2bb, {0xe7, 0xaf, 0x8f}},
    {0xe2bc, {0xe7, 0xae, 0xb4}},
    {0xe2bd, {0xe7, 0xaf, 0x86}},
    {0xe2be, {0xe7, 0xaf, 0x9d}},
    {0xe2bf, {0xe7, 0xaf, 0xa9}},
    {0xe2c0, {0xe7, 0xb0, 0x91}},
    {0xe2c1, {0xe7, 0xb0, 0x94}},
    {0xe2c2, {0xe7, 0xaf, 0xa6}},
    {0xe2c3, {0xe7, 0xaf, 0xa5}},
    {0xe2c4, {0xe7, 0xb1, 0xa0}},
    {0xe2c5, {0xe7, 0xb0, 0x80}},
    {0xe2c6, {0xe7, 0xb0, 0x87}},
    {0xe2c7, {0xe7, 0xb0, 0x93}},
    {0xe2c8, {0xe7, 0xaf, 0xb3}},
    {0xe2c9, {0xe7, 0xaf, 0xb7}},
    {0xe2ca, {0xe7, 0xb0, 0x97}},
    {0xe2cb, {0xe7, 0xb0, 0x8d}},
    {0xe2cc, {0xe7, 0xaf, 0xb6}},
    {0xe2cd, {0xe7, 0xb0, 0xa3}},
    {0xe2ce, {0xe7, 0xb0, 0xa7}},
    {0xe2cf, {0xe7, 0xb0, 0xaa}},
    {0xe2d0, {0xe7, 0xb0, 0x9f}},
    {0xe2d1, {0xe7, 0xb0, 0xb7}},
    {0xe2d2, {0xe7, 0xb0, 0xab}},
    {0xe2d3, {0xe7, 0xb0, 0xbd}},
    {0xe2d4, {0xe7, 0xb1, 0x8c}},
    {0xe2d5, {0xe7, 0xb1, 0x83}},
    {0xe2d6, {0xe7, 0xb1, 0x94}},
    {0xe2d7, {0xe7, 0xb1, 0x8f}},
    {0xe2d8, {0xe7, 0xb1, 0x80}},
    {0xe2d9, {0xe7, 0xb1, 0x90}},
    {0xe2da, {0xe7, 0xb1, 0x98}},
    {0xe2db, {0xe7, 0xb1, 0x9f}},
    {0xe2dc, {0xe7, 0xb1, 0xa4}},
    {0xe2dd, {0xe7, 0xb1, 0x96}},
    {0xe2de, {0xe7, 0xb1, 0xa5}},
    {0xe2df, {0xe7, 0xb1, 0xac}},
    {0xe2e0, {0xe7, 0xb1, 0xb5}},
    {0xe2e1, {0xe7, 0xb2, 0x83}},
    {0xe2e2, {0xe7, 0xb2, 0x90}},
    {0xe2e3, {0xe7, 0xb2, 0xa4}},
    {0xe2e4, {0xe7, 0xb2, 0xad}},
    {0xe2e5, {0xe7, 0xb2, 0xa2}},
    {0xe2e6, {0xe7, 0xb2, 0xab}},
    {0xe2e7, {0xe7, 0xb2, 0xa1}},
    {0xe2e8, {0xe7, 0xb2, 0xa8}},
    {0xe2e9, {0xe7, 0xb2, 0xb3}},
    {0xe2ea, {0xe7, 0xb2, 0xb2}},
    {0xe2eb, {0xe7, 0xb2, 0xb1}},
    {0xe2ec, {0xe7, 0xb2, 0xae}},
    {0xe2ed, {0xe7, 0xb2, 0xb9}},
    {0xe2ee, {0xe7, 0xb2, 0xbd}},
    {0xe2ef, {0xe7, 0xb3, 0x80}},
    {0xe2f0, {0xe7, 0xb3, 0x85}},
    {0xe2f1, {0xe7, 0xb3, 0x82}},
    {0xe2f2, {0xe7, 0xb3, 0x98}},
    {0xe2f3, {0xe7, 0xb3, 0x92}},
    {0xe2f4, {0xe7, 0xb3, 0x9c}},
    {0xe2f5, {0xe7, 0xb3, 0xa2}},
    {0xe2f6, {0xe9, 0xac, 0xbb}},
    {0xe2f7, {0xe7, 0xb3, 0xaf}},
    {0xe2f8, {0xe7, 0xb3, 0xb2}},
    {0xe2f9, {0xe7, 0xb3, 0xb4}},
    {0xe2fa, {0xe7, 0xb3, 0xb6}},
    {0xe2fb, {0xe7, 0xb3, 0xba}},
    {0xe2fc, {0xe7, 0xb4, 0x86}},
    {0xe340, {0xe7, 0xb4, 0x82}},
    {0xe341, {0xe7, 0xb4, 0x9c}},
    {0xe342, {0xe7, 0xb4, 0x95}},
    {0xe343, {0xe7, 0xb4, 0x8a}},
    {0xe344, {0xe7, 0xb5, 0x85}},
    {0xe345, {0xe7, 0xb5, 0x8b}},
    {0xe346, {0xe7, 0xb4, 0xae}},
    {0xe347, {0xe7, 0xb4, 0xb2}},
    {0xe348, {0xe7, 0xb4, 0xbf}},
    {0xe349, {0xe7, 0xb4, 0xb5}},
    {0xe34a, {0xe7, 0xb5, 0x86}},
    {0xe34b, {0xe7, 0xb5, 0xb3}},
    {0xe34c, {0xe7, 0xb5, 0x96}},
    {0xe34d, {0xe7, 0xb5, 0x8e}},
    {0xe34e, {0xe7, 0xb5, 0xb2}},
    {0xe34f, {0xe7, 0xb5, 0xa8}},
    {0xe350, {0xe7, 0xb5, 0xae}},
    {0xe351, {0xe7, 0xb5, 0x8f}},
    {0xe352, {0xe7, 0xb5, 0xa3}},
    {0xe353, {0xe7, 0xb6, 0x93}},
    {0xe354, {0xe7, 0xb6, 0x89}},
    {0xe355, {0xe7, 0xb5, 0x9b}},
    {0xe356, {0xe7, 0xb6, 0x8f}},
    {0xe357, {0xe7, 0xb5, 0xbd}},
    {0xe358, {0xe7, 0xb6, 0x9b}},
    {0xe359, {0xe7, 0xb6, 0xba}},
    {0xe35a, {0xe7, 0xb6, 0xae}},
    {0xe35b, {0xe7, 0xb6, 0xa3}},
    {0xe35c, {0xe7, 0xb6, 0xb5}},
    {0xe35d, {0xe7, 0xb7, 0x87}},
    {0xe35e, {0xe7, 0xb6, 0xbd}},
    {0xe35f, {0xe7, 0xb6, 0xab}},
    {0xe360, {0xe7, 0xb8, 0xbd}},
    {0xe361, {0xe7, 0xb6, 0xa2}},
    {0xe362, {0xe7, 0xb6, 0xaf}},
    {0xe363, {0xe7, 0xb7, 0x9c}},
    {0xe364, {0xe7, 0xb6, 0xb8}},
    {0xe365, {0xe7, 0xb6, 0x9f}},
    {0xe366, {0xe7, 0xb6, 0xb0}},
    {0xe367, {0xe7, 0xb7, 0x98}},
    {0xe368, {0xe7, 0xb7, 0x9d}},
    {0xe369, {0xe7, 0xb7, 0xa4}},
    {0xe36a, {0xe7, 0xb7, 0x9e}},
    {0xe36b, {0xe7, 0xb7, 0xbb}},
    {0xe36c, {0xe7, 0xb7, 0xb2}},
    {0xe36d, {0xe7, 0xb7, 0xa1}},
    {0xe36e, {0xe7, 0xb8, 0x85}},
    {0xe36f, {0xe7, 0xb8, 0x8a}},
    {0xe370, {0xe7, 0xb8, 0xa3}},
    {0xe371, {0xe7, 0xb8, 0xa1}},
    {0xe372, {0xe7, 0xb8, 0x92}},
    {0xe373, {0xe7, 0xb8, 0xb1}},
    {0xe374, {0xe7, 0xb8, 0x9f}},
    {0xe375, {0xe7, 0xb8, 0x89}},
    {0xe376, {0xe7, 0xb8, 0x8b}},
    {0xe377, {0xe7, 0xb8, 0xa2}},
    {0xe378, {0xe7, 0xb9, 0x86}},
    {0xe379, {0xe7, 0xb9, 0xa6}},
    {0xe37a, {0xe7, 0xb8, 0xbb}},
    {0xe37b, {0xe7, 0xb8, 0xb5}},
    {0xe37c, {0xe7, 0xb8, 0xb9}},
    {0xe37d, {0xe7, 0xb9, 0x83}},
    {0xe37e, {0xe7, 0xb8, 0xb7}},
    {0xe380, {0xe7, 0xb8, 0xb2}},
    {0xe381, {0xe7, 0xb8, 0xba}},
    {0xe382, {0xe7, 0xb9, 0xa7}},
    {0xe383, {0xe7, 0xb9, 0x9d}},
    {0xe384, {0xe7, 0xb9, 0x96}},
    {0xe385, {0xe7, 0xb9, 0x9e}},
    {0xe386, {0xe7, 0xb9, 0x99}},
    {0xe387, {0xe7, 0xb9, 0x9a}},
    {0xe388, {0xe7, 0xb9, 0xb9}},
    {0xe389, {0xe7, 0xb9, 0xaa}},
    {0xe38a, {0xe7, 0xb9, 0xa9}},
    {0xe38b, {0xe7, 0xb9, 0xbc}},
    {0xe38c, {0xe7, 0xb9, 0xbb}},
    {0xe38d, {0xe7, 0xba, 0x83}},
    {0xe38e, {0xe7, 0xb7, 0x95}},
    {0xe38f, {0xe7, 0xb9, 0xbd}},
    {0xe390, {0xe8, 0xbe, 0xae}},
    {0xe391, {0xe7, 0xb9, 0xbf}},
    {0xe392, {0xe7, 0xba, 0x88}},
    {0xe393, {0xe7, 0xba, 0x89}},
    {0xe394, {0xe7, 0xba, 0x8c}},
    {0xe395, {0xe7, 0xba, 0x92}},
    {0xe396, {0xe7, 0xba, 0x90}},
    {0xe397, {0xe7, 0xba, 0x93}},
    {0xe398, {0xe7, 0xba, 0x94}},
    {0xe399, {0xe7, 0xba, 0x96}},
    {0xe39a, {0xe7, 0xba, 0x8e}},
    {0xe39b, {0xe7, 0xba, 0x9b}},
    {0xe39c, {0xe7, 0xba, 0x9c}},
    {0xe39d, {0xe7, 0xbc, 0xb8}},
    {0xe39e, {0xe7, 0xbc, 0xba}},
    {0xe39f, {0xe7, 0xbd, 0x85}},
    {0xe3a0, {0xe7, 0xbd, 0x8c}},
    {0xe3a1, {0xe7, 0xbd, 0x8d}},
    {0xe3a2, {0xe7, 0xbd, 0x8e}},
    {0xe3a3, {0xe7, 0xbd, 0x90}},
    {0xe3a4, {0xe7, 0xbd, 0x91}},
    {0xe3a5, {0xe7, 0xbd, 0x95}},
    {0xe3a6, {0xe7, 0xbd, 0x94}},
    {0xe3a7, {0xe7, 0xbd, 0x98}},
    {0xe3a8, {0xe7, 0xbd, 0x9f}},
    {0xe3a9, {0xe7, 0xbd, 0xa0}},
    {0xe3aa, {0xe7, 0xbd, 0xa8}},
    {0xe3ab, {0xe7, 0xbd, 0xa9}},
    {0xe3ac, {0xe7, 0xbd, 0xa7}},
    {0xe3ad, {0xe7, 0xbd, 0xb8}},
    {0xe3ae, {0xe7, 0xbe, 0x82}},
    {0xe3af, {0xe7, 0xbe, 0x86}},
    {0xe3b0, {0xe7, 0xbe, 0x83}},
    {0xe3b1, {0xe7, 0xbe, 0x88}},
    {0xe3b2, {0xe7, 0xbe, 0x87}},
    {0xe3b3, {0xe7, 0xbe, 0x8c}},
    {0xe3b4, {0xe7, 0xbe, 0x94}},
    {0xe3b5, {0xe7, 0xbe, 0x9e}},
    {0xe3b6, {0xe7, 0xbe, 0x9d}},
    {0xe3b7, {0xe7, 0xbe, 0x9a}},
    {0xe3b8, {0xe7, 0xbe, 0xa3}},
    {0xe3b9, {0xe7, 0xbe, 0xaf}},
    {0xe3ba, {0xe7, 0xbe, 0xb2}},
    {0xe3bb, {0xe7, 0xbe, 0xb9}},
    {0xe3bc, {0xe7, 0xbe, 0xae}},
    {0xe3bd, {0xe7, 0xbe, 0xb6}},
    {0xe3be, {0xe7, 0xbe, 0xb8}},
    {0xe3bf, {0xe8, 0xad, 0xb1}},
    {0xe3c0, {0xe7, 0xbf, 0x85}},
    {0xe3c1, {0xe7, 0xbf, 0x86}},
    {0xe3c2, {0xe7, 0xbf, 0x8a}},
    {0xe3c3, {0xe7, 0xbf, 0x95}},
    {0xe3c4, {0xe7, 0xbf, 0x94}},
    {0xe3c5, {0xe7, 0xbf, 0xa1}},
    {0xe3c6, {0xe7, 0xbf, 0xa6}},
    {0xe3c7, {0xe7, 0xbf, 0xa9}},
    {0xe3c8, {0xe7, 0xbf, 0xb3}},
    {0xe3c9, {0xe7, 0xbf, 0xb9}},
    {0xe3ca, {0xe9, 0xa3, 0x9c}},
    {0xe3cb, {0xe8, 0x80, 0x86}},
    {0xe3cc, {0xe8, 0x80, 0x84}},
    {0xe3cd, {0xe8, 0x80, 0x8b}},
    {0xe3ce, {0xe8, 0x80, 0x92}},
    {0xe3cf, {0xe8, 0x80, 0x98}},
    {0xe3d0, {0xe8, 0x80, 0x99}},
    {0xe3d1, {0xe8, 0x80, 0x9c}},
    {0xe3d2, {0xe8, 0x80, 0xa1}},
    {0xe3d3, {0xe8, 0x80, 0xa8}},
    {0xe3d4, {0xe8, 0x80, 0xbf}},
    {0xe3d5, {0xe8, 0x80, 0xbb}},
    {0xe3d6, {0xe8, 0x81, 0x8a}},
    {0xe3d7, {0xe8, 0x81, 0x86}},
    {0xe3d8, {0xe8, 0x81, 0x92}},
    {0xe3d9, {0xe8, 0x81, 0x98}},
    {0xe3da, {0xe8, 0x81, 0x9a}},
    {0xe3db, {0xe8, 0x81, 0x9f}},
    {0xe3dc, {0xe8, 0x81, 0xa2}},
    {0xe3dd, {0xe8, 0x81, 0xa8}},
    {0xe3de, {0xe8, 0x81, 0xb3}},
    {0xe3df, {0xe8, 0x81, 0xb2}},
    {0xe3e0, {0xe8, 0x81, 0xb0}},
    {0xe3e1, {0xe8, 0x81, 0xb6}},
    {0xe3e2, {0xe8, 0x81, 0xb9}},
    {0xe3e3, {0xe8, 0x81, 0xbd}},
    {0xe3e4, {0xe8, 0x81, 0xbf}},
    {0xe3e5, {0xe8, 0x82, 0x84}},
    {0xe3e6, {0xe8, 0x82, 0x86}},
    {0xe3e7, {0xe8, 0x82, 0x85}},
    {0xe3e8, {0xe8, 0x82, 0x9b}},
    {0xe3e9, {0xe8, 0x82, 0x93}},
    {0xe3ea, {0xe8, 0x82, 0x9a}},
    {0xe3eb, {0xe8, 0x82, 0xad}},
    {0xe3ec, {0xe5, 0x86, 0x90}},
    {0xe3ed, {0xe8, 0x82, 0xac}},
    {0xe3ee, {0xe8, 0x83, 0x9b}},
    {0xe3ef, {0xe8, 0x83, 0xa5}},
    {0xe3f0, {0xe8, 0x83, 0x99}},
    {0xe3f1, {0xe8, 0x83, 0x9d}},
    {0xe3f2, {0xe8, 0x83, 0x84}},
    {0xe3f3, {0xe8, 0x83, 0x9a}},
    {0xe3f4, {0xe8, 0x83, 0x96}},
    {0xe3f5, {0xe8, 0x84, 0x89}},
    {0xe3f6, {0xe8, 0x83, 0xaf}},
    {0xe3f7, {0xe8, 0x83, 0xb1}},
    {0xe3f8, {0xe8, 0x84, 0x9b}},
    {0xe3f9, {0xe8, 0x84, 0xa9}},
    {0xe3fa, {0xe8, 0x84, 0xa3}},
    {0xe3fb, {0xe8, 0x84, 0xaf}},
    {0xe3fc, {0xe8, 0x85, 0x8b}},
    {0xe440, {0xe9, 0x9a, 0x8b}},
    {0xe441, {0xe8, 0x85, 0x86}},
    {0xe442, {0xe8, 0x84, 0xbe}},
    {0xe443, {0xe8, 0x85, 0x93}},
    {0xe444, {0xe8, 0x85, 0x91}},
    {0xe445, {0xe8, 0x83, 0xbc}},
    {0xe446, {0xe8, 0x85, 0xb1}},
    {0xe447, {0xe8, 0x85, 0xae}},
    {0xe448, {0xe8, 0x85, 0xa5}},
    {0xe449, {0xe8, 0x85, 0xa6}},
    {0xe44a, {0xe8, 0x85, 0xb4}},
    {0xe44b, {0xe8, 0x86, 0x83}},
    {0xe44c, {0xe8, 0x86, 0x88}},
    {0xe44d, {0xe8, 0x86, 0x8a}},
    {0xe44e, {0xe8, 0x86, 0x80}},
    {0xe44f, {0xe8, 0x86, 0x82}},
    {0xe450, {0xe8, 0x86, 0xa0}},
    {0xe451, {0xe8, 0x86, 0x95}},
    {0xe452, {0xe8, 0x86, 0xa4}},
    {0xe453, {0xe8, 0x86, 0xa3}},
    {0xe454, {0xe8, 0x85, 0x9f}},
    {0xe455, {0xe8, 0x86, 0x93}},
    {0xe456, {0xe8, 0x86, 0xa9}},
    {0xe457, {0xe8, 0x86, 0xb0}},
    {0xe458, {0xe8, 0x86, 0xb5}},
    {0xe459, {0xe8, 0x86, 0xbe}},
    {0xe45a, {0xe8, 0x86, 0xb8}},
    {0xe45b, {0xe8, 0x86, 0xbd}},
    {0xe45c, {0xe8, 0x87, 0x80}},
    {0xe45d, {0xe8, 0x87, 0x82}},
    {0xe45e, {0xe8, 0x86, 0xba}},
    {0xe45f, {0xe8, 0x87, 0x89}},
    {0xe460, {0xe8, 0x87, 0x8d}},
    {0xe461, {0xe8, 0x87, 0x91}},
    {0xe462, {0xe8, 0x87, 0x99}},
    {0xe463, {0xe8, 0x87, 0x98}},
    {0xe464, {0xe8, 0x87, 0x88}},
    {0xe465, {0xe8, 0x87, 0x9a}},
    {0xe466, {0xe8, 0x87, 0x9f}},
    {0xe467, {0xe8, 0x87, 0xa0}},
    {0xe468, {0xe8, 0x87, 0xa7}},
    {0xe469, {0xe8, 0x87, 0xba}},
    {0xe46a, {0xe8, 0x87, 0xbb}},
    {0xe46b, {0xe8, 0x87, 0xbe}},
    {0xe46c, {0xe8, 0x88, 0x81}},
    {0xe46d, {0xe8, 0x88, 0x82}},
    {0xe46e, {0xe8, 0x88, 0x85}},
    {0xe46f, {0xe8, 0x88, 0x87}},
    {0xe470, {0xe8, 0x88, 0x8a}},
    {0xe471, {0xe8, 0x88, 0x8d}},
    {0xe472, {0xe8, 0x88, 0x90}},
    {0xe473, {0xe8, 0x88, 0x96}},
    {0xe474, {0xe8, 0x88, 0xa9}},
    {0xe475, {0xe8, 0x88, 0xab}},
    {0xe476, {0xe8, 0x88, 0xb8}},
    {0xe477, {0xe8, 0x88, 0xb3}},
    {0xe478, {0xe8, 0x89, 0x80}},
    {0xe479, {0xe8, 0x89, 0x99}},
    {0xe47a, {0xe8, 0x89, 0x98}},
    {0xe47b, {0xe8, 0x89, 0x9d}},
    {0xe47c, {0xe8, 0x89, 0x9a}},
    {0xe47d, {0xe8, 0x89, 0x9f}},
    {0xe47e, {0xe8, 0x89, 0xa4}},
    {0xe480, {0xe8, 0x89, 0xa2}},
    {0xe481, {0xe8, 0x89, 0xa8}},
    {0xe482, {0xe8, 0x89, 0xaa}},
    {0xe483, {0xe8, 0x89, 0xab}},
    {0xe484, {0xe8, 0x88, 0xae}},
    {0xe485, {0xe8, 0x89, 0xb1}},
    {0xe486, {0xe8, 0x89, 0xb7}},
    {0xe487, {0xe8, 0x89, 0xb8}},
    {0xe488, {0xe8, 0x89, 0xbe}},
    {0xe489, {0xe8, 0x8a, 0x8d}},
    {0xe48a, {0xe8, 0x8a, 0x92}},
    {0xe48b, {0xe8, 0x8a, 0xab}},
    {0xe48c, {0xe8, 0x8a, 0x9f}},
    {0xe48d, {0xe8, 0x8a, 0xbb}},
    {0xe48e, {0xe8, 0x8a, 0xac}},
    {0xe48f, {0xe8, 0x8b, 0xa1}},
    {0xe490, {0xe8, 0x8b, 0xa3}},
    {0xe491, {0xe8, 0x8b, 0x9f}},
    {0xe492, {0xe8, 0x8b, 0x92}},
    {0xe493, {0xe8, 0x8b, 0xb4}},
    {0xe494, {0xe8, 0x8b, 0xb3}},
    {0xe495, {0xe8, 0x8b, 0xba}},
    {0xe496, {0xe8, 0x8e, 0x93}},
    {0xe497, {0xe8, 0x8c, 0x83}},
    {0xe498, {0xe8, 0x8b, 0xbb}},
    {0xe499, {0xe8, 0x8b, 0xb9}},
    {0xe49a, {0xe8, 0x8b, 0x9e}},
    {0xe49b, {0xe8, 0x8c, 0x86}},
    {0xe49c, {0xe8, 0x8b, 0x9c}},
    {0xe49d, {0xe8, 0x8c, 0x89}},
    {0xe49e, {0xe8, 0x8b, 0x99}},
    {0xe49f, {0xe8, 0x8c, 0xb5}},
    {0xe4a0, {0xe8, 0x8c, 0xb4}},
    {0xe4a1, {0xe8, 0x8c, 0x96}},
    {0xe4a2, {0xe8, 0x8c, 0xb2}},
    {0xe4a3, {0xe8, 0x8c, 0xb1}},
    {0xe4a4, {0xe8, 0x8d, 0x80}},
    {0xe4a5, {0xe8, 0x8c, 0xb9}},
    {0xe4a6, {0xe8, 0x8d, 0x90}},
    {0xe4a7, {0xe8, 0x8d, 0x85}},
    {0xe4a8, {0xe8, 0x8c, 0xaf}},
    {0xe4a9, {0xe8, 0x8c, 0xab}},
    {0xe4aa, {0xe8, 0x8c, 0x97}},
    {0xe4ab, {0xe8, 0x8c, 0x98}},
    {0xe4ac, {0xe8, 0x8e, 0x85}},
    {0xe4ad, {0xe8, 0x8e, 0x9a}},
    {0xe4ae, {0xe8, 0x8e, 0xaa}},
    {0xe4af, {0xe8, 0x8e, 0x9f}},
    {0xe4b0, {0xe8, 0x8e, 0xa2}},
    {0xe4b1, {0xe8, 0x8e, 0x96}},
    {0xe4b2, {0xe8, 0x8c, 0xa3}},
    {0xe4b3, {0xe8, 0x8e, 0x8e}},
    {0xe4b4, {0xe8, 0x8e, 0x87}},
    {0xe4b5, {0xe8, 0x8e, 0x8a}},
    {0xe4b6, {0xe8, 0x8d, 0xbc}},
    {0xe4b7, {0xe8, 0x8e, 0xb5}},
    {0xe4b8, {0xe8, 0x8d, 0xb3}},
    {0xe4b9, {0xe8, 0x8d, 0xb5}},
    {0xe4ba, {0xe8, 0x8e, 0xa0}},
    {0xe4bb, {0xe8, 0x8e, 0x89}},
    {0xe4bc, {0xe8, 0x8e, 0xa8}},
    {0xe4bd, {0xe8, 0x8f, 0xb4}},
    {0xe4be, {0xe8, 0x90, 0x93}},
    {0xe4bf, {0xe8, 0x8f, 0xab}},
    {0xe4c0, {0xe8, 0x8f, 0x8e}},
    {0xe4c1, {0xe8, 0x8f, 0xbd}},
    {0xe4c2, {0xe8, 0x90, 0x83}},
    {0xe4c3, {0xe8, 0x8f, 0x98}},
    {0xe4c4, {0xe8, 0x90, 0x8b}},
    {0xe4c5, {0xe8, 0x8f, 0x81}},
    {0xe4c6, {0xe8, 0x8f, 0xb7}},
    {0xe4c7, {0xe8, 0x90, 0x87}},
    {0xe4c8, {0xe8, 0x8f, 0xa0}},
    {0xe4c9, {0xe8, 0x8f, 0xb2}},
    {0xe4ca, {0xe8, 0x90, 0x8d}},
    {0xe4cb, {0xe8, 0x90, 0xa2}},
    {0xe4cc, {0xe8, 0x90, 0xa0}},
    {0xe4cd, {0xe8, 0x8e, 0xbd}},
    {0xe4ce, {0xe8, 0x90, 0xb8}},
    {0xe4cf, {0xe8, 0x94, 0x86}},
    {0xe4d0, {0xe8, 0x8f, 0xbb}},
    {0xe4d1, {0xe8, 0x91, 0xad}},
    {0xe4d2, {0xe8, 0x90, 0xaa}},
    {0xe4d3, {0xe8, 0x90, 0xbc}},
    {0xe4d4, {0xe8, 0x95, 0x9a}},
    {0xe4d5, {0xe8, 0x92, 0x84}},
    {0xe4d6, {0xe8, 0x91, 0xb7}},
    {0xe4d7, {0xe8, 0x91, 0xab}},
    {0xe4d8, {0xe8, 0x92, 0xad}},
    {0xe4d9, {0xe8, 0x91, 0xae}},
    {0xe4da, {0xe8, 0x92, 0x82}},
    {0xe4db, {0xe8, 0x91, 0xa9}},
    {0xe4dc, {0xe8, 0x91, 0x86}},
    {0xe4dd, {0xe8, 0x90, 0xac}},
    {0xe4de, {0xe8, 0x91, 0xaf}},
    {0xe4df, {0xe8, 0x91, 0xb9}},
    {0xe4e0, {0xe8, 0x90, 0xb5}},
    {0xe4e1, {0xe8, 0x93, 0x8a}},
    {0xe4e2, {0xe8, 0x91, 0xa2}},
    {0xe4e3, {0xe8, 0x92, 0xb9}},
    {0xe4e4, {0xe8, 0x92, 0xbf}},
    {0xe4e5, {0xe8, 0x92, 0x9f}},
    {0xe4e6, {0xe8, 0x93, 0x99}},
    {0xe4e7, {0xe8, 0x93, 0x8d}},
    {0xe4e8, {0xe8, 0x92, 0xbb}},
    {0xe4e9, {0xe8, 0x93, 0x9a}},
    {0xe4ea, {0xe8, 0x93, 0x90}},
    {0xe4eb, {0xe8, 0x93, 0x81}},
    {0xe4ec, {0xe8, 0x93, 0x86}},
    {0xe4ed, {0xe8, 0x93, 0x96}},
    {0xe4ee, {0xe8, 0x92, 0xa1}},
    {0xe4ef, {0xe8, 0x94, 0xa1}},
    {0xe4f0, {0xe8, 0x93, 0xbf}},
    {0xe4f1, {0xe8, 0x93, 0xb4}},
    {0xe4f2, {0xe8, 0x94, 0x97}},
    {0xe4f3, {0xe8, 0x94, 0x98}},
    {0xe4f4, {0xe8, 0x94, 0xac}},
    {0xe4f5, {0xe8, 0x94, 0x9f}},
    {0xe4f6, {0xe8, 0x94, 0x95}},
    {0xe4f7, {0xe8, 0x94, 0x94}},
    {0xe4f8, {0xe8, 0x93, 0xbc}},
    {0xe4f9, {0xe8, 0x95, 0x80}},
    {0xe4fa, {0xe8, 0x95, 0xa3}},
    {0xe4fb, {0xe8, 0x95, 0x98}},
    {0xe4fc, {0xe8, 0x95, 0x88}},
    {0xe540, {0xe8, 0x95, 0x81}},
    {0xe541, {0xe8, 0x98, 0x82}},
    {0xe542, {0xe8, 0x95, 0x8b}},
    {0xe543, {0xe8, 0x95, 0x95}},
    {0xe544, {0xe8, 0x96, 0x80}},
    {0xe545, {0xe8, 0x96, 0xa4}},
    {0xe546, {0xe8, 0x96, 0x88}},
    {0xe547, {0xe8, 0x96, 0x91}},
    {0xe548, {0xe8, 0x96, 0x8a}},
    {0xe549, {0xe8, 0x96, 0xa8}},
    {0xe54a, {0xe8, 0x95, 0xad}},
    {0xe54b, {0xe8, 0x96, 0x94}},
    {0xe54c, {0xe8, 0x96, 0x9b}},
    {0xe54d, {0xe8, 0x97, 0xaa}},
    {0xe54e, {0xe8, 0x96, 0x87}},
    {0xe54f, {0xe8, 0x96, 0x9c}},
    {0xe550, {0xe8, 0x95, 0xb7}},
    {0xe551, {0xe8, 0x95, 0xbe}},
    {0xe552, {0xe8, 0x96, 0x90}},
    {0xe553, {0xe8, 0x97, 0x89}},
    {0xe554, {0xe8, 0x96, 0xba}},
    {0xe555, {0xe8, 0x97, 0x8f}},
    {0xe556, {0xe8, 0x96, 0xb9}},
    {0xe557, {0xe8, 0x97, 0x90}},
    {0xe558, {0xe8, 0x97, 0x95}},
    {0xe559, {0xe8, 0x97, 0x9d}},
    {0xe55a, {0xe8, 0x97, 0xa5}},
    {0xe55b, {0xe8, 0x97, 0x9c}},
    {0xe55c, {0xe8, 0x97, 0xb9}},
    {0xe55d, {0xe8, 0x98, 0x8a}},
    {0xe55e, {0xe8, 0x98, 0x93}},
    {0xe55f, {0xe8, 0x98, 0x8b}},
    {0xe560, {0xe8, 0x97, 0xbe}},
    {0xe561, {0xe8, 0x97, 0xba}},
    {0xe562, {0xe8, 0x98, 0x86}},
    {0xe563, {0xe8, 0x98, 0xa2}},
    {0xe564, {0xe8, 0x98, 0x9a}},
    {0xe565, {0xe8, 0x98, 0xb0}},
    {0xe566, {0xe8, 0x98, 0xbf}},
    {0xe567, {0xe8, 0x99, 0x8d}},
    {0xe568, {0xe4, 0xb9, 0x95}},
    {0xe569, {0xe8, 0x99, 0x94}},
    {0xe56a, {0xe8, 0x99, 0x9f}},
    {0xe56b, {0xe8, 0x99, 0xa7}},
    {0xe56c, {0xe8, 0x99, 0xb1}},
    {0xe56d, {0xe8, 0x9a, 0x93}},
    {0xe56e, {0xe8, 0x9a, 0xa3}},
    {0xe56f, {0xe8, 0x9a, 0xa9}},
    {0xe570, {0xe8, 0x9a, 0xaa}},
    {0xe571, {0xe8, 0x9a, 0x8b}},
    {0xe572, {0xe8, 0x9a, 0x8c}},
    {0xe573, {0xe8, 0x9a, 0xb6}},
    {0xe574, {0xe8, 0x9a, 0xaf}},
    {0xe575, {0xe8, 0x9b, 0x84}},
    {0xe576, {0xe8, 0x9b, 0x86}},
    {0xe577, {0xe8, 0x9a, 0xb0}},
    {0xe578, {0xe8, 0x9b, 0x89}},
    {0xe579, {0xe8, 0xa0, 0xa3}},
    {0xe57a, {0xe8, 0x9a, 0xab}},
    {0xe57b, {0xe8, 0x9b, 0x94}},
    {0xe57c, {0xe8, 0x9b, 0x9e}},
    {0xe57d, {0xe8, 0x9b, 0xa9}},
    {0xe57e, {0xe8, 0x9b, 0xac}},
    {0xe580, {0xe8, 0x9b, 0x9f}},
    {0xe581, {0xe8, 0x9b, 0x9b}},
    {0xe582, {0xe8, 0x9b, 0xaf}},
    {0xe583, {0xe8, 0x9c, 0x92}},
    {0xe584, {0xe8, 0x9c, 0x86}},
    {0xe585, {0xe8, 0x9c, 0x88}},
    {0xe586, {0xe8, 0x9c, 0x80}},
    {0xe587, {0xe8, 0x9c, 0x83}},
    {0xe588, {0xe8, 0x9b, 0xbb}},
    {0xe589, {0xe8, 0x9c, 0x91}},
    {0xe58a, {0xe8, 0x9c, 0x89}},
    {0xe58b, {0xe8, 0x9c, 0x8d}},
    {0xe58c, {0xe8, 0x9b, 0xb9}},
    {0xe58d, {0xe8, 0x9c, 0x8a}},
    {0xe58e, {0xe8, 0x9c, 0xb4}},
    {0xe58f, {0xe8, 0x9c, 0xbf}},
    {0xe590, {0xe8, 0x9c, 0xb7}},
    {0xe591, {0xe8, 0x9c, 0xbb}},
    {0xe592, {0xe8, 0x9c, 0xa5}},
    {0xe593, {0xe8, 0x9c, 0xa9}},
    {0xe594, {0xe8, 0x9c, 0x9a}},
    {0xe595, {0xe8, 0x9d, 0xa0}},
    {0xe596, {0xe8, 0x9d, 0x9f}},
    {0xe597, {0xe8, 0x9d, 0xb8}},
    {0xe598, {0xe8, 0x9d, 0x8c}},
    {0xe599, {0xe8, 0x9d, 0x8e}},
    {0xe59a, {0xe8, 0x9d, 0xb4}},
    {0xe59b, {0xe8, 0x9d, 0x97}},
    {0xe59c, {0xe8, 0x9d, 0xa8}},
    {0xe59d, {0xe8, 0x9d, 0xae}},
    {0xe59e, {0xe8, 0x9d, 0x99}},
    {0xe59f, {0xe8, 0x9d, 0x93}},
    {0xe5a0, {0xe8, 0x9d, 0xa3}},
    {0xe5a1, {0xe8, 0x9d, 0xaa}},
    {0xe5a2, {0xe8, 0xa0, 0x85}},
    {0xe5a3, {0xe8, 0x9e, 0xa2}},
    {0xe5a4, {0xe8, 0x9e, 0x9f}},
    {0xe5a5, {0xe8, 0x9e, 0x82}},
    {0xe5a6, {0xe8, 0x9e, 0xaf}},
    {0xe5a7, {0xe8, 0x9f, 0x8b}},
    {0xe5a8, {0xe8, 0x9e, 0xbd}},
    {0xe5a9, {0xe8, 0x9f, 0x80}},
    {0xe5aa, {0xe8, 0x9f, 0x90}},
    {0xe5ab, {0xe9, 0x9b, 0x96}},
    {0xe5ac, {0xe8, 0x9e, 0xab}},
    {0xe5ad, {0xe8, 0x9f, 0x84}},
    {0xe5ae, {0xe8, 0x9e, 0xb3}},
    {0xe5af, {0xe8, 0x9f, 0x87}},
    {0xe5b0, {0xe8, 0x9f, 0x86}},
    {0xe5b1, {0xe8, 0x9e, 0xbb}},
    {0xe5b2, {0xe8, 0x9f, 0xaf}},
    {0xe5b3, {0xe8, 0x9f, 0xb2}},
    {0xe5b4, {0xe8, 0x9f, 0xa0}},
    {0xe5b5, {0xe8, 0xa0, 0x8f}},
    {0xe5b6, {0xe8, 0xa0, 0x8d}},
    {0xe5b7, {0xe8, 0x9f, 0xbe}},
    {0xe5b8, {0xe8, 0x9f, 0xb6}},
    {0xe5b9, {0xe8, 0x9f, 0xb7}},
    {0xe5ba, {0xe8, 0xa0, 0x8e}},
    {0xe5bb, {0xe8, 0x9f, 0x92}},
    {0xe5bc, {0xe8, 0xa0, 0x91}},
    {0xe5bd, {0xe8, 0xa0, 0x96}},
    {0xe5be, {0xe8, 0xa0, 0x95}},
    {0xe5bf, {0xe8, 0xa0, 0xa2}},
    {0xe5c0, {0xe8, 0xa0, 0xa1}},
    {0xe5c1, {0xe8, 0xa0, 0xb1}},
    {0xe5c2, {0xe8, 0xa0, 0xb6}},
    {0xe5c3, {0xe8, 0xa0, 0xb9}},
    {0xe5c4, {0xe8, 0xa0, 0xa7}},
    {0xe5c5, {0xe8, 0xa0, 0xbb}},
    {0xe5c6, {0xe8, 0xa1, 0x84}},
    {0xe5c7, {0xe8, 0xa1, 0x82}},
    {0xe5c8, {0xe8, 0xa1, 0x92}},
    {0xe5c9, {0xe8, 0xa1, 0x99}},
    {0xe5ca, {0xe8, 0xa1, 0x9e}},
    {0xe5cb, {0xe8, 0xa1, 0xa2}},
    {0xe5cc, {0xe8, 0xa1, 0xab}},
    {0xe5cd, {0xe8, 0xa2, 0x81}},
    {0xe5ce, {0xe8, 0xa1, 0xbe}},
    {0xe5cf, {0xe8, 0xa2, 0x9e}},
    {0xe5d0, {0xe8, 0xa1, 0xb5}},
    {0xe5d1, {0xe8, 0xa1, 0xbd}},
    {0xe5d2, {0xe8, 0xa2, 0xb5}},
    {0xe5d3, {0xe8, 0xa1, 0xb2}},
    {0xe5d4, {0xe8, 0xa2, 0x82}},
    {0xe5d5, {0xe8, 0xa2, 0x97}},
    {0xe5d6, {0xe8, 0xa2, 0x92}},
    {0xe5d7, {0xe8, 0xa2, 0xae}},
    {0xe5d8, {0xe8, 0xa2, 0x99}},
    {0xe5d9, {0xe8, 0xa2, 0xa2}},
    {0xe5da, {0xe8, 0xa2, 0x8d}},
    {0xe5db, {0xe8, 0xa2, 0xa4}},
    {0xe5dc, {0xe8, 0xa2, 0xb0}},
    {0xe5dd, {0xe8, 0xa2, 0xbf}},
    {0xe5de, {0xe8, 0xa2, 0xb1}},
    {0xe5df, {0xe8, 0xa3, 0x83}},
    {0xe5e0, {0xe8, 0xa3, 0x84}},
    {0xe5e1, {0xe8, 0xa3, 0x94}},
    {0xe5e2, {0xe8, 0xa3, 0x98}},
    {0xe5e3, {0xe8, 0xa3, 0x99}},
    {0xe5e4, {0xe8, 0xa3, 0x9d}},
    {0xe5e5, {0xe8, 0xa3, 0xb9}},
    {0xe5e6, {0xe8, 0xa4, 0x82}},
    {0xe5e7, {0xe8, 0xa3, 0xbc}},
    {0xe5e8, {0xe8, 0xa3, 0xb4}},
    {0xe5e9, {0xe8, 0xa3, 0xa8}},
    {0xe5ea, {0xe8, 0xa3, 0xb2}},
    {0xe5eb, {0xe8, 0xa4, 0x84}},
    {0xe5ec, {0xe8, 0xa4, 0x8c}},
    {0xe5ed, {0xe8, 0xa4, 0x8a}},
    {0xe5ee, {0xe8, 0xa4, 0x93}},
    {0xe5ef, {0xe8, 0xa5, 0x83}},
    {0xe5f0, {0xe8, 0xa4, 0x9e}},
    {0xe5f1, {0xe8, 0xa4, 0xa5}},
    {0xe5f2, {0xe8, 0xa4, 0xaa}},
    {0xe5f3, {0xe8, 0xa4, 0xab}},
    {0xe5f4, {0xe8, 0xa5, 0x81}},
    {0xe5f5, {0xe8, 0xa5, 0x84}},
    {0xe5f6, {0xe8, 0xa4, 0xbb}},
    {0xe5f7, {0xe8, 0xa4, 0xb6}},
    {0xe5f8, {0xe8, 0xa4, 0xb8}},
    {0xe5f9, {0xe8, 0xa5, 0x8c}},
    {0xe5fa, {0xe8, 0xa4, 0x9d}},
    {0xe5fb, {0xe8, 0xa5, 0xa0}},
    {0xe5fc, {0xe8, 0xa5, 0x9e}},
    {0xe640, {0xe8, 0xa5, 0xa6}},
    {0xe641, {0xe8, 0xa5, 0xa4}},
    {0xe642, {0xe8, 0xa5, 0xad}},
    {0xe643, {0xe8, 0xa5, 0xaa}},
    {0xe644, {0xe8, 0xa5, 0xaf}},
    {0xe645, {0xe8, 0xa5, 0xb4}},
    {0xe646, {0xe8, 0xa5, 0xb7}},
    {0xe647, {0xe8, 0xa5, 0xbe}},
    {0xe648, {0xe8, 0xa6, 0x83}},
    {0xe649, {0xe8, 0xa6, 0x88}},
    {0xe64a, {0xe8, 0xa6, 0x8a}},
    {0xe64b, {0xe8, 0xa6, 0x93}},
    {0xe64c, {0xe8, 0xa6, 0x98}},
    {0xe64d, {0xe8, 0xa6, 0xa1}},
    {0xe64e, {0xe8, 0xa6, 0xa9}},
    {0xe64f, {0xe8, 0xa6, 0xa6}},
    {0xe650, {0xe8, 0xa6, 0xac}},
    {0xe651, {0xe8, 0xa6, 0xaf}},
    {0xe652, {0xe8, 0xa6, 0xb2}},
    {0xe653, {0xe8, 0xa6, 0xba}},
    {0xe654, {0xe8, 0xa6, 0xbd}},
    {0xe655, {0xe8, 0xa6, 0xbf}},
    {0xe656, {0xe8, 0xa7, 0x80}},
    {0xe657, {0xe8, 0xa7, 0x9a}},
    {0xe658, {0xe8, 0xa7, 0x9c}},
    {0xe659, {0xe8, 0xa7, 0x9d}},
    {0xe65a, {0xe8, 0xa7, 0xa7}},
    {0xe65b, {0xe8, 0xa7, 0xb4}},
    {0xe65c, {0xe8, 0xa7, 0xb8}},
    {0xe65d, {0xe8, 0xa8, 0x83}},
    {0xe65e, {0xe8, 0xa8, 0x96}},
    {0xe65f, {0xe8, 0xa8, 0x90}},
    {0xe660, {0xe8, 0xa8, 0x8c}},
    {0xe661, {0xe8, 0xa8, 0x9b}},
    {0xe662, {0xe8, 0xa8, 0x9d}},
    {0xe663, {0xe8, 0xa8, 0xa5}},
    {0xe664, {0xe8, 0xa8, 0xb6}},
    {0xe665, {0xe8, 0xa9, 0x81}},
    {0xe666, {0xe8, 0xa9, 0x9b}},
    {0xe667, {0xe8, 0xa9, 0x92}},
    {0xe668, {0xe8, 0xa9, 0x86}},
    {0xe669, {0xe8, 0xa9, 0x88}},
    {0xe66a, {0xe8, 0xa9, 0xbc}},
    {0xe66b, {0xe8, 0xa9, 0xad}},
    {0xe66c, {0xe8, 0xa9, 0xac}},
    {0xe66d, {0xe8, 0xa9, 0xa2}},
    {0xe66e, {0xe8, 0xaa, 0x85}},
    {0xe66f, {0xe8, 0xaa, 0x82}},
    {0xe670, {0xe8, 0xaa, 0x84}},
    {0xe671, {0xe8, 0xaa, 0xa8}},
    {0xe672, {0xe8, 0xaa, 0xa1}},
    {0xe673, {0xe8, 0xaa, 0x91}},
    {0xe674, {0xe8, 0xaa, 0xa5}},
    {0xe675, {0xe8, 0xaa, 0xa6}},
    {0xe676, {0xe8, 0xaa, 0x9a}},
    {0xe677, {0xe8, 0xaa, 0xa3}},
    {0xe678, {0xe8, 0xab, 0x84}},
    {0xe679, {0xe8, 0xab, 0x8d}},
    {0xe67a, {0xe8, 0xab, 0x82}},
    {0xe67b, {0xe8, 0xab, 0x9a}},
    {0xe67c, {0xe8, 0xab, 0xab}},
    {0xe67d, {0xe8, 0xab, 0xb3}},
    {0xe67e, {0xe8, 0xab, 0xa7}},
    {0xe680, {0xe8, 0xab, 0xa4}},
    {0xe681, {0xe8, 0xab, 0xb1}},
    {0xe682, {0xe8, 0xac, 0x94}},
    {0xe683, {0xe8, 0xab, 0xa0}},
    {0xe684, {0xe8, 0xab, 0xa2}},
    {0xe685, {0xe8, 0xab, 0xb7}},
    {0xe686, {0xe8, 0xab, 0x9e}},
    {0xe687, {0xe8, 0xab, 0x9b}},
    {0xe688, {0xe8, 0xac, 0x8c}},
    {0xe689, {0xe8, 0xac, 0x87}},
    {0xe68a, {0xe8, 0xac, 0x9a}},
    {0xe68b, {0xe8, 0xab, 0xa1}},
    {0xe68c, {0xe8, 0xac, 0x96}},
    {0xe68d, {0xe8, 0xac, 0x90}},
    {0xe68e, {0xe8, 0xac, 0x97}},
    {0xe68f, {0xe8, 0xac, 0xa0}},
    {0xe690, {0xe8, 0xac, 0xb3}},
    {0xe691, {0xe9, 0x9e, 0xab}},
    {0xe692, {0xe8, 0xac, 0xa6}},
    {0xe693, {0xe8, 0xac, 0xab}},
    {0xe694, {0xe8, 0xac, 0xbe}},
    {0xe695, {0xe8, 0xac, 0xa8}},
    {0xe696, {0xe8, 0xad, 0x81}},
    {0xe697, {0xe8, 0xad, 0x8c}},
    {0xe698, {0xe8, 0xad, 0x8f}},
    {0xe699, {0xe8, 0xad, 0x8e}},
    {0xe69a, {0xe8, 0xad, 0x89}},
    {0xe69b, {0xe8, 0xad, 0x96}},
    {0xe69c, {0xe8, 0xad, 0x9b}},
    {0xe69d, {0xe8, 0xad, 0x9a}},
    {0xe69e, {0xe8, 0xad, 0xab}},
    {0xe69f, {0xe8, 0xad, 0x9f}},
    {0xe6a0, {0xe8, 0xad, 0xac}},
    {0xe6a1, {0xe8, 0xad, 0xaf}},
    {0xe6a2, {0xe8, 0xad, 0xb4}},
    {0xe6a3, {0xe8, 0xad, 0xbd}},
    {0xe6a4, {0xe8, 0xae, 0x80}},
    {0xe6a5, {0xe8, 0xae, 0x8c}},
    {0xe6a6, {0xe8, 0xae, 0x8e}},
    {0xe6a7, {0xe8, 0xae, 0x92}},
    {0xe6a8, {0xe8, 0xae, 0x93}},
    {0xe6a9, {0xe8, 0xae, 0x96}},
    {0xe6aa, {0xe8, 0xae, 0x99}},
    {0xe6ab, {0xe8, 0xae, 0x9a}},
    {0xe6ac, {0xe8, 0xb0, 0xba}},
    {0xe6ad, {0xe8, 0xb1, 0x81}},
    {0xe6ae, {0xe8, 0xb0, 0xbf}},
    {0xe6af, {0xe8, 0xb1, 0x88}},
    {0xe6b0, {0xe8, 0xb1, 0x8c}},
    {0xe6b1, {0xe8, 0xb1, 0x8e}},
    {0xe6b2, {0xe8, 0xb1, 0x90}},
    {0xe6b3, {0xe8, 0xb1, 0x95}},
    {0xe6b4, {0xe8, 0xb1, 0xa2}},
    {0xe6b5, {0xe8, 0xb1, 0xac}},
    {0xe6b6, {0xe8, 0xb1, 0xb8}},
    {0xe6b7, {0xe8, 0xb1, 0xba}},
    {0xe6b8, {0xe8, 0xb2, 0x82}},
    {0xe6b9, {0xe8, 0xb2, 0x89}},
    {0xe6ba, {0xe8, 0xb2, 0x85}},
    {0xe6bb, {0xe8, 0xb2, 0x8a}},
    {0xe6bc, {0xe8, 0xb2, 0x8d}},
    {0xe6bd, {0xe8, 0xb2, 0x8e}},
    {0xe6be, {0xe8, 0xb2, 0x94}},
    {0xe6bf, {0xe8, 0xb1, 0xbc}},
    {0xe6c0, {0xe8, 0xb2, 0x98}},
    {0xe6c1, {0xe6, 0x88, 0x9d}},
    {0xe6c2, {0xe8, 0xb2, 0xad}},
    {0xe6c3, {0xe8, 0xb2, 0xaa}},
    {0xe6c4, {0xe8, 0xb2, 0xbd}},
    {0xe6c5, {0xe8, 0xb2, 0xb2}},
    {0xe6c6, {0xe8, 0xb2, 0xb3}},
    {0xe6c7, {0xe8, 0xb2, 0xae}},
    {0xe6c8, {0xe8, 0xb2, 0xb6}},
    {0xe6c9, {0xe8, 0xb3, 0x88}},
    {0xe6ca, {0xe8, 0xb3, 0x81}},
    {0xe6cb, {0xe8, 0xb3, 0xa4}},
    {0xe6cc, {0xe8, 0xb3, 0xa3}},
    {0xe6cd, {0xe8, 0xb3, 0x9a}},
    {0xe6ce, {0xe8, 0xb3, 0xbd}},
    {0xe6cf, {0xe8, 0xb3, 0xba}},
    {0xe6d0, {0xe8, 0xb3, 0xbb}},
    {0xe6d1, {0xe8, 0xb4, 0x84}},
    {0xe6d2, {0xe8, 0xb4, 0x85}},
    {0xe6d3, {0xe8, 0xb4, 0x8a}},
    {0xe6d4, {0xe8, 0xb4, 0x87}},
    {0xe6d5, {0xe8, 0xb4, 0x8f}},
    {0xe6d6, {0xe8, 0xb4, 0x8d}},
    {0xe6d7, {0xe8, 0xb4, 0x90}},
    {0xe6d8, {0xe9, 0xbd, 0x8e}},
    {0xe6d9, {0xe8, 0xb4, 0x93}},
    {0xe6da, {0xe8, 0xb3, 0x8d}},
    {0xe6db, {0xe8, 0xb4, 0x94}},
    {0xe6dc, {0xe8, 0xb4, 0x96}},
    {0xe6dd, {0xe8, 0xb5, 0xa7}},
    {0xe6de, {0xe8, 0xb5, 0xad}},
    {0xe6df, {0xe8, 0xb5, 0xb1}},
    {0xe6e0, {0xe8, 0xb5, 0xb3}},
    {0xe6e1, {0xe8, 0xb6, 0x81}},
    {0xe6e2, {0xe8, 0xb6, 0x99}},
    {0xe6e3, {0xe8, 0xb7, 0x82}},
    {0xe6e4, {0xe8, 0xb6, 0xbe}},
    {0xe6e5, {0xe8, 0xb6, 0xba}},
    {0xe6e6, {0xe8, 0xb7, 0x8f}},
    {0xe6e7, {0xe8, 0xb7, 0x9a}},
    {0xe6e8, {0xe8, 0xb7, 0x96}},
    {0xe6e9, {0xe8, 0xb7, 0x8c}},
    {0xe6ea, {0xe8, 0xb7, 0x9b}},
    {0xe6eb, {0xe8, 0xb7, 0x8b}},
    {0xe6ec, {0xe8, 0xb7, 0xaa}},
    {0xe6ed, {0xe8, 0xb7, 0xab}},
    {0xe6ee, {0xe8, 0xb7, 0x9f}},
    {0xe6ef, {0xe8, 0xb7, 0xa3}},
    {0xe6f0, {0xe8, 0xb7, 0xbc}},
    {0xe6f1, {0xe8, 0xb8, 0x88}},
    {0xe6f2, {0xe8, 0xb8, 0x89}},
    {0xe6f3, {0xe8, 0xb7, 0xbf}},
    {0xe6f4, {0xe8, 0xb8, 0x9d}},
    {0xe6f5, {0xe8, 0xb8, 0x9e}},
    {0xe6f6, {0xe8, 0xb8, 0x90}},
    {0xe6f7, {0xe8, 0xb8, 0x9f}},
    {0xe6f8, {0xe8, 0xb9, 0x82}},
    {0xe6f9, {0xe8, 0xb8, 0xb5}},
    {0xe6fa, {0xe8, 0xb8, 0xb0}},
    {0xe6fb, {0xe8, 0xb8, 0xb4}},
    {0xe6fc, {0xe8, 0xb9, 0x8a}},
    {0xe740, {0xe8, 0xb9, 0x87}},
    {0xe741, {0xe8, 0xb9, 0x89}},
    {0xe742, {0xe8, 0xb9, 0x8c}},
    {0xe743, {0xe8, 0xb9, 0x90}},
    {0xe744, {0xe8, 0xb9, 0x88}},
    {0xe745, {0xe8, 0xb9, 0x99}},
    {0xe746, {0xe8, 0xb9, 0xa4}},
    {0xe747, {0xe8, 0xb9, 0xa0}},
    {0xe748, {0xe8, 0xb8, 0xaa}},
    {0xe749, {0xe8, 0xb9, 0xa3}},
    {0xe74a, {0xe8, 0xb9, 0x95}},
    {0xe74b, {0xe8, 0xb9, 0xb6}},
    {0xe74c, {0xe8, 0xb9, 0xb2}},
    {0xe74d, {0xe8, 0xb9, 0xbc}},
    {0xe74e, {0xe8, 0xba, 0x81}},
    {0xe74f, {0xe8, 0xba, 0x87}},
    {0xe750, {0xe8, 0xba, 0x85}},
    {0xe751, {0xe8, 0xba, 0x84}},
    {0xe752, {0xe8, 0xba, 0x8b}},
    {0xe753, {0xe8, 0xba, 0x8a}},
    {0xe754, {0xe8, 0xba, 0x93}},
    {0xe755, {0xe8, 0xba, 0x91}},
    {0xe756, {0xe8, 0xba, 0x94}},
    {0xe757, {0xe8, 0xba, 0x99}},
    {0xe758, {0xe8, 0xba, 0xaa}},
    {0xe759, {0xe8, 0xba, 0xa1}},
    {0xe75a, {0xe8, 0xba, 0xac}},
    {0xe75b, {0xe8, 0xba, 0xb0}},
    {0xe75c, {0xe8, 0xbb, 0x86}},
    {0xe75d, {0xe8, 0xba, 0xb1}},
    {0xe75e, {0xe8, 0xba, 0xbe}},
    {0xe75f, {0xe8, 0xbb, 0x85}},
    {0xe760, {0xe8, 0xbb, 0x88}},
    {0xe761, {0xe8, 0xbb, 0x8b}},
    {0xe762, {0xe8, 0xbb, 0x9b}},
    {0xe763, {0xe8, 0xbb, 0xa3}},
    {0xe764, {0xe8, 0xbb, 0xbc}},
    {0xe765, {0xe8, 0xbb, 0xbb}},
    {0xe766, {0xe8, 0xbb, 0xab}},
    {0xe767, {0xe8, 0xbb, 0xbe}},
    {0xe768, {0xe8, 0xbc, 0x8a}},
    {0xe769, {0xe8, 0xbc, 0x85}},
    {0xe76a, {0xe8, 0xbc, 0x95}},
    {0xe76b, {0xe8, 0xbc, 0x92}},
    {0xe76c, {0xe8, 0xbc, 0x99}},
    {0xe76d, {0xe8, 0xbc, 0x93}},
    {0xe76e, {0xe8, 0xbc, 0x9c}},
    {0xe76f, {0xe8, 0xbc, 0x9f}},
    {0xe770, {0xe8, 0xbc, 0x9b}},
    {0xe771, {0xe8, 0xbc, 0x8c}},
    {0xe772, {0xe8, 0xbc, 0xa6}},
    {0xe773, {0xe8, 0xbc, 0xb3}},
    {0xe774, {0xe8, 0xbc, 0xbb}},
    {0xe775, {0xe8, 0xbc, 0xb9}},
    {0xe776, {0xe8, 0xbd, 0x85}},
    {0xe777, {0xe8, 0xbd, 0x82}},
    {0xe778, {0xe8, 0xbc, 0xbe}},
    {0xe779, {0xe8, 0xbd, 0x8c}},
    {0xe77a, {0xe8, 0xbd, 0x89}},
    {0xe77b, {0xe8, 0xbd, 0x86}},
    {0xe77c, {0xe8, 0xbd, 0x8e}},
    {0xe77d, {0xe8, 0xbd, 0x97}},
    {0xe77e, {0xe8, 0xbd, 0x9c}},
    {0xe780, {0xe8, 0xbd, 0xa2}},
    {0xe781, {0xe8, 0xbd, 0xa3}},
    {0xe782, {0xe8, 0xbd, 0xa4}},
    {0xe783, {0xe8, 0xbe, 0x9c}},
    {0xe784, {0xe8, 0xbe, 0x9f}},
    {0xe785, {0xe8, 0xbe, 0xa3}},
    {0xe786, {0xe8, 0xbe, 0xad}},
    {0xe787, {0xe8, 0xbe, 0xaf}},
    {0xe788, {0xe8, 0xbe, 0xb7}},
    {0xe789, {0xe8, 0xbf, 0x9a}},
    {0xe78a, {0xe8, 0xbf, 0xa5}},
    {0xe78b, {0xe8, 0xbf, 0xa2}},
    {0xe78c, {0xe8, 0xbf, 0xaa}},
    {0xe78d, {0xe8, 0xbf, 0xaf}},
    {0xe78e, {0xe9, 0x82, 0x87}},
    {0xe78f, {0xe8, 0xbf, 0xb4}},
    {0xe790, {0xe9, 0x80, 0x85}},
    {0xe791, {0xe8, 0xbf, 0xb9}},
    {0xe792, {0xe8, 0xbf, 0xba}},
    {0xe793, {0xe9, 0x80, 0x91}},
    {0xe794, {0xe9, 0x80, 0x95}},
    {0xe795, {0xe9, 0x80, 0xa1}},
    {0xe796, {0xe9, 0x80, 0x8d}},
    {0xe797, {0xe9, 0x80, 0x9e}},
    {0xe798, {0xe9, 0x80, 0x96}},
    {0xe799, {0xe9, 0x80, 0x8b}},
    {0xe79a, {0xe9, 0x80, 0xa7}},
    {0xe79b, {0xe9, 0x80, 0xb6}},
    {0xe79c, {0xe9, 0x80, 0xb5}},
    {0xe79d, {0xe9, 0x80, 0xb9}},
    {0xe79e, {0xe8, 0xbf, 0xb8}},
    {0xe79f, {0xe9, 0x81, 0x8f}},
    {0xe7a0, {0xe9, 0x81, 0x90}},
    {0xe7a1, {0xe9, 0x81, 0x91}},
    {0xe7a2, {0xe9, 0x81, 0x92}},
    {0xe7a3, {0xe9, 0x80, 0x8e}},
    {0xe7a4, {0xe9, 0x81, 0x89}},
    {0xe7a5, {0xe9, 0x80, 0xbe}},
    {0xe7a6, {0xe9, 0x81, 0x96}},
    {0xe7a7, {0xe9, 0x81, 0x98}},
    {0xe7a8, {0xe9, 0x81, 0x9e}},
    {0xe7a9, {0xe9, 0x81, 0xa8}},
    {0xe7aa, {0xe9, 0x81, 0xaf}},
    {0xe7ab, {0xe9, 0x81, 0xb6}},
    {0xe7ac, {0xe9, 0x9a, 0xa8}},
    {0xe7ad, {0xe9, 0x81, 0xb2}},
    {0xe7ae, {0xe9, 0x82, 0x82}},
    {0xe7af, {0xe9, 0x81, 0xbd}},
    {0xe7b0, {0xe9, 0x82, 0x81}},
    {0xe7b1, {0xe9, 0x82, 0x80}},
    {0xe7b2, {0xe9, 0x82, 0x8a}},
    {0xe7b3, {0xe9, 0x82, 0x89}},
    {0xe7b4, {0xe9, 0x82, 0x8f}},
    {0xe7b5, {0xe9, 0x82, 0xa8}},
    {0xe7b6, {0xe9, 0x82, 0xaf}},
    {0xe7b7, {0xe9, 0x82, 0xb1}},
    {0xe7b8, {0xe9, 0x82, 0xb5}},
    {0xe7b9, {0xe9, 0x83, 0xa2}},
    {0xe7ba, {0xe9, 0x83, 0xa4}},
    {0xe7bb, {0xe6, 0x89, 0x88}},
    {0xe7bc, {0xe9, 0x83, 0x9b}},
    {0xe7bd, {0xe9, 0x84, 0x82}},
    {0xe7be, {0xe9, 0x84, 0x92}},
    {0xe7bf, {0xe9, 0x84, 0x99}},
    {0xe7c0, {0xe9, 0x84, 0xb2}},
    {0xe7c1, {0xe9, 0x84, 0xb0}},
    {0xe7c2, {0xe9, 0x85, 0x8a}},
    {0xe7c3, {0xe9, 0x85, 0x96}},
    {0xe7c4, {0xe9, 0x85, 0x98}},
    {0xe7c5, {0xe9, 0x85, 0xa3}},
    {0xe7c6, {0xe9, 0x85, 0xa5}},
    {0xe7c7, {0xe9, 0x85, 0xa9}},
    {0xe7c8, {0xe9, 0x85, 0xb3}},
    {0xe7c9, {0xe9, 0x85, 0xb2}},
    {0xe7ca, {0xe9, 0x86, 0x8b}},
    {0xe7cb, {0xe9, 0x86, 0x89}},
    {0xe7cc, {0xe9, 0x86, 0x82}},
    {0xe7cd, {0xe9, 0x86, 0xa2}},
    {0xe7ce, {0xe9, 0x86, 0xab}},
    {0xe7cf, {0xe9, 0x86, 0xaf}},
    {0xe7d0, {0xe9, 0x86, 0xaa}},
    {0xe7d1, {0xe9, 0x86, 0xb5}},
    {0xe7d2, {0xe9, 0x86, 0xb4}},
    {0xe7d3, {0xe9, 0x86, 0xba}},
    {0xe7d4, {0xe9, 0x87, 0x80}},
    {0xe7d5, {0xe9, 0x87, 0x81}},
    {0xe7d6, {0xe9, 0x87, 0x89}},
    {0xe7d7, {0xe9, 0x87, 0x8b}},
    {0xe7d8, {0xe9, 0x87, 0x90}},
    {0xe7d9, {0xe9, 0x87, 0x96}},
    {0xe7da, {0xe9, 0x87, 0x9f}},
    {0xe7db, {0xe9, 0x87, 0xa1}},
    {0xe7dc, {0xe9, 0x87, 0x9b}},
    {0xe7dd, {0xe9, 0x87, 0xbc}},
    {0xe7de, {0xe9, 0x87, 0xb5}},
    {0xe7df, {0xe9, 0x87, 0xb6}},
    {0xe7e0, {0xe9, 0x88, 0x9e}},
    {0xe7e1, {0xe9, 0x87, 0xbf}},
    {0xe7e2, {0xe9, 0x88, 0x94}},
    {0xe7e3, {0xe9, 0x88, 0xac}},
    {0xe7e4, {0xe9, 0x88, 0x95}},
    {0xe7e5, {0xe9, 0x88, 0x91}},
    {0xe7e6, {0xe9, 0x89, 0x9e}},
    {0xe7e7, {0xe9, 0x89, 0x97}},
    {0xe7e8, {0xe9, 0x89, 0x85}},
    {0xe7e9, {0xe9, 0x89, 0x89}},
    {0xe7ea, {0xe9, 0x89, 0xa4}},
    {0xe7eb, {0xe9, 0x89, 0x88}},
    {0xe7ec, {0xe9, 0x8a, 0x95}},
    {0xe7ed, {0xe9, 0x88, 0xbf}},
    {0xe7ee, {0xe9, 0x89, 0x8b}},
    {0xe7ef, {0xe9, 0x89, 0x90}},
    {0xe7f0, {0xe9, 0x8a, 0x9c}},
    {0xe7f1, {0xe9, 0x8a, 0x96}},
    {0xe7f2, {0xe9, 0x8a, 0x93}},
    {0xe7f3, {0xe9, 0x8a, 0x9b}},
    {0xe7f4, {0xe9, 0x89, 0x9a}},
    {0xe7f5, {0xe9, 0x8b, 0x8f}},
    {0xe7f6, {0xe9, 0x8a, 0xb9}},
    {0xe7f7, {0xe9, 0x8a, 0xb7}},
    {0xe7f8, {0xe9, 0x8b, 0xa9}},
    {0xe7f9, {0xe9, 0x8c, 0x8f}},
    {0xe7fa, {0xe9, 0x8b, 0xba}},
    {0xe7fb, {0xe9, 0x8d, 0x84}},
    {0xe7fc, {0xe9, 0x8c, 0xae}},
    {0xe840, {0xe9, 0x8c, 0x99}},
    {0xe841, {0xe9, 0x8c, 0xa2}},
    {0xe842, {0xe9, 0x8c, 0x9a}},
    {0xe843, {0xe9, 0x8c, 0xa3}},
    {0xe844, {0xe9, 0x8c, 0xba}},
    {0xe845, {0xe9, 0x8c, 0xb5}},
    {0xe846, {0xe9, 0x8c, 0xbb}},
    {0xe847, {0xe9, 0x8d, 0x9c}},
    {0xe848, {0xe9, 0x8d, 0xa0}},
    {0xe849, {0xe9, 0x8d, 0xbc}},
    {0xe84a, {0xe9, 0x8d, 0xae}},
    {0xe84b, {0xe9, 0x8d, 0x96}},
    {0xe84c, {0xe9, 0x8e, 0xb0}},
    {0xe84d, {0xe9, 0x8e, 0xac}},
    {0xe84e, {0xe9, 0x8e, 0xad}},
    {0xe84f, {0xe9, 0x8e, 0x94}},
    {0xe850, {0xe9, 0x8e, 0xb9}},
    {0xe851, {0xe9, 0x8f, 0x96}},
    {0xe852, {0xe9, 0x8f, 0x97}},
    {0xe853, {0xe9, 0x8f, 0xa8}},
    {0xe854, {0xe9, 0x8f, 0xa5}},
    {0xe855, {0xe9, 0x8f, 0x98}},
    {0xe856, {0xe9, 0x8f, 0x83}},
    {0xe857, {0xe9, 0x8f, 0x9d}},
    {0xe858, {0xe9, 0x8f, 0x90}},
    {0xe859, {0xe9, 0x8f, 0x88}},
    {0xe85a, {0xe9, 0x8f, 0xa4}},
    {0xe85b, {0xe9, 0x90, 0x9a}},
    {0xe85c, {0xe9, 0x90, 0x94}},
    {0xe85d, {0xe9, 0x90, 0x93}},
    {0xe85e, {0xe9, 0x90, 0x83}},
    {0xe85f, {0xe9, 0x90, 0x87}},
    {0xe860, {0xe9, 0x90, 0x90}},
    {0xe861, {0xe9, 0x90, 0xb6}},
    {0xe862, {0xe9, 0x90, 0xab}},
    {0xe863, {0xe9, 0x90, 0xb5}},
    {0xe864, {0xe9, 0x90, 0xa1}},
    {0xe865, {0xe9, 0x90, 0xba}},
    {0xe866, {0xe9, 0x91, 0x81}},
    {0xe867, {0xe9, 0x91, 0x92}},
    {0xe868, {0xe9, 0x91, 0x84}},
    {0xe869, {0xe9, 0x91, 0x9b}},
    {0xe86a, {0xe9, 0x91, 0xa0}},
    {0xe86b, {0xe9, 0x91, 0xa2}},
    {0xe86c, {0xe9, 0x91, 0x9e}},
    {0xe86d, {0xe9, 0x91, 0xaa}},
    {0xe86e, {0xe9, 0x88, 0xa9}},
    {0xe86f, {0xe9, 0x91, 0xb0}},
    {0xe870, {0xe9, 0x91, 0xb5}},
    {0xe871, {0xe9, 0x91, 0xb7}},
    {0xe872, {0xe9, 0x91, 0xbd}},
    {0xe873, {0xe9, 0x91, 0x9a}},
    {0xe874, {0xe9, 0x91, 0xbc}},
    {0xe875, {0xe9, 0x91, 0xbe}},
    {0xe876, {0xe9, 0x92, 0x81}},
    {0xe877, {0xe9, 0x91, 0xbf}},
    {0xe878, {0xe9, 0x96, 0x82}},
    {0xe879, {0xe9, 0x96, 0x87}},
    {0xe87a, {0xe9, 0x96, 0x8a}},
    {0xe87b, {0xe9, 0x96, 0x94}},
    {0xe87c, {0xe9, 0x96, 0x96}},
    {0xe87d, {0xe9, 0x96, 0x98}},
    {0xe87e, {0xe9, 0x96, 0x99}},
    {0xe880, {0xe9, 0x96, 0xa0}},
    {0xe881, {0xe9, 0x96, 0xa8}},
    {0xe882, {0xe9, 0x96, 0xa7}},
    {0xe883, {0xe9, 0x96, 0xad}},
    {0xe884, {0xe9, 0x96, 0xbc}},
    {0xe885, {0xe9, 0x96, 0xbb}},
    {0xe886, {0xe9, 0x96, 0xb9}},
    {0xe887, {0xe9, 0x96, 0xbe}},
    {0xe888, {0xe9, 0x97, 0x8a}},
    {0xe889, {0xe6, 0xbf, 0xb6}},
    {0xe88a, {0xe9, 0x97, 0x83}},
    {0xe88b, {0xe9, 0x97, 0x8d}},
    {0xe88c, {0xe9, 0x97, 0x8c}},
    {0xe88d, {0xe9, 0x97, 0x95}},
    {0xe88e, {0xe9, 0x97, 0x94}},
    {0xe88f, {0xe9, 0x97, 0x96}},
    {0xe890, {0xe9, 0x97, 0x9c}},
    {0xe891, {0xe9, 0x97, 0xa1}},
    {0xe892, {0xe9, 0x97, 0xa5}},
    {0xe893, {0xe9, 0x97, 0xa2}},
    {0xe894, {0xe9, 0x98, 0xa1}},
    {0xe895, {0xe9, 0x98, 0xa8}},
    {0xe896, {0xe9, 0x98, 0xae}},
    {0xe897, {0xe9, 0x98, 0xaf}},
    {0xe898, {0xe9, 0x99, 0x82}},
    {0xe899, {0xe9, 0x99, 0x8c}},
    {0xe89a, {0xe9, 0x99, 0x8f}},
    {0xe89b, {0xe9, 0x99, 0x8b}},
    {0xe89c, {0xe9, 0x99, 0xb7}},
    {0xe89d, {0xe9, 0x99, 0x9c}},
    {0xe89e, {0xe9, 0x99, 0x9e}},
    {0xe89f, {0xe9, 0x99, 0x9d}},
    {0xe8a0, {0xe9, 0x99, 0x9f}},
    {0xe8a1, {0xe9, 0x99, 0xa6}},
    {0xe8a2, {0xe9, 0x99, 0xb2}},
    {0xe8a3, {0xe9, 0x99, 0xac}},
    {0xe8a4, {0xe9, 0x9a, 0x8d}},
    {0xe8a5, {0xe9, 0x9a, 0x98}},
    {0xe8a6, {0xe9, 0x9a, 0x95}},
    {0xe8a7, {0xe9, 0x9a, 0x97}},
    {0xe8a8, {0xe9, 0x9a, 0xaa}},
    {0xe8a9, {0xe9, 0x9a, 0xa7}},
    {0xe8aa, {0xe9, 0x9a, 0xb1}},
    {0xe8ab, {0xe9, 0x9a, 0xb2}},
    {0xe8ac, {0xe9, 0x9a, 0xb0}},
    {0xe8ad, {0xe9, 0x9a, 0xb4}},
    {0xe8ae, {0xe9, 0x9a, 0xb6}},
    {0xe8af, {0xe9, 0x9a, 0xb8}},
    {0xe8b0, {0xe9, 0x9a, 0xb9}},
    {0xe8b1, {0xe9, 0x9b, 0x8e}},
    {0xe8b2, {0xe9, 0x9b, 0x8b}},
    {0xe8b3, {0xe9, 0x9b, 0x89}},
    {0xe8b4, {0xe9, 0x9b, 0x8d}},
    {0xe8b5, {0xe8, 0xa5, 0x8d}},
    {0xe8b6, {0xe9, 0x9b, 0x9c}},
    {0xe8b7, {0xe9, 0x9c, 0x8d}},
    {0xe8b8, {0xe9, 0x9b, 0x95}},
    {0xe8b9, {0xe9, 0x9b, 0xb9}},
    {0xe8ba, {0xe9, 0x9c, 0x84}},
    {0xe8bb, {0xe9, 0x9c, 0x86}},
    {0xe8bc, {0xe9, 0x9c, 0x88}},
    {0xe8bd, {0xe9, 0x9c, 0x93}},
    {0xe8be, {0xe9, 0x9c, 0x8e}},
    {0xe8bf, {0xe9, 0x9c, 0x91}},
    {0xe8c0, {0xe9, 0x9c, 0x8f}},
    {0xe8c1, {0xe9, 0x9c, 0x96}},
    {0xe8c2, {0xe9, 0x9c, 0x99}},
    {0xe8c3, {0xe9, 0x9c, 0xa4}},
    {0xe8c4, {0xe9, 0x9c, 0xaa}},
    {0xe8c5, {0xe9, 0x9c, 0xb0}},
    {0xe8c6, {0xe9, 0x9c, 0xb9}},
    {0xe8c7, {0xe9, 0x9c, 0xbd}},
    {0xe8c8, {0xe9, 0x9c, 0xbe}},
    {0xe8c9, {0xe9, 0x9d, 0x84}},
    {0xe8ca, {0xe9, 0x9d, 0x86}},
    {0xe8cb, {0xe9, 0x9d, 0x88}},
    {0xe8cc, {0xe9, 0x9d, 0x82}},
    {0xe8cd, {0xe9, 0x9d, 0x89}},
    {0xe8ce, {0xe9, 0x9d, 0x9c}},
    {0xe8cf, {0xe9, 0x9d, 0xa0}},
    {0xe8d0, {0xe9, 0x9d, 0xa4}},
    {0xe8d1, {0xe9, 0x9d, 0xa6}},
    {0xe8d2, {0xe9, 0x9d, 0xa8}},
    {0xe8d3, {0xe5, 0x8b, 0x92}},
    {0xe8d4, {0xe9, 0x9d, 0xab}},
    {0xe8d5, {0xe9, 0x9d, 0xb1}},
    {0xe8d6, {0xe9, 0x9d, 0xb9}},
    {0xe8d7, {0xe9, 0x9e, 0x85}},
    {0xe8d8, {0xe9, 0x9d, 0xbc}},
    {0xe8d9, {0xe9, 0x9e, 0x81}},
    {0xe8da, {0xe9, 0x9d, 0xba}},
    {0xe8db, {0xe9, 0x9e, 0x86}},
    {0xe8dc, {0xe9, 0x9e, 0x8b}},
    {0xe8dd, {0xe9, 0x9e, 0x8f}},
    {0xe8de, {0xe9, 0x9e, 0x90}},
    {0xe8df, {0xe9, 0x9e, 0x9c}},
    {0xe8e0, {0xe9, 0x9e, 0xa8}},
    {0xe8e1, {0xe9, 0x9e, 0xa6}},
    {0xe8e2, {0xe9, 0x9e, 0xa3}},
    {0xe8e3, {0xe9, 0x9e, 0xb3}},
    {0xe8e4, {0xe9, 0x9e, 0xb4}},
    {0xe8e5, {0xe9, 0x9f, 0x83}},
    {0xe8e6, {0xe9, 0x9f, 0x86}},
    {0xe8e7, {0xe9, 0x9f, 0x88}},
    {0xe8e8, {0xe9, 0x9f, 0x8b}},
    {0xe8e9, {0xe9, 0x9f, 0x9c}},
    {0xe8ea, {0xe9, 0x9f, 0xad}},
    {0xe8eb, {0xe9, 0xbd, 0x8f}},
    {0xe8ec, {0xe9, 0x9f, 0xb2}},
    {0xe8ed, {0xe7, 0xab, 0x9f}},
    {0xe8ee, {0xe9, 0x9f, 0xb6}},
    {0xe8ef, {0xe9, 0x9f, 0xb5}},
    {0xe8f0, {0xe9, 0xa0, 0x8f}},
    {0xe8f1, {0xe9, 0xa0, 0x8c}},
    {0xe8f2, {0xe9, 0xa0, 0xb8}},
    {0xe8f3, {0xe9, 0xa0, 0xa4}},
    {0xe8f4, {0xe9, 0xa0, 0xa1}},
    {0xe8f5, {0xe9, 0xa0, 0xb7}},
    {0xe8f6, {0xe9, 0xa0, 0xbd}},
    {0xe8f7, {0xe9, 0xa1, 0x86}},
    {0xe8f8, {0xe9, 0xa1, 0x8f}},
    {0xe8f9, {0xe9, 0xa1, 0x8b}},
    {0xe8fa, {0xe9, 0xa1, 0xab}},
    {0xe8fb, {0xe9, 0xa1, 0xaf}},
    {0xe8fc, {0xe9, 0xa1, 0xb0}},
    {0xe940, {0xe9, 0xa1, 0xb1}},
    {0xe941, {0xe9, 0xa1, 0xb4}},
    {0xe942, {0xe9, 0xa1, 0xb3}},
    {0xe943, {0xe9, 0xa2, 0xaa}},
    {0xe944, {0xe9, 0xa2, 0xaf}},
    {0xe945, {0xe9, 0xa2, 0xb1}},
    {0xe946, {0xe9, 0xa2, 0xb6}},
    {0xe947, {0xe9, 0xa3, 0x84}},
    {0xe948, {0xe9, 0xa3, 0x83}},
    {0xe949, {0xe9, 0xa3, 0x86}},
    {0xe94a, {0xe9, 0xa3, 0xa9}},
    {0xe94b, {0xe9, 0xa3, 0xab}},
    {0xe94c, {0xe9, 0xa4, 0x83}},
    {0xe94d, {0xe9, 0xa4, 0x89}},
    {0xe94e, {0xe9, 0xa4, 0x92}},
    {0xe94f, {0xe9, 0xa4, 0x94}},
    {0xe950, {0xe9, 0xa4, 0x98}},
    {0xe951, {0xe9, 0xa4, 0xa1}},
    {0xe952, {0xe9, 0xa4, 0x9d}},
    {0xe953, {0xe9, 0xa4, 0x9e}},
    {0xe954, {0xe9, 0xa4, 0xa4}},
    {0xe955, {0xe9, 0xa4, 0xa0}},
    {0xe956, {0xe9, 0xa4, 0xac}},
    {0xe957, {0xe9, 0xa4, 0xae}},
    {0xe958, {0xe9, 0xa4, 0xbd}},
    {0xe959, {0xe9, 0xa4, 0xbe}},
    {0xe95a, {0xe9, 0xa5, 0x82}},
    {0xe95b, {0xe9, 0xa5, 0x89}},
    {0xe95c, {0xe9, 0xa5, 0x85}},
    {0xe95d, {0xe9, 0xa5, 0x90}},
    {0xe95e, {0xe9, 0xa5, 0x8b}},
    {0xe95f, {0xe9, 0xa5, 0x91}},
    {0xe960, {0xe9, 0xa5, 0x92}},
    {0xe961, {0xe9, 0xa5, 0x8c}},
    {0xe962, {0xe9, 0xa5, 0x95}},
    {0xe963, {0xe9, 0xa6, 0x97}},
    {0xe964, {0xe9, 0xa6, 0x98}},
    {0xe965, {0xe9, 0xa6, 0xa5}},
    {0xe966, {0xe9, 0xa6, 0xad}},
    {0xe967, {0xe9, 0xa6, 0xae}},
    {0xe968, {0xe9, 0xa6, 0xbc}},
    {0xe969, {0xe9, 0xa7, 0x9f}},
    {0xe96a, {0xe9, 0xa7, 0x9b}},
    {0xe96b, {0xe9, 0xa7, 0x9d}},
    {0xe96c, {0xe9, 0xa7, 0x98}},
    {0xe96d, {0xe9, 0xa7, 0x91}},
    {0xe96e, {0xe9, 0xa7, 0xad}},
    {0xe96f, {0xe9, 0xa7, 0xae}},
    {0xe970, {0xe9, 0xa7, 0xb1}},
    {0xe971, {0xe9, 0xa7, 0xb2}},
    {0xe972, {0xe9, 0xa7, 0xbb}},
    {0xe973, {0xe9, 0xa7, 0xb8}},
    {0xe974, {0xe9, 0xa8, 0x81}},
    {0xe975, {0xe9, 0xa8, 0x8f}},
    {0xe976, {0xe9, 0xa8, 0x85}},
    {0xe977, {0xe9, 0xa7, 0xa2}},
    {0xe978, {0xe9, 0xa8, 0x99}},
    {0xe979, {0xe9, 0xa8, 0xab}},
    {0xe97a, {0xe9, 0xa8, 0xb7}},
    {0xe97b, {0xe9, 0xa9, 0x85}},
    {0xe97c, {0xe9, 0xa9, 0x82}},
    {0xe97d, {0xe9, 0xa9, 0x80}},
    {0xe97e, {0xe9, 0xa9, 0x83}},
    {0xe980, {0xe9, 0xa8, 0xbe}},
    {0xe981, {0xe9, 0xa9, 0x95}},
    {0xe982, {0xe9, 0xa9, 0x8d}},
    {0xe983, {0xe9, 0xa9, 0x9b}},
    {0xe984, {0xe9, 0xa9, 0x97}},
    {0xe985, {0xe9, 0xa9, 0x9f}},
    {0xe986, {0xe9, 0xa9, 0xa2}},
    {0xe987, {0xe9, 0xa9, 0xa5}},
    {0xe988, {0xe9, 0xa9, 0xa4}},
    {0xe989, {0xe9, 0xa9, 0xa9}},
    {0xe98a, {0xe9, 0xa9, 0xab}},
    {0xe98b, {0xe9, 0xa9, 0xaa}},
    {0xe98c, {0xe9, 0xaa, 0xad}},
    {0xe98d, {0xe9, 0xaa, 0xb0}},
    {0xe98e, {0xe9, 0xaa, 0xbc}},
    {0xe98f, {0xe9, 0xab, 0x80}},
    {0xe990, {0xe9, 0xab, 0x8f}},
    {0xe991, {0xe9, 0xab, 0x91}},
    {0xe992, {0xe9, 0xab, 0x93}},
    {0xe993, {0xe9, 0xab, 0x94}},
    {0xe994, {0xe9, 0xab, 0x9e}},
    {0xe995, {0xe9, 0xab, 0x9f}},
    {0xe996, {0xe9, 0xab, 0xa2}},
    {0xe997, {0xe9, 0xab, 0xa3}},
    {0xe998, {0xe9, 0xab, 0xa6}},
    {0xe999, {0xe9, 0xab, 0xaf}},
    {0xe99a, {0xe9, 0xab, 0xab}},
    {0xe99b, {0xe9, 0xab, 0xae}},
    {0xe99c, {0xe9, 0xab, 0xb4}},
    {0xe99d, {0xe9, 0xab, 0xb1}},
    {0xe99e, {0xe9, 0xab, 0xb7}},
    {0xe99f, {0xe9, 0xab, 0xbb}},
    {0xe9a0, {0xe9, 0xac, 0x86}},
    {0xe9a1, {0xe9, 0xac, 0x98}},
    {0xe9a2, {0xe9, 0xac, 0x9a}},
    {0xe9a3, {0xe9, 0xac, 0x9f}},
    {0xe9a4, {0xe9, 0xac, 0xa2}},
    {0xe9a5, {0xe9, 0xac, 0xa3}},
    {0xe9a6, {0xe9, 0xac, 0xa5}},
    {0xe9a7, {0xe9, 0xac, 0xa7}},
    {0xe9a8, {0xe9, 0xac, 0xa8}},
    {0xe9a9, {0xe9, 0xac, 0xa9}},
    {0xe9aa, {0xe9, 0xac, 0xaa}},
    {0xe9ab, {0xe9, 0xac, 0xae}},
    {0xe9ac, {0xe9, 0xac, 0xaf}},
    {0xe9ad, {0xe9, 0xac, 0xb2}},
    {0xe9ae, {0xe9, 0xad, 0x84}},
    {0xe9af, {0xe9, 0xad, 0x83}},
    {0xe9b0, {0xe9, 0xad, 0x8f}},
    {0xe9b1, {0xe9, 0xad, 0x8d}},
    {0xe9b2, {0xe9, 0xad, 0x8e}},
    {0xe9b3, {0xe9, 0xad, 0x91}},
    {0xe9b4, {0xe9, 0xad, 0x98}},
    {0xe9b5, {0xe9, 0xad, 0xb4}},
    {0xe9b6, {0xe9, 0xae, 0x93}},
    {0xe9b7, {0xe9, 0xae, 0x83}},
    {0xe9b8, {0xe9, 0xae, 0x91}},
    {0xe9b9, {0xe9, 0xae, 0x96}},
    {0xe9ba, {0xe9, 0xae, 0x97}},
    {0xe9bb, {0xe9, 0xae, 0x9f}},
    {0xe9bc, {0xe9, 0xae, 0xa0}},
    {0xe9bd, {0xe9, 0xae, 0xa8}},
    {0xe9be, {0xe9, 0xae, 0xb4}},
    {0xe9bf, {0xe9, 0xaf, 0x80}},
    {0xe9c0, {0xe9, 0xaf, 0x8a}},
    {0xe9c1, {0xe9, 0xae, 0xb9}},
    {0xe9c2, {0xe9, 0xaf, 0x86}},
    {0xe9c3, {0xe9, 0xaf, 0x8f}},
    {0xe9c4, {0xe9, 0xaf, 0x91}},
    {0xe9c5, {0xe9, 0xaf, 0x92}},
    {0xe9c6, {0xe9, 0xaf, 0xa3}},
    {0xe9c7, {0xe9, 0xaf, 0xa2}},
    {0xe9c8, {0xe9, 0xaf, 0xa4}},
    {0xe9c9, {0xe9, 0xaf, 0x94}},
    {0xe9ca, {0xe9, 0xaf, 0xa1}},
    {0xe9cb, {0xe9, 0xb0, 0xba}},
    {0xe9cc, {0xe9, 0xaf, 0xb2}},
    {0xe9cd, {0xe9, 0xaf, 0xb1}},
    {0xe9ce, {0xe9, 0xaf, 0xb0}},
    {0xe9cf, {0xe9, 0xb0, 0x95}},
    {0xe9d0, {0xe9, 0xb0, 0x94}},
    {0xe9d1, {0xe9, 0xb0, 0x89}},
    {0xe9d2, {0xe9, 0xb0, 0x93}},
    {0xe9d3, {0xe9, 0xb0, 0x8c}},
    {0xe9d4, {0xe9, 0xb0, 0x86}},
    {0xe9d5, {0xe9, 0xb0, 0x88}},
    {0xe9d6, {0xe9, 0xb0, 0x92}},
    {0xe9d7, {0xe9, 0xb0, 0x8a}},
    {0xe9d8, {0xe9, 0xb0, 0x84}},
    {0xe9d9, {0xe9, 0xb0, 0xae}},
    {0xe9da, {0xe9, 0xb0, 0x9b}},
    {0xe9db, {0xe9, 0xb0, 0xa5}},
    {0xe9dc, {0xe9, 0xb0, 0xa4}},
    {0xe9dd, {0xe9, 0xb0, 0xa1}},
    {0xe9de, {0xe9, 0xb0, 0xb0}},
    {0xe9df, {0xe9, 0xb1, 0x87}},
    {0xe9e0, {0xe9, 0xb0, 0xb2}},
    {0xe9e1, {0xe9, 0xb1, 0x86}},
    {0xe9e2, {0xe9, 0xb0, 0xbe}},
    {0xe9e3, {0xe9, 0xb1, 0x9a}},
    {0xe9e4, {0xe9, 0xb1, 0xa0}},
    {0xe9e5, {0xe9, 0xb1, 0xa7}},
    {0xe9e6, {0xe9, 0xb1, 0xb6}},
    {0xe9e7, {0xe9, 0xb1, 0xb8}},
    {0xe9e8, {0xe9, 0xb3, 0xa7}},
    {0xe9e9, {0xe9, 0xb3, 0xac}},
    {0xe9ea, {0xe9, 0xb3, 0xb0}},
    {0xe9eb, {0xe9, 0xb4, 0x89}},
    {0xe9ec, {0xe9, 0xb4, 0x88}},
    {0xe9ed, {0xe9, 0xb3, 0xab}},
    {0xe9ee, {0xe9, 0xb4, 0x83}},
    {0xe9ef, {0xe9, 0xb4, 0x86}},
    {0xe9f0, {0xe9, 0xb4, 0xaa}},
    {0xe9f1, {0xe9, 0xb4, 0xa6}},
    {0xe9f2, {0xe9, 0xb6, 0xaf}},
    {0xe9f3, {0xe9, 0xb4, 0xa3}},
    {0xe9f4, {0xe9, 0xb4, 0x9f}},
    {0xe9f5, {0xe9, 0xb5, 0x84}},
    {0xe9f6, {0xe9, 0xb4, 0x95}},
    {0xe9f7, {0xe9, 0xb4, 0x92}},
    {0xe9f8, {0xe9, 0xb5, 0x81}},
    {0xe9f9, {0xe9, 0xb4, 0xbf}},
    {0xe9fa, {0xe9, 0xb4, 0xbe}},
    {0xe9fb, {0xe9, 0xb5, 0x86}},
    {0xe9fc, {0xe9, 0xb5, 0x88}},
    {0xea40, {0xe9, 0xb5, 0x9d}},
    {0xea41, {0xe9, 0xb5, 0x9e}},
    {0xea42, {0xe9, 0xb5, 0xa4}},
    {0xea43, {0xe9, 0xb5, 0x91}},
    {0xea44, {0xe9, 0xb5, 0x90}},
    {0xea45, {0xe9, 0xb5, 0x99}},
    {0xea46, {0xe9, 0xb5, 0xb2}},
    {0xea47, {0xe9, 0xb6, 0x89}},
    {0xea48, {0xe9, 0xb6, 0x87}},
    {0xea49, {0xe9, 0xb6, 0xab}},
    {0xea4a, {0xe9, 0xb5, 0xaf}},
    {0xea4b, {0xe9, 0xb5, 0xba}},
    {0xea4c, {0xe9, 0xb6, 0x9a}},
    {0xea4d, {0xe9, 0xb6, 0xa4}},
    {0xea4e, {0xe9, 0xb6, 0xa9}},
    {0xea4f, {0xe9, 0xb6, 0xb2}},
    {0xea50, {0xe9, 0xb7, 0x84}},
    {0xea51, {0xe9, 0xb7, 0x81}},
    {0xea52, {0xe9, 0xb6, 0xbb}},
    {0xea53, {0xe9, 0xb6, 0xb8}},
    {0xea54, {0xe9, 0xb6, 0xba}},
    {0xea55, {0xe9, 0xb7, 0x86}},
    {0xea56, {0xe9, 0xb7, 0x8f}},
    {0xea57, {0xe9, 0xb7, 0x82}},
    {0xea58, {0xe9, 0xb7, 0x99}},
    {0xea59, {0xe9, 0xb7, 0x93}},
    {0xea5a, {0xe9, 0xb7, 0xb8}},
    {0xea5b, {0xe9, 0xb7, 0xa6}},
    {0xea5c, {0xe9, 0xb7, 0xad}},
    {0xea5d, {0xe9, 0xb7, 0xaf}},
    {0xea5e, {0xe9, 0xb7, 0xbd}},
    {0xea5f, {0xe9, 0xb8, 0x9a}},
    {0xea60, {0xe9, 0xb8, 0x9b}},
    {0xea61, {0xe9, 0xb8, 0x9e}},
    {0xea62, {0xe9, 0xb9, 0xb5}},
    {0xea63, {0xe9, 0xb9, 0xb9}},
    {0xea64, {0xe9, 0xb9, 0xbd}},
    {0xea65, {0xe9, 0xba, 0x81}},
    {0xea66, {0xe9, 0xba, 0x88}},
    {0xea67, {0xe9, 0xba, 0x8b}},
    {0xea68, {0xe9, 0xba, 0x8c}},
    {0xea69, {0xe9, 0xba, 0x92}},
    {0xea6a, {0xe9, 0xba, 0x95}},
    {0xea6b, {0xe9, 0xba, 0x91}},
    {0xea6c, {0xe9, 0xba, 0x9d}},
    {0xea6d, {0xe9, 0xba, 0xa5}},
    {0xea6e, {0xe9, 0xba, 0xa9}},
    {0xea6f, {0xe9, 0xba, 0xb8}},
    {0xea70, {0xe9, 0xba, 0xaa}},
    {0xea71, {0xe9, 0xba, 0xad}},
    {0xea72, {0xe9, 0x9d, 0xa1}},
    {0xea73, {0xe9, 0xbb, 0x8c}},
    {0xea74, {0xe9, 0xbb, 0x8e}},
    {0xea75, {0xe9, 0xbb, 0x8f}},
    {0xea76, {0xe9, 0xbb, 0x90}},
    {0xea77, {0xe9, 0xbb, 0x94}},
    {0xea78, {0xe9, 0xbb, 0x9c}},
    {0xea79, {0xe9, 0xbb, 0x9e}},
    {0xea7a, {0xe9, 0xbb, 0x9d}},
    {0xea7b, {0xe9, 0xbb, 0xa0}},
    {0xea7c, {0xe9, 0xbb, 0xa5}},
    {0xea7d, {0xe9, 0xbb, 0xa8}},
    {0xea7e, {0xe9, 0xbb, 0xaf}},
    {0xea80, {0xe9, 0xbb, 0xb4}},
    {0xea81, {0xe9, 0xbb, 0xb6}},
    {0xea82, {0xe9, 0xbb, 0xb7}},
    {0xea83, {0xe9, 0xbb, 0xb9}},
    {0xea84, {0xe9, 0xbb, 0xbb}},
    {0xea85, {0xe9, 0xbb, 0xbc}},
    {0xea86, {0xe9, 0xbb, 0xbd}},
    {0xea87, {0xe9, 0xbc, 0x87}},
    {0xea88, {0xe9, 0xbc, 0x88}},
    {0xea89, {0xe7, 0x9a, 0xb7}},
    {0xea8a, {0xe9, 0xbc, 0x95}},
    {0xea8b, {0xe9, 0xbc, 0xa1}},
    {0xea8c, {0xe9, 0xbc, 0xac}},
    {0xea8d, {0xe9, 0xbc, 0xbe}},
    {0xea8e, {0xe9, 0xbd, 0x8a}},
    {0xea8f, {0xe9, 0xbd, 0x92}},
    {0xea90, {0xe9, 0xbd, 0x94}},
    {0xea91, {0xe9, 0xbd, 0xa3}},
    {0xea92, {0xe9, 0xbd, 0x9f}},
    {0xea93, {0xe9, 0xbd, 0xa0}},
    {0xea94, {0xe9, 0xbd, 0xa1}},
    {0xea95, {0xe9, 0xbd, 0xa6}},
    {0xea96, {0xe9, 0xbd, 0xa7}},
    {0xea97, {0xe9, 0xbd, 0xac}},
    {0xea98, {0xe9, 0xbd, 0xaa}},
    {0xea99, {0xe9, 0xbd, 0xb7}},
    {0xea9a, {0xe9, 0xbd, 0xb2}},
    {0xea9b, {0xe9, 0xbd, 0xb6}},
    {0xea9c, {0xe9, 0xbe, 0x95}},
    {0xea9d, {0xe9, 0xbe, 0x9c}},
    {0xea9e, {0xe9, 0xbe, 0xa0}},
    {0xea9f, {0xe5, 0xa0, 0xaf}},
    {0xeaa0, {0xe6, 0xa7, 0x87}},
    {0xeaa1, {0xe9, 0x81, 0x99}},
    {0xeaa2, {0xe7, 0x91, 0xa4}},
    {0xeaa3, {0xe5, 0x87, 0x9c}},
    {0xeaa4, {0xe7, 0x86, 0x99}},
    {0xed40, {0xe7, 0xba, 0x8a}},
    {0xed41, {0xe8, 0xa4, 0x9c}},
    {0xed42, {0xe9, 0x8d, 0x88}},
    {0xed43, {0xe9, 0x8a, 0x88}},
    {0xed44, {0xe8, 0x93, 0x9c}},
    {0xed45, {0xe4, 0xbf, 0x89}},
    {0xed46, {0xe7, 0x82, 0xbb}},
    {0xed47, {0xe6, 0x98, 0xb1}},
    {0xed48, {0xe6, 0xa3, 0x88}},
    {0xed49, {0xe9, 0x8b, 0xb9}},
    {0xed4a, {0xe6, 0x9b, 0xbb}},
    {0xed4b, {0xe5, 0xbd, 0x85}},
    {0xed4c, {0xe4, 0xb8, 0xa8}},
    {0xed4d, {0xe4, 0xbb, 0xa1}},
    {0xed4e, {0xe4, 0xbb, 0xbc}},
    {0xed4f, {0xe4, 0xbc, 0x80}},
    {0xed50, {0xe4, 0xbc, 0x83}},
    {0xed51, {0xe4, 0xbc, 0xb9}},
    {0xed52, {0xe4, 0xbd, 0x96}},
    {0xed53, {0xe4, 0xbe, 0x92}},
    {0xed54, {0xe4, 0xbe, 0x8a}},
    {0xed55, {0xe4, 0xbe, 0x9a}},
    {0xed56, {0xe4, 0xbe, 0x94}},
    {0xed57, {0xe4, 0xbf, 0x8d}},
    {0xed58, {0xe5, 0x81, 0x80}},
    {0xed59, {0xe5, 0x80, 0xa2}},
    {0xed5a, {0xe4, 0xbf, 0xbf}},
    {0xed5b, {0xe5, 0x80, 0x9e}},
    {0xed5c, {0xe5, 0x81, 0x86}},
    {0xed5d, {0xe5, 0x81, 0xb0}},
    {0xed5e, {0xe5, 0x81, 0x82}},
    {0xed5f, {0xe5, 0x82, 0x94}},
    {0xed60, {0xe5, 0x83, 0xb4}},
    {0xed61, {0xe5, 0x83, 0x98}},
    {0xed62, {0xe5, 0x85, 0x8a}},
    {0xed63, {0xe5, 0x85, 0xa4}},
    {0xed64, {0xe5, 0x86, 0x9d}},
    {0xed65, {0xe5, 0x86, 0xbe}},
    {0xed66, {0xe5, 0x87, 0xac}},
    {0xed67, {0xe5, 0x88, 0x95}},
    {0xed68, {0xe5, 0x8a, 0x9c}},
    {0xed69, {0xe5, 0x8a, 0xa6}},
    {0xed6a, {0xe5, 0x8b, 0x80}},
    {0xed6b, {0xe5, 0x8b, 0x9b}},
    {0xed6c, {0xe5, 0x8c, 0x80}},
    {0xed6d, {0xe5, 0x8c, 0x87}},
    {0xed6e, {0xe5, 0x8c, 0xa4}},
    {0xed6f, {0xe5, 0x8d, 0xb2}},
    {0xed70, {0xe5, 0x8e, 0x93}},
    {0xed71, {0xe5, 0x8e, 0xb2}},
    {0xed72, {0xe5, 0x8f, 0x9d}},
    {0xed73, {0xef, 0xa8, 0x8e}},
    {0xed74, {0xe5, 0x92, 0x9c}},
    {0xed75, {0xe5, 0x92, 0x8a}},
    {0xed76, {0xe5, 0x92, 0xa9}},
    {0xed77, {0xe5, 0x93, 0xbf}},
    {0xed78, {0xe5, 0x96, 0x86}},
    {0xed79, {0xe5, 0x9d, 0x99}},
    {0xed7a, {0xe5, 0x9d, 0xa5}},
    {0xed7b, {0xe5, 0x9e, 0xac}},
    {0xed7c, {0xe5, 0x9f, 0x88}},
    {0xed7d, {0xe5, 0x9f, 0x87}},
    {0xed7e, {0xef, 0xa8, 0x8f}},
    {0xed80, {0xef, 0xa8, 0x90}},
    {0xed81, {0xe5, 0xa2, 0x9e}},
    {0xed82, {0xe5, 0xa2, 0xb2}},
    {0xed83, {0xe5, 0xa4, 0x8b}},
    {0xed84, {0xe5, 0xa5, 0x93}},
    {0xed85, {0xe5, 0xa5, 0x9b}},
    {0xed86, {0xe5, 0xa5, 0x9d}},
    {0xed87, {0xe5, 0xa5, 0xa3}},
    {0xed88, {0xe5, 0xa6, 0xa4}},
    {0xed89, {0xe5, 0xa6, 0xba}},
    {0xed8a, {0xe5, 0xad, 0x96}},
    {0xed8b, {0xe5, 0xaf, 0x80}},
    {0xed8c, {0xe7, 0x94, 0xaf}},
    {0xed8d, {0xe5, 0xaf, 0x98}},
    {0xed8e, {0xe5, 0xaf, 0xac}},
    {0xed8f, {0xe5, 0xb0, 0x9e}},
    {0xed90, {0xe5, 0xb2, 0xa6}},
    {0xed91, {0xe5, 0xb2, 0xba}},
    {0xed92, {0xe5, 0xb3, 0xb5}},
    {0xed93, {0xe5, 0xb4, 0xa7}},
    {0xed94, {0xe5, 0xb5, 0x93}},
    {0xed95, {0xef, 0xa8, 0x91}},
    {0xed96, {0xe5, 0xb5, 0x82}},
    {0xed97, {0xe5, 0xb5, 0xad}},
    {0xed98, {0xe5, 0xb6, 0xb8}},
    {0xed99, {0xe5, 0xb6, 0xb9}},
    {0xed9a, {0xe5, 0xb7, 0x90}},
    {0xed9b, {0xe5, 0xbc, 0xa1}},
    {0xed9c, {0xe5, 0xbc, 0xb4}},
    {0xed9d, {0xe5, 0xbd, 0xa7}},
    {0xed9e, {0xe5, 0xbe, 0xb7}},
    {0xed9f, {0xe5, 0xbf, 0x9e}},
    {0xeda0, {0xe6, 0x81, 0x9d}},
    {0xeda1, {0xe6, 0x82, 0x85}},
    {0xeda2, {0xe6, 0x82, 0x8a}},
    {0xeda3, {0xe6, 0x83, 0x9e}},
    {0xeda4, {0xe6, 0x83, 0x95}},
    {0xeda5, {0xe6, 0x84, 0xa0}},
    {0xeda6, {0xe6, 0x83, 0xb2}},
    {0xeda7, {0xe6, 0x84, 0x91}},
    {0xeda8, {0xe6, 0x84, 0xb7}},
    {0xeda9, {0xe6, 0x84, 0xb0}},
    {0xedaa, {0xe6, 0x86, 0x98}},
    {0xedab, {0xe6, 0x88, 0x93}},
    {0xedac, {0xe6, 0x8a, 0xa6}},
    {0xedad, {0xe6, 0x8f, 0xb5}},
    {0xedae, {0xe6, 0x91, 0xa0}},
    {0xedaf, {0xe6, 0x92, 0x9d}},
    {0xedb0, {0xe6, 0x93, 0x8e}},
    {0xedb1, {0xe6, 0x95, 0x8e}},
    {0xedb2, {0xe6, 0x98, 0x80}},
    {0xedb3, {0xe6, 0x98, 0x95}},
    {0xedb4, {0xe6, 0x98, 0xbb}},
    {0xedb5, {0xe6, 0x98, 0x89}},
    {0xedb6, {0xe6, 0x98, 0xae}},
    {0xedb7, {0xe6, 0x98, 0x9e}},
    {0xedb8, {0xe6, 0x98, 0xa4}},
    {0xedb9, {0xe6, 0x99, 0xa5}},
    {0xedba, {0xe6, 0x99, 0x97}},
    {0xedbb, {0xe6, 0x99, 0x99}},
    {0xedbc, {0xef, 0xa8, 0x92}},
    {0xedbd, {0xe6, 0x99, 0xb3}},
    {0xedbe, {0xe6, 0x9a, 0x99}},
    {0xedbf, {0xe6, 0x9a, 0xa0}},
    {0xedc0, {0xe6, 0x9a, 0xb2}},
    {0xedc1, {0xe6, 0x9a, 0xbf}},
    {0xedc2, {0xe6, 0x9b, 0xba}},
    {0xedc3, {0xe6, 0x9c, 0x8e}},
    {0xedc4, {0xef, 0xa4, 0xa9}},
    {0xedc5, {0xe6, 0x9d, 0xa6}},
    {0xedc6, {0xe6, 0x9e, 0xbb}},
    {0xedc7, {0xe6, 0xa1, 0x92}},
    {0xedc8, {0xe6, 0x9f, 0x80}},
    {0xedc9, {0xe6, 0xa0, 0x81}},
    {0xedca, {0xe6, 0xa1, 0x84}},
    {0xedcb, {0xe6, 0xa3, 0x8f}},
    {0xedcc, {0xef, 0xa8, 0x93}},
    {0xedcd, {0xe6, 0xa5, 0xa8}},
    {0xedce, {0xef, 0xa8, 0x94}},
    {0xedcf, {0xe6, 0xa6, 0x98}},
    {0xedd0, {0xe6, 0xa7, 0xa2}},
    {0xedd1, {0xe6, 0xa8, 0xb0}},
    {0xedd2, {0xe6, 0xa9, 0xab}},
    {0xedd3, {0xe6, 0xa9, 0x86}},
    {0xedd4, {0xe6, 0xa9, 0xb3}},
    {0xedd5, {0xe6, 0xa9, 0xbe}},
    {0xedd6, {0xe6, 0xab, 0xa2}},
    {0xedd7, {0xe6, 0xab, 0xa4}},
    {0xedd8, {0xe6, 0xaf, 0x96}},
    {0xedd9, {0xe6, 0xb0, 0xbf}},
    {0xedda, {0xe6, 0xb1, 0x9c}},
    {0xeddb, {0xe6, 0xb2, 0x86}},
    {0xeddc, {0xe6, 0xb1, 0xaf}},
    {0xeddd, {0xe6, 0xb3, 0x9a}},
    {0xedde, {0xe6, 0xb4, 0x84}},
    {0xeddf, {0xe6, 0xb6, 0x87}},
    {0xede0, {0xe6, 0xb5, 0xaf}},
    {0xede1, {0xe6, 0xb6, 0x96}},
    {0xede2, {0xe6, 0xb6, 0xac}},
    {0xede3, {0xe6, 0xb7, 0x8f}},
    {0xede4, {0xe6, 0xb7, 0xb8}},
    {0xede5, {0xe6, 0xb7, 0xb2}},
    {0xede6, {0xe6, 0xb7, 0xbc}},
    {0xede7, {0xe6, 0xb8, 0xb9}},
    {0xede8, {0xe6, 0xb9, 0x9c}},
    {0xede9, {0xe6, 0xb8, 0xa7}},
    {0xedea, {0xe6, 0xb8, 0xbc}},
    {0xedeb, {0xe6, 0xba, 0xbf}},
    {0xedec, {0xe6, 0xbe, 0x88}},
    {0xeded, {0xe6, 0xbe, 0xb5}},
    {0xedee, {0xe6, 0xbf, 0xb5}},
    {0xedef, {0xe7, 0x80, 0x85}},
    {0xedf0, {0xe7, 0x80, 0x87}},
    {0xedf1, {0xe7, 0x80, 0xa8}},
    {0xedf2, {0xe7, 0x82, 0x85}},
    {0xedf3, {0xe7, 0x82, 0xab}},
    {0xedf4, {0xe7, 0x84, 0x8f}},
    {0xedf5, {0xe7, 0x84, 0x84}},
    {0xedf6, {0xe7, 0x85, 0x9c}},
    {0xedf7, {0xe7, 0x85, 0x86}},
    {0xedf8, {0xe7, 0x85, 0x87}},
    {0xedf9, {0xef, 0xa8, 0x95}},
    {0xedfa, {0xe7, 0x87, 0x81}},
    {0xedfb, {0xe7, 0x87, 0xbe}},
    {0xedfc, {0xe7, 0x8a, 0xb1}},
    {0xee40, {0xe7, 0x8a, 0xbe}},
    {0xee41, {0xe7, 0x8c, 0xa4}},
    {0xee42, {0xef, 0xa8, 0x96}},
    {0xee43, {0xe7, 0x8d, 0xb7}},
    {0xee44, {0xe7, 0x8e, 0xbd}},
    {0xee45, {0xe7, 0x8f, 0x89}},
    {0xee46, {0xe7, 0x8f, 0x96}},
    {0xee47, {0xe7, 0x8f, 0xa3}},
    {0xee48, {0xe7, 0x8f, 0x92}},
    {0xee49, {0xe7, 0x90, 0x87}},
    {0xee4a, {0xe7, 0x8f, 0xb5}},
    {0xee4b, {0xe7, 0x90, 0xa6}},
    {0xee4c, {0xe7, 0x90, 0xaa}},
    {0xee4d, {0xe7, 0x90, 0xa9}},
    {0xee4e, {0xe7, 0x90, 0xae}},
    {0xee4f, {0xe7, 0x91, 0xa2}},
    {0xee50, {0xe7, 0x92, 0x89}},
    {0xee51, {0xe7, 0x92, 0x9f}},
    {0xee52, {0xe7, 0x94, 0x81}},
    {0xee53, {0xe7, 0x95, 0xaf}},
    {0xee54, {0xe7, 0x9a, 0x82}},
    {0xee55, {0xe7, 0x9a, 0x9c}},
    {0xee56, {0xe7, 0x9a, 0x9e}},
    {0xee57, {0xe7, 0x9a, 0x9b}},
    {0xee58, {0xe7, 0x9a, 0xa6}},
    {0xee59, {0xef, 0xa8, 0x97}},
    {0xee5a, {0xe7, 0x9d, 0x86}},
    {0xee5b, {0xe5, 0x8a, 0xaf}},
    {0xee5c, {0xe7, 0xa0, 0xa1}},
    {0xee5d, {0xe7, 0xa1, 0x8e}},
    {0xee5e, {0xe7, 0xa1, 0xa4}},
    {0xee5f, {0xe7, 0xa1, 0xba}},
    {0xee60, {0xe7, 0xa4, 0xb0}},
    {0xee61, {0xef, 0xa8, 0x98}},
    {0xee62, {0xef, 0xa8, 0x99}},
    {0xee63, {0xef, 0xa8, 0x9a}},
    {0xee64, {0xe7, 0xa6, 0x94}},
    {0xee65, {0xef, 0xa8, 0x9b}},
    {0xee66, {0xe7, 0xa6, 0x9b}},
    {0xee67, {0xe7, 0xab, 0x91}},
    {0xee68, {0xe7, 0xab, 0xa7}},
    {0xee69, {0xef, 0xa8, 0x9c}},
    {0xee6a, {0xe7, 0xab, 0xab}},
    {0xee6b, {0xe7, 0xae, 0x9e}},
    {0xee6c, {0xef, 0xa8, 0x9d}},
    {0xee6d, {0xe7, 0xb5, 0x88}},
    {0xee6e, {0xe7, 0xb5, 0x9c}},
    {0xee6f, {0xe7, 0xb6, 0xb7}},
    {0xee70, {0xe7, 0xb6, 0xa0}},
    {0xee71, {0xe7, 0xb7, 0x96}},
    {0xee72, {0xe7, 0xb9, 0x92}},
    {0xee73, {0xe7, 0xbd, 0x87}},
    {0xee74, {0xe7, 0xbe, 0xa1}},
    {0xee75, {0xef, 0xa8, 0x9e}},
    {0xee76, {0xe8, 0x8c, 0x81}},
    {0xee77, {0xe8, 0x8d, 0xa2}},
    {0xee78, {0xe8, 0x8d, 0xbf}},
    {0xee79, {0xe8, 0x8f, 0x87}},
    {0xee7a, {0xe8, 0x8f, 0xb6}},
    {0xee7b, {0xe8, 0x91, 0x88}},
    {0xee7c, {0xe8, 0x92, 0xb4}},
    {0xee7d, {0xe8, 0x95, 0x93}},
    {0xee7e, {0xe8, 0x95, 0x99}},
    {0xee80, {0xe8, 0x95, 0xab}},
    {0xee81, {0xef, 0xa8, 0x9f}},
    {0xee82, {0xe8, 0x96, 0xb0}},
    {0xee83, {0xef, 0xa8, 0xa0}},
    {0xee84, {0xef, 0xa8, 0xa1}},
    {0xee85, {0xe8, 0xa0, 0x87}},
    {0xee86, {0xe8, 0xa3, 0xb5}},
    {0xee87, {0xe8, 0xa8, 0x92}},
    {0xee88, {0xe8, 0xa8, 0xb7}},
    {0xee89, {0xe8, 0xa9, 0xb9}},
    {0xee8a, {0xe8, 0xaa, 0xa7}},
    {0xee8b, {0xe8, 0xaa, 0xbe}},
    {0xee8c, {0xe8, 0xab, 0x9f}},
    {0xee8d, {0xef, 0xa8, 0xa2}},
    {0xee8e, {0xe8, 0xab, 0xb6}},
    {0xee8f, {0xe8, 0xad, 0x93}},
    {0xee90, {0xe8, 0xad, 0xbf}},
    {0xee91, {0xe8, 0xb3, 0xb0}},
    {0xee92, {0xe8, 0xb3, 0xb4}},
    {0xee93, {0xe8, 0xb4, 0x92}},
    {0xee94, {0xe8, 0xb5, 0xb6}},
    {0xee95, {0xef, 0xa8, 0xa3}},
    {0xee96, {0xe8, 0xbb, 0x8f}},
    {0xee97, {0xef, 0xa8, 0xa4}},
    {0xee98, {0xef, 0xa8, 0xa5}},
    {0xee99, {0xe9, 0x81, 0xa7}},
    {0xee9a, {0xe9, 0x83, 0x9e}},
    {0xee9b, {0xef, 0xa8, 0xa6}},
    {0xee9c, {0xe9, 0x84, 0x95}},
    {0xee9d, {0xe9, 0x84, 0xa7}},
    {0xee9e, {0xe9, 0x87, 0x9a}},
    {0xee9f, {0xe9, 0x87, 0x97}},
    {0xeea0, {0xe9, 0x87, 0x9e}},
    {0xeea1, {0xe9, 0x87, 0xad}},
    {0xeea2, {0xe9, 0x87, 0xae}},
    {0xeea3, {0xe9, 0x87, 0xa4}},
    {0xeea4, {0xe9, 0x87, 0xa5}},
    {0xeea5, {0xe9, 0x88, 0x86}},
    {0xeea6, {0xe9, 0x88, 0x90}},
    {0xeea7, {0xe9, 0x88, 0x8a}},
    {0xeea8, {0xe9, 0x88, 0xba}},
    {0xeea9, {0xe9, 0x89, 0x80}},
    {0xeeaa, {0xe9, 0x88, 0xbc}},
    {0xeeab, {0xe9, 0x89, 0x8e}},
    {0xeeac, {0xe9, 0x89, 0x99}},
    {0xeead, {0xe9, 0x89, 0x91}},
    {0xeeae, {0xe9, 0x88, 0xb9}},
    {0xeeaf, {0xe9, 0x89, 0xa7}},
    {0xeeb0, {0xe9, 0x8a, 0xa7}},
    {0xeeb1, {0xe9, 0x89, 0xb7}},
    {0xeeb2, {0xe9, 0x89, 0xb8}},
    {0xeeb3, {0xe9, 0x8b, 0xa7}},
    {0xeeb4, {0xe9, 0x8b, 0x97}},
    {0xeeb5, {0xe9, 0x8b, 0x99}},
    {0xeeb6, {0xe9, 0x8b, 0x90}},
    {0xeeb7, {0xef, 0xa8, 0xa7}},
    {0xeeb8, {0xe9, 0x8b, 0x95}},
    {0xeeb9, {0xe9, 0x8b, 0xa0}},
    {0xeeba, {0xe9, 0x8b, 0x93}},
    {0xeebb, {0xe9, 0x8c, 0xa5}},
    {0xeebc, {0xe9, 0x8c, 0xa1}},
    {0xeebd, {0xe9, 0x8b, 0xbb}},
    {0xeebe, {0xef, 0xa8, 0xa8}},
    {0xeebf, {0xe9, 0x8c, 0x9e}},
    {0xeec0, {0xe9, 0x8b, 0xbf}},
    {0xeec1, {0xe9, 0x8c, 0x9d}},
    {0xeec2, {0xe9, 0x8c, 0x82}},
    {0xeec3, {0xe9, 0x8d, 0xb0}},
    {0xeec4, {0xe9, 0x8d, 0x97}},
    {0xeec5, {0xe9, 0x8e, 0xa4}},
    {0xeec6, {0xe9, 0x8f, 0x86}},
    {0xeec7, {0xe9, 0x8f, 0x9e}},
    {0xeec8, {0xe9, 0x8f, 0xb8}},
    {0xeec9, {0xe9, 0x90, 0xb1}},
    {0xeeca, {0xe9, 0x91, 0x85}},
    {0xeecb, {0xe9, 0x91, 0x88}},
    {0xeecc, {0xe9, 0x96, 0x92}},
    {0xeecd, {0xef, 0xa7, 0x9c}},
    {0xeece, {0xef, 0xa8, 0xa9}},
    {0xeecf, {0xe9, 0x9a, 0x9d}},
    {0xeed0, {0xe9, 0x9a, 0xaf}},
    {0xeed1, {0xe9, 0x9c, 0xb3}},
    {0xeed2, {0xe9, 0x9c, 0xbb}},
    {0xeed3, {0xe9, 0x9d, 0x83}},
    {0xeed4, {0xe9, 0x9d, 0x8d}},
    {0xeed5, {0xe9, 0x9d, 0x8f}},
    {0xeed6, {0xe9, 0x9d, 0x91}},
    {0xeed7, {0xe9, 0x9d, 0x95}},
    {0xeed8, {0xe9, 0xa1, 0x97}},
    {0xeed9, {0xe9, 0xa1, 0xa5}},
    {0xeeda, {0xef, 0xa8, 0xaa}},
    {0xeedb, {0xef, 0xa8, 0xab}},
    {0xeedc, {0xe9, 0xa4, 0xa7}},
    {0xeedd, {0xef, 0xa8, 0xac}},
    {0xeede, {0xe9, 0xa6, 0x9e}},
    {0xeedf, {0xe9, 0xa9, 0x8e}},
    {0xeee0, {0xe9, 0xab, 0x99}},
    {0xeee1, {0xe9, 0xab, 0x9c}},
    {0xeee2, {0xe9, 0xad, 0xb5}},
    {0xeee3, {0xe9, 0xad, 0xb2}},
    {0xeee4, {0xe9, 0xae, 0x8f}},
    {0xeee5, {0xe9, 0xae, 0xb1}},
    {0xeee6, {0xe9, 0xae, 0xbb}},
    {0xeee7, {0xe9, 0xb0, 0x80}},
    {0xeee8, {0xe9, 0xb5, 0xb0}},
    {0xeee9, {0xe9, 0xb5, 0xab}},
    {0xeeea, {0xef, 0xa8, 0xad}},
    {0xeeeb, {0xe9, 0xb8, 0x99}},
    {0xeeec, {0xe9, 0xbb, 0x91}},
    {0xeeef, {0xe2, 0x85, 0xb0}},
    {0xeef0, {0xe2, 0x85, 0xb1}},
    {0xeef1, {0xe2, 0x85, 0xb2}},
    {0xeef2, {0xe2, 0x85, 0xb3}},
    {0xeef3, {0xe2, 0x85, 0xb4}},
    {0xeef4, {0xe2, 0x85, 0xb5}},
    {0xeef5, {0xe2, 0x85, 0xb6}},
    {0xeef6, {0xe2, 0x85, 0xb7}},
    {0xeef7, {0xe2, 0x85, 0xb8}},
    {0xeef8, {0xe2, 0x85, 0xb9}},
    {0xeef9, {0xef, 0xbf, 0xa2}},
    {0xeefa, {0xef, 0xbf, 0xa4}},
    {0xeefb, {0xef, 0xbc, 0x87}},
    {0xeefc, {0xef, 0xbc, 0x82}},
};

static japanese_entry *utf8_to_codepage;

static const int num_entries = sizeof(codepage_to_utf8) / sizeof(japanese_entry);

static const int image_id_block_indexes[128] = {
    // 80-8f
    -1, -1, 0, 1, -1, -1, -1, -1, 1, 2, 3, 4, 5, 6, 7, 8,
    // 90-97
    9, 10, 11, 12, 13, 14, 15, 16, 17
};

static const int image_id_punctuation_81[96] = {
//   0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f
    63, 64, 65, -1, 66, 67, 68, -1, 69, 70, -1, -1, -1, -1, -1, -1, // 0x40
    -1, -1, -1, -1, -1, -1, -1, -1, 71, -1, -1, 72, -1, -1, 73, -1, // 0x50
    74, -1, -1, -1, -1, -1, -1, -1, -1, 75, 76, -1, -1, -1, -1, -1, // 0x60
    -1, -1, -1, -1, -1, 77, 88, -1, -1, -1, -1, -1, 89, -1, -1, -1, // 0x70
    -1, 90, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, // 0x80
    -1, -1, -1, 91, -1, 92, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, // 0x90
};

static const japanese_image_entry image_entries[] = {
    {0x875a, 93},
    {0x99e1, 94},
    {0x9aba, 121},
    {0x9ad0, 122},
    {0x9bbc, 123},
    {0x9bde, 124},
    {0x9be7, 125},
    {0x9cbf, 126},
    {0x9ceb, 153},
    {0x9d58, 154},
    {0x9d68, 155},
    {0x9d86, 156},
    {0x9db1, 240},
    {0x9df0, 241},
    {0x9ef2, 242},
    {0x9f42, 243},
    {0x9f7e, 244},
    {0x9fe6, 245},
    {0xe068, 246},
    {0xe0d6, 247},
    {0xe0f8, 248},
    {0xe1f7, 249},
    {0xe249, 250},
    {0xe2c4, 337},
    {0xe2fc, 338},
    {0xe34f, 339},
    {0xe477, 340},
    {0xe54b, 341},
    {0xe54e, 342},
    {0xe569, 343},
    {0xe5e1, 344},
    {0xe6d1, 3310},
    {0xe6d2, 3311},
    {0xe6f8, 3312},
    {0xe757, 3313},
    {0xe76e, 3314},
    {0xe797, 3315},
    {0xe7b4, 3316},
    {0xe873, 3317},
    {0xe878, 3318},
    {0xe95b, 3319},
    {0xea74, 3320},
};

static int compare_utf8(const void *a, const void *b)
{
    const uint8_t *va = ((const japanese_entry*) a)->utf8;
    const uint8_t *vb = ((const japanese_entry*) b)->utf8;
    for (int i = 0; i < 3; i++) {
        if (va[i] == vb[i] || (va[i] == 0 || vb[i] == 0)) {
            continue;
        }
        return va[i] < vb[i] ? -1 : 1;
    }
    return 0;
}

static int compare_codepage(const void *a, const void *b)
{
    uint16_t va = ((const japanese_entry*) a)->cp932;
    uint16_t vb = ((const japanese_entry*) b)->cp932;
    return va == vb ? 0 : (va < vb ? -1 : 1);
}

void encoding_japanese_init(void)
{
    if (!utf8_to_codepage) {
        utf8_to_codepage = (japanese_entry*) malloc(sizeof(codepage_to_utf8));
        if (!utf8_to_codepage) {
            log_error("Unable to allocate memory for Japanese codepage", 0, 0);
            return;
        }
    }
    // codepage_to_unicode is already sorted, copy data and sort the other way around
    memcpy(utf8_to_codepage, codepage_to_utf8, sizeof(codepage_to_utf8));

    qsort(utf8_to_codepage, sizeof(codepage_to_utf8) / sizeof(japanese_entry), sizeof(japanese_entry), compare_utf8);
}

void encoding_japanese_to_utf8(const uint8_t *input, char *output, int output_length)
{
    const char *max_output = &output[output_length - 1];

    while (*input && output < max_output) {
        if (*input < 0x80) {
            *output = *input;
            ++output;
            ++input;
        } else {
            // Possibly multi-byte char
            int is_kata = input[0] >= 0xa0 && input[0] < 0xe0;
            const japanese_entry key = {input[0] << 8 | (is_kata ? 0 : input[1])};
            const japanese_entry *entry = bsearch(&key, codepage_to_utf8,
                num_entries, sizeof(japanese_entry), compare_codepage);
            if (entry && output + 3 <= max_output) {
                for (int i = 0; i < 3 && entry->utf8[i]; i++) {
                    *output = entry->utf8[i];
                    output++;
                }
            }
            input += is_kata ? 1 : 2;
        }
    }
    *output = 0;
}

void encoding_japanese_from_utf8(const char *input, uint8_t *output, int output_length)
{
    if (!utf8_to_codepage) {
        output[0] = 0;
        return;
    }
    const uint8_t *max_output = &output[output_length - 1];

    while (*input && output < max_output) {
        if ((*input & 0x80) == 0) {
            *output = *input;
            ++output;
            ++input;
        } else {
            // Multi-byte char: Japanese characters are 2 or 3 bytes in utf-8
            const japanese_entry key = {0, {(uint8_t)input[0], (uint8_t)input[1], (uint8_t)input[2]}};
            const japanese_entry *entry = bsearch(&key, utf8_to_codepage,
                num_entries, sizeof(japanese_entry), compare_utf8);
            if (entry) {
                // Either 1 or 2 bytes in output
                int output_size = entry->cp932 & 0xff ? 2 : 1;
                if (output + output_size <= max_output) {
                    *output = (entry->cp932 >> 8) & 0xff;
                    output++;
                    if (output_size == 2) {
                        *output = entry->cp932 & 0xff;
                        output++;
                    }
                    input += entry->utf8[2] ? 3 : 2;
                } else {
                    break;
                }
            } else {
                *output = '?';
                output++;
                input += encoding_get_utf8_character_bytes(*input);
            }
        }
    }
    *output = 0;
}

static int compare_image(const void *a, const void *b)
{
    uint16_t va = ((const japanese_image_entry*) a)->cp932;
    uint16_t vb = ((const japanese_image_entry*) b)->cp932;
    return va == vb ? 0 : (va < vb ? -1 : 1);
}

/**
 * Japanese Shift-JIS consists of 2 types of characters:
 * - Single-byte half-width katakana (range 0xa0-0xdf)
 * - Two-byte full-width characters (leading byte 0x80-0x9f and 0xe0-0xff)
 *   The second byte of these characters always falls within the range 0x40-0xfc,
 *   excluding 0x7f, for a total of 188 possible chars per block
 * In Caesar 3, most characters in use are from the earlier blocks, with some
 * less-frequently used characters from later blocks. Some blocks have unused
 * positions. To efficiently map the characters, we fill up these unused positions
 * with characters from different ranges.
 * For block 0x81 (punctuation): only 20 of the 188 characters are used, but they
 * are used frequently - hence the additional mapping for performance reasons.
 */
int encoding_japanese_sjis_to_image_id(uint8_t first, uint8_t second)
{
    if (first < 0x80) {
        return -1;
    } else if (first >= 0xa0 && first < 0xe0) {
        // half width single-byte katakana are the first chars in the font file
        return HALF_WIDTH_START + first - 0xa1;
    } else if (first == 0x81 && second >= 0x40 && second <= 0x9f) {
        // frequently used but only 20 chars out of 188 used in the block
        return image_id_punctuation_81[second - 0x40];
    } else if (first <= 0x98 && image_id_block_indexes[first - 0x80] >= 0) {
        // character from frequently used block
        int block_index = image_id_block_indexes[first - 0x80];
        int char_index = second - 0x40 - (second >= 0x80 ? 1 : 0);
        return FULL_WIDTH_START + block_index * 188 + char_index;
    } else {
        // character from infrequently used block, look up in table
        const japanese_image_entry key = {(first << 8) | second};
        const japanese_image_entry *entry = bsearch(&key, image_entries,
            sizeof(image_entries) / sizeof(japanese_image_entry),
            sizeof(japanese_image_entry), compare_image);
        if (entry) {
            return entry->image_id;
        }
    }
    return -1;
}
