"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSetSettings = void 0;
const react_1 = require("react");
const context_1 = require("./context");
function useSetSettings() {
    const { sigma, container } = (0, context_1.useSigmaContext)();
    const [settings, setSettings] = (0, react_1.useState)({});
    (0, react_1.useEffect)(() => {
        if (!sigma || !settings) {
            return;
        }
        const prevSettings = {};
        Object.keys(settings).forEach(key => {
            prevSettings[key] = settings[key];
            sigma.setSetting(key, settings[key]);
        });
        return () => {
            if (sigma && container && container.offsetWidth > 0 && container.offsetHeight > 0) {
                Object.keys(prevSettings).forEach(key => {
                    sigma.setSetting(key, prevSettings[key]);
                });
            }
        };
    }, [sigma, settings, container]);
    return setSettings;
}
exports.useSetSettings = useSetSettings;
//# sourceMappingURL=useSetSettings.js.map