/*
 * Decompiled with CFR 0.152.
 */
package burp.faraday.models;

import burp.IBurpExtenderCallbacks;

public class ExtensionSettings {
    private final IBurpExtenderCallbacks callbacks;
    private static final String DEFAULT_FARADAY_URL = "http://127.0.0.1:5985";
    private static final String DEFAULT_IMPORT_NEW_VULNS = "0";
    private static final String KEY_FARADAY_URL = "faraday_url";
    private static final String KEY_USERNAME = "faraday_username";
    private static final String KEY_PASSWORD = "faraday_password";
    private static final String KEY_CURRENT_WORKSPACE = "faraday_current_workspace";
    private static final String KEY_IMPORT_NEW_VULNS = "faraday_import_new";

    public ExtensionSettings(IBurpExtenderCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    public String getFaradayURL() {
        return this.getSetting(KEY_FARADAY_URL, DEFAULT_FARADAY_URL);
    }

    public void setFaradayURL(String faradayURL) {
        if (faradayURL != null) {
            faradayURL = faradayURL.trim();
        }
        this.callbacks.saveExtensionSetting(KEY_FARADAY_URL, faradayURL);
    }

    public String getUsername() {
        return this.getSetting(KEY_USERNAME);
    }

    public void setUsername(String username) {
        if (username != null) {
            username = username.trim();
        }
        this.callbacks.saveExtensionSetting(KEY_USERNAME, username);
    }

    public String getPassword() {
        return this.getSetting(KEY_PASSWORD);
    }

    public void setPassword(String password) {
        if (password != null) {
            password = password.trim();
        }
        this.callbacks.saveExtensionSetting(KEY_PASSWORD, password);
    }

    public String getCurrentWorkspace() {
        return this.getSetting(KEY_CURRENT_WORKSPACE);
    }

    public void setCurrentWorkspace(String currentWorkspace) {
        if (currentWorkspace != null) {
            currentWorkspace = currentWorkspace.trim();
        }
        this.callbacks.saveExtensionSetting(KEY_CURRENT_WORKSPACE, currentWorkspace);
    }

    public boolean importNewVulns() {
        return this.getSetting(KEY_IMPORT_NEW_VULNS, DEFAULT_IMPORT_NEW_VULNS).equals("1");
    }

    public void setImportNewVulns(boolean importNewVulns) {
        this.callbacks.saveExtensionSetting(KEY_IMPORT_NEW_VULNS, importNewVulns ? "1" : DEFAULT_IMPORT_NEW_VULNS);
    }

    public void restore() {
        this.callbacks.saveExtensionSetting(KEY_FARADAY_URL, DEFAULT_FARADAY_URL);
        this.callbacks.saveExtensionSetting(KEY_USERNAME, "");
        this.callbacks.saveExtensionSetting(KEY_PASSWORD, "");
        this.callbacks.saveExtensionSetting(KEY_CURRENT_WORKSPACE, "");
        this.callbacks.saveExtensionSetting(KEY_IMPORT_NEW_VULNS, DEFAULT_IMPORT_NEW_VULNS);
    }

    private String getSetting(String key) {
        return this.getSetting(key, "");
    }

    private String getSetting(String key, String defaultValue) {
        String value = this.callbacks.loadExtensionSetting(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    public String getDefaultFaradayUrl() {
        return DEFAULT_FARADAY_URL;
    }
}

