class oci::configure_backports(
  $ceph_configure_osbpo       = false,
  $nova_use_qemu_backports    = false,
  $nova_use_libvirt_backports = false,
){
  if $facts['os']['distro']['codename'] == "bookworm" {
    if $ceph_configure_osbpo or $nova_use_qemu_backports or $nova_use_libvirt_backports {
      # Always set priority to the osbpo repo.
      # Later, we set or not the *.source files.
      file { '/etc/apt/preferences.d/99-prio-from-osbpo':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Package: *
Pin: release o=osbpo
Pin-Priority: 900
',
        notify                  => Exec['apt-update-after-osbpo'],
      }
    }else{
      file { '/etc/apt/preferences.d/99-prio-from-osbpo':
        ensure => absent,
        notify => Exec['apt-update-after-osbpo'],
      }
    }
    # Always remove this file, this is legacy, we're now using
    # a unique /etc/oci/oci-repository-key.asc key that contains
    # them all.
    file { '/etc/oci/osbpo.asc':
      ensure => absent,
      notify => Exec['apt-update-after-osbpo'],
    }

    # ceph-reef repo from osbpo
    if $ceph_configure_osbpo {
      file { '/etc/apt/sources.list.d/ceph_reef.sources':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Types: deb deb-src
Uris: http://osbpo.debian.net/debian
Suites: ceph-reef
Components: main
Architectures: amd64 arm64
Signed-By: /etc/oci/oci-repository-key.asc
',
        notify                  => Exec['apt-update-after-osbpo'],
      }

    }else{
      file { '/etc/apt/sources.list.d/ceph_reef.sources':
        ensure => absent,
        notify => Exec['apt-update-after-osbpo'],
      }
    }

    # QEMU from official Debian backports
    if $nova_use_qemu_backports {
      file { '/etc/apt/sources.list.d/qemu.sources':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Types: deb deb-src
Uris: http://osbpo.debian.net/debian
Suites: bookworm-qemu
Components: main
Architectures: amd64 arm64
Signed-By: /etc/oci/oci-repository-key.asc
',
        notify                  => Exec['apt-update-after-osbpo'],
      }
    }else{
      file { '/etc/apt/sources.list.d/qemu.sources':
        ensure => absent,
        notify => Exec['apt-update-after-osbpo'],
      }
    }

    if $nova_use_libvirt_backports {
      file { '/etc/apt/sources.list.d/libvirt.sources':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Types: deb deb-src
Uris: http://osbpo.debian.net/debian
Suites: bookworm-libvirt
Components: main
Architectures: amd64 arm64
Signed-By: /etc/oci/oci-repository-key.asc
',
        notify                  => Exec['apt-update-after-osbpo'],
      }
    }else{
      file { '/etc/apt/sources.list.d/libvirt.sources':
        ensure => absent,
        notify => Exec['apt-update-after-osbpo'],
      }
    }

    # apt-update if repo files where created.
    exec { "apt-update-after-osbpo":
      command     => "/bin/true # comment to satisfy puppet syntax requirements
apt-get update
",
      logoutput   => 'on_failure',
      tries       => 3,
      try_sleep   => 1,
      refreshonly => true,
    }
  }
}
