use Test2::V0;
use Test2::Tools::Command;

plan 7;

local @Test2::Tools::Command::command = ( $ENV{'RUDOF'} || 'rudof' );

subtest 'options or arguments' => sub {
	command {
		stderr => qr{\n\QUsage: rudof [OPTIONS] [COMMAND]},
		status => 2,
	};
};

subtest 'help option' => sub {
	command {
		args   => ['--help'],
		stdout => qr{\n\QUsage: rudof [OPTIONS] [COMMAND]},
	};
};

subtest 'version option' => sub {
	command {
		args   => ['--version'],
		stdout => qr{^rudof_cli},
	};
};

subtest 'show data, default' => sub {
	command {
		args  => [qw(data examples/user.ttl)],
		stdout => qr{\n:d schema:name 23 .\n},
	};
};

subtest 'show data, RDF/XML' => sub {
	command {
		args  => [qw(data examples/user.ttl -r rdfxml)],
		stdout => qr{\n\s*<status rdf:resource="http://example.org/Active"/>\n},
	};
};

subtest 'show node, outgoing' => sub {
	command {
		args  => [qw(node -n :a examples/user.ttl)],
		stdout => qr{^Outgoing arcs\n:a\n},
	};
};

subtest 'show node, incoming' => sub {
	command {
		args  => [qw(node -n :a examples/user.ttl -m incoming)],
		stdout => qr{^Incoming arcs\n:a\n},
	};
};

done_testing;
