/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"fmt"
)

// checks if the FavoriteContact type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &FavoriteContact{}

// FavoriteContact struct for FavoriteContact
type FavoriteContact struct {
	// List or Contact ID.
	EntityId int32 `json:"entityId"`
	// Entity type which should be marked as **favorite**.
	EntityType string `json:"entityType"`
	// Contact first name/last name if entityType is **contact**; List name if entity type is **list**.
	PrimaryLabel string `json:"primaryLabel"`
	// Phone number if entityType is **contact**; List contacts number if entity type is **list**.
	SecondaryLabel string `json:"secondaryLabel"`
	// Contact country if entityType is **contact**; else, null.
	TertiaryLabel NullableString `json:"tertiaryLabel"`
	Avatar NullableString `json:"avatar"`
	AdditionalProperties map[string]interface{}
}

type _FavoriteContact FavoriteContact

// NewFavoriteContact instantiates a new FavoriteContact object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewFavoriteContact(entityId int32, entityType string, primaryLabel string, secondaryLabel string, tertiaryLabel NullableString, avatar NullableString) *FavoriteContact {
	this := FavoriteContact{}
	this.EntityId = entityId
	this.EntityType = entityType
	this.PrimaryLabel = primaryLabel
	this.SecondaryLabel = secondaryLabel
	this.TertiaryLabel = tertiaryLabel
	this.Avatar = avatar
	return &this
}

// NewFavoriteContactWithDefaults instantiates a new FavoriteContact object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewFavoriteContactWithDefaults() *FavoriteContact {
	this := FavoriteContact{}
	return &this
}

// GetEntityId returns the EntityId field value
func (o *FavoriteContact) GetEntityId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.EntityId
}

// GetEntityIdOk returns a tuple with the EntityId field value
// and a boolean to check if the value has been set.
func (o *FavoriteContact) GetEntityIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.EntityId, true
}

// SetEntityId sets field value
func (o *FavoriteContact) SetEntityId(v int32) {
	o.EntityId = v
}

// GetEntityType returns the EntityType field value
func (o *FavoriteContact) GetEntityType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.EntityType
}

// GetEntityTypeOk returns a tuple with the EntityType field value
// and a boolean to check if the value has been set.
func (o *FavoriteContact) GetEntityTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.EntityType, true
}

// SetEntityType sets field value
func (o *FavoriteContact) SetEntityType(v string) {
	o.EntityType = v
}

// GetPrimaryLabel returns the PrimaryLabel field value
func (o *FavoriteContact) GetPrimaryLabel() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.PrimaryLabel
}

// GetPrimaryLabelOk returns a tuple with the PrimaryLabel field value
// and a boolean to check if the value has been set.
func (o *FavoriteContact) GetPrimaryLabelOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.PrimaryLabel, true
}

// SetPrimaryLabel sets field value
func (o *FavoriteContact) SetPrimaryLabel(v string) {
	o.PrimaryLabel = v
}

// GetSecondaryLabel returns the SecondaryLabel field value
func (o *FavoriteContact) GetSecondaryLabel() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.SecondaryLabel
}

// GetSecondaryLabelOk returns a tuple with the SecondaryLabel field value
// and a boolean to check if the value has been set.
func (o *FavoriteContact) GetSecondaryLabelOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.SecondaryLabel, true
}

// SetSecondaryLabel sets field value
func (o *FavoriteContact) SetSecondaryLabel(v string) {
	o.SecondaryLabel = v
}

// GetTertiaryLabel returns the TertiaryLabel field value
// If the value is explicit nil, the zero value for string will be returned
func (o *FavoriteContact) GetTertiaryLabel() string {
	if o == nil || o.TertiaryLabel.Get() == nil {
		var ret string
		return ret
	}

	return *o.TertiaryLabel.Get()
}

// GetTertiaryLabelOk returns a tuple with the TertiaryLabel field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *FavoriteContact) GetTertiaryLabelOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.TertiaryLabel.Get(), o.TertiaryLabel.IsSet()
}

// SetTertiaryLabel sets field value
func (o *FavoriteContact) SetTertiaryLabel(v string) {
	o.TertiaryLabel.Set(&v)
}

// GetAvatar returns the Avatar field value
// If the value is explicit nil, the zero value for string will be returned
func (o *FavoriteContact) GetAvatar() string {
	if o == nil || o.Avatar.Get() == nil {
		var ret string
		return ret
	}

	return *o.Avatar.Get()
}

// GetAvatarOk returns a tuple with the Avatar field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *FavoriteContact) GetAvatarOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Avatar.Get(), o.Avatar.IsSet()
}

// SetAvatar sets field value
func (o *FavoriteContact) SetAvatar(v string) {
	o.Avatar.Set(&v)
}

func (o FavoriteContact) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o FavoriteContact) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["entityId"] = o.EntityId
	toSerialize["entityType"] = o.EntityType
	toSerialize["primaryLabel"] = o.PrimaryLabel
	toSerialize["secondaryLabel"] = o.SecondaryLabel
	toSerialize["tertiaryLabel"] = o.TertiaryLabel.Get()
	toSerialize["avatar"] = o.Avatar.Get()

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *FavoriteContact) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"entityId",
		"entityType",
		"primaryLabel",
		"secondaryLabel",
		"tertiaryLabel",
		"avatar",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varFavoriteContact := _FavoriteContact{}

	err = json.Unmarshal(data, &varFavoriteContact)

	if err != nil {
		return err
	}

	*o = FavoriteContact(varFavoriteContact)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "entityId")
		delete(additionalProperties, "entityType")
		delete(additionalProperties, "primaryLabel")
		delete(additionalProperties, "secondaryLabel")
		delete(additionalProperties, "tertiaryLabel")
		delete(additionalProperties, "avatar")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableFavoriteContact struct {
	value *FavoriteContact
	isSet bool
}

func (v NullableFavoriteContact) Get() *FavoriteContact {
	return v.value
}

func (v *NullableFavoriteContact) Set(val *FavoriteContact) {
	v.value = val
	v.isSet = true
}

func (v NullableFavoriteContact) IsSet() bool {
	return v.isSet
}

func (v *NullableFavoriteContact) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableFavoriteContact(val *FavoriteContact) *NullableFavoriteContact {
	return &NullableFavoriteContact{value: val, isSet: true}
}

func (v NullableFavoriteContact) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableFavoriteContact) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


