/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the MessageIn type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &MessageIn{}

// MessageIn struct for MessageIn
type MessageIn struct {
	// The ID of the inbound message.
	Id int32 `json:"id"`
	// The sender’s phone number.
	Sender string `json:"sender"`
	// The receiver’s phone number (i.e. your dedicated or shared reply number).
	Receiver NullableString `json:"receiver"`
	// The time when the message reached the Textmagic API endpoint.
	MessageTime time.Time `json:"messageTime"`
	// The text from the received message.
	Text string `json:"text"`
	// Sender contact ID.
	ContactId NullableInt32 `json:"contactId,omitempty"`
	// Sender contact first name.
	FirstName NullableString `json:"firstName,omitempty"`
	// Sender contact last name.
	LastName NullableString `json:"lastName,omitempty"`
	Avatar NullableString `json:"avatar"`
	// Sender email.
	Email NullableString `json:"email,omitempty"`
	ContactUserId NullableInt32 `json:"contactUserId,omitempty"`
	UserId NullableInt32 `json:"userId,omitempty"`
}

type _MessageIn MessageIn

// NewMessageIn instantiates a new MessageIn object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewMessageIn(id int32, sender string, receiver NullableString, messageTime time.Time, text string, avatar NullableString) *MessageIn {
	this := MessageIn{}
	this.Id = id
	this.Sender = sender
	this.Receiver = receiver
	this.MessageTime = messageTime
	this.Text = text
	this.Avatar = avatar
	return &this
}

// NewMessageInWithDefaults instantiates a new MessageIn object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewMessageInWithDefaults() *MessageIn {
	this := MessageIn{}
	return &this
}

// GetId returns the Id field value
func (o *MessageIn) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *MessageIn) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *MessageIn) SetId(v int32) {
	o.Id = v
}

// GetSender returns the Sender field value
func (o *MessageIn) GetSender() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Sender
}

// GetSenderOk returns a tuple with the Sender field value
// and a boolean to check if the value has been set.
func (o *MessageIn) GetSenderOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Sender, true
}

// SetSender sets field value
func (o *MessageIn) SetSender(v string) {
	o.Sender = v
}

// GetReceiver returns the Receiver field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageIn) GetReceiver() string {
	if o == nil || o.Receiver.Get() == nil {
		var ret string
		return ret
	}

	return *o.Receiver.Get()
}

// GetReceiverOk returns a tuple with the Receiver field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetReceiverOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Receiver.Get(), o.Receiver.IsSet()
}

// SetReceiver sets field value
func (o *MessageIn) SetReceiver(v string) {
	o.Receiver.Set(&v)
}

// GetMessageTime returns the MessageTime field value
func (o *MessageIn) GetMessageTime() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.MessageTime
}

// GetMessageTimeOk returns a tuple with the MessageTime field value
// and a boolean to check if the value has been set.
func (o *MessageIn) GetMessageTimeOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.MessageTime, true
}

// SetMessageTime sets field value
func (o *MessageIn) SetMessageTime(v time.Time) {
	o.MessageTime = v
}

// GetText returns the Text field value
func (o *MessageIn) GetText() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Text
}

// GetTextOk returns a tuple with the Text field value
// and a boolean to check if the value has been set.
func (o *MessageIn) GetTextOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Text, true
}

// SetText sets field value
func (o *MessageIn) SetText(v string) {
	o.Text = v
}

// GetContactId returns the ContactId field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetContactId() int32 {
	if o == nil || IsNil(o.ContactId.Get()) {
		var ret int32
		return ret
	}
	return *o.ContactId.Get()
}

// GetContactIdOk returns a tuple with the ContactId field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetContactIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ContactId.Get(), o.ContactId.IsSet()
}

// HasContactId returns a boolean if a field has been set.
func (o *MessageIn) HasContactId() bool {
	if o != nil && o.ContactId.IsSet() {
		return true
	}

	return false
}

// SetContactId gets a reference to the given NullableInt32 and assigns it to the ContactId field.
func (o *MessageIn) SetContactId(v int32) {
	o.ContactId.Set(&v)
}
// SetContactIdNil sets the value for ContactId to be an explicit nil
func (o *MessageIn) SetContactIdNil() {
	o.ContactId.Set(nil)
}

// UnsetContactId ensures that no value is present for ContactId, not even an explicit nil
func (o *MessageIn) UnsetContactId() {
	o.ContactId.Unset()
}

// GetFirstName returns the FirstName field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetFirstName() string {
	if o == nil || IsNil(o.FirstName.Get()) {
		var ret string
		return ret
	}
	return *o.FirstName.Get()
}

// GetFirstNameOk returns a tuple with the FirstName field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetFirstNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.FirstName.Get(), o.FirstName.IsSet()
}

// HasFirstName returns a boolean if a field has been set.
func (o *MessageIn) HasFirstName() bool {
	if o != nil && o.FirstName.IsSet() {
		return true
	}

	return false
}

// SetFirstName gets a reference to the given NullableString and assigns it to the FirstName field.
func (o *MessageIn) SetFirstName(v string) {
	o.FirstName.Set(&v)
}
// SetFirstNameNil sets the value for FirstName to be an explicit nil
func (o *MessageIn) SetFirstNameNil() {
	o.FirstName.Set(nil)
}

// UnsetFirstName ensures that no value is present for FirstName, not even an explicit nil
func (o *MessageIn) UnsetFirstName() {
	o.FirstName.Unset()
}

// GetLastName returns the LastName field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetLastName() string {
	if o == nil || IsNil(o.LastName.Get()) {
		var ret string
		return ret
	}
	return *o.LastName.Get()
}

// GetLastNameOk returns a tuple with the LastName field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetLastNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastName.Get(), o.LastName.IsSet()
}

// HasLastName returns a boolean if a field has been set.
func (o *MessageIn) HasLastName() bool {
	if o != nil && o.LastName.IsSet() {
		return true
	}

	return false
}

// SetLastName gets a reference to the given NullableString and assigns it to the LastName field.
func (o *MessageIn) SetLastName(v string) {
	o.LastName.Set(&v)
}
// SetLastNameNil sets the value for LastName to be an explicit nil
func (o *MessageIn) SetLastNameNil() {
	o.LastName.Set(nil)
}

// UnsetLastName ensures that no value is present for LastName, not even an explicit nil
func (o *MessageIn) UnsetLastName() {
	o.LastName.Unset()
}

// GetAvatar returns the Avatar field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessageIn) GetAvatar() string {
	if o == nil || o.Avatar.Get() == nil {
		var ret string
		return ret
	}

	return *o.Avatar.Get()
}

// GetAvatarOk returns a tuple with the Avatar field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetAvatarOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Avatar.Get(), o.Avatar.IsSet()
}

// SetAvatar sets field value
func (o *MessageIn) SetAvatar(v string) {
	o.Avatar.Set(&v)
}

// GetEmail returns the Email field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetEmail() string {
	if o == nil || IsNil(o.Email.Get()) {
		var ret string
		return ret
	}
	return *o.Email.Get()
}

// GetEmailOk returns a tuple with the Email field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetEmailOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Email.Get(), o.Email.IsSet()
}

// HasEmail returns a boolean if a field has been set.
func (o *MessageIn) HasEmail() bool {
	if o != nil && o.Email.IsSet() {
		return true
	}

	return false
}

// SetEmail gets a reference to the given NullableString and assigns it to the Email field.
func (o *MessageIn) SetEmail(v string) {
	o.Email.Set(&v)
}
// SetEmailNil sets the value for Email to be an explicit nil
func (o *MessageIn) SetEmailNil() {
	o.Email.Set(nil)
}

// UnsetEmail ensures that no value is present for Email, not even an explicit nil
func (o *MessageIn) UnsetEmail() {
	o.Email.Unset()
}

// GetContactUserId returns the ContactUserId field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetContactUserId() int32 {
	if o == nil || IsNil(o.ContactUserId.Get()) {
		var ret int32
		return ret
	}
	return *o.ContactUserId.Get()
}

// GetContactUserIdOk returns a tuple with the ContactUserId field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetContactUserIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ContactUserId.Get(), o.ContactUserId.IsSet()
}

// HasContactUserId returns a boolean if a field has been set.
func (o *MessageIn) HasContactUserId() bool {
	if o != nil && o.ContactUserId.IsSet() {
		return true
	}

	return false
}

// SetContactUserId gets a reference to the given NullableInt32 and assigns it to the ContactUserId field.
func (o *MessageIn) SetContactUserId(v int32) {
	o.ContactUserId.Set(&v)
}
// SetContactUserIdNil sets the value for ContactUserId to be an explicit nil
func (o *MessageIn) SetContactUserIdNil() {
	o.ContactUserId.Set(nil)
}

// UnsetContactUserId ensures that no value is present for ContactUserId, not even an explicit nil
func (o *MessageIn) UnsetContactUserId() {
	o.ContactUserId.Unset()
}

// GetUserId returns the UserId field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetUserId() int32 {
	if o == nil || IsNil(o.UserId.Get()) {
		var ret int32
		return ret
	}
	return *o.UserId.Get()
}

// GetUserIdOk returns a tuple with the UserId field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetUserIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.UserId.Get(), o.UserId.IsSet()
}

// HasUserId returns a boolean if a field has been set.
func (o *MessageIn) HasUserId() bool {
	if o != nil && o.UserId.IsSet() {
		return true
	}

	return false
}

// SetUserId gets a reference to the given NullableInt32 and assigns it to the UserId field.
func (o *MessageIn) SetUserId(v int32) {
	o.UserId.Set(&v)
}
// SetUserIdNil sets the value for UserId to be an explicit nil
func (o *MessageIn) SetUserIdNil() {
	o.UserId.Set(nil)
}

// UnsetUserId ensures that no value is present for UserId, not even an explicit nil
func (o *MessageIn) UnsetUserId() {
	o.UserId.Unset()
}

func (o MessageIn) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o MessageIn) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["sender"] = o.Sender
	toSerialize["receiver"] = o.Receiver.Get()
	toSerialize["messageTime"] = o.MessageTime
	toSerialize["text"] = o.Text
	if o.ContactId.IsSet() {
		toSerialize["contactId"] = o.ContactId.Get()
	}
	if o.FirstName.IsSet() {
		toSerialize["firstName"] = o.FirstName.Get()
	}
	if o.LastName.IsSet() {
		toSerialize["lastName"] = o.LastName.Get()
	}
	toSerialize["avatar"] = o.Avatar.Get()
	if o.Email.IsSet() {
		toSerialize["email"] = o.Email.Get()
	}
	if o.ContactUserId.IsSet() {
		toSerialize["contactUserId"] = o.ContactUserId.Get()
	}
	if o.UserId.IsSet() {
		toSerialize["userId"] = o.UserId.Get()
	}
	return toSerialize, nil
}

func (o *MessageIn) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"sender",
		"receiver",
		"messageTime",
		"text",
		"avatar",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varMessageIn := _MessageIn{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varMessageIn)

	if err != nil {
		return err
	}

	*o = MessageIn(varMessageIn)

	return err
}

type NullableMessageIn struct {
	value *MessageIn
	isSet bool
}

func (v NullableMessageIn) Get() *MessageIn {
	return v.value
}

func (v *NullableMessageIn) Set(val *MessageIn) {
	v.value = val
	v.isSet = true
}

func (v NullableMessageIn) IsSet() bool {
	return v.isSet
}

func (v *NullableMessageIn) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableMessageIn(val *MessageIn) *NullableMessageIn {
	return &NullableMessageIn{value: val, isSet: true}
}

func (v NullableMessageIn) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableMessageIn) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


