/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
)

// checks if the SendMessageRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &SendMessageRequest{}

// SendMessageRequest struct for SendMessageRequest
type SendMessageRequest struct {
	// Message text. Required if the **template_id** is not set.
	Text *string `json:"text,omitempty"`
	// Template used instead of message text. Required if the **text** is not set.
	TemplateId *int32 `json:"templateId,omitempty"`
	// DEPRECATED, consider using sendingDateTime and sendingTimezone parameters instead: Optional (required with rrule set). Message sending time in unix timestamp format. Default is now.
	SendingTime *int32 `json:"sendingTime,omitempty"`
	// Sending time in Y-m-d H:i:s format (e.g. 2022-05-27 13:05:10). This time is relative to **sendingTimezone**. Note: for correct operation, the value of seconds must not be less than 10.
	SendingDateTime *string `json:"sendingDateTime,omitempty"`
	// ID or ISO-name of timezone used for sending when sendingDateTime parameter is set. E.g. if you specify sendingDateTime = \\\"2016-05-27 13:02:33\\\" and sendingTimezone = \\\"America/Buenos_Aires\\\", your message will be sent at May 27, 2016 13:02:33 Buenos Aires time, or 16:02:33 UTC. Default is account timezone.
	SendingTimezone *string `json:"sendingTimezone,omitempty"`
	// Comma separated array of contact resources id message will be sent to.
	Contacts *string `json:"contacts,omitempty"`
	// Comma separated array of list resources id message will be sent to.
	Lists *string `json:"lists,omitempty"`
	// Comma separated array of E.164 phone numbers message will be sent to.
	Phones *string `json:"phones,omitempty"`
	// Should sending method cut extra characters which not fit supplied partsCount or return 400 Bad request response instead.
	CutExtra *bool `json:"cutExtra,omitempty"`
	// Maximum message parts count (Textmagic allows sending 1 to 6 message parts).
	PartsCount *int32 `json:"partsCount,omitempty"`
	// Custom message reference id which can be used in your application infrastructure.
	ReferenceId *int32 `json:"referenceId,omitempty"`
	// One of allowed Sender ID (phone number or alphanumeric sender ID). If specified Sender ID is not allowed for some destinations, a fallback default Sender ID will be used to ensure delivery. See [Get timezones](https://docs.textmagic.com/#tag/Sender-IDs).
	From *string `json:"from,omitempty"`
	// iCal RRULE parameter to create recurrent scheduled messages. When used, sendingTime is mandatory as start point of sending. See https://www.textmagic.com/free-tools/rrule-generator for format details.
	Rrule *string `json:"rrule,omitempty"`
	// Should sending method try to create new Chat (if not exist) with specified recipients?
	CreateChat *bool `json:"createChat,omitempty"`
	// Send a Text-to-Speech message.
	Tts *bool `json:"tts,omitempty"`
	// Treat phone numbers passed in the \\'phones\\' field as local.
	Local *bool `json:"local,omitempty"`
	// The 2-letter ISO country code for local phone numbers, used when \\'local\\' is set to true. Default is the account country.
	LocalCountry *string `json:"localCountry,omitempty"`
	// Messsage destination type allowed [mms, tts].
	Destination *string `json:"destination,omitempty"`
	// File name from mms attachment response (named as resource)
	Resources *string `json:"resources,omitempty"`
}

// NewSendMessageRequest instantiates a new SendMessageRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSendMessageRequest() *SendMessageRequest {
	this := SendMessageRequest{}
	var cutExtra bool = false
	this.CutExtra = &cutExtra
	var createChat bool = false
	this.CreateChat = &createChat
	var tts bool = false
	this.Tts = &tts
	var local bool = false
	this.Local = &local
	return &this
}

// NewSendMessageRequestWithDefaults instantiates a new SendMessageRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSendMessageRequestWithDefaults() *SendMessageRequest {
	this := SendMessageRequest{}
	var cutExtra bool = false
	this.CutExtra = &cutExtra
	var createChat bool = false
	this.CreateChat = &createChat
	var tts bool = false
	this.Tts = &tts
	var local bool = false
	this.Local = &local
	return &this
}

// GetText returns the Text field value if set, zero value otherwise.
func (o *SendMessageRequest) GetText() string {
	if o == nil || IsNil(o.Text) {
		var ret string
		return ret
	}
	return *o.Text
}

// GetTextOk returns a tuple with the Text field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetTextOk() (*string, bool) {
	if o == nil || IsNil(o.Text) {
		return nil, false
	}
	return o.Text, true
}

// HasText returns a boolean if a field has been set.
func (o *SendMessageRequest) HasText() bool {
	if o != nil && !IsNil(o.Text) {
		return true
	}

	return false
}

// SetText gets a reference to the given string and assigns it to the Text field.
func (o *SendMessageRequest) SetText(v string) {
	o.Text = &v
}

// GetTemplateId returns the TemplateId field value if set, zero value otherwise.
func (o *SendMessageRequest) GetTemplateId() int32 {
	if o == nil || IsNil(o.TemplateId) {
		var ret int32
		return ret
	}
	return *o.TemplateId
}

// GetTemplateIdOk returns a tuple with the TemplateId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetTemplateIdOk() (*int32, bool) {
	if o == nil || IsNil(o.TemplateId) {
		return nil, false
	}
	return o.TemplateId, true
}

// HasTemplateId returns a boolean if a field has been set.
func (o *SendMessageRequest) HasTemplateId() bool {
	if o != nil && !IsNil(o.TemplateId) {
		return true
	}

	return false
}

// SetTemplateId gets a reference to the given int32 and assigns it to the TemplateId field.
func (o *SendMessageRequest) SetTemplateId(v int32) {
	o.TemplateId = &v
}

// GetSendingTime returns the SendingTime field value if set, zero value otherwise.
func (o *SendMessageRequest) GetSendingTime() int32 {
	if o == nil || IsNil(o.SendingTime) {
		var ret int32
		return ret
	}
	return *o.SendingTime
}

// GetSendingTimeOk returns a tuple with the SendingTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetSendingTimeOk() (*int32, bool) {
	if o == nil || IsNil(o.SendingTime) {
		return nil, false
	}
	return o.SendingTime, true
}

// HasSendingTime returns a boolean if a field has been set.
func (o *SendMessageRequest) HasSendingTime() bool {
	if o != nil && !IsNil(o.SendingTime) {
		return true
	}

	return false
}

// SetSendingTime gets a reference to the given int32 and assigns it to the SendingTime field.
func (o *SendMessageRequest) SetSendingTime(v int32) {
	o.SendingTime = &v
}

// GetSendingDateTime returns the SendingDateTime field value if set, zero value otherwise.
func (o *SendMessageRequest) GetSendingDateTime() string {
	if o == nil || IsNil(o.SendingDateTime) {
		var ret string
		return ret
	}
	return *o.SendingDateTime
}

// GetSendingDateTimeOk returns a tuple with the SendingDateTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetSendingDateTimeOk() (*string, bool) {
	if o == nil || IsNil(o.SendingDateTime) {
		return nil, false
	}
	return o.SendingDateTime, true
}

// HasSendingDateTime returns a boolean if a field has been set.
func (o *SendMessageRequest) HasSendingDateTime() bool {
	if o != nil && !IsNil(o.SendingDateTime) {
		return true
	}

	return false
}

// SetSendingDateTime gets a reference to the given string and assigns it to the SendingDateTime field.
func (o *SendMessageRequest) SetSendingDateTime(v string) {
	o.SendingDateTime = &v
}

// GetSendingTimezone returns the SendingTimezone field value if set, zero value otherwise.
func (o *SendMessageRequest) GetSendingTimezone() string {
	if o == nil || IsNil(o.SendingTimezone) {
		var ret string
		return ret
	}
	return *o.SendingTimezone
}

// GetSendingTimezoneOk returns a tuple with the SendingTimezone field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetSendingTimezoneOk() (*string, bool) {
	if o == nil || IsNil(o.SendingTimezone) {
		return nil, false
	}
	return o.SendingTimezone, true
}

// HasSendingTimezone returns a boolean if a field has been set.
func (o *SendMessageRequest) HasSendingTimezone() bool {
	if o != nil && !IsNil(o.SendingTimezone) {
		return true
	}

	return false
}

// SetSendingTimezone gets a reference to the given string and assigns it to the SendingTimezone field.
func (o *SendMessageRequest) SetSendingTimezone(v string) {
	o.SendingTimezone = &v
}

// GetContacts returns the Contacts field value if set, zero value otherwise.
func (o *SendMessageRequest) GetContacts() string {
	if o == nil || IsNil(o.Contacts) {
		var ret string
		return ret
	}
	return *o.Contacts
}

// GetContactsOk returns a tuple with the Contacts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetContactsOk() (*string, bool) {
	if o == nil || IsNil(o.Contacts) {
		return nil, false
	}
	return o.Contacts, true
}

// HasContacts returns a boolean if a field has been set.
func (o *SendMessageRequest) HasContacts() bool {
	if o != nil && !IsNil(o.Contacts) {
		return true
	}

	return false
}

// SetContacts gets a reference to the given string and assigns it to the Contacts field.
func (o *SendMessageRequest) SetContacts(v string) {
	o.Contacts = &v
}

// GetLists returns the Lists field value if set, zero value otherwise.
func (o *SendMessageRequest) GetLists() string {
	if o == nil || IsNil(o.Lists) {
		var ret string
		return ret
	}
	return *o.Lists
}

// GetListsOk returns a tuple with the Lists field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetListsOk() (*string, bool) {
	if o == nil || IsNil(o.Lists) {
		return nil, false
	}
	return o.Lists, true
}

// HasLists returns a boolean if a field has been set.
func (o *SendMessageRequest) HasLists() bool {
	if o != nil && !IsNil(o.Lists) {
		return true
	}

	return false
}

// SetLists gets a reference to the given string and assigns it to the Lists field.
func (o *SendMessageRequest) SetLists(v string) {
	o.Lists = &v
}

// GetPhones returns the Phones field value if set, zero value otherwise.
func (o *SendMessageRequest) GetPhones() string {
	if o == nil || IsNil(o.Phones) {
		var ret string
		return ret
	}
	return *o.Phones
}

// GetPhonesOk returns a tuple with the Phones field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetPhonesOk() (*string, bool) {
	if o == nil || IsNil(o.Phones) {
		return nil, false
	}
	return o.Phones, true
}

// HasPhones returns a boolean if a field has been set.
func (o *SendMessageRequest) HasPhones() bool {
	if o != nil && !IsNil(o.Phones) {
		return true
	}

	return false
}

// SetPhones gets a reference to the given string and assigns it to the Phones field.
func (o *SendMessageRequest) SetPhones(v string) {
	o.Phones = &v
}

// GetCutExtra returns the CutExtra field value if set, zero value otherwise.
func (o *SendMessageRequest) GetCutExtra() bool {
	if o == nil || IsNil(o.CutExtra) {
		var ret bool
		return ret
	}
	return *o.CutExtra
}

// GetCutExtraOk returns a tuple with the CutExtra field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetCutExtraOk() (*bool, bool) {
	if o == nil || IsNil(o.CutExtra) {
		return nil, false
	}
	return o.CutExtra, true
}

// HasCutExtra returns a boolean if a field has been set.
func (o *SendMessageRequest) HasCutExtra() bool {
	if o != nil && !IsNil(o.CutExtra) {
		return true
	}

	return false
}

// SetCutExtra gets a reference to the given bool and assigns it to the CutExtra field.
func (o *SendMessageRequest) SetCutExtra(v bool) {
	o.CutExtra = &v
}

// GetPartsCount returns the PartsCount field value if set, zero value otherwise.
func (o *SendMessageRequest) GetPartsCount() int32 {
	if o == nil || IsNil(o.PartsCount) {
		var ret int32
		return ret
	}
	return *o.PartsCount
}

// GetPartsCountOk returns a tuple with the PartsCount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetPartsCountOk() (*int32, bool) {
	if o == nil || IsNil(o.PartsCount) {
		return nil, false
	}
	return o.PartsCount, true
}

// HasPartsCount returns a boolean if a field has been set.
func (o *SendMessageRequest) HasPartsCount() bool {
	if o != nil && !IsNil(o.PartsCount) {
		return true
	}

	return false
}

// SetPartsCount gets a reference to the given int32 and assigns it to the PartsCount field.
func (o *SendMessageRequest) SetPartsCount(v int32) {
	o.PartsCount = &v
}

// GetReferenceId returns the ReferenceId field value if set, zero value otherwise.
func (o *SendMessageRequest) GetReferenceId() int32 {
	if o == nil || IsNil(o.ReferenceId) {
		var ret int32
		return ret
	}
	return *o.ReferenceId
}

// GetReferenceIdOk returns a tuple with the ReferenceId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetReferenceIdOk() (*int32, bool) {
	if o == nil || IsNil(o.ReferenceId) {
		return nil, false
	}
	return o.ReferenceId, true
}

// HasReferenceId returns a boolean if a field has been set.
func (o *SendMessageRequest) HasReferenceId() bool {
	if o != nil && !IsNil(o.ReferenceId) {
		return true
	}

	return false
}

// SetReferenceId gets a reference to the given int32 and assigns it to the ReferenceId field.
func (o *SendMessageRequest) SetReferenceId(v int32) {
	o.ReferenceId = &v
}

// GetFrom returns the From field value if set, zero value otherwise.
func (o *SendMessageRequest) GetFrom() string {
	if o == nil || IsNil(o.From) {
		var ret string
		return ret
	}
	return *o.From
}

// GetFromOk returns a tuple with the From field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetFromOk() (*string, bool) {
	if o == nil || IsNil(o.From) {
		return nil, false
	}
	return o.From, true
}

// HasFrom returns a boolean if a field has been set.
func (o *SendMessageRequest) HasFrom() bool {
	if o != nil && !IsNil(o.From) {
		return true
	}

	return false
}

// SetFrom gets a reference to the given string and assigns it to the From field.
func (o *SendMessageRequest) SetFrom(v string) {
	o.From = &v
}

// GetRrule returns the Rrule field value if set, zero value otherwise.
func (o *SendMessageRequest) GetRrule() string {
	if o == nil || IsNil(o.Rrule) {
		var ret string
		return ret
	}
	return *o.Rrule
}

// GetRruleOk returns a tuple with the Rrule field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetRruleOk() (*string, bool) {
	if o == nil || IsNil(o.Rrule) {
		return nil, false
	}
	return o.Rrule, true
}

// HasRrule returns a boolean if a field has been set.
func (o *SendMessageRequest) HasRrule() bool {
	if o != nil && !IsNil(o.Rrule) {
		return true
	}

	return false
}

// SetRrule gets a reference to the given string and assigns it to the Rrule field.
func (o *SendMessageRequest) SetRrule(v string) {
	o.Rrule = &v
}

// GetCreateChat returns the CreateChat field value if set, zero value otherwise.
func (o *SendMessageRequest) GetCreateChat() bool {
	if o == nil || IsNil(o.CreateChat) {
		var ret bool
		return ret
	}
	return *o.CreateChat
}

// GetCreateChatOk returns a tuple with the CreateChat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetCreateChatOk() (*bool, bool) {
	if o == nil || IsNil(o.CreateChat) {
		return nil, false
	}
	return o.CreateChat, true
}

// HasCreateChat returns a boolean if a field has been set.
func (o *SendMessageRequest) HasCreateChat() bool {
	if o != nil && !IsNil(o.CreateChat) {
		return true
	}

	return false
}

// SetCreateChat gets a reference to the given bool and assigns it to the CreateChat field.
func (o *SendMessageRequest) SetCreateChat(v bool) {
	o.CreateChat = &v
}

// GetTts returns the Tts field value if set, zero value otherwise.
func (o *SendMessageRequest) GetTts() bool {
	if o == nil || IsNil(o.Tts) {
		var ret bool
		return ret
	}
	return *o.Tts
}

// GetTtsOk returns a tuple with the Tts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetTtsOk() (*bool, bool) {
	if o == nil || IsNil(o.Tts) {
		return nil, false
	}
	return o.Tts, true
}

// HasTts returns a boolean if a field has been set.
func (o *SendMessageRequest) HasTts() bool {
	if o != nil && !IsNil(o.Tts) {
		return true
	}

	return false
}

// SetTts gets a reference to the given bool and assigns it to the Tts field.
func (o *SendMessageRequest) SetTts(v bool) {
	o.Tts = &v
}

// GetLocal returns the Local field value if set, zero value otherwise.
func (o *SendMessageRequest) GetLocal() bool {
	if o == nil || IsNil(o.Local) {
		var ret bool
		return ret
	}
	return *o.Local
}

// GetLocalOk returns a tuple with the Local field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetLocalOk() (*bool, bool) {
	if o == nil || IsNil(o.Local) {
		return nil, false
	}
	return o.Local, true
}

// HasLocal returns a boolean if a field has been set.
func (o *SendMessageRequest) HasLocal() bool {
	if o != nil && !IsNil(o.Local) {
		return true
	}

	return false
}

// SetLocal gets a reference to the given bool and assigns it to the Local field.
func (o *SendMessageRequest) SetLocal(v bool) {
	o.Local = &v
}

// GetLocalCountry returns the LocalCountry field value if set, zero value otherwise.
func (o *SendMessageRequest) GetLocalCountry() string {
	if o == nil || IsNil(o.LocalCountry) {
		var ret string
		return ret
	}
	return *o.LocalCountry
}

// GetLocalCountryOk returns a tuple with the LocalCountry field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetLocalCountryOk() (*string, bool) {
	if o == nil || IsNil(o.LocalCountry) {
		return nil, false
	}
	return o.LocalCountry, true
}

// HasLocalCountry returns a boolean if a field has been set.
func (o *SendMessageRequest) HasLocalCountry() bool {
	if o != nil && !IsNil(o.LocalCountry) {
		return true
	}

	return false
}

// SetLocalCountry gets a reference to the given string and assigns it to the LocalCountry field.
func (o *SendMessageRequest) SetLocalCountry(v string) {
	o.LocalCountry = &v
}

// GetDestination returns the Destination field value if set, zero value otherwise.
func (o *SendMessageRequest) GetDestination() string {
	if o == nil || IsNil(o.Destination) {
		var ret string
		return ret
	}
	return *o.Destination
}

// GetDestinationOk returns a tuple with the Destination field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetDestinationOk() (*string, bool) {
	if o == nil || IsNil(o.Destination) {
		return nil, false
	}
	return o.Destination, true
}

// HasDestination returns a boolean if a field has been set.
func (o *SendMessageRequest) HasDestination() bool {
	if o != nil && !IsNil(o.Destination) {
		return true
	}

	return false
}

// SetDestination gets a reference to the given string and assigns it to the Destination field.
func (o *SendMessageRequest) SetDestination(v string) {
	o.Destination = &v
}

// GetResources returns the Resources field value if set, zero value otherwise.
func (o *SendMessageRequest) GetResources() string {
	if o == nil || IsNil(o.Resources) {
		var ret string
		return ret
	}
	return *o.Resources
}

// GetResourcesOk returns a tuple with the Resources field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMessageRequest) GetResourcesOk() (*string, bool) {
	if o == nil || IsNil(o.Resources) {
		return nil, false
	}
	return o.Resources, true
}

// HasResources returns a boolean if a field has been set.
func (o *SendMessageRequest) HasResources() bool {
	if o != nil && !IsNil(o.Resources) {
		return true
	}

	return false
}

// SetResources gets a reference to the given string and assigns it to the Resources field.
func (o *SendMessageRequest) SetResources(v string) {
	o.Resources = &v
}

func (o SendMessageRequest) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o SendMessageRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Text) {
		toSerialize["text"] = o.Text
	}
	if !IsNil(o.TemplateId) {
		toSerialize["templateId"] = o.TemplateId
	}
	if !IsNil(o.SendingTime) {
		toSerialize["sendingTime"] = o.SendingTime
	}
	if !IsNil(o.SendingDateTime) {
		toSerialize["sendingDateTime"] = o.SendingDateTime
	}
	if !IsNil(o.SendingTimezone) {
		toSerialize["sendingTimezone"] = o.SendingTimezone
	}
	if !IsNil(o.Contacts) {
		toSerialize["contacts"] = o.Contacts
	}
	if !IsNil(o.Lists) {
		toSerialize["lists"] = o.Lists
	}
	if !IsNil(o.Phones) {
		toSerialize["phones"] = o.Phones
	}
	if !IsNil(o.CutExtra) {
		toSerialize["cutExtra"] = o.CutExtra
	}
	if !IsNil(o.PartsCount) {
		toSerialize["partsCount"] = o.PartsCount
	}
	if !IsNil(o.ReferenceId) {
		toSerialize["referenceId"] = o.ReferenceId
	}
	if !IsNil(o.From) {
		toSerialize["from"] = o.From
	}
	if !IsNil(o.Rrule) {
		toSerialize["rrule"] = o.Rrule
	}
	if !IsNil(o.CreateChat) {
		toSerialize["createChat"] = o.CreateChat
	}
	if !IsNil(o.Tts) {
		toSerialize["tts"] = o.Tts
	}
	if !IsNil(o.Local) {
		toSerialize["local"] = o.Local
	}
	if !IsNil(o.LocalCountry) {
		toSerialize["localCountry"] = o.LocalCountry
	}
	if !IsNil(o.Destination) {
		toSerialize["destination"] = o.Destination
	}
	if !IsNil(o.Resources) {
		toSerialize["resources"] = o.Resources
	}
	return toSerialize, nil
}

type NullableSendMessageRequest struct {
	value *SendMessageRequest
	isSet bool
}

func (v NullableSendMessageRequest) Get() *SendMessageRequest {
	return v.value
}

func (v *NullableSendMessageRequest) Set(val *SendMessageRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableSendMessageRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableSendMessageRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSendMessageRequest(val *SendMessageRequest) *NullableSendMessageRequest {
	return &NullableSendMessageRequest{value: val, isSet: true}
}

func (v NullableSendMessageRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSendMessageRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


