// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google_libphonenumber/resources/phonenumber.proto

package libphonenumber

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The source from which the country_code is derived. This is not set in the
// general parsing method, but in the method that parses and keeps raw_input.
// New fields could be added upon request.
type PhoneNumber_CountryCodeSource int32

const (
	// Default value returned if this is not set, because the phone number was
	// created using parse, not parseAndKeepRawInput. hasCountryCodeSource will
	// return false if this is the case.
	PhoneNumber_UNSPECIFIED PhoneNumber_CountryCodeSource = 0
	// The country_code is derived based on a phone number with a leading "+",
	// e.g. the French number "+33 1 42 68 53 00".
	PhoneNumber_FROM_NUMBER_WITH_PLUS_SIGN PhoneNumber_CountryCodeSource = 1
	// The country_code is derived based on a phone number with a leading IDD,
	// e.g. the French number "011 33 1 42 68 53 00", as it is dialled from US.
	PhoneNumber_FROM_NUMBER_WITH_IDD PhoneNumber_CountryCodeSource = 5
	// The country_code is derived based on a phone number without a leading
	// "+", e.g. the French number "33 1 42 68 53 00" when defaultCountry is
	// supplied as France.
	PhoneNumber_FROM_NUMBER_WITHOUT_PLUS_SIGN PhoneNumber_CountryCodeSource = 10
	// The country_code is derived NOT based on the phone number itself, but
	// from the defaultCountry parameter provided in the parsing function by the
	// clients. This happens mostly for numbers written in the national format
	// (without country code). For example, this would be set when parsing the
	// French number "01 42 68 53 00", when defaultCountry is supplied as
	// France.
	PhoneNumber_FROM_DEFAULT_COUNTRY PhoneNumber_CountryCodeSource = 20
)

var PhoneNumber_CountryCodeSource_name = map[int32]string{
	0:  "UNSPECIFIED",
	1:  "FROM_NUMBER_WITH_PLUS_SIGN",
	5:  "FROM_NUMBER_WITH_IDD",
	10: "FROM_NUMBER_WITHOUT_PLUS_SIGN",
	20: "FROM_DEFAULT_COUNTRY",
}
var PhoneNumber_CountryCodeSource_value = map[string]int32{
	"UNSPECIFIED":                   0,
	"FROM_NUMBER_WITH_PLUS_SIGN":    1,
	"FROM_NUMBER_WITH_IDD":          5,
	"FROM_NUMBER_WITHOUT_PLUS_SIGN": 10,
	"FROM_DEFAULT_COUNTRY":          20,
}

func (x PhoneNumber_CountryCodeSource) Enum() *PhoneNumber_CountryCodeSource {
	p := new(PhoneNumber_CountryCodeSource)
	*p = x
	return p
}
func (x PhoneNumber_CountryCodeSource) String() string {
	return proto.EnumName(PhoneNumber_CountryCodeSource_name, int32(x))
}
func (x *PhoneNumber_CountryCodeSource) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PhoneNumber_CountryCodeSource_value, data, "PhoneNumber_CountryCodeSource")
	if err != nil {
		return err
	}
	*x = PhoneNumber_CountryCodeSource(value)
	return nil
}
func (PhoneNumber_CountryCodeSource) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{0, 0}
}

type PhoneNumber struct {
	// The country calling code for this number, as defined by the International
	// Telecommunication Union (ITU). For example, this would be 1 for NANPA
	// countries, and 33 for France.
	CountryCode *int32 `protobuf:"varint,1,req,name=country_code,json=countryCode" json:"country_code,omitempty"`
	// The National (significant) Number, as defined in International
	// Telecommunication Union (ITU) Recommendation E.164, without any leading
	// zero. The leading-zero is stored separately if required, since this is an
	// uint64 and hence cannot store such information. Do not use this field
	// directly: if you want the national significant number, call the
	// getNationalSignificantNumber method of PhoneNumberUtil.
	//
	// For countries which have the concept of an "area code" or "national
	// destination code", this is included in the National (significant) Number.
	// Although the ITU says the maximum length should be 15, we have found longer
	// numbers in some countries e.g. Germany.
	// Note that the National (significant) Number does not contain the National
	// (trunk) prefix. Obviously, as a uint64, it will never contain any
	// formatting (hyphens, spaces, parentheses), nor any alphanumeric spellings.
	NationalNumber *uint64 `protobuf:"varint,2,req,name=national_number,json=nationalNumber" json:"national_number,omitempty"`
	// Extension is not standardized in ITU recommendations, except for being
	// defined as a series of numbers with a maximum length of 40 digits. It is
	// defined as a string here to accommodate for the possible use of a leading
	// zero in the extension (organizations have complete freedom to do so, as
	// there is no standard defined). Other than digits, some other dialling
	// characters such as "," (indicating a wait) may be stored here.
	Extension *string `protobuf:"bytes,3,opt,name=extension" json:"extension,omitempty"`
	// In some countries, the national (significant) number starts with one or
	// more "0"s without this being a national prefix or trunk code of some kind.
	// For example, the leading zero in the national (significant) number of an
	// Italian phone number indicates the number is a fixed-line number.  There
	// have been plans to migrate fixed-line numbers to start with the digit two
	// since December 2000, but it has not happened yet. See
	// http://en.wikipedia.org/wiki/%2B39 for more details.
	//
	// These fields can be safely ignored (there is no need to set them) for most
	// countries. Some limited number of countries behave like Italy - for these
	// cases, if the leading zero(s) of a number would be retained even when
	// dialling internationally, set this flag to true, and also set the number of
	// leading zeros.
	//
	// Clients who use the parsing functionality of the i18n phone
	// number libraries will have these fields set if necessary automatically.
	ItalianLeadingZero   *bool  `protobuf:"varint,4,opt,name=italian_leading_zero,json=italianLeadingZero" json:"italian_leading_zero,omitempty"`
	NumberOfLeadingZeros *int32 `protobuf:"varint,8,opt,name=number_of_leading_zeros,json=numberOfLeadingZeros,def=1" json:"number_of_leading_zeros,omitempty"`
	// This field is used to store the raw input string containing phone numbers
	// before it was canonicalized by the library. For example, it could be used
	// to store alphanumerical numbers such as "1-800-GOOG-411".
	RawInput *string `protobuf:"bytes,5,opt,name=raw_input,json=rawInput" json:"raw_input,omitempty"`
	// The source from which the country_code is derived.
	CountryCodeSource *PhoneNumber_CountryCodeSource `protobuf:"varint,6,opt,name=country_code_source,json=countryCodeSource,enum=i18n.phonenumbers.PhoneNumber_CountryCodeSource" json:"country_code_source,omitempty"`
	// The carrier selection code that is preferred when calling this phone number
	// domestically. This also includes codes that need to be dialed in some
	// countries when calling from landlines to mobiles or vice versa. For
	// example, in Columbia, a "3" needs to be dialed before the phone number
	// itself when calling from a mobile phone to a domestic landline phone and
	// vice versa.
	//
	// Note this is the "preferred" code, which means other codes may work as
	// well.
	PreferredDomesticCarrierCode *string `protobuf:"bytes,7,opt,name=preferred_domestic_carrier_code,json=preferredDomesticCarrierCode" json:"preferred_domestic_carrier_code,omitempty"`
	XXX_unrecognized             []byte  `json:"-"`
}

func (m *PhoneNumber) Reset()                    { *m = PhoneNumber{} }
func (m *PhoneNumber) String() string            { return proto.CompactTextString(m) }
func (*PhoneNumber) ProtoMessage()               {}
func (*PhoneNumber) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

const Default_PhoneNumber_NumberOfLeadingZeros int32 = 1

func (m *PhoneNumber) GetCountryCode() int32 {
	if m != nil && m.CountryCode != nil {
		return *m.CountryCode
	}
	return 0
}

func (m *PhoneNumber) GetNationalNumber() uint64 {
	if m != nil && m.NationalNumber != nil {
		return *m.NationalNumber
	}
	return 0
}

func (m *PhoneNumber) GetExtension() string {
	if m != nil && m.Extension != nil {
		return *m.Extension
	}
	return ""
}

func (m *PhoneNumber) GetItalianLeadingZero() bool {
	if m != nil && m.ItalianLeadingZero != nil {
		return *m.ItalianLeadingZero
	}
	return false
}

func (m *PhoneNumber) GetNumberOfLeadingZeros() int32 {
	if m != nil && m.NumberOfLeadingZeros != nil {
		return *m.NumberOfLeadingZeros
	}
	return Default_PhoneNumber_NumberOfLeadingZeros
}

func (m *PhoneNumber) GetRawInput() string {
	if m != nil && m.RawInput != nil {
		return *m.RawInput
	}
	return ""
}

func (m *PhoneNumber) GetCountryCodeSource() PhoneNumber_CountryCodeSource {
	if m != nil && m.CountryCodeSource != nil {
		return *m.CountryCodeSource
	}
	return PhoneNumber_UNSPECIFIED
}

func (m *PhoneNumber) GetPreferredDomesticCarrierCode() string {
	if m != nil && m.PreferredDomesticCarrierCode != nil {
		return *m.PreferredDomesticCarrierCode
	}
	return ""
}

func init() {
	proto.RegisterType((*PhoneNumber)(nil), "i18n.phonenumbers.PhoneNumber")
	proto.RegisterEnum("i18n.phonenumbers.PhoneNumber_CountryCodeSource", PhoneNumber_CountryCodeSource_name, PhoneNumber_CountryCodeSource_value)
}

func init() { proto.RegisterFile("google_libphonenumber/resources/phonenumber.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 428 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x92, 0xd1, 0x6f, 0xd2, 0x50,
	0x14, 0xc6, 0x2d, 0x03, 0x85, 0x83, 0xd9, 0xe0, 0x4a, 0x62, 0xa3, 0xa8, 0xdd, 0x5e, 0xec, 0x53,
	0x37, 0x7c, 0x5a, 0x7c, 0x73, 0x6d, 0x71, 0x4d, 0x58, 0x21, 0x17, 0x1a, 0xa3, 0x2f, 0xd7, 0xae,
	0x3d, 0xe0, 0x4d, 0xca, 0x3d, 0xe4, 0xb6, 0x64, 0xea, 0xbf, 0xe2, 0x1f, 0xe4, 0xbf, 0x65, 0xa0,
	0xb8, 0x75, 0xf0, 0xd8, 0xdf, 0xf7, 0x7d, 0xe7, 0x9c, 0x7e, 0xb9, 0x30, 0x58, 0x10, 0x2d, 0x32,
	0x14, 0x99, 0xbc, 0x5d, 0xfd, 0x20, 0x85, 0x6a, 0xbd, 0xbc, 0x45, 0x7d, 0xae, 0x31, 0xa7, 0xb5,
	0x4e, 0x30, 0x3f, 0xaf, 0x50, 0x67, 0xa5, 0xa9, 0x20, 0xd6, 0x95, 0x83, 0x4b, 0xe5, 0x54, 0x78,
	0x7e, 0xf6, 0xb7, 0x0e, 0xed, 0xc9, 0x06, 0x84, 0x5b, 0xc0, 0x4e, 0xe1, 0x79, 0x42, 0x6b, 0x55,
	0xe8, 0x5f, 0x22, 0xa1, 0x14, 0x4d, 0xc3, 0xaa, 0xd9, 0x0d, 0xde, 0xde, 0x31, 0x97, 0x52, 0x64,
	0xef, 0xe1, 0x44, 0xc5, 0x85, 0x24, 0x15, 0x67, 0xa2, 0x1c, 0x63, 0xd6, 0xac, 0x9a, 0x5d, 0xe7,
	0xc7, 0xff, 0xf1, 0x6e, 0x56, 0x1f, 0x5a, 0xf8, 0xb3, 0x40, 0x95, 0x4b, 0x52, 0xe6, 0x91, 0x65,
	0xd8, 0x2d, 0xfe, 0x00, 0xd8, 0x05, 0xf4, 0x64, 0x11, 0x67, 0x32, 0x56, 0x22, 0xc3, 0x38, 0x95,
	0x6a, 0x21, 0x7e, 0xa3, 0x26, 0xb3, 0x6e, 0x19, 0x76, 0x93, 0xb3, 0x9d, 0x36, 0x2a, 0xa5, 0x6f,
	0xa8, 0x89, 0x5d, 0xc2, 0xcb, 0x72, 0x9f, 0xa0, 0xf9, 0xa3, 0x4c, 0x6e, 0x36, 0x2d, 0xc3, 0x6e,
	0x7c, 0x34, 0x06, 0xbc, 0x57, 0x3a, 0xc6, 0xf3, 0x4a, 0x30, 0x67, 0xaf, 0xa1, 0xa5, 0xe3, 0x3b,
	0x21, 0xd5, 0x6a, 0x5d, 0x98, 0x8d, 0xed, 0x25, 0x4d, 0x1d, 0xdf, 0x05, 0x9b, 0x6f, 0xf6, 0x1d,
	0x5e, 0x54, 0x7f, 0x59, 0x94, 0xfd, 0x99, 0x4f, 0x2d, 0xc3, 0x3e, 0xfe, 0x70, 0xe1, 0x1c, 0x74,
	0xe6, 0x54, 0xfa, 0x72, 0xdc, 0x87, 0x62, 0xa6, 0xdb, 0x1c, 0xef, 0x26, 0xfb, 0x88, 0xf9, 0xf0,
	0x6e, 0xa5, 0x71, 0x8e, 0x5a, 0x63, 0x2a, 0x52, 0x5a, 0x62, 0x5e, 0xc8, 0x44, 0x24, 0xb1, 0xd6,
	0x12, 0x75, 0xd9, 0xf3, 0xb3, 0xed, 0x51, 0xfd, 0x7b, 0x9b, 0xb7, 0x73, 0xb9, 0xa5, 0x69, 0x33,
	0xec, 0xec, 0x8f, 0x01, 0xdd, 0x83, 0x7d, 0xec, 0x04, 0xda, 0x51, 0x38, 0x9d, 0xf8, 0x6e, 0x30,
	0x0c, 0x7c, 0xaf, 0xf3, 0x84, 0xbd, 0x85, 0x57, 0x43, 0x3e, 0xbe, 0x11, 0x61, 0x74, 0x73, 0xe5,
	0x73, 0xf1, 0x25, 0x98, 0x5d, 0x8b, 0xc9, 0x28, 0x9a, 0x8a, 0x69, 0xf0, 0x39, 0xec, 0x18, 0xcc,
	0x84, 0xde, 0x81, 0x1e, 0x78, 0x5e, 0xa7, 0xc1, 0x4e, 0xe1, 0xcd, 0xbe, 0x32, 0x8e, 0x66, 0x95,
	0x30, 0xdc, 0x87, 0x3d, 0x7f, 0xf8, 0x29, 0x1a, 0xcd, 0x84, 0x3b, 0x8e, 0xc2, 0x19, 0xff, 0xda,
	0xe9, 0x5d, 0x59, 0xd0, 0x4f, 0x68, 0xe9, 0x94, 0xaf, 0xf2, 0xb0, 0xb5, 0xeb, 0xa3, 0x7f, 0x01,
	0x00, 0x00, 0xff, 0xff, 0x1b, 0x38, 0x5c, 0x5c, 0xb2, 0x02, 0x00, 0x00,
}
