/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.CollaborationSession;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.CollaborationSessionManager;
import com.paterva.maltego.collab.session.xmpp.PatervaServer;
import com.paterva.maltego.collab.session.xmpp.RegistrationManager;
import com.paterva.maltego.collab.session.xmpp.SessionInitializationStrategy;
import com.paterva.maltego.collab.session.xmpp.XMPPConnectionFactory;
import com.paterva.maltego.collab.session.xmpp.XmppCollaborationConnection;
import com.paterva.maltego.collab.session.xmpp.XmppCollaborationSession;
import com.paterva.maltego.collab.ui.PortInfo;
import com.paterva.maltego.util.NormalException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.XMPPConnection;

public class XmppSessionManager
extends CollaborationSessionManager {
    private static final Logger LOG = Logger.getLogger(XmppSessionManager.class.getName());
    private final Map<String, ConnectionInfo> _connections = new HashMap<String, ConnectionInfo>();

    @Override
    public synchronized CollaborationSession createSession(CollaborationSessionInfo info, ConnectionInitiationCallback cb) throws CollaborationException {
        XMPPConnection cn = null;
        if (info.isUseDefaultServer() || info.isUsePrivatePatervaServer()) {
            cn = this.configureDefaultServerInfo(info, cb, info.isUsePrivatePatervaServer());
        }
        cn = RegistrationManager.getInstance().updateRegistrationInfo(cn, info, cb);
        if (cb.isCancelled()) {
            return null;
        }
        String serverInfo = this.getServerInfo(info);
        ConnectionInfo connectionInfo = this._connections.get(serverInfo);
        if (connectionInfo == null) {
            LOG.log(Level.FINE, "Creating new session for {0}", serverInfo);
            if (cn == null) {
                cn = this.createConfiguration(info);
            }
            XmppCollaborationConnection connection = new XmppCollaborationConnection(cn);
            connectionInfo = new ConnectionInfo(connection);
            this._connections.put(this.getServerInfo(info), connectionInfo);
        } else {
            LOG.log(Level.FINE, "Reusing session for {0}", serverInfo);
        }
        connectionInfo.reference(info.getRoomName());
        return new XmppCollaborationSession(connectionInfo.getConnection(), info);
    }

    protected XMPPConnection createConfiguration(CollaborationSessionInfo info) {
        try {
            return XMPPConnectionFactory.create(info);
        }
        catch (Exception ex) {
            NormalException.showStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public void openSession(CollaborationSession session, ConnectionInitiationCallback cb) throws CollaborationException {
        ((XmppCollaborationSession)session).initialize(this.strategy(cb));
    }

    @Override
    public void configureSession(CollaborationSession session, ConnectionInitiationCallback cb) throws CollaborationException {
        ((XmppCollaborationSession)session).configure(this.strategy(cb));
    }

    @Override
    public void sendSessionID(CollaborationSession session, String id, ConnectionInitiationCallback cb) throws CollaborationException {
        ((XmppCollaborationSession)session).sendSessionID(this.strategy(cb), id);
    }

    private SessionInitializationStrategy strategy(ConnectionInitiationCallback cb) {
        return new SessionInitializationStrategy.InstantChat(cb);
    }

    @Override
    public synchronized void closeSession(CollaborationSession session) throws CollaborationException {
        ((XmppCollaborationSession)session).close();
        String serverInfo = this.getServerInfo(session.getSessionInfo());
        ConnectionInfo info = this._connections.get(serverInfo);
        if (info != null && info.dereference(session.getSessionInfo().getRoomName()) == 0) {
            LOG.log(Level.FINE, "Remove unused session for {0}", serverInfo);
            info.getConnection().disconnect();
            this._connections.remove(serverInfo);
        }
    }

    private String getServerInfo(CollaborationSessionInfo info) {
        return String.format("%s@%s:%d", info.getUsername(), info.getService(), info.getPort());
    }

    private XMPPConnection configureDefaultServerInfo(CollaborationSessionInfo info, ConnectionInitiationCallback cb, boolean isPrivateServer) throws CollaborationException {
        boolean debug = info.isDebugSession();
        String service = isPrivateServer ? "maltego-comms" : PatervaServer.getServerName();
        String server = isPrivateServer ? info.getServer() : PatervaServer.getServerName();
        PortInfo portInfo = PatervaServer.getPortInfo(false);
        XMPPConnection cn = this.connect(cb, service, server, portInfo, debug);
        if (cn == null && (cn = this.connect(cb, service, server, portInfo = PatervaServer.getPortInfo(true), debug)) == null) {
            throw new CollaborationException("Could not connect to server", false);
        }
        info.setService(service);
        info.setServer(server);
        info.setPortInfo(portInfo);
        return cn;
    }

    private XMPPConnection connect(ConnectionInitiationCallback cb, String service, String server, PortInfo portInfo, boolean isDebug) {
        XMPPConnection cn;
        block4: {
            cn = null;
            int port = portInfo.getSelectedPort();
            String msg = String.format("Connecting to %s", service);
            if (port > 0) {
                msg = msg + ":" + port;
            }
            cb.progress(LogMessageLevel.Info, msg);
            try {
                cn = XMPPConnectionFactory.create(service, server, portInfo, isDebug);
                cn.connect();
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
                if (cn == null) break block4;
                cn.disconnect();
            }
        }
        if (cn != null && !cn.isConnected()) {
            cn = null;
        }
        return cn;
    }

    private class ConnectionInfo {
        private final XmppCollaborationConnection _connection;
        private final Set<String> _rooms = new HashSet<String>();

        public ConnectionInfo(XmppCollaborationConnection connection) {
            this._connection = connection;
        }

        public int getReferenceCount() {
            return this._rooms.size();
        }

        public int reference(String roomName) throws CollaborationException {
            if (this._rooms.contains(roomName)) {
                throw new CollaborationException(String.format("Attempting to connect to an existing collaboration session (%s) from the same jabber account.", roomName), false);
            }
            this._rooms.add(roomName);
            return this.getReferenceCount();
        }

        public int dereference(String roomName) {
            this._rooms.remove(roomName);
            return this.getReferenceCount();
        }

        public XmppCollaborationConnection getConnection() {
            return this._connection;
        }
    }
}

