/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.actions;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.Exceptions;

public class UrlReplaceEvaluator {
    private static final Pattern _valuePattern = Pattern.compile("\\$value\\(\\)", 2);
    private static final Pattern _encodePattern = Pattern.compile("(\\$urlencode\\((.*?)\\))", 2);
    private final Evaluator.Replacement _delegate = new Evaluator.Replacement();

    public String evaluate(String formula, DataSource inputs, PropertyDescriptor valueProperty) {
        String result = this.substituteValue(formula, inputs, valueProperty);
        result = this._delegate.evaluate(result, inputs);
        result = this.encode(result);
        return result;
    }

    private String substituteValue(String formula, DataSource inputs, PropertyDescriptor valueProperty) {
        Object value;
        String valueStr = "";
        if (valueProperty != null && (value = inputs.getValue(valueProperty)) != null) {
            valueStr = TypeRegistry.getDefault().getType(valueProperty.getType()).convert(value);
        }
        return _valuePattern.matcher(formula).replaceAll(valueStr);
    }

    private String encode(String formula) {
        int start = 0;
        Matcher matcher = _encodePattern.matcher(formula);
        StringBuilder format = new StringBuilder();
        while (matcher.find()) {
            String pre = formula.substring(start, matcher.start());
            format.append(pre);
            try {
                format.append(URLEncoder.encode(matcher.group(2), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            start = matcher.end();
        }
        String post = formula.substring(start, formula.length());
        format.append(post);
        return format.toString();
    }
}

