/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineProgressMonitor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.feeders.AutomationServerManager;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    private final String PREF_MOVED_MACHINE_ENTITIES = "movedMachineEntities";

    public void restored() {
        this.moveMachineEntitySpecs();
        MachineProgressMonitor.getDefault().start();
        Thread thread = new Thread(() -> {
            try {
                HashSet<String> inputTypes = new HashSet<String>();
                for (MachineDescriptor machineDescriptor : MachineRepository.getDefault().getAll()) {
                    MachineInput input = MachineInputProvider.getDefault().getInputDescriptor(machineDescriptor);
                    inputTypes.addAll(Arrays.asList(input.getSupportedEntityTypes()));
                }
                LOG.log(Level.FINE, "Machine input entity types: {0}", inputTypes);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }, "Machine Warmup");
        thread.start();
    }

    public void close() {
        super.close();
        AutomationServerManager.getDefault().stopAllServers();
    }

    private void moveMachineEntitySpecs() {
        Preferences prefs = NbPreferences.forModule(Installer.class);
        if (!prefs.getBoolean("movedMachineEntities", false)) {
            prefs.putBoolean("movedMachineEntities", true);
            this.moveMachineEntitySpec("maltego.MachineAction");
            this.moveMachineEntitySpec("maltego.FilterAction");
            this.moveMachineEntitySpec("maltego.MachineGlobalInput");
            this.moveMachineEntitySpec("maltego.MachineTransformAction");
            this.moveMachineEntitySpec("maltego.UserFilterAction");
            this.moveMachineEntitySpec("maltego.MachineInfoAction");
            this.removeMachinesDirIfEmpty();
        }
    }

    private void moveMachineEntitySpec(String typeName) {
        EntityRegistry registry = EntityRegistry.getDefault();
        MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(typeName);
        if (spec != null && "Machines".equals(spec.getDefaultCategory())) {
            registry.remove(typeName);
            spec.setDefaultCategory("Personal");
            registry.put((TypeSpec)spec);
        }
    }

    private void removeMachinesDirIfEmpty() {
        FileObject machines = FileUtil.getConfigRoot().getFileObject("Maltego/Entities/Machines");
        if (machines != null && machines.isFolder() && machines.getChildren().length == 0) {
            try {
                machines.delete();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

