/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.PropertySupport;
import com.paterva.maltego.automation.actions.InvertEntityFilter;
import com.paterva.maltego.automation.actions.NumericFilterSupport;
import com.paterva.maltego.automation.actions.ValueUtilities;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;

class PropertyFilter
extends NumericFilterSupport {
    public PropertyFilter() {
        super("property");
    }

    protected String getPropertyName() {
        return this.getValueOrProperty("property", "").toString();
    }

    protected Object getEqualTo() {
        return this.getProperty("equalTo");
    }

    @Override
    protected Payloads.EntityFilter createEntityFilter(AutomationContext ctx, boolean invert) {
        return this.createEntityFilter(ctx, this.getPropertyName(), this.getEqualTo(), this.getMoreThan(), this.getLessThan(), this.getMoreThanOrEqual(), this.getLessThanOrEqual(), invert);
    }

    protected Payloads.EntityFilter createEntityFilter(AutomationContext ctx, String propertyName, Object equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
        return new EntityPropertyFilter(ctx, propertyName, equalTo, moreThan, lessThan, moreThanOrEqual, lessThanOrEqual, invert);
    }

    protected class EntityPropertyFilter
    extends InvertEntityFilter {
        private final Object _equalTo;
        private final Object _like;
        private final Object _matches;
        private final boolean _ignoreCase;
        private final double _moreThan;
        private final double _lessThan;
        private final double _moreThanOrEqual;
        private final double _lessThanOrEqual;
        private PropertyDescriptor _property;
        private EntityRegistry _registry;

        public EntityPropertyFilter(AutomationContext ctx, String propertyName, Object equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
            super(ctx, invert);
            this._matches = PropertyFilter.this.getProperty("matches");
            this._like = PropertyFilter.this.getProperty("like");
            this._equalTo = equalTo;
            this._moreThan = moreThan;
            this._lessThan = lessThan;
            this._moreThanOrEqual = moreThanOrEqual;
            this._lessThanOrEqual = lessThanOrEqual;
            if (propertyName != null) {
                this._property = new PropertyDescriptor(Object.class, propertyName);
            }
            this._ignoreCase = (Boolean)PropertyFilter.this.getProperty("ignoreCase", false);
            this._registry = EntityRegistry.forGraphID((GraphID)ctx.getTargetGraphID());
        }

        public Object getEqualTo() {
            return this._equalTo;
        }

        @Override
        public boolean pass(MaltegoEntity entity) {
            Object value = this.getPropertyValue(entity);
            if (this.useNumericFilter()) {
                double number = PropertySupport.getNumber(value, Double.MIN_VALUE);
                return NumericFilterSupport.check(number, Double.MIN_VALUE, this._moreThan, this._lessThan, this._moreThanOrEqual, this._lessThanOrEqual);
            }
            if (value != null) {
                return ValueUtilities.matches(value, this.getEqualTo(), this.getLike(), this.getMatches(), this.ignoreCase());
            }
            return false;
        }

        public Object getLike() {
            return this._like;
        }

        public Object getMatches() {
            return this._matches;
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this._property;
        }

        public boolean ignoreCase() {
            return this._ignoreCase;
        }

        private Object getPropertyValue(MaltegoEntity entity) {
            if (this.getPropertyDescriptor() == null) {
                return InheritanceHelper.getValue((SpecRegistry)this.getRegistry(), (TypedPropertyBag)entity);
            }
            return entity.getValue(this.getPropertyDescriptor());
        }

        public EntityRegistry getRegistry() {
            return this._registry;
        }

        private String toString(MaltegoEntity entity) {
            Object value = InheritanceHelper.getValue((SpecRegistry)this.getContext().getEntityRegistry(), (TypedPropertyBag)entity);
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        private boolean useNumericFilter() {
            return this._moreThan != Double.MIN_VALUE || this._lessThan != Double.MAX_VALUE;
        }
    }
}

