/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.automation.view.startup.MachineSelectionControl;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.util.ui.CheckListItem;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.WizardDescriptor;

class MachineSelectionController
extends ValidatingController<MachineSelectionControl> {
    MachineSelectionController() {
    }

    protected MachineSelectionControl createComponent() {
        MachineSelectionControl ctrl = new MachineSelectionControl();
        ctrl.addChangeListener(this.changeListener());
        return ctrl;
    }

    protected String getFirstError(MachineSelectionControl component) {
        CheckListItem item = component.getSelectedItem();
        if (item == null) {
            return "Please select a machine to run.";
        }
        return null;
    }

    protected void readSettings(WizardDescriptor descriptor) {
        Collection machines = (Collection)descriptor.getProperty("machines");
        ((MachineSelectionControl)this.component()).setItems(this.getItems(machines));
        Object property = descriptor.getProperty("selectedMachine");
        if (property instanceof MachineDescriptor) {
            MachineDescriptor md = (MachineDescriptor)property;
            CheckListItem cli = this.getItem(MachineInputProvider.getDefault(), EntityRegistry.getDefault(), md);
            ((MachineSelectionControl)this.component()).setSelectedItem(cli);
        }
    }

    protected void storeSettings(WizardDescriptor descriptor) {
        CheckListItem item = ((MachineSelectionControl)this.component()).getSelectedItem();
        if (item != null) {
            descriptor.putProperty("selectedMachine", item.getUserObject());
        }
    }

    private CheckListItem[] getItems(Collection<MachineDescriptor> machines) {
        ArrayList<CheckListItem> items = new ArrayList<CheckListItem>(machines.size());
        MachineInputProvider provider = MachineInputProvider.getDefault();
        EntityRegistry registry = EntityRegistry.getDefault();
        for (MachineDescriptor machine : machines) {
            items.add(this.getItem(provider, registry, machine));
        }
        return items.toArray(new CheckListItem[items.size()]);
    }

    private CheckListItem getItem(MachineInputProvider provider, EntityRegistry registry, MachineDescriptor machine) {
        CheckListItem item = new CheckListItem(machine.getDisplayName(), machine.getDescription(), (Object)machine);
        MachineInput input = provider.getInputDescriptor(machine);
        input.getSupportedEntityTypes();
        item.setNote("[" + this.getEntityNames(registry, input.getSupportedEntityTypes(), 1) + "]");
        return item;
    }

    private String getEntityNames(EntityRegistry registry, String[] types, int max) {
        int count = 0;
        StringBuilder value = new StringBuilder();
        for (String type : types) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(type);
            if (spec != null) {
                value.append(spec.getDisplayName());
                value.append(", ");
                ++count;
            }
            if (count >= max) break;
        }
        if (types.length > count) {
            return "Multiple types";
        }
        if (value.length() >= 2) {
            return value.substring(0, value.length() - 2);
        }
        return "";
    }
}

