/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.profile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.keycloak.common.Profile;
import org.keycloak.common.profile.ProfileConfigResolver;
import org.keycloak.common.profile.ProfileException;

public class PropertiesFileProfileConfigResolver
implements ProfileConfigResolver {
    private Properties properties;

    public PropertiesFileProfileConfigResolver() {
        block7: {
            try {
                File file;
                String jbossServerConfigDir = System.getProperty("jboss.server.config.dir");
                if (jbossServerConfigDir == null || !(file = new File(jbossServerConfigDir, "profile.properties")).isFile()) break block7;
                try (FileInputStream is = new FileInputStream(file);){
                    this.properties = new Properties();
                    this.properties.load(is);
                }
            }
            catch (IOException e) {
                throw new ProfileException("Failed to load profile propeties file", e);
            }
        }
    }

    @Override
    public Profile.ProfileName getProfileName() {
        String profile;
        if (this.properties != null && (profile = this.properties.getProperty("profile")) != null) {
            return Profile.ProfileName.valueOf(profile.toUpperCase());
        }
        return null;
    }

    @Override
    public ProfileConfigResolver.FeatureConfig getFeatureConfig(Profile.Feature feature) {
        String config;
        if (this.properties != null && (config = this.properties.getProperty("feature." + feature.name().toLowerCase())) != null) {
            switch (config) {
                case "enabled": {
                    return ProfileConfigResolver.FeatureConfig.ENABLED;
                }
                case "disabled": {
                    return ProfileConfigResolver.FeatureConfig.DISABLED;
                }
            }
            throw new ProfileException("Invalid config value '" + config + "' for feature " + feature.getKey());
        }
        return ProfileConfigResolver.FeatureConfig.UNCONFIGURED;
    }
}

