/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaModLabelUI;
import com.bulenkov.iconloader.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;

public class DarculaModTextAreaUI
extends BasicTextAreaUI {
    private final JTextArea myTextArea;

    public DarculaModTextAreaUI(JTextArea textArea) {
        this.myTextArea = textArea;
    }

    public static ComponentUI createUI(final JComponent ta) {
        DarculaModTextAreaUI darculaModTextAreaUI = new DarculaModTextAreaUI((JTextArea)ta);
        ta.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ta.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ta.repaint();
            }
        });
        return darculaModTextAreaUI;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        GraphicsUtil.setupTextAntialiasing(g, c);
        super.update(g, c);
    }

    @Override
    protected void paintSafely(Graphics g) {
        if (this.myTextArea.isEnabled() && DarculaModLabelUI.makeDesiredForeground(this.myTextArea, false)) {
            this.myTextArea.setForeground(DarculaModLabelUI.LABEL_DESIRED_FG);
        } else if (DarculaModTextAreaUI.isInStringCustomEditor(this.myTextArea) && !this.myTextArea.isEditable()) {
            this.myTextArea.setForeground(DarculaModLabelUI.LABEL_DESIRED_FG);
        }
        super.paintSafely(g);
    }

    @Override
    protected void paintBackground(Graphics g) {
        g.setColor(this.getBackgroundColor());
        g.fillRect(0, 0, this.myTextArea.getWidth(), this.myTextArea.getHeight());
    }

    private static boolean isInStringCustomEditor(JComponent c) {
        Container parent = c.getParent();
        if (parent != null && (parent = parent.getParent()) != null) {
            return (parent = parent.getParent()) != null && parent.getClass().getName().startsWith("org.netbeans.beaninfo.editors.StringCustomEditor");
        }
        return false;
    }

    public Color getBackgroundColor() {
        Container parent;
        Color color = this.myTextArea.getBackground() == UIManager.getLookAndFeelDefaults().getColor("TextArea.background") ? (this.myTextArea.isEditable() ? this.myTextArea.getBackground() : ((parent = this.myTextArea.getParent()) != null && parent instanceof JComponent ? ((JComponent)parent).getBackground() : new JPanel().getBackground())) : this.myTextArea.getBackground();
        return color;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension d = super.getMinimumSize(c);
        if (!c.isMinimumSizeSet()) {
            d.width = 20;
        }
        return d;
    }
}

