/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.FormattedConverter;
import java.beans.PropertyEditorSupport;
import java.text.Format;
import java.text.ParseException;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

class TypePropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private Class _class;
    private Format _format;
    private PropertyEnv _env;

    public TypePropertyEditor(Class clazz, Format format) {
        if (clazz == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        this._class = clazz;
        this._format = format;
    }

    public Class getType() {
        return this._class;
    }

    @Override
    public String getAsText() {
        return FormattedConverter.convertTo((Object)this.getValue(), (Class)this._class, (Format)this.getFormat());
    }

    @Override
    public void setAsText(String s) {
        try {
            this.setValue(FormattedConverter.convertFrom((String)s, (Class)this._class, (Format)this.getFormat()));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void attachEnv(PropertyEnv env) {
        this._env = env;
    }

    protected void setValid(boolean value) {
        if (this._env != null) {
            this._env.setState(value ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
        }
    }

    public Format getFormat() {
        return this._format;
    }

    public void setFormat(Format format) {
        this._format = format;
    }
}

