/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.actions;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.ui.wizard.ImportFileController;
import com.paterva.maltego.transform.gen.TransformSource;
import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.transforms.tabular.ui.TabularTransformSourceCreator;
import com.paterva.maltego.transforms.tabular.ui.TabularTransformSourceDetailsDisplayer;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class NewTabularTransformSourceAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        ImportFileController controller = new ImportFileController();
        EditDialogDescriptor descriptor = new EditDialogDescriptor((WizardDescriptor.Panel)controller);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (NotifyDescriptor.OK_OPTION.equals(result)) {
            try {
                List files = (List)descriptor.getProperty("files");
                List<String> filesList = files.stream().map(File::getPath).collect(Collectors.toList());
                TabularGraph tabularGraph = controller.getTabularGraph();
                TabularTransformSource txSource = TabularTransformSourceCreator.getDefault().create(tabularGraph, filesList);
                TabularTransformSourceRepository.getInstance().add((Object)txSource);
                new TabularTransformSourceDetailsDisplayer().show((TransformSource)txSource);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

