/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api.impl;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.runner.api.TransformServerSelector;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class RandomTransformServerSelector
extends TransformServerSelector {
    private Random _random = new Random();

    @Override
    public TransformServerInfo selectServer(TransformDefinition transform) {
        Set servers = TransformServerRegistry.getDefault().findServers(transform.getName(), true);
        if (servers.isEmpty()) {
            return null;
        }
        if (servers.size() == 1) {
            return (TransformServerInfo)servers.iterator().next();
        }
        int index = this._random.nextInt(servers.size());
        return RandomTransformServerSelector.getByIndex(servers, index);
    }

    private static TransformServerInfo getByIndex(Collection<TransformServerInfo> servers, int index) {
        Iterator<TransformServerInfo> iterator = servers.iterator();
        TransformServerInfo current = null;
        for (int i = 0; i <= index; ++i) {
            current = iterator.next();
        }
        return current;
    }
}

