/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.finder.wizard.UpdateDisclaimerPanel;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.util.TreeSet;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

class UpdateDisclaimerController
extends ValidatingController<UpdateDisclaimerPanel> {
    private TreeSet<String> disclaimerSet;

    public UpdateDisclaimerController() {
        this.setName("Data Sources T&Cs");
        this.setDescription("Accept Terms & Conditions of the chosen Data Sources to continue");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png".replace(".png", "48.png")));
    }

    protected UpdateDisclaimerPanel createComponent() {
        return new UpdateDisclaimerPanel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSettings(WizardDescriptor settings) {
        try {
            WindowUtil.showWaitCursor();
            DiscoveryResult listings = (DiscoveryResult)settings.getProperty("transformListings");
            this.disclaimerSet = new TreeSet();
            if (listings != null) {
                for (TransformServerListing listing : (TransformServerListing[])listings.getData()) {
                    String disclaimer = listing.getDisclaimer();
                    if (disclaimer == null || disclaimer.trim().isEmpty()) continue;
                    this.disclaimerSet.add(disclaimer);
                }
            }
            UpdateDisclaimerPanel component = (UpdateDisclaimerPanel)((Object)this.component());
            if (this.disclaimerSet.isEmpty()) {
                settings.doNextClick();
            } else {
                component.setAccept(false);
                component.setText(this.disclaimerSet);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    protected void storeSettings(WizardDescriptor settings) {
        UpdateDisclaimerPanel component = (UpdateDisclaimerPanel)((Object)this.component());
        if (component.isAccept()) {
            settings.putProperty("autoAcceptDisclaimers", (Object)true);
        } else {
            settings.putProperty("autoAcceptDisclaimers", (Object)false);
        }
    }

    protected String getFirstError(UpdateDisclaimerPanel component) {
        boolean accept = this.disclaimerSet.isEmpty() || component.isAccept();
        return accept ? null : "Please accept the License Agreement to continue";
    }
}

