/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

public class V3EntityOverlay {
    private final String propertyName;
    private final OverlayPosition position;
    private final OverlayType type;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public V3EntityOverlay(@JsonProperty(value="propertyName", required=true) String propertyName, @JsonProperty(value="position", required=true) OverlayPosition position, @JsonProperty(value="type", required=true) OverlayType type) {
        this.propertyName = propertyName;
        this.position = position;
        this.type = type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public OverlayPosition getPosition() {
        return this.position;
    }

    public OverlayType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3EntityOverlay that = (V3EntityOverlay)o;
        return Objects.equals(this.propertyName, that.propertyName) && this.position == that.position && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.propertyName, this.position, this.type});
    }

    public static enum OverlayPosition {
        N,
        S,
        SW,
        W,
        NW,
        C;

    }

    public static enum OverlayType {
        TEXT("text"),
        IMAGE("image"),
        COLOR("color");

        private final String type;

        private OverlayType(String type) {
            this.type = type;
        }

        @JsonValue
        public String getType() {
            return this.type;
        }

        @JsonCreator
        public static OverlayType fromType(String type) {
            if (type.equalsIgnoreCase("colour")) {
                return COLOR;
            }
            for (OverlayType overlayType : OverlayType.values()) {
                if (!Objects.equals(overlayType.getType(), type)) continue;
                return overlayType;
            }
            throw new IllegalArgumentException("Invalid value for overlay type: " + type);
        }
    }
}

