/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.packet.Authentication;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PacketParserUtils {
    private static final String PROPERTIES_NAMESPACE = "http://www.jivesoftware.com/xmlns/xmpp/properties";

    public static Packet parseMessage(XmlPullParser parser) throws Exception {
        Message message = new Message();
        String id = parser.getAttributeValue("", "id");
        message.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        message.setTo(parser.getAttributeValue("", "to"));
        message.setFrom(parser.getAttributeValue("", "from"));
        message.setType(Message.Type.fromString(parser.getAttributeValue("", "type")));
        String language = PacketParserUtils.getLanguageAttribute(parser);
        String defaultLanguage = null;
        if (language != null && !"".equals(language.trim())) {
            message.setLanguage(language);
            defaultLanguage = language;
        } else {
            defaultLanguage = Packet.getDefaultLanguage();
        }
        boolean done = false;
        String thread = null;
        Map<String, Object> properties = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String xmlLang;
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("subject")) {
                    xmlLang = PacketParserUtils.getLanguageAttribute(parser);
                    if (xmlLang == null) {
                        xmlLang = defaultLanguage;
                    }
                    String subject = PacketParserUtils.parseContent(parser);
                    if (message.getSubject(xmlLang) != null) continue;
                    message.addSubject(xmlLang, subject);
                    continue;
                }
                if (elementName.equals("body")) {
                    xmlLang = PacketParserUtils.getLanguageAttribute(parser);
                    if (xmlLang == null) {
                        xmlLang = defaultLanguage;
                    }
                    String body = PacketParserUtils.parseContent(parser);
                    if (message.getBody(xmlLang) != null) continue;
                    message.addBody(xmlLang, body);
                    continue;
                }
                if (elementName.equals("thread")) {
                    if (thread != null) continue;
                    thread = parser.nextText();
                    continue;
                }
                if (elementName.equals("error")) {
                    message.setError(PacketParserUtils.parseError(parser));
                    continue;
                }
                if (elementName.equals("properties") && namespace.equals(PROPERTIES_NAMESPACE)) {
                    properties = PacketParserUtils.parseProperties(parser);
                    continue;
                }
                message.addExtension(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("message")) continue;
            done = true;
        }
        message.setThread(thread);
        if (properties != null) {
            for (String name : properties.keySet()) {
                message.setProperty(name, properties.get(name));
            }
        }
        return message;
    }

    private static String parseContent(XmlPullParser parser) throws XmlPullParserException, IOException {
        String content = "";
        int parserDepth = parser.getDepth();
        while (parser.next() != 3 || parser.getDepth() != parserDepth) {
            content = content + parser.getText();
        }
        return content;
    }

    public static Presence parsePresence(XmlPullParser parser) throws Exception {
        Presence.Type type = Presence.Type.available;
        String typeString = parser.getAttributeValue("", "type");
        if (typeString != null && !typeString.equals("")) {
            try {
                type = Presence.Type.valueOf(typeString);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Found invalid presence type " + typeString);
            }
        }
        Presence presence = new Presence(type);
        presence.setTo(parser.getAttributeValue("", "to"));
        presence.setFrom(parser.getAttributeValue("", "from"));
        String id = parser.getAttributeValue("", "id");
        presence.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        String language = PacketParserUtils.getLanguageAttribute(parser);
        if (language != null && !"".equals(language.trim())) {
            presence.setLanguage(language);
        }
        presence.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("status")) {
                    presence.setStatus(parser.nextText());
                    continue;
                }
                if (elementName.equals("priority")) {
                    try {
                        int priority = Integer.parseInt(parser.nextText());
                        presence.setPriority(priority);
                    }
                    catch (NumberFormatException nfe) {
                    }
                    catch (IllegalArgumentException iae) {
                        presence.setPriority(0);
                    }
                    continue;
                }
                if (elementName.equals("show")) {
                    String modeText = parser.nextText();
                    try {
                        presence.setMode(Presence.Mode.valueOf(modeText));
                    }
                    catch (IllegalArgumentException iae) {
                        System.err.println("Found invalid presence mode " + modeText);
                    }
                    continue;
                }
                if (elementName.equals("error")) {
                    presence.setError(PacketParserUtils.parseError(parser));
                    continue;
                }
                if (elementName.equals("properties") && namespace.equals(PROPERTIES_NAMESPACE)) {
                    Map<String, Object> properties = PacketParserUtils.parseProperties(parser);
                    for (String name : properties.keySet()) {
                        presence.setProperty(name, properties.get(name));
                    }
                    continue;
                }
                presence.addExtension(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("presence")) continue;
            done = true;
        }
        return presence;
    }

    public static IQ parseIQ(XmlPullParser parser, Connection connection) throws Exception {
        Packet iqPacket = null;
        String id = parser.getAttributeValue("", "id");
        String to = parser.getAttributeValue("", "to");
        String from = parser.getAttributeValue("", "from");
        IQ.Type type = IQ.Type.fromString(parser.getAttributeValue("", "type"));
        XMPPError error = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("error")) {
                    error = PacketParserUtils.parseError(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:auth")) {
                    iqPacket = PacketParserUtils.parseAuthentication(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:roster")) {
                    iqPacket = PacketParserUtils.parseRoster(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:register")) {
                    iqPacket = PacketParserUtils.parseRegistration(parser);
                    continue;
                }
                if (elementName.equals("bind") && namespace.equals("urn:ietf:params:xml:ns:xmpp-bind")) {
                    iqPacket = PacketParserUtils.parseResourceBinding(parser);
                    continue;
                }
                Object provider = ProviderManager.getInstance().getIQProvider(elementName, namespace);
                if (provider == null) continue;
                if (provider instanceof IQProvider) {
                    iqPacket = ((IQProvider)provider).parseIQ(parser);
                    continue;
                }
                if (!(provider instanceof Class)) continue;
                iqPacket = (IQ)PacketParserUtils.parseWithIntrospection(elementName, (Class)provider, parser);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("iq")) continue;
            done = true;
        }
        if (iqPacket == null) {
            if (IQ.Type.GET == type || IQ.Type.SET == type) {
                iqPacket = new IQ(){

                    @Override
                    public String getChildElementXML() {
                        return null;
                    }
                };
                iqPacket.setPacketID(id);
                iqPacket.setTo(from);
                iqPacket.setFrom(to);
                ((IQ)iqPacket).setType(IQ.Type.ERROR);
                iqPacket.setError(new XMPPError(XMPPError.Condition.feature_not_implemented));
                connection.sendPacket(iqPacket);
                return null;
            }
            iqPacket = new IQ(){

                @Override
                public String getChildElementXML() {
                    return null;
                }
            };
        }
        iqPacket.setPacketID(id);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        ((IQ)iqPacket).setType(type);
        iqPacket.setError(error);
        return iqPacket;
    }

    private static Authentication parseAuthentication(XmlPullParser parser) throws Exception {
        Authentication authentication = new Authentication();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("username")) {
                    authentication.setUsername(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("password")) {
                    authentication.setPassword(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("digest")) {
                    authentication.setDigest(parser.nextText());
                    continue;
                }
                if (!parser.getName().equals("resource")) continue;
                authentication.setResource(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        return authentication;
    }

    private static RosterPacket parseRoster(XmlPullParser parser) throws Exception {
        RosterPacket roster = new RosterPacket();
        boolean done = false;
        RosterPacket.Item item = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String groupName;
                if (parser.getName().equals("item")) {
                    String jid = parser.getAttributeValue("", "jid");
                    String name = parser.getAttributeValue("", "name");
                    item = new RosterPacket.Item(jid, name);
                    String ask = parser.getAttributeValue("", "ask");
                    RosterPacket.ItemStatus status = RosterPacket.ItemStatus.fromString(ask);
                    item.setItemStatus(status);
                    String subscription = parser.getAttributeValue("", "subscription");
                    RosterPacket.ItemType type = RosterPacket.ItemType.valueOf(subscription != null ? subscription : "none");
                    item.setItemType(type);
                }
                if (!parser.getName().equals("group") || item == null || (groupName = parser.nextText()) == null || groupName.trim().length() <= 0) continue;
                item.addGroupName(groupName);
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("item")) {
                roster.addRosterItem(item);
            }
            if (!parser.getName().equals("query")) continue;
            done = true;
        }
        return roster;
    }

    private static Registration parseRegistration(XmlPullParser parser) throws Exception {
        Registration registration = new Registration();
        HashMap<String, String> fields = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getNamespace().equals("jabber:iq:register")) {
                    String name = parser.getName();
                    String value = "";
                    if (fields == null) {
                        fields = new HashMap<String, String>();
                    }
                    if (parser.next() == 4) {
                        value = parser.getText();
                    }
                    if (!name.equals("instructions")) {
                        fields.put(name, value);
                        continue;
                    }
                    registration.setInstructions(value);
                    continue;
                }
                registration.addExtension(PacketParserUtils.parsePacketExtension(parser.getName(), parser.getNamespace(), parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        registration.setAttributes(fields);
        return registration;
    }

    private static Bind parseResourceBinding(XmlPullParser parser) throws IOException, XmlPullParserException {
        Bind bind = new Bind();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("resource")) {
                    bind.setResource(parser.nextText());
                    continue;
                }
                if (!parser.getName().equals("jid")) continue;
                bind.setJid(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("bind")) continue;
            done = true;
        }
        return bind;
    }

    public static Collection<String> parseMechanisms(XmlPullParser parser) throws Exception {
        ArrayList<String> mechanisms = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                if (!elementName.equals("mechanism")) continue;
                mechanisms.add(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("mechanisms")) continue;
            done = true;
        }
        return mechanisms;
    }

    public static Collection<String> parseCompressionMethods(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<String> methods = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                if (!elementName.equals("method")) continue;
                methods.add(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("compression")) continue;
            done = true;
        }
        return methods;
    }

    public static Map<String, Object> parseProperties(XmlPullParser parser) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        block2: while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2 && parser.getName().equals("property")) {
                boolean done = false;
                String name = null;
                String type = null;
                String valueText = null;
                Object value = null;
                while (true) {
                    if (done) continue block2;
                    eventType = parser.next();
                    if (eventType == 2) {
                        String elementName = parser.getName();
                        if (elementName.equals("name")) {
                            name = parser.nextText();
                            continue;
                        }
                        if (!elementName.equals("value")) continue;
                        type = parser.getAttributeValue("", "type");
                        valueText = parser.nextText();
                        continue;
                    }
                    if (eventType != 3 || !parser.getName().equals("property")) continue;
                    if ("integer".equals(type)) {
                        value = Integer.valueOf(valueText);
                    } else if ("long".equals(type)) {
                        value = Long.valueOf(valueText);
                    } else if ("float".equals(type)) {
                        value = Float.valueOf(valueText);
                    } else if ("double".equals(type)) {
                        value = Double.valueOf(valueText);
                    } else if ("boolean".equals(type)) {
                        value = Boolean.valueOf(valueText);
                    } else if ("string".equals(type)) {
                        value = valueText;
                    } else if ("java-object".equals(type)) {
                        try {
                            byte[] bytes = StringUtils.decodeBase64(valueText);
                            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                            value = in.readObject();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (name != null && value != null) {
                        properties.put(name, value);
                    }
                    done = true;
                }
            }
            if (eventType == 3 && parser.getName().equals("properties")) break;
        }
        return properties;
    }

    public static SASLMechanism.Failure parseSASLFailure(XmlPullParser parser) throws Exception {
        String condition = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("failure")) continue;
                condition = parser.getName();
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("failure")) continue;
            done = true;
        }
        return new SASLMechanism.Failure(condition);
    }

    public static StreamError parseStreamError(XmlPullParser parser) throws IOException, XmlPullParserException {
        StreamError streamError = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                streamError = new StreamError(parser.getName());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("error")) continue;
            done = true;
        }
        return streamError;
    }

    public static XMPPError parseError(XmlPullParser parser) throws Exception {
        String errorNamespace = "urn:ietf:params:xml:ns:xmpp-stanzas";
        String errorCode = "-1";
        String type = null;
        String message = null;
        String condition = null;
        ArrayList<PacketExtension> extensions = new ArrayList<PacketExtension>();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (parser.getAttributeName(i).equals("code")) {
                errorCode = parser.getAttributeValue("", "code");
            }
            if (!parser.getAttributeName(i).equals("type")) continue;
            type = parser.getAttributeValue("", "type");
        }
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("text")) {
                    message = parser.nextText();
                    continue;
                }
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if ("urn:ietf:params:xml:ns:xmpp-stanzas".equals(namespace)) {
                    condition = elementName;
                    continue;
                }
                extensions.add(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("error")) continue;
            done = true;
        }
        XMPPError.Type errorType = XMPPError.Type.CANCEL;
        try {
            if (type != null) {
                errorType = XMPPError.Type.valueOf(type.toUpperCase());
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        return new XMPPError(Integer.parseInt(errorCode), errorType, condition, message, extensions);
    }

    public static PacketExtension parsePacketExtension(String elementName, String namespace, XmlPullParser parser) throws Exception {
        Object provider = ProviderManager.getInstance().getExtensionProvider(elementName, namespace);
        if (provider != null) {
            if (provider instanceof PacketExtensionProvider) {
                return ((PacketExtensionProvider)provider).parseExtension(parser);
            }
            if (provider instanceof Class) {
                return (PacketExtension)PacketParserUtils.parseWithIntrospection(elementName, (Class)provider, parser);
            }
        }
        DefaultPacketExtension extension = new DefaultPacketExtension(elementName, namespace);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String name = parser.getName();
                if (parser.isEmptyElementTag()) {
                    extension.setValue(name, "");
                    continue;
                }
                eventType = parser.next();
                if (eventType != 4) continue;
                String value = parser.getText();
                extension.setValue(name, value);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals(elementName)) continue;
            done = true;
        }
        return extension;
    }

    private static String getLanguageAttribute(XmlPullParser parser) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeName(i);
            if (!"xml:lang".equals(attributeName) && (!"lang".equals(attributeName) || !"xml".equals(parser.getAttributePrefix(i)))) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }

    public static Object parseWithIntrospection(String elementName, Class objectClass, XmlPullParser parser) throws Exception {
        boolean done = false;
        Object object = objectClass.newInstance();
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String name = parser.getName();
                String stringValue = parser.nextText();
                PropertyDescriptor descriptor = new PropertyDescriptor(name, objectClass);
                Class<?> propertyType = descriptor.getPropertyType();
                Object value = PacketParserUtils.decode(propertyType, stringValue);
                descriptor.getWriteMethod().invoke(object, value);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals(elementName)) continue;
            done = true;
        }
        return object;
    }

    private static Object decode(Class type, String value) throws Exception {
        if (type.getName().equals("java.lang.String")) {
            return value;
        }
        if (type.getName().equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.getName().equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.getName().equals("long")) {
            return Long.valueOf(value);
        }
        if (type.getName().equals("float")) {
            return Float.valueOf(value);
        }
        if (type.getName().equals("double")) {
            return Double.valueOf(value);
        }
        if (type.getName().equals("java.lang.Class")) {
            return Class.forName(value);
        }
        return null;
    }
}

