/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.ui.graph.nodes.SpecActionMenuFactory;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;

public class SpecActionsMenuAction
extends TopGraphEntitySelectionAction
implements Presenter.Popup,
Presenter.Menu {
    private boolean hasActions = true;

    public SpecActionsMenuAction() {
        this.putValue("position", 800);
    }

    @Override
    protected void actionPerformed() {
    }

    public String getName() {
        return "Type Actions";
    }

    public JMenuItem getPopupPresenter() {
        JMenu menu = null;
        GraphID graphID = this.getTopGraphID();
        Set<EntityID> entityIDs = this.getSelectedModelEntities();
        if (!entityIDs.isEmpty()) {
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
            Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID, entityIDs);
            menu = new SpecActionMenuFactory().createMenu(this.getName(), entities, registry);
            if (menu != null) {
                menu.setIcon(new ImageIcon(ImageUtilities.loadImage((String)this.iconResource())));
                this.hasActions = true;
            } else {
                this.hasActions = false;
            }
        }
        return menu;
    }

    public boolean isEnabled() {
        return this.hasActions && super.isEnabled();
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/resources/SpecActions.png";
    }
}

