/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.crypto.util;

import java.util.Arrays;

public final class PKCS7Padding {
    private PKCS7Padding() {
    }

    public static byte[] add(byte[] bytes, int blockSize) {
        byte[] padding = PKCS7Padding.createPadding(bytes, blockSize);
        byte[] paddedBytes = new byte[bytes.length + padding.length];
        System.arraycopy(bytes, 0, paddedBytes, 0, bytes.length);
        System.arraycopy(padding, 0, paddedBytes, bytes.length, padding.length);
        return paddedBytes;
    }

    public static byte[] remove(byte[] bytes) {
        int paddingLength = PKCS7Padding.calculatePaddingLength(bytes);
        return Arrays.copyOfRange(bytes, 0, bytes.length - paddingLength);
    }

    private static byte[] createPadding(byte[] bytes, int blockSize) {
        if (blockSize < 1 || blockSize > 255) {
            throw new IllegalArgumentException("Block size must be between 0 and 256 bytes (exclusive)");
        }
        int paddingLength = blockSize - bytes.length % blockSize;
        byte paddingByte = (byte)paddingLength;
        byte[] padding = new byte[paddingLength];
        Arrays.fill(padding, paddingByte);
        return padding;
    }

    private static int calculatePaddingLength(byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalArgumentException("Bytes must not be empty");
        }
        byte paddingByte = bytes[bytes.length - 1];
        int paddingLength = paddingByte & 0xFF;
        int paddingStartIndex = bytes.length - paddingLength;
        if (paddingLength >= bytes.length) {
            throw new IllegalArgumentException("Padding is corrupted");
        }
        for (int i = paddingStartIndex; i < bytes.length; ++i) {
            if (bytes[i] == paddingByte) continue;
            throw new IllegalArgumentException("Padding is corrupted");
        }
        return paddingLength;
    }
}

