/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import org.officelaf.OfficeTitlePane;
import org.officelaf.OfficeWindowsLookAndFeel;
import org.officelaf.RootPaneLayout;
import org.officelaf.RoundRectangleBorder;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;

public class OfficeRootPaneUI
extends BasicRootPaneUI {
    private static final Logger LOG = Logger.getLogger(OfficeRootPaneUI.class.getName());
    private static final String[] BORDER_KEYS = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private static boolean isFirst = true;
    private Window window;
    private OfficeTitlePane titlePane;
    static OfficeTitlePane titlePaneHolder;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private JRibbon ribbon;
    private static boolean DO_SPECIAL_MAXIMIZE_CHECK;
    private static final int[] CURSOR_MAPPING;

    public OfficeRootPaneUI(JRootPane root) {
        this.root = root;
    }

    public static ComponentUI createUI(JComponent c) {
        return new OfficeRootPaneUI((JRootPane)c);
    }

    private static boolean m_doSpecialMaximizeChecks() {
        if (Utilities.isWindows()) {
            Rectangle bounds = null;
            for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (bounds == null) {
                    bounds = device.getDefaultConfiguration().getBounds();
                    continue;
                }
                Rectangle deviceBounds = device.getDefaultConfiguration().getBounds();
                if (bounds.width == deviceBounds.width && bounds.height == deviceBounds.height) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void installUI(JComponent c) {
        int style;
        super.installUI(c);
        if (isFirst) {
            this.root.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    Frame f;
                    if (OfficeRootPaneUI.this.root == null) {
                        return;
                    }
                    Window w = SwingUtilities.getWindowAncestor(OfficeRootPaneUI.this.root);
                    if (w instanceof Frame && !(f = (Frame)w).isDisplayable() && !f.isUndecorated() && isFirst) {
                        OfficeRootPaneUI.this.root.setWindowDecorationStyle(1);
                        f.setUndecorated(true);
                        if ("mac os x".compareToIgnoreCase(System.getProperty("os.name")) != 0) {
                            f.addComponentListener(!DO_SPECIAL_MAXIMIZE_CHECK ? new DefaultComponentAdapter(f) : new MaximizeCheckComponentAdapter(f));
                        }
                        f.addComponentListener(new MonitorLostAdapter(f));
                        OfficeRootPaneUI.this.root.removeHierarchyListener(this);
                        isFirst = false;
                        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                            @Override
                            public void run() {
                                OfficeRootPaneUI.this.checkOffScreen();
                            }
                        });
                    }
                }
            });
        }
        if ((style = this.root.getWindowDecorationStyle()) != 0) {
            this.installClientDecorations(this.root);
            titlePaneHolder = this.titlePane;
        }
    }

    private void checkOffScreen() throws HeadlessException {
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        GraphicsConfiguration config = mainWindow.getGraphicsConfiguration();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        Rectangle windowBounds = mainWindow.getBounds();
        Rectangle screenBounds = config.getBounds();
        int x = (int)Math.max(windowBounds.getX(), screenBounds.getX() + (double)screenInsets.left);
        int y = (int)Math.max(windowBounds.getY(), screenBounds.getY() + (double)screenInsets.top);
        Point locationBefore = mainWindow.getLocation();
        mainWindow.setLocation(x, y);
        Point locationAfter = mainWindow.getLocation();
        if (!locationBefore.equals(locationAfter)) {
            LOG.log(Level.INFO, "Window bounds: {0}", windowBounds);
            LOG.log(Level.INFO, "Screen bounds: {0}", screenBounds);
            LOG.log(Level.INFO, "Screen insets: {0}", screenInsets);
            LOG.log(Level.INFO, "Adjusted main window to be on-screen from {0} to {1}", new Object[]{locationBefore, locationAfter});
        }
    }

    public static void updateMaximizedBounds(Frame f) throws HeadlessException {
        GraphicsConfiguration conf = f.getGraphicsConfiguration();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(conf);
        if (screenInsets.left == 0 && screenInsets.right == 0 && screenInsets.top == 0 && screenInsets.bottom == 0) {
            f.setMaximizedBounds(null);
        } else {
            Rectangle screenBounds = conf.getBounds();
            Rectangle newBounds = new Rectangle(screenInsets.left, screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom));
            f.setMaximizedBounds(newBounds);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    public void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, BORDER_KEYS[style]);
            int titleHeight = this.titlePane.getPreferredSize().height;
            BorderUIResource border = style == 2 || style == 3 || style == 4 || style == 5 || style == 6 || style == 7 || style == 8 ? new BorderUIResource(new RoundRectangleBorder(0.0f, 0.0f, titleHeight, this.titlePane.getBackgroundImage(), true)) : new BorderUIResource(new RoundRectangleBorder(0.0f, 0.0f, titleHeight, this.titlePane.getBackgroundImage(), false));
            root.setBorder(border);
        }
    }

    private void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void installClientDecorationListeners(JRootPane root) {
        this.window = SwingUtilities.getWindowAncestor(root);
        if (this.window != null) {
            if (this.mouseInputListener != null) {
                this.uninstallClientDecorationListeners(root);
            }
            this.mouseInputListener = this.createMouseInputListener(root);
            root.addMouseListener(this.mouseInputListener);
            root.addMouseMotionListener(this.mouseInputListener);
            this.titlePane.addMouseListener(this.mouseInputListener);
            this.titlePane.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallClientDecorationListeners(JRootPane root) {
        if (this.window != null) {
            root.removeMouseListener(this.mouseInputListener);
            root.removeMouseMotionListener(this.mouseInputListener);
            if (this.titlePane != null) {
                this.titlePane.removeMouseListener(this.mouseInputListener);
                this.titlePane.removeMouseMotionListener(this.mouseInputListener);
            }
        }
    }

    private void installLayout(JRootPane root) {
        this.savedOldLayout = root.getLayout();
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager(this.savedOldLayout);
        }
        root.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        this.setTitlePane(root, this.createTitlePane(root));
        this.installBorder(root);
        this.installClientDecorationListeners(root);
        this.installLayout(root);
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallClientDecorationListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private OfficeTitlePane createTitlePane(JRootPane root) {
        OfficeTitlePane retVal = new OfficeTitlePane(root, this);
        return retVal;
    }

    private MouseInputListener createMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager(LayoutManager delegate) {
        return new RootPaneLayout(delegate);
    }

    private void setTitlePane(JRootPane root, OfficeTitlePane titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        this.titlePane = titlePane;
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
    }

    JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane rootPane = (JRootPane)e.getSource();
            int style = rootPane.getWindowDecorationStyle();
            this.uninstallClientDecorations(rootPane);
            if (style != 0) {
                this.installClientDecorations(rootPane);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallClientDecorationListeners(this.root);
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installClientDecorationListeners(this.root);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(new OfficeWindowsLookAndFeel());
        JFrame frame = new JFrame("Builder Office LAF Test");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(new JMenuItem("Exit"));
        menuBar.add(file);
        frame.setJMenuBar(menuBar);
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBackground(Color.RED);
        JPanel inner = new JPanel();
        inner.setBackground(Color.GREEN);
        contentPane.add((Component)inner, "Center");
        frame.setContentPane(contentPane);
        frame.setVisible(true);
    }

    static {
        DO_SPECIAL_MAXIMIZE_CHECK = OfficeRootPaneUI.m_doSpecialMaximizeChecks();
        CURSOR_MAPPING = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};
    }

    private class MaximizeCheckComponentAdapter
    extends DefaultComponentAdapter {
        public MaximizeCheckComponentAdapter(Frame f) {
            super(f);
            f.addWindowStateListener(new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    if (DO_SPECIAL_MAXIMIZE_CHECK && e.getNewState() != 1) {
                        OfficeRootPaneUI.titlePaneHolder.wasIconified = true;
                        OfficeRootPaneUI.titlePaneHolder.isManualResize = true;
                    }
                }
            });
        }

        @Override
        protected void postMaxResize(Rectangle bounds) {
            if (DO_SPECIAL_MAXIMIZE_CHECK) {
                Rectangle frameBounds = this.f.getBounds();
                if ((bounds.width != frameBounds.width || bounds.height != frameBounds.height) && titlePaneHolder != null) {
                    OfficeRootPaneUI.titlePaneHolder.isManualResize = true;
                    OfficeRootPaneUI.titlePaneHolder.useOverrideState = true;
                    OfficeRootPaneUI.titlePaneHolder.overrideState = 6;
                    if (OfficeRootPaneUI.titlePaneHolder.storedBounds == null) {
                        OfficeRootPaneUI.titlePaneHolder.storedBounds = frameBounds;
                    }
                    this.f.setBounds(bounds);
                    titlePaneHolder.refreshState();
                }
            }
        }

        @Override
        protected void postNormalResize() {
            this.doPeacefullChecking();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            super.componentMoved(e);
            if (DO_SPECIAL_MAXIMIZE_CHECK) {
                if (!OfficeRootPaneUI.titlePaneHolder.wasIconified) {
                    this.doPeacefullChecking();
                } else {
                    OfficeRootPaneUI.titlePaneHolder.wasIconified = false;
                }
            }
        }

        private synchronized void doPeacefullChecking() {
            if (DO_SPECIAL_MAXIMIZE_CHECK && titlePaneHolder != null) {
                if (!OfficeRootPaneUI.titlePaneHolder.isManualResize) {
                    if (OfficeRootPaneUI.titlePaneHolder.useOverrideState) {
                        OfficeRootPaneUI.titlePaneHolder.useOverrideState = false;
                        OfficeRootPaneUI.titlePaneHolder.overrideState = 0;
                        this.adjustBoundToMousePointer(OfficeRootPaneUI.titlePaneHolder.storedBounds);
                        this.f.setBounds(OfficeRootPaneUI.titlePaneHolder.storedBounds);
                        titlePaneHolder.refreshState();
                    } else {
                        OfficeRootPaneUI.titlePaneHolder.storedBounds = this.f.getBounds();
                    }
                } else {
                    OfficeRootPaneUI.titlePaneHolder.isManualResize = false;
                }
            }
        }

        private void adjustBoundToMousePointer(Rectangle frameBounds) {
            Point loc;
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (frameBounds != null && pointerInfo != null && (loc = pointerInfo.getLocation()) != null) {
                int needsToMoveBy;
                int pixelPadding = 5;
                int mouseX = loc.x - pixelPadding;
                int frameX = frameBounds.x;
                if (mouseX < frameX) {
                    needsToMoveBy = frameX - mouseX;
                    frameBounds.x -= needsToMoveBy;
                }
                if ((frameX = frameBounds.x + frameBounds.width) < (mouseX = loc.x + pixelPadding)) {
                    needsToMoveBy = mouseX - frameX;
                    frameBounds.width += needsToMoveBy;
                }
            }
        }
    }

    private class DefaultComponentAdapter
    extends ComponentAdapter {
        protected final Frame f;

        public DefaultComponentAdapter(Frame f) {
            this.f = f;
        }

        @Override
        public synchronized void componentResized(ComponentEvent e) {
            if (this.f.getExtendedState() == 6) {
                GraphicsConfiguration conf = this.f.getGraphicsConfiguration();
                Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(conf);
                Rectangle bounds = conf.getBounds();
                bounds.width -= screenInsets.left + screenInsets.right;
                bounds.height -= screenInsets.top + screenInsets.bottom;
                this.f.setShape(new RoundRectangle2D.Float(0.0f, 0.0f, bounds.width, bounds.height, 0.0f, 0.0f));
                this.postMaxResize(bounds);
            } else {
                this.f.setShape(new RoundRectangle2D.Float(0.0f, 0.0f, this.f.getWidth(), this.f.getHeight(), 0.0f, 0.0f));
                this.postNormalResize();
            }
        }

        protected void postMaxResize(Rectangle bounds) {
        }

        protected void postNormalResize() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            OfficeRootPaneUI.updateMaximizedBounds(this.f);
        }
    }

    private class MonitorLostAdapter
    extends ComponentAdapter {
        private final Frame f;
        private int monitorCount;
        private Timer timer;
        private Rectangle screenDimensions;

        public MonitorLostAdapter(Frame f) {
            this.f = f;
            this.monitorCount = this.getMonitorCount();
            this.screenDimensions = this.getScreenDimensions();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.timer == null) {
                this.timer = new Timer(250, ignored -> {
                    int monitors = this.getMonitorCount();
                    Rectangle dim = this.getScreenDimensions();
                    boolean isWindowDragged = this.isWindowsDragged(e);
                    if (!(isWindowDragged || this.monitorCount == monitors && this.screenDimensions.height == dim.height && this.screenDimensions.width == dim.width)) {
                        this.readjust();
                        this.monitorCount = monitors;
                        this.screenDimensions = dim;
                    }
                    this.timer = null;
                });
                this.timer.setRepeats(false);
                this.timer.start();
            } else {
                this.timer.restart();
            }
        }

        private boolean isWindowsDragged(ComponentEvent e) {
            JFrame frame;
            JLayeredPane pane;
            boolean isWindowDragged = false;
            Object obj = e.getSource();
            if (obj != null && obj instanceof JFrame && (pane = (frame = (JFrame)obj).getLayeredPane()) != null) {
                for (Component component : pane.getComponents()) {
                    if (component == null || !(component instanceof OfficeTitlePane)) continue;
                    OfficeTitlePane otp = (OfficeTitlePane)component;
                    for (MouseListener ml : otp.getMouseListeners()) {
                        if (ml == null || !(ml instanceof MouseInputHandler)) continue;
                        MouseInputHandler mi = (MouseInputHandler)ml;
                        isWindowDragged = mi.isMovingWindow();
                        return isWindowDragged;
                    }
                }
            }
            return isWindowDragged;
        }

        private void readjust() {
            boolean maxed;
            boolean bl = maxed = this.f.getExtendedState() == 6;
            if (Utilities.isWindows()) {
                boolean continueChecks = OfficeRootPaneUI.m_doSpecialMaximizeChecks();
                if (continueChecks != DO_SPECIAL_MAXIMIZE_CHECK) {
                    DO_SPECIAL_MAXIMIZE_CHECK = continueChecks;
                }
                OfficeRootPaneUI.titlePaneHolder.isManualResize = false;
                OfficeRootPaneUI.titlePaneHolder.useOverrideState = false;
                titlePaneHolder.refreshState();
            }
            GraphicsConfiguration config = this.f.getGraphicsConfiguration();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(config);
            Rectangle screenBounds = config.getBounds();
            int x = screenBounds.x + screenInsets.left;
            int y = screenBounds.y + screenInsets.top;
            int width = screenBounds.width - screenInsets.right - screenInsets.left;
            int height = screenBounds.height - screenInsets.bottom - screenInsets.top;
            int horizontal_5 = (int)((double)(width - x) * 0.1);
            int vertical_5 = (int)((double)(height - y) * 0.1);
            x += horizontal_5;
            y += vertical_5;
            width -= horizontal_5 * 2;
            height -= vertical_5 * 2;
            if (maxed) {
                this.f.setExtendedState(0);
                this.f.setBounds(x, y, width, height);
                this.f.setExtendedState(6);
            } else {
                this.f.setBounds(x, y, width, height);
            }
        }

        private int getMonitorCount() {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
        }

        private Rectangle getScreenDimensions() {
            GraphicsConfiguration config = this.f.getGraphicsConfiguration();
            return config.getBounds();
        }

        private Rectangle getScreenDimensionsWithoutInsets() {
            GraphicsConfiguration config = this.f.getGraphicsConfiguration();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(config);
            Rectangle screenBounds = this.getScreenDimensions();
            screenBounds.width -= screenInsets.right + screenInsets.left;
            screenBounds.height -= screenInsets.bottom + screenInsets.top;
            return screenBounds;
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private boolean hasWindowStartedMoving;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = OfficeRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Component source = (Component)ev.getSource();
            Window w = this.windowForEvent(ev);
            if (w != null) {
                w.toFront();
            }
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(source, dragWindowOffset, OfficeRootPaneUI.this.getTitlePane());
            dragWindowOffset = SwingUtilities.convertPoint(source, dragWindowOffset, w);
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int n = frameState = f != null ? f.getExtendedState() : 0;
            if (OfficeRootPaneUI.this.getTitlePane() != null && OfficeRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                if ((f != null && (frameState & 6) == 0 || d != null) && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                }
            } else if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && OfficeRootPaneUI.this.window != null && !OfficeRootPaneUI.this.window.isValid()) {
                OfficeRootPaneUI.this.window.validate();
                OfficeRootPaneUI.this.getRootPane().repaint();
            }
            if (this.hasWindowStartedMoving) {
                GraphicsDevice[] devices;
                Point los = ev.getLocationOnScreen();
                int x = los.x;
                int y = los.y;
                GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (GraphicsDevice device : devices = g.getScreenDevices()) {
                    GraphicsConfiguration conf = device.getDefaultConfiguration();
                    Rectangle bounds = conf.getBounds();
                    if (x < bounds.x || x > bounds.x + bounds.width || y < bounds.y || y > bounds.y + bounds.height) continue;
                    Frame f = WindowUtil.getMainWindow();
                    Rectangle frameBounds = f.getBounds();
                    if (frameBounds.y < bounds.y) {
                        f.setBounds(frameBounds.x, bounds.y, frameBounds.width, frameBounds.height);
                    }
                    if (y < bounds.y || y > bounds.y + 5) break;
                    f.setExtendedState(6);
                    break;
                }
            }
            this.isMovingWindow = false;
            this.hasWindowStartedMoving = false;
            this.dragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            JRootPane root = OfficeRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Component source = (Component)ev.getSource();
            Window w = this.windowForEvent(ev);
            Point pt = SwingUtilities.convertPoint(source, ev.getPoint(), w);
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int cursor = this.getCursor(this.calculateCorner(w, pt.x, pt.y));
            if (cursor != 0 && (f != null && f.isResizable() && (f.getExtendedState() & 6) == 0 || d != null && d.isResizable())) {
                w.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w.setCursor(OfficeRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        private Rectangle adjustBoundToMousePointer(Rectangle frameBounds, int mouseLocX) {
            int needsToMoveBy;
            frameBounds = new Rectangle(frameBounds);
            int pixelPadding = 5;
            int mouseX = mouseLocX - pixelPadding;
            int frameX = frameBounds.x;
            if (mouseX < frameX) {
                needsToMoveBy = frameX - mouseX;
                frameBounds.x -= needsToMoveBy;
                this.dragOffsetX -= needsToMoveBy;
            }
            if ((frameX = frameBounds.x + frameBounds.width) < (mouseX = mouseLocX + pixelPadding)) {
                needsToMoveBy = mouseX - frameX;
                frameBounds.x += needsToMoveBy;
                this.dragOffsetX += needsToMoveBy;
            }
            return frameBounds;
        }

        private boolean checkSource(Frame f, Component source) {
            Container parent;
            if (source instanceof OfficeTitlePane && (parent = source.getParent()) != null && (parent = parent.getParent()) != null) {
                return f == (parent = parent.getParent());
            }
            return false;
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            Component source = (Component)ev.getSource();
            Window w = this.windowForEvent(ev);
            Point pt = SwingUtilities.convertPoint(source, ev.getPoint(), w);
            Frame f = WindowUtil.getMainWindow();
            if (f.getExtendedState() == 6 && this.checkSource(f, source)) {
                f.setExtendedState(0);
                int y = ev.getY();
                MouseEvent mouseEvent = new MouseEvent(source, ev.getID(), System.currentTimeMillis(), ev.getModifiers(), ev.getX(), y < 5 ? 5 : y, ev.getClickCount(), ev.isPopupTrigger());
                Rectangle frameBounds = f.getBounds();
                Rectangle adjustedBounds = this.adjustBoundToMousePointer(frameBounds, ev.getXOnScreen());
                if (!frameBounds.equals(adjustedBounds)) {
                    f.setBounds(adjustedBounds);
                }
                this.mousePressed(mouseEvent);
                this.isMovingWindow = true;
            }
            if (this.isMovingWindow) {
                this.hasWindowStartedMoving = true;
                Point eventLocationOnScreen = ev.getLocationOnScreen();
                int x = eventLocationOnScreen.x - this.dragOffsetX;
                int y = eventLocationOnScreen.y - this.dragOffsetY;
                if (Utilities.isMac()) {
                    GraphicsConfiguration conf = w.getGraphicsConfiguration();
                    Rectangle bounds = conf.getBounds();
                    Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(conf);
                    int insetY = bounds.y + screenInsets.top;
                    if (eventLocationOnScreen.y >= bounds.y && eventLocationOnScreen.y <= insetY || y >= bounds.y && y <= insetY) {
                        y = Math.max(y, insetY);
                    }
                }
                w.setLocation(x, y);
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min = w.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                }
                if (Utilities.isMac()) {
                    Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(w.getGraphicsConfiguration());
                    r.y = Math.max(r.y, screenInsets.top);
                }
                if (!r.equals(startBounds)) {
                    w.setBounds(r.x, r.y, r.width, r.height);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w.validate();
                        OfficeRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            Window w = this.windowForEvent(ev);
            OfficeRootPaneUI.this.lastCursor = w.getCursor();
            this.mouseMoved(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            Window w = this.windowForEvent(ev);
            w.setCursor(OfficeRootPaneUI.this.lastCursor);
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Component source = (Component)ev.getSource();
            Window w = this.windowForEvent(ev);
            if (!(w instanceof Frame)) {
                return;
            }
            Frame f = (Frame)w;
            Point convertedPoint = SwingUtilities.convertPoint(source, ev.getPoint(), OfficeRootPaneUI.this.getTitlePane());
            int state = f.getExtendedState();
            if (OfficeRootPaneUI.this.getTitlePane() != null && OfficeRootPaneUI.this.getTitlePane().contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & 6) != 0) {
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f.setExtendedState(state | 6);
                }
            }
        }

        private int calculateCorner(Window w, int x, int y) {
            Insets insets = w.getInsets();
            int xPosition = this.calculatePosition(x - insets.left, w.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePosition(y - insets.top, w.getHeight() - insets.top - insets.bottom);
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return CURSOR_MAPPING[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }

        private Window windowForEvent(MouseEvent ev) {
            Component source = (Component)ev.getSource();
            return source instanceof Window ? (Window)source : SwingUtilities.getWindowAncestor(source);
        }

        public boolean isMovingWindow() {
            return this.isMovingWindow;
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof OfficeRootPaneUI && (titlePane = ((OfficeRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof OfficeRootPaneUI && (titlePane = ((OfficeRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof OfficeRootPaneUI && (titlePane = ((OfficeRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            OfficeRootPaneUI ui;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof OfficeRootPaneUI && (titlePane = (ui = (OfficeRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null && root.getJMenuBar().isVisible()) {
                JMenuBar menuBar = root.getJMenuBar();
                Dimension mbd = menuBar.getPreferredSize();
                menuBar.setBounds(43, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

