/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.core.ProxySettings;

public class ProxyUtils {
    private static final Logger LOG = Logger.getLogger(ProxyUtils.class.getName());
    private static final String NON_PROXY_HOSTS_DELIMITER = "|";

    public static void addPreferenceChangeListener(PreferenceChangeListener listener) {
    }

    public static String getProxyUrl(String connectionUri) {
        String proxyUrl = null;
        int proxyType = ProxySettings.getProxyType();
        switch (proxyType) {
            case 0: {
                LOG.log(Level.INFO, "Direct connection - No proxy is being used");
                break;
            }
            case 1: {
                LOG.log(Level.WARNING, "Auto-detect proxy is being used - Not supported at present");
                break;
            }
            case 2: {
                LOG.log(Level.INFO, "Manual set proxy is being used");
                if (ProxyUtils.useAuthentication()) {
                    LOG.log(Level.WARNING, "Manual set proxy is being used, but explicit proxy authentication is not supported at present");
                    break;
                }
                String host = ProxySettings.getHttpHost();
                String port = ProxySettings.getHttpPort();
                String httpsHost = ProxySettings.getHttpsHost();
                String httpsPort = ProxySettings.getHttpsPort();
                String nonProxyHosts = ProxySettings.getNonProxyHosts();
                String socksHost = ProxySettings.getSocksHost();
                String socksPort = ProxySettings.getSocksPort();
                if (!(ProxySettings.useProxyAllProtocols() || socksHost == null || socksHost.isEmpty() || socksHost.equals(host) && socksHost.equals(httpsHost))) {
                    LOG.log(Level.WARNING, "Manual set proxy is being used, but socks proxy is not supported at present");
                    break;
                }
                boolean preferHttp = ProxySettings.preferHttpProxyForMaltegoIdRequests();
                try {
                    URL testingUrl = new URL(connectionUri);
                    String testingUrlHost = testingUrl.getHost();
                    String proxyHost = null;
                    String proxyPortString = null;
                    Object nonProxyHosts2 = null;
                    if (preferHttp) {
                        LOG.log(Level.INFO, "Preference for http for Maltego ID auth requests is set");
                    } else {
                        LOG.log(Level.INFO, "Preference for http for Maltego ID auth requests NOT set");
                    }
                    proxyUrl = ProxyUtils.getAnalyzedProxyUrl(connectionUri);
                    if (proxyUrl == null) break;
                    LOG.log(Level.INFO, "proxyUrl (a) = {0}", proxyUrl);
                    boolean isHttps = testingUrl.getProtocol().equals("https") && !preferHttp;
                    proxyHost = ProxySettings.getHttpHost();
                    proxyPortString = ProxySettings.getHttpPort();
                    try {
                        int proxyPort = Integer.parseInt(proxyPortString);
                        String proxyUrl2 = proxyHost + ":" + proxyPort;
                        if (!proxyUrl.equals(proxyUrl2)) break;
                        URI proxyUri = URI.create("http://" + proxyUrl);
                        proxyUrl = proxyUri.toString();
                        LOG.log(Level.INFO, "proxyUrl (b) = {0}", proxyUrl);
                    }
                    catch (Exception ex) {
                        Proxy testingProxy = Proxy.NO_PROXY;
                        proxyUrl = null;
                        LOG.log(Level.INFO, "proxyUrl (c) = {0}", proxyUrl);
                        LOG.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
                catch (AssertionError | Exception ex2) {
                    Proxy testingProxy = Proxy.NO_PROXY;
                    proxyUrl = null;
                    LOG.log(Level.INFO, "proxyUrl (d) = {0}", proxyUrl);
                    LOG.log(Level.WARNING, ((Throwable)ex2).getMessage(), (Throwable)ex2);
                }
                break;
            }
            case 3: {
                LOG.log(Level.WARNING, "Auto-detect PAC - Not supported at present");
                break;
            }
            case 4: {
                LOG.log(Level.WARNING, "Manual set PAC - Not supported at present");
                break;
            }
            default: {
                LOG.log(Level.WARNING, "Invalid proxy type: {0}", proxyType);
            }
        }
        LOG.log(Level.INFO, "proxyUrl (e) = {0}", proxyUrl);
        return proxyUrl;
    }

    private static boolean isNonProxy(String host, String nonProxyHosts) {
        boolean isNonProxy = false;
        if (host != null && nonProxyHosts != null) {
            StringTokenizer st = new StringTokenizer(nonProxyHosts, NON_PROXY_HOSTS_DELIMITER, false);
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(host)) continue;
                isNonProxy = true;
                break;
            }
        }
        return isNonProxy;
    }

    private static String view2code(String view) {
        return view == null ? view : view.replace(", ", NON_PROXY_HOSTS_DELIMITER);
    }

    private static String getAnalyzedProxyUrl(String connectionUri) throws URISyntaxException {
        URI uri = new URI(connectionUri);
        InetSocketAddress sa = ProxyUtils.analyzeProxy(uri);
        String hostnameString = sa == null ? null : sa.getHostString();
        String portString = sa == null ? null : Integer.toString(sa.getPort());
        String proxyUrl = null;
        if (hostnameString != null && !hostnameString.isEmpty() && portString != null && !portString.isEmpty()) {
            try {
                Integer.valueOf(portString);
                proxyUrl = hostnameString + ":" + portString;
            }
            catch (NumberFormatException nfe) {
                LOG.log(Level.WARNING, nfe.getMessage(), nfe);
            }
        } else {
            LOG.log(Level.INFO, "No proxy configured");
        }
        return proxyUrl;
    }

    private static InetSocketAddress analyzeProxy(URI uri) {
        List<Proxy> proxies = ProxySelector.getDefault().select(uri);
        InetSocketAddress sa = null;
        if (!proxies.isEmpty()) {
            Proxy p = proxies.get(0);
            sa = Proxy.Type.DIRECT == p.type() || Proxy.Type.SOCKS == p.type() ? null : (p.address() instanceof InetSocketAddress ? (InetSocketAddress)p.address() : null);
        }
        return sa;
    }

    private static boolean useAuthentication() {
        return ProxySettings.useAuthentication();
    }
}

