/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.icons;

import com.paterva.maltego.imgfactory.icons.IconSelector;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.openide.util.ImageUtilities;

public class ImageBrowserPanel
extends JPanel {
    private final JLabel _imageLabel;
    private final JButton _browseButton;
    private EventListenerList _listeners;
    private IconSize _clipSize = IconSize.MASSIVE;
    private RegistryIcon _icon;

    public ImageBrowserPanel() {
        super(new FlowLayout(0, 0, 0));
        this._imageLabel = new JLabel();
        this._imageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this._browseButton = new JButton("Browse...");
        this.add(this._imageLabel);
        this.add(Box.createHorizontalStrut(10));
        this.add(this._browseButton);
        this._browseButton.addActionListener(__ -> {
            RegistryIcon icon = IconSelector.getDefault().getIcon(this.getClipSize(), this._icon);
            if (icon != null) {
                this.setIcon(icon);
                this.fireImageSelected();
            }
        });
        this.setImage(null);
    }

    public void setIconResource(VirtualIcon icon) {
        RegistryIcon regIcon = IconRegistry.getDefault().findRegistryIcon(icon).orElse(null);
        this.setIcon(regIcon);
    }

    public RegistryIcon getIconResource() {
        return this._icon;
    }

    private void setIcon(RegistryIcon icon) {
        this._icon = icon;
        Image img = this._icon == null ? null : (Image)IconRegistry.getDefault().loadImage(this._icon, this.getClipSize()).orElse(null);
        this.setImage(img);
    }

    private void setImage(Image image) {
        if (image == null) {
            int size = this._clipSize == null ? 0 : this._clipSize.getSize();
            image = size == 16 || size == 24 || size == 32 && size == 48 ? ImageUtilities.loadImage((String)("com/paterva/maltego/util/ui/EmptyImage" + this._clipSize.getSize() + ".png")) : this.resize(ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/EmptyImage48.png"));
        }
        BufferedImage bi = ImageUtils.createBufferedImage((Image)image);
        BufferedImage clipped = ImageUtils.smartClip((BufferedImage)bi, (double)IconSize.MASSIVE.getSize());
        this._imageLabel.setIcon(new ImageIcon(clipped));
    }

    private Image resize(Image image) {
        if (image == null) {
            return null;
        }
        if (this._clipSize == null) {
            return image;
        }
        BufferedImage bi = ImageUtils.createBufferedImage((Image)image);
        BufferedImage clipped = ImageUtils.smartClip((BufferedImage)bi, (double)this._clipSize.getSize());
        return clipped;
    }

    private void fireImageSelected() {
        this.fireActionPerformed(new ActionEvent(this, 0, "imageSelected"));
    }

    private EventListenerList listeners() {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        return this._listeners;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners().add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners().remove(ActionListener.class, listener);
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this._listeners != null) {
            for (ActionListener l : (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
                l.actionPerformed(e);
            }
        }
    }

    public IconSize getClipSize() {
        return this._clipSize;
    }

    public void setClipSize(IconSize clipSize) {
        if (clipSize != this._clipSize) {
            this._clipSize = clipSize;
            this.setIcon(this._icon);
        }
    }
}

