/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.Exceptions;

final class PreviousConfigFileSystem
extends LocalFileSystem {
    private SecretKeySpec _keySpec;
    private IvParameterSpec _ivSpec;
    private String _rootDir;

    public PreviousConfigFileSystem() {
        this(false);
    }

    public PreviousConfigFileSystem(boolean supportRemoveWritablesAttr) {
    }

    public synchronized void setRootDirectory(File r) throws PropertyVetoException, IOException {
        super.setRootDirectory(r);
        this._rootDir = r.getAbsolutePath();
        byte[] key = null;
        byte[] iv = null;
        try {
            key = this.getKey();
            iv = this.getIV();
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this._keySpec = new SecretKeySpec(key, "DESede");
        this._ivSpec = new IvParameterSpec(iv);
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(2, (Key)this._keySpec, this._ivSpec);
            String string = CipherInputStream.class.getName() + cipher;
        }
        catch (GeneralSecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private byte[] getKey() throws UnsupportedEncodingException {
        return this.generateBytes(24, "0nsblYkwEgniNimeld1sleke");
    }

    private byte[] getIV() throws UnsupportedEncodingException {
        return this.generateBytes(8, "b0l@amBr");
    }

    private byte[] generateBytes(int length, String seed) throws UnsupportedEncodingException {
        String paddedDir = this._rootDir + seed;
        byte[] bytes = paddedDir.getBytes("UTF-8");
        byte[] key = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            int n = i % length;
            key[n] = (byte)(key[n] ^ bytes[i]);
        }
        return key;
    }

    protected InputStream inputStream(String name) throws FileNotFoundException {
        InputStream is = super.inputStream(name);
        try {
            if (is != null && !name.startsWith("Modules")) {
                return this.wrap(is);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return is;
    }

    protected OutputStream outputStream(String name) throws IOException {
        OutputStream os = super.outputStream(name);
        try {
            if (os != null && !name.startsWith("Modules")) {
                return this.wrap(os);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return os;
    }

    InputStream wrap(InputStream is) throws Exception {
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        cipher.init(2, (Key)this._keySpec, this._ivSpec);
        return new CipherInputStream(is, cipher){

            @Override
            public void close() throws IOException {
                block2: {
                    try {
                        super.close();
                    }
                    catch (IOException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof BadPaddingException || cause instanceof IllegalBlockSizeException) break block2;
                        throw ex;
                    }
                }
            }
        };
    }

    private OutputStream wrap(OutputStream os) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(this.getKey(), "DESede");
        IvParameterSpec ivSpec = new IvParameterSpec(this.getIV());
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        cipher.init(1, (Key)keySpec, ivSpec);
        return new CipherOutputStream(os, cipher);
    }
}

