/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.api.flamingo;

import com.pinkmatter.api.flamingo.DiscreteResizableIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class ResizableIcons {
    public static final ResizableIcon EMPTY = new Empty();

    private ResizableIcons() {
    }

    public static ResizableIcon fromResource(String resource) {
        return new DiscreteResizableIcon(resource);
    }

    public static ResizableIcon fromImage(Image image) {
        return new ResizableImageIcon(image);
    }

    public static ResizableIcon binary(Icon smallIcon, Icon largeIcon) {
        return new BinaryResizableIcon(smallIcon, largeIcon);
    }

    public static ResizableIcon getEmpty() {
        return EMPTY;
    }

    private static class Empty
    implements ResizableIcon {
        private Empty() {
        }

        public void setDimension(Dimension dmnsn) {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }
    }

    private static class ResizableImageIcon
    extends ImageIcon
    implements ResizableIcon {
        public ResizableImageIcon(Image image) {
            super(image);
        }

        public void setDimension(Dimension dmnsn) {
        }
    }

    private static class BinaryResizableIcon
    implements ResizableIcon {
        private Icon _small;
        private Icon _large;
        private Icon _delegate;
        private int _width;
        private int _height;

        public BinaryResizableIcon(Icon small, Icon large) {
            this._small = small;
            this._large = large;
            if (this._small == null) {
                this._small = large;
            }
            if (this._large == null) {
                this._large = small;
            }
            if (this._small != null) {
                this.setSize(this._small.getIconWidth(), this._small.getIconWidth());
            } else if (this._large != null) {
                this.setSize(this._large.getIconWidth(), this._large.getIconWidth());
            }
        }

        public void setDimension(Dimension size) {
            this.setSize((int)size.getWidth(), (int)size.getHeight());
        }

        private void setSize(int width, int height) {
            if (!(this._small == null && this._large == null || width == this._width && height == this._height)) {
                this._width = width;
                this._height = height;
                this._delegate = this._height > this._small.getIconHeight() + 2 ? this._large : this._small;
            }
        }

        public int getIconHeight() {
            if (this._delegate != null) {
                return this._delegate.getIconHeight();
            }
            return this._height;
        }

        public int getIconWidth() {
            if (this._delegate != null) {
                return this._delegate.getIconWidth();
            }
            return this._width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this._delegate != null) {
                this._delegate.paintIcon(c, g, x, y);
            } else {
                g.setColor(Color.GRAY);
                g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            }
        }
    }
}

