/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.recovery.ui;

import com.maltego.recovery.api.BackupScheduler;
import com.maltego.recovery.ui.BackupPreferences;
import com.maltego.recovery.ui.BackupSerializer;
import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.archive.mtz.MaltegoBackupWriter;
import com.paterva.maltego.core.GraphID;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultBackupScheduler
implements BackupScheduler {
    private static final Logger LOG = Logger.getLogger(DefaultBackupScheduler.class.getName());
    private static final int BACKUP_DELAY = 30;
    private static final int BACKUP_PERIOD = 300;
    private static final TimeUnit BACKUP_TIMEUNIT = TimeUnit.SECONDS;
    private final String graphIDString;
    private final BackupSerializer serializer;
    private ScheduledExecutorService scheduledExecutor;

    public DefaultBackupScheduler(GraphID graphID, GraphFileType fileType) {
        this.serializer = new BackupSerializer(graphID, fileType);
        this.graphIDString = graphID.toString();
    }

    public void setGraphName(String name) {
        this.serializer.setGraphName(name);
    }

    public void setGraphFile(File file) {
        this.serializer.setGraphFile(file);
    }

    public void startBackupSchedule() {
        this.trigger(this.isRecoveryEnabled());
        BackupPreferences.getInstance().addRecoveryEnabledListener(this.graphIDString, this::trigger);
    }

    private boolean isRecoveryEnabled() {
        return BackupPreferences.getInstance().isRecoveryEnabled();
    }

    private void trigger(boolean recoveryEnabled) {
        if (recoveryEnabled) {
            LOG.log(Level.INFO, "Starting the backup schedule for graph: {0}", this.graphIDString);
            this.runScheduler();
        } else {
            LOG.log(Level.INFO, "Stopping the backup schedule for graph: {0}", this.graphIDString);
            this.shutdownScheduler();
        }
    }

    private void runScheduler() {
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        Runnable r = () -> {
            try {
                LOG.log(Level.INFO, "Updating the backup for graph: {0}", this.graphIDString);
                long currentTimeMillis = System.currentTimeMillis();
                this.serializer.updateBackup(() -> {
                    if (this.scheduledExecutor.isShutdown()) {
                        throw new MaltegoBackupWriter.BackupInterruptedException();
                    }
                });
                currentTimeMillis = System.currentTimeMillis() - currentTimeMillis;
                LOG.log(Level.INFO, "Graph: {0} updated in {1} ms", new Object[]{this.graphIDString, currentTimeMillis});
            }
            catch (IOException ex) {
                if (ex.getCause() instanceof MaltegoBackupWriter.BackupInterruptedException) {
                    LOG.log(Level.INFO, "Backup interrupted for graph: {0}", this.graphIDString);
                }
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        };
        this.scheduledExecutor.scheduleWithFixedDelay(r, 30L, 300L, BACKUP_TIMEUNIT);
    }

    public void release() {
        LOG.log(Level.INFO, "Releasing the backup schedule for graph: {0}", this.graphIDString);
        this.shutdownScheduler();
        BackupPreferences.getInstance().removeRecoveryEnabledListener(this.graphIDString);
    }

    private void shutdownScheduler() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            try {
                LOG.log(Level.INFO, "Waiting for termination: {0}", this.graphIDString);
                boolean awaitTermination = this.scheduledExecutor.awaitTermination(10L, BACKUP_TIMEUNIT);
                if (awaitTermination) {
                    LOG.log(Level.INFO, "Scheduler terminated: {0}", this.graphIDString);
                } else {
                    LOG.log(Level.INFO, "Scheduler termination timeout: {0}", this.graphIDString);
                }
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.scheduledExecutor = null;
        }
    }
}

