/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts.link;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.cache.LinkCache;
import com.paterva.maltego.graph.cache.PartCache;
import com.paterva.maltego.graph.store.GraphMods;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.data.sort.PartSortAndFilterInfo;
import com.paterva.maltego.graph.store.data.sort.SortField;
import com.paterva.maltego.graph.store.query.part.LinkDataQuery;
import com.paterva.maltego.graph.store.query.part.LinksDataQuery;
import com.paterva.maltego.graph.store.query.part.PartDataQuery;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.treelist.parts.CachedLazyPartsProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class LinkCachedLazyPartsProvider
extends CachedLazyPartsProvider<LinkID, MaltegoLink> {
    private static final Logger LOG = Logger.getLogger(LinkCachedLazyPartsProvider.class.getName());
    private final String _name;
    private LinkCache _cache = null;
    private GraphListener _graphListener;

    public LinkCachedLazyPartsProvider(String name) {
        this._name = name;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        try {
            GraphID graphID = this.getGraphID();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            this._graphListener = new GraphListener();
            graphStore.addPropertyChangeListener((PropertyChangeListener)this._graphListener);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    protected void removeListeners() {
        try {
            GraphID graphID = this.getGraphID();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.removePropertyChangeListener((PropertyChangeListener)this._graphListener);
            this._graphListener = null;
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        super.removeListeners();
    }

    @Override
    public PartCache<LinkID, MaltegoLink> getCache() {
        if (this._cache == null) {
            this._cache = new LinkCache(this._name, 500);
        }
        return this._cache;
    }

    @Override
    public Map<LinkID, MaltegoLink> getParts(Collection<LinkID> partIDs) {
        Map links = null;
        try {
            GraphDataStoreReader dataReader = this.getDataReader();
            if (dataReader != null) {
                LinkDataQuery linkQuery = new LinkDataQuery();
                linkQuery.setAllProperties(true);
                linkQuery.setAllSections(true);
                LinksDataQuery linksQuery = new LinksDataQuery();
                linksQuery.setIDs(new HashSet<LinkID>(partIDs));
                linksQuery.setPartDataQuery((PartDataQuery)linkQuery);
                links = dataReader.getLinks(linksQuery);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return links != null ? links : Collections.EMPTY_MAP;
    }

    @Override
    public List<LinkID> getSortedFilteredIDs(Collection<LinkID> partIDs, PartSortAndFilterInfo info) {
        LOG.log(Level.FINE, "Sort & filter info: {0}", info);
        List<Object> sortedIDs = Collections.EMPTY_LIST;
        try {
            GraphDataStoreReader dataReader = this.getDataReader();
            if (dataReader != null) {
                LOG.log(Level.FINE, "Unfiltered parts: {0}", partIDs);
                sortedIDs = new ArrayList(dataReader.getFilteredLinks(info.getFilterText(), partIDs));
                LOG.log(Level.FINE, "Unsorted parts: {0}", sortedIDs);
                ArrayList fields = new ArrayList(info.getFields());
                Collections.reverse(fields);
                SortField ascendingDisplaySort = new SortField(0, true);
                if (fields.isEmpty() || !((SortField)fields.iterator().next()).equals((Object)ascendingDisplaySort)) {
                    sortedIDs = dataReader.getSortedLinks(ascendingDisplaySort, sortedIDs);
                }
                for (SortField field : fields) {
                    switch (field.getField()) {
                        case 0: {
                            sortedIDs = dataReader.getSortedLinks(field, sortedIDs);
                            break;
                        }
                        case 2: {
                            sortedIDs = this.sortByEntity(sortedIDs, true, field.isAscending());
                            break;
                        }
                        case 3: {
                            sortedIDs = this.sortByEntity(sortedIDs, false, field.isAscending());
                            break;
                        }
                        default: {
                            LOG.log(Level.SEVERE, "Unknown sort field: {0}", field);
                        }
                    }
                    LOG.log(Level.FINE, "{0} sorted: {1}", new Object[]{field, sortedIDs});
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sortedIDs;
    }

    private List<LinkID> sortByEntity(List<LinkID> ids, boolean source, boolean ascending) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this.getGraphID());
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        Map entityIDs = source ? structureReader.getSources(ids) : structureReader.getTargets(ids);
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        List sortedEntities = dataReader.getSortedEntities(entityIDs.values(), new SortField[]{new SortField(0, ascending)});
        Collections.sort(ids, (o1, o2) -> {
            EntityID o1Entity = (EntityID)entityIDs.get(o1);
            EntityID o2Entity = (EntityID)entityIDs.get(o2);
            int o1Index = sortedEntities.indexOf(o1Entity);
            int o2Index = sortedEntities.indexOf(o2Entity);
            return o1Index - o2Index;
        });
        return ids;
    }

    private class GraphListener
    implements PropertyChangeListener {
        private GraphListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("graphModified".equals(evt.getPropertyName())) {
                GraphStructureMods structureMods;
                GraphMods mods = (GraphMods)evt.getNewValue();
                GraphDataMods dataMods = mods.getDataMods();
                if (dataMods != null) {
                    Map linksUpdated = dataMods.getLinksUpdated();
                    LinkCachedLazyPartsProvider.this.getCache().remove(linksUpdated.keySet());
                }
                if ((structureMods = mods.getStructureMods()) != null) {
                    Map linksRemoved = structureMods.getLinksRemoved();
                    LinkCachedLazyPartsProvider.this.getCache().remove(linksRemoved.keySet());
                }
            }
        }
    }
}

