/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.gui.ColorFactory;

final class RBlank
extends BaseBoundableRenderable {
    public final int ascentPlusLeading;
    private final FontMetrics fontMetrics;

    public RBlank(ModelNode me, FontMetrics fm, RenderableContainer container, int ascentPlusLeading, int width, int height) {
        super(container, me);
        this.fontMetrics = fm;
        this.ascentPlusLeading = ascentPlusLeading;
        this.width = width;
        this.height = height;
    }

    @Override
    protected void invalidateLayoutLocal() {
    }

    @Override
    public boolean onMouseClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseClick(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onDoubleClick(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onMousePressed(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseDown(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseUp(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onMouseDisarmed(MouseEvent event) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseDisarmed(me, event);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paint(Graphics g) {
        Color over;
        int td;
        RenderState rs = this.modelNode.getRenderState();
        Color bkg = rs.getTextBackgroundColor();
        if (bkg != null) {
            Color oldColor = g.getColor();
            try {
                g.setColor(bkg);
                g.fillRect(0, 0, this.width, this.height);
            }
            finally {
                g.setColor(oldColor);
            }
        }
        if ((td = rs.getTextDecorationMask()) != 0) {
            if ((td & 1) != 0) {
                int lineOffset = this.ascentPlusLeading + 2;
                g.drawLine(0, lineOffset, this.width, lineOffset);
            }
            if ((td & 4) != 0) {
                FontMetrics fm = this.fontMetrics;
                int lineOffset = fm.getLeading() + (fm.getAscent() + fm.getDescent()) / 2;
                g.drawLine(0, lineOffset, this.width, lineOffset);
            }
            if ((td & 2) != 0) {
                int lineOffset = this.fontMetrics.getLeading();
                g.drawLine(0, lineOffset, this.width, lineOffset);
            }
            if ((td & 8) != 0) {
                // empty if block
            }
        }
        if ((over = rs.getOverlayColor()) != null) {
            Color oldColor = g.getColor();
            try {
                g.setColor(over);
                g.fillRect(0, 0, this.width, this.height);
            }
            finally {
                g.setColor(oldColor);
            }
        }
    }

    @Override
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        if (this == startPoint.renderable || this == endPoint.renderable ? inSelection : !inSelection) {
            return false;
        }
        RenderState rs = this.modelNode.getRenderState();
        ColorFactory.setupSelection(g, rs);
        g.fillRect(0, 0, this.width, this.height);
        g.setPaintMode();
        return true;
    }

    @Override
    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        if (this == startPoint.renderable || this == endPoint.renderable ? inSelection : !inSelection) {
            return false;
        }
        buffer.append(' ');
        return true;
    }

    @Override
    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        return new RenderableSpot(this, x, y);
    }

    @Override
    public boolean isContainedByNode() {
        return true;
    }

    @Override
    public boolean onRightClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onContextMenu(me, event, x, y);
        }
        return true;
    }
}

