/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;

public class ResourcePermission {
    private final Resource resource;
    private final Collection<Scope> scopes;
    private ResourceServer resourceServer;
    private Map<String, Set<String>> claims;
    private boolean granted;

    public ResourcePermission(Resource resource, Collection<Scope> scopes, ResourceServer resourceServer) {
        this(resource, scopes, resourceServer, null);
    }

    public ResourcePermission(Resource resource, ResourceServer resourceServer, Map<String, ? extends Collection<String>> claims) {
        this(resource, new LinkedHashSet<Scope>(), resourceServer, claims);
    }

    public ResourcePermission(Resource resource, Collection<Scope> scopes, ResourceServer resourceServer, Map<String, ? extends Collection<String>> claims) {
        this.resource = resource;
        this.scopes = scopes;
        this.resourceServer = resourceServer;
        if (claims != null) {
            this.claims = new HashMap<String, Set<String>>();
            for (Map.Entry<String, ? extends Collection<String>> entry : claims.entrySet()) {
                this.claims.computeIfAbsent(entry.getKey(), key -> new LinkedHashSet()).addAll(entry.getValue());
            }
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public Collection<Scope> getScopes() {
        return this.scopes;
    }

    public ResourceServer getResourceServer() {
        return this.resourceServer;
    }

    public Map<String, Set<String>> getClaims() {
        if (this.claims == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.claims);
    }

    public boolean addClaim(String name, String value) {
        if (this.claims == null) {
            this.claims = new HashMap<String, Set<String>>();
        }
        return this.claims.computeIfAbsent(name, key -> new HashSet()).add(value);
    }

    public void removeClaim(String name) {
        if (this.claims != null) {
            this.claims.remove(name);
        }
    }

    public void addScope(Scope scope) {
        if (this.resource != null && !this.resource.getScopes().contains(scope)) {
            return;
        }
        if (!this.scopes.contains(scope)) {
            this.scopes.add(scope);
        }
    }

    public void addClaims(Map<String, Set<String>> claims) {
        if (this.claims == null) {
            this.claims = new HashMap<String, Set<String>>();
        }
        this.claims.putAll(claims);
    }

    public void setGranted(boolean granted) {
        this.granted = granted;
    }

    public boolean isGranted() {
        return this.granted;
    }
}

