/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.Status;
import com.paterva.maltego.transform.descriptor.StealthLevel;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HubTransformDefinitionProxy
extends TransformDefinition {
    private final TransformDefinition _delegate;
    private final List<HubSeedDescriptor> _hubSeeds;
    private final DisplayDescriptorCollection _properties;
    private final Map<PropertyDescriptor, DataSource> _data;

    HubTransformDefinitionProxy(TransformDefinition transform, TransformServerInfo server) {
        super((TransformDescriptor)transform, (TransformSettings)transform);
        this._delegate = transform;
        this._hubSeeds = HubSeedRegistry.getDefault().getHubSeeds(server);
        this._properties = new DisplayDescriptorList();
        this._data = new HashMap<PropertyDescriptor, DataSource>();
        HubSeedSettings settings = HubSeedSettings.getDefault();
        DisplayDescriptorCollection txProperties = this._delegate.getProperties();
        for (HubSeedDescriptor hubSeed : this._hubSeeds) {
            DataSource dataSource = settings.getGlobalTransformSettings(hubSeed);
            DisplayDescriptorCollection hubProperties = settings.getGlobalTransformProperties(hubSeed);
            if (hubProperties == null) continue;
            for (DisplayDescriptor hubProperty : hubProperties) {
                if (hubProperty == null || this._properties.contains(hubProperty) || !txProperties.contains(hubProperty.getName())) continue;
                this._properties.add(hubProperty);
                this._data.put((PropertyDescriptor)hubProperty, dataSource);
            }
        }
        for (DisplayDescriptor property : txProperties) {
            if (property == null || this._properties.contains(property)) continue;
            this._properties.add(property);
            this._data.put((PropertyDescriptor)property, (DataSource)this._delegate);
        }
    }

    public DisplayDescriptorCollection getProperties() {
        return this._properties;
    }

    public DisplayDescriptorCollection getPopupProperties(DataSource additionalValues) {
        DisplayDescriptorList popups = new DisplayDescriptorList();
        for (DisplayDescriptor dd : this.getProperties()) {
            if (dd == null || !this.showPopup((PropertyDescriptor)dd, additionalValues)) continue;
            popups.add(dd);
        }
        return popups;
    }

    private boolean showPopup(PropertyDescriptor descriptor, DataSource additionalValues) {
        if (descriptor == null || descriptor.isHidden()) {
            return false;
        }
        Popup value = this._delegate.getPopup(descriptor);
        if (value == Popup.Yes) {
            return true;
        }
        DisplayDescriptor dd = this.getProperties().get(descriptor.getName());
        if (dd != null) {
            String propName = dd.getName();
            if (propName.toLowerCase().startsWith("global#") || dd instanceof TransformPropertyDescriptor && ((TransformPropertyDescriptor)dd).isGlobal()) {
                return !dd.isNullable() && this.isNull(additionalValues.getValue(descriptor));
            }
            return !dd.isNullable() && this.isNull(this.getValue((PropertyDescriptor)dd)) && this.isNull(additionalValues.getValue(descriptor));
        }
        return true;
    }

    public Object getValue(PropertyDescriptor descriptor) {
        DataSource dataSource = this._data.get(descriptor);
        if (dataSource != null) {
            DisplayDescriptor dd;
            Object value = dataSource.getValue(descriptor);
            if (value == null && (dd = this.getProperties().get(descriptor.getName())) != null) {
                return dd.getDefaultValue();
            }
            return value;
        }
        return null;
    }

    public void setValue(PropertyDescriptor descriptor, Object value) {
        DataSource dataSource = this._data.get(descriptor);
        if (dataSource != null) {
            dataSource.setValue(descriptor, value);
            if (!dataSource.equals(this._delegate)) {
                HubSeedSettings settings = HubSeedSettings.getDefault();
                this._hubSeeds.forEach(arg_0 -> ((HubSeedSettings)settings).save(arg_0));
                this.disablePopupForAllTransformsWithGlobalInput(descriptor);
            }
        }
    }

    private void disablePopupForAllTransformsWithGlobalInput(PropertyDescriptor descriptor) {
        HubSeedRegistry registry = HubSeedRegistry.getDefault();
        this._hubSeeds.stream().flatMap(hubSeed -> registry.getTransforms(hubSeed).stream()).filter(transform -> transform.getProperties().get(descriptor.getName()) != null).forEach(transform -> transform.setPopup(descriptor, Popup.No));
    }

    public Popup getPopup(PropertyDescriptor descriptor) {
        return this._delegate.getPopup(descriptor);
    }

    public void setPopup(PropertyDescriptor descriptor, Popup value) {
        this._delegate.setPopup(descriptor, value);
    }

    public Visibility getVisibility(PropertyDescriptor descriptor) {
        return this._delegate.getVisibility(descriptor);
    }

    public void setVisibility(PropertyDescriptor descriptor, Visibility mode) {
        this._delegate.setVisibility(descriptor, mode);
    }

    public boolean isEnabled() {
        return this._delegate.isEnabled();
    }

    public void setEnabled(boolean value) {
        this._delegate.setEnabled(value);
    }

    public boolean isDisclaimerAccepted() {
        return this._delegate.isDisclaimerAccepted();
    }

    public void setDisclaimerAccepted(boolean value) {
        this._delegate.setDisclaimerAccepted(value);
    }

    public boolean showHelp() {
        return this._delegate.showHelp();
    }

    public void setShowHelp(boolean value) {
        this._delegate.setShowHelp(value);
    }

    public Status getStatus() {
        return this._delegate.getStatus();
    }

    public String getHtmlDisplayName() {
        return this._delegate.getHtmlDisplayName();
    }

    public String getRepositoryName() {
        return this._delegate.getRepositoryName();
    }

    public void setRepositoryName(String repositoryName) {
        this._delegate.setRepositoryName(repositoryName);
    }

    public boolean isRunWithAll() {
        return this._delegate.isRunWithAll();
    }

    public void setRunWithAll(boolean runWithAll) {
        this._delegate.setRunWithAll(runWithAll);
    }

    public boolean isFavorite() {
        return this._delegate.isFavorite();
    }

    public void setFavorite(boolean favorite) {
        this._delegate.setFavorite(favorite);
    }

    public int hashCode() {
        return this._delegate.hashCode();
    }

    public boolean equals(TransformDefinition td) {
        return this._delegate.equals(td);
    }

    public boolean equals(Object obj) {
        return this._delegate.equals(obj);
    }

    public boolean isDirty() {
        return this._delegate.isDirty();
    }

    public void markClean() {
        this._delegate.markClean();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._delegate.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._delegate.removePropertyChangeListener(pcl);
    }

    public String getName() {
        return this._delegate.getName();
    }

    public String toString() {
        return this._delegate.toString();
    }

    public String getBaseName() {
        return this._delegate.getBaseName();
    }

    public void setBaseName(String uniqueName) {
        this._delegate.setBaseName(uniqueName);
    }

    public Constraint getInputConstraint() {
        return this._delegate.getInputConstraint();
    }

    public void setInputConstraint(Constraint c) {
        this._delegate.setInputConstraint(c);
    }

    public Set<String> getOutputEntities() {
        return this._delegate.getOutputEntities();
    }

    public boolean isAbstract() {
        return this._delegate.isAbstract();
    }

    public void setAbstract(boolean value) {
        this._delegate.setAbstract(value);
    }

    public String getDisplayName() {
        return this._delegate.getDisplayName();
    }

    public void setDisplayName(String displayName) {
        this._delegate.setDisplayName(displayName);
    }

    public String getDescription() {
        return this._delegate.getDescription();
    }

    public void setDescription(String description) {
        this._delegate.setDescription(description);
    }

    public String getHelpUrl() {
        return this._delegate.getHelpUrl();
    }

    public void setHelpUrl(String helpUrl) {
        this._delegate.setHelpUrl(helpUrl);
    }

    public String getHelpText() {
        return this._delegate.getHelpText();
    }

    public void setHelpText(String helpText) {
        this._delegate.setHelpText(helpText);
    }

    public String getAuthor() {
        return this._delegate.getAuthor();
    }

    public void setAuthor(String author) {
        this._delegate.setAuthor(author);
    }

    public String getOwner() {
        return this._delegate.getOwner();
    }

    public void setOwner(String owner) {
        this._delegate.setOwner(owner);
    }

    public String getDisclaimer() {
        return this._delegate.getDisclaimer();
    }

    public void setDisclaimer(String disclaimer) {
        this._delegate.setDisclaimer(disclaimer);
    }

    public String getLocationRelevance() {
        return this._delegate.getLocationRelevance();
    }

    public void setLocationRelevance(String locationRelevance) {
        this._delegate.setLocationRelevance(locationRelevance);
    }

    public String getVersion() {
        return this._delegate.getVersion();
    }

    public void setVersion(String version) {
        this._delegate.setVersion(version);
    }

    public String[] getDefaultSets() {
        return this._delegate.getDefaultSets();
    }

    public void setDefaultSets(String[] defaultSets) {
        this._delegate.setDefaultSets(defaultSets);
    }

    public boolean isRequireDisplayInfo() {
        return this._delegate.isRequireDisplayInfo();
    }

    public void setRequireDisplayInfo(boolean requireDisplayInfo) {
        this._delegate.setRequireDisplayInfo(requireDisplayInfo);
    }

    public StealthLevel getStealthLevel() {
        return this._delegate.getStealthLevel();
    }

    public void setStealthLevel(StealthLevel stealthLevel) {
        this._delegate.setStealthLevel(stealthLevel);
    }

    public boolean isTemplate() {
        return this._delegate.isTemplate();
    }

    public void setTemplate(boolean template) {
        this._delegate.setTemplate(template);
    }

    public Visibility getVisibility() {
        return this._delegate.getVisibility();
    }

    public void setVisibility(Visibility visibility) {
        this._delegate.setVisibility(visibility);
    }

    public boolean equals(TransformDescriptor td) {
        return this._delegate.equals(td);
    }

    public ProtocolVersion getProtocolVersion() {
        return this._delegate.getProtocolVersion();
    }

    public int compareTo(TransformDescriptor o) {
        return this._delegate.compareTo(o);
    }

    public MatchingRuleDescriptor getMatchingRule() {
        return this._delegate.getMatchingRule();
    }

    public void setMatchingRule(MatchingRuleDescriptor rule) {
        this._delegate.setMatchingRule(rule);
    }

    public String getAuthenticator() {
        return this._delegate.getAuthenticator();
    }

    public void setAuthenticator(String authenticator) {
        this._delegate.setAuthenticator(authenticator);
    }

    public boolean isCopy(TransformDescriptor descriptor) {
        return this._delegate.isCopy(descriptor);
    }

    private boolean isNull(Object o) {
        if (o instanceof String) {
            return StringUtilities.isNullOrEmpty((String)((String)o));
        }
        return o == null;
    }
}

