/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.TransformMessageWindow;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformSpecialMessageHandler;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.HtmlUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.components.SmoothScrollingEditorPane;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

public class UITransformSpecialMessageHandler
implements TransformSpecialMessageHandler {
    private static final String EXIT_BUTTON_ID = "exit";
    private static final String DISMISS_BUTTON_ID = "dismiss";
    private static boolean _isHandlingMessage = false;

    public boolean handle(TransformRunContext ctx, TransformMessage message) {
        Args.notNull((Object)ctx, (String)"ctx");
        Args.notNull((Object)message, (String)"message");
        if (message.getCode() >= 201 && message.getCode() < 300) {
            SwingUtilities.invokeLater(() -> this.showSpecialMessageDialog(ctx, message));
            TransformMessageWindow.getDefault().write(message);
            return true;
        }
        return false;
    }

    private void showSpecialMessageDialog(TransformRunContext ctx, TransformMessage message) {
        if (_isHandlingMessage) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be called in EDT");
        }
        _isHandlingMessage = true;
        this.show(message);
        _isHandlingMessage = false;
    }

    public void show(TransformMessage message) {
        TransformMessage.MessageButton buttonPressed;
        DialogDescriptor descriptor = this.createDialogDescriptor(message);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setMinimumSize(dialog.getPreferredSize());
        dialog.setVisible(true);
        Object value = descriptor.getValue();
        if (value instanceof TransformMessage.MessageButton && (buttonPressed = (TransformMessage.MessageButton)value).getUrl().isPresent()) {
            String urlStr = (String)buttonPressed.getUrl().get();
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(urlStr));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private DialogDescriptor createDialogDescriptor(TransformMessage message) {
        String title = message.getSeverity().toString();
        boolean modal = true;
        JScrollPane scrollPane = this.createComponent(message);
        Object[] buttons = this.getButtons(message);
        DialogDescriptor descriptor = new DialogDescriptor((Object)scrollPane, title, modal, buttons, (Object)buttons[0], 0, HelpCtx.DEFAULT_HELP, null);
        descriptor.setClosingOptions(buttons);
        return descriptor;
    }

    private JScrollPane createComponent(TransformMessage message) {
        SmoothScrollingEditorPane editorPane = new SmoothScrollingEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        editorPane.setFocusable(false);
        String text = message.getText().trim();
        int maxWidth = 550;
        float fontSize = FontUtils.defaultScaled((float)-1.0f).getSize();
        FontMetrics fm = editorPane.getFontMetrics(editorPane.getFont().deriveFont(1).deriveFont(fontSize));
        int lineCount = this.getLineCount(text, fm, (JEditorPane)editorPane, maxWidth);
        text = text.replaceAll("\\r?\\n", "<br> \n");
        String clickableText = HtmlUtils.getClickableText((String)text, (FontMetrics)fm, (Insets)editorPane.getInsets(), (int)maxWidth, (boolean)true);
        text = "<html><head><style>h4{font-size:" + (fontSize + 1.0f) + "px;}</style></head><body style='font-size:" + fontSize + "px'>" + clickableText + "</body></html>";
        editorPane.setText(text);
        editorPane.setCaretPosition(0);
        editorPane.addHyperlinkListener(evt -> HtmlUtils.registerHyperlinkEvents((HyperlinkEvent)evt));
        JPanel viewPanel = new JPanel(new BorderLayout());
        viewPanel.add((Component)editorPane);
        int topBottom = 8;
        viewPanel.setBorder(new EmptyBorder(topBottom, 8, topBottom, 8));
        int minHeight = 125;
        int insetsTopBottom = editorPane.getInsets().top;
        int height = Math.max(minHeight, topBottom * 2 + insetsTopBottom * 2 + lineCount * (fm.getHeight() + 5));
        viewPanel.setPreferredSize(new Dimension(maxWidth, height));
        JScrollPane scrollPane = new JScrollPane(viewPanel);
        return scrollPane;
    }

    private TransformMessage.MessageButton[] getButtons(TransformMessage message) {
        boolean dismissButtonPresent = false;
        for (TransformMessage.MessageButton button : message.getButtons()) {
            String buttonID = button.getId();
            if (!EXIT_BUTTON_ID.equalsIgnoreCase(buttonID) && !DISMISS_BUTTON_ID.equalsIgnoreCase(buttonID)) continue;
            dismissButtonPresent = true;
            break;
        }
        if (!dismissButtonPresent) {
            message.getButtons().add(new TransformMessage.MessageButton(DISMISS_BUTTON_ID, "Dismiss", null));
        }
        return message.getButtons().toArray(new TransformMessage.MessageButton[0]);
    }

    private int getLineCount(String text, FontMetrics fm, JEditorPane editorPane, int maxWidth) {
        String heightText = text;
        heightText = heightText.replace("<br>", "#!#!#");
        if (HtmlUtils.containsHtmlLink((String)(heightText = heightText.replaceAll("\\r?\\n", "@!@!@")))) {
            heightText = HtmlUtils.getPlainText((String)heightText);
        }
        heightText = heightText.replace("#!#!#", "\n");
        heightText = heightText.replace("@!@!@", "\n");
        int wrappedLines = StringUtilities.getWrappedLines((String)heightText, (FontMetrics)fm, (Insets)editorPane.getInsets(), (int)maxWidth);
        return wrappedLines;
    }
}

