/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkMessageWriter;
import org.xlightweb.IHttpHeader;
import org.xsocket.DataConverter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

final class BodylessMessageWriter
extends AbstractNetworkMessageWriter {
    private static final Logger LOG = Logger.getLogger(BodylessMessageWriter.class.getName());
    private boolean isHeaderWritten = false;
    private final IHttpHeader header;

    BodylessMessageWriter(AbstractHttpConnection httpConnection, boolean destroyOnClose, IHttpHeader header) throws IOException {
        super(httpConnection, destroyOnClose);
        this.header = header;
    }

    public void flush(ByteBuffer[] bodyData, boolean isContentImmutable, IConnection.FlushMode flushMode, IWriteCompletionHandler completionHandler) throws IOException {
        if (completionHandler != null) {
            completionHandler.onWritten(0);
        }
    }

    void onClose(boolean destroyOnClose) throws IOException {
        AbstractHttpConnection con = this.getConnection();
        if (con != null) {
            try {
                if (!this.isHeaderWritten) {
                    this.isHeaderWritten = true;
                    con.setFlushmode(IConnection.FlushMode.ASYNC);
                    con.write(this.header.toString() + "\r\n");
                    con.flush();
                    con.incCountMessageSent();
                }
                if (destroyOnClose) {
                    con.destroy();
                }
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by flushing bodyless message writer. Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
                }
                this.destroy();
                throw ioe;
            }
        }
    }

    public boolean isNetworkEndpoint() {
        return true;
    }
}

