/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.actions;

import com.paterva.maltego.customicons.manage.IconNameController;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class IconCategoryNameOrAliasMappingTestsAction
extends SystemAction {
    public String getName() {
        return "IconCategoryNameOrAliasMapping Tests";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent ae) {
        SlownessDetector.setEnabled((boolean)false);
        this.testCategoryNameVsAliasMappings();
        this.testCategoryNameMappings();
    }

    private void testCategoryNameVsAliasMappings() {
        String testCase = "testCategoryNameVsAliasMappings";
        IconRegistry registry = IconRegistry.getDefault();
        List icons = registry.getCategories().stream().map(arg_0 -> ((IconRegistry)registry).getIcons(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
        Pattern namePattern = Pattern.compile(IconNameController.getNamePatternString());
        Pattern aliasPattern = IconNameController.getAliasPattern();
        for (RegistryIcon icon : icons) {
            Matcher matcher = namePattern.matcher(icon.getName());
            if (!matcher.matches()) {
                System.out.println("  " + testCase + " --> " + icon.getCategory() + "/" + icon.getName() + " != a-zA-z _");
            }
            for (String iconAlias : icon.getAliases()) {
                this.diffCombinations(testCase, registry, icon.getCategory(), iconAlias, icon.getCategory(), iconAlias);
                this.diffCombinations(testCase, registry, icon.getCategory(), iconAlias, icon.getCategory(), icon.getName());
                matcher = aliasPattern.matcher(iconAlias);
                if (matcher.matches()) continue;
                System.out.println("  " + testCase + " --> " + icon.getCategory() + "/" + iconAlias + " (" + icon.getName() + ") != UTF8 .,-'()[]");
            }
        }
    }

    private void testCategoryNameMappings() {
        String testCase = "testCategoryNameMappings";
        IconRegistry registry = IconRegistry.getDefault();
        for (String iconCategory : registry.getCategories()) {
            for (String iconName : registry.getIconNames(iconCategory)) {
                this.diffCombinations(testCase, registry, iconCategory, iconName, iconCategory, iconName);
            }
        }
    }

    private void diffCombinations(String testCase, IconRegistry registry, String iconCategory1, String iconName1, String iconCategory2, String iconName2) {
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, null, iconName1, null, iconName2);
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, null, iconName1, null, iconName2.toLowerCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, null, iconName1, null, iconName2.toUpperCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, null, iconName1, null, StringUtilities.capitalizeFully((String)iconName2));
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, null, iconName2);
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, null, iconName2.toLowerCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, null, iconName2.toUpperCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, null, StringUtilities.capitalizeFully((String)iconName2));
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2, iconName2);
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2, iconName2.toLowerCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2, iconName2.toUpperCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2, StringUtilities.capitalizeFully((String)iconName2));
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2.toLowerCase(), iconName2);
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2.toLowerCase(), iconName2.toLowerCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2.toLowerCase(), iconName2.toUpperCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2.toLowerCase(), StringUtilities.capitalizeFully((String)iconName2));
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2.toUpperCase(), iconName2);
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2.toUpperCase(), iconName2.toLowerCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2.toUpperCase(), iconName2.toUpperCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, iconCategory2.toUpperCase(), StringUtilities.capitalizeFully((String)iconName2));
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, StringUtilities.capitalizeFully((String)iconCategory2), iconName2);
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, StringUtilities.capitalizeFully((String)iconCategory2), iconName2.toLowerCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, StringUtilities.capitalizeFully((String)iconCategory2), iconName2.toUpperCase());
        IconCategoryNameOrAliasMappingTestsAction.diffImageCheck(testCase, registry, iconCategory1, iconName1, StringUtilities.capitalizeFully((String)iconCategory2), StringUtilities.capitalizeFully((String)iconName2));
    }

    private static void diffImageCheck(final String testCase, IconRegistry registry, final String category1, final String name1, final String category2, final String name2) {
        final Image[] img = new Image[]{null, null};
        final Boolean[] imgSet = new Boolean[]{false, false};
        ImageCallback cb1 = new ImageCallback(){

            public void imageReady(Image image) {
                img[0] = image;
                imgSet[0] = true;
                if (!IconCategoryNameOrAliasMappingTestsAction.isSameIcon(img[0], imgSet[0], img[1], imgSet[1])) {
                    System.out.println("  " + testCase + " --> " + category1 + "/" + name1 + " != " + category2 + "/" + name2);
                }
            }

            public void imageFailed(Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        ImageCallback cb2 = new ImageCallback(){

            public void imageReady(Image image) {
                img[1] = image;
                imgSet[1] = true;
                if (!IconCategoryNameOrAliasMappingTestsAction.isSameIcon(img[0], imgSet[0], img[1], imgSet[1])) {
                    System.out.println("  " + testCase + " --> " + category1 + "/" + name1 + " != " + category2 + "/" + name2);
                }
            }

            public void imageFailed(Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        registry.loadImage(category1, name1, IconSize.TINY, cb1);
        registry.loadImage(category2, name2, IconSize.TINY, cb2);
    }

    private static boolean isSameIcon(Image img1, boolean img1Set, Image img2, boolean img2Set) {
        if (img1Set && img2Set) {
            BufferedImage bIcon2;
            if (img1 == null || img2 == null) {
                return false;
            }
            BufferedImage bIcon1 = ImageUtils.createBufferedImage((Image)img1);
            if (!ImageUtils.equals((BufferedImage)bIcon1, (BufferedImage)(bIcon2 = ImageUtils.createBufferedImage((Image)img2)))) {
                return false;
            }
        }
        return true;
    }
}

