/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.ui.BackgroundWorker;
import com.paterva.maltego.util.ui.BackgroundWorkerHandle;
import com.paterva.maltego.util.ui.BackgroundWorkerListener;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class BackgroundWorkerControl
extends JPanel {
    private boolean _busy = false;
    private BackgroundWorker _worker;
    private RequestProcessor _rp;
    private RequestProcessor.Task _task;
    private JLabel _main;
    private JLabel _detail;
    private JComponent _progress;
    private boolean _cancelled;
    private final Object _cancelLock = new String();
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final Color innerBackground = LAF.getColor("collaboration-connection-status-panel-bg");

    public BackgroundWorkerControl() {
        super(new BorderLayout(5, 5));
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)"Busy... Please wait...");
        this.updateProgressComponent(handle);
        handle.start();
        handle.finish();
    }

    public void start(final Object data, String description) {
        if (!this._busy) {
            this._busy = true;
            this._cancelled = false;
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)description);
            this.updateProgressComponent(handle);
            this._task = this.processor().create(new Runnable(){

                @Override
                public void run() {
                    try {
                        handle.start(100);
                        handle.progress("Initializing...");
                        final Object result = BackgroundWorkerControl.this._worker.doWork(data, new Handle(handle));
                        handle.progress(100);
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (BackgroundWorkerControl.this._cancelled) {
                                        BackgroundWorkerControl.this.fireWorkerCancelled();
                                    } else {
                                        BackgroundWorkerControl.this.fireWorkerComplete(result);
                                    }
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    catch (Exception e) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (BackgroundWorkerControl.this._cancelled) {
                                        BackgroundWorkerControl.this.fireWorkerCancelled();
                                    } else {
                                        BackgroundWorkerControl.this.fireWorkerFailed(e);
                                    }
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    finally {
                        handle.finish();
                    }
                }
            });
            this._task.schedule(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this._cancelLock;
        synchronized (object) {
            if (this._busy) {
                this._task.cancel();
                this._cancelled = true;
            }
        }
    }

    public boolean isBusy() {
        return this._busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Object object = this._cancelLock;
        synchronized (object) {
            return this._cancelled;
        }
    }

    public void addBackgroundWorkerListener(BackgroundWorkerListener listener) {
        this.listenerList.add(BackgroundWorkerListener.class, listener);
    }

    public void removeBackgroundWorkerListener(BackgroundWorkerListener listener) {
        this.listenerList.remove(BackgroundWorkerListener.class, listener);
    }

    protected void fireWorkerComplete(Object result) {
        this._busy = false;
        this._task = null;
        for (BackgroundWorkerListener listener : (BackgroundWorkerListener[])this.listenerList.getListeners(BackgroundWorkerListener.class)) {
            listener.workerCompleted(result);
        }
    }

    protected void fireWorkerFailed(Throwable error) {
        this._busy = false;
        this._task = null;
        for (BackgroundWorkerListener listener : (BackgroundWorkerListener[])this.listenerList.getListeners(BackgroundWorkerListener.class)) {
            listener.workerFailed(error);
        }
    }

    protected void fireWorkerCancelled() {
        this._busy = false;
        this._task = null;
        for (BackgroundWorkerListener listener : (BackgroundWorkerListener[])this.listenerList.getListeners(BackgroundWorkerListener.class)) {
            listener.workerCancelled();
        }
    }

    public BackgroundWorker getWorker() {
        return this._worker;
    }

    public void setWorker(BackgroundWorker worker) {
        this._worker = worker;
    }

    private RequestProcessor processor() {
        if (this._rp == null) {
            this._rp = new RequestProcessor(this.toString(), 1, true);
        }
        return this._rp;
    }

    private void updateProgressComponent(ProgressHandle handle) {
        if (this._main != null) {
            this.remove(this._main);
        }
        if (this._detail != null) {
            this.remove(this._detail);
        }
        if (this._progress != null) {
            this.remove(this._progress);
        }
        this._main = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        this._detail = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        this._progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        this._progress.setBackground(this.innerBackground);
        this._detail.setText(" ");
        this._main.setText(" ");
        this._main.setHorizontalAlignment(2);
        this._detail.setHorizontalAlignment(4);
        this.add((Component)this._main, "North");
        this.add((Component)this._detail, "South");
        this.add((Component)this._progress, "Center");
        this.validate();
    }

    private class Handle
    implements BackgroundWorkerHandle {
        private final ProgressHandle _handle;

        public Handle(ProgressHandle handle) {
            this._handle = handle;
        }

        @Override
        public void progress(String message, int percent) {
            this._handle.progress(message, percent);
        }

        @Override
        public void progress(String message) {
            this._handle.progress(message);
        }

        @Override
        public boolean isCancelled() {
            return BackgroundWorkerControl.this.isCancelled();
        }
    }
}

