/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import com.bulenkov.darcula.ui.DarculaCheckBoxUI;
import com.bulenkov.iconloader.util.EmptyIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.plaf.IconUIResource;

public class TriStateCheckBox
extends JCheckBox
implements ActionListener {
    public static int NONE_SELECTED = 0;
    public static int SOME_SELECTED = 1;
    public static int ALL_SELECTED = 2;
    private static String SELECTION_STATE = "SelectionState";

    public TriStateCheckBox() {
        this("");
    }

    public TriStateCheckBox(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.putClientProperty(SELECTION_STATE, NONE_SELECTED);
        this.addActionListener(this);
    }

    @Override
    public boolean isSelected() {
        return this.getSelectionState() == ALL_SELECTED;
    }

    @Override
    public void setSelected(boolean selected) {
        this.setSelectionState(selected ? ALL_SELECTED : NONE_SELECTED);
    }

    private void setSelectedInternal(boolean selected) {
        super.setSelected(selected);
    }

    public int getSelectionState() {
        return (Integer)this.getClientProperty(SELECTION_STATE);
    }

    public void setSelectionState(int selectionState) {
        int old = this.getSelectionState();
        if (old != selectionState) {
            this.putClientProperty(SELECTION_STATE, selectionState);
            this.setSelectedInternal(this.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TriStateCheckBox tcb = (TriStateCheckBox)e.getSource();
        int selectionState = tcb.getSelectionState();
        if (selectionState == ALL_SELECTED) {
            tcb.setSelectionState(NONE_SELECTED);
        } else {
            tcb.setSelectionState(ALL_SELECTED);
        }
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        int selectionState = this.getSelectionState();
        super.paintComponent(g2d);
        Color color = DarculaCheckBoxUI.getCheckSignColorHub();
        g2d.setColor(color);
        Graphics2D g = (Graphics2D)g2d;
        TriStateCheckBox b = this;
        Dimension size = b.getSize();
        Font font = b.getFont();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = b.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), new IconUIResource(EmptyIcon.create((int)20)), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap() - 3);
        int x = iconRect.x;
        int y = iconRect.y + 3;
        int w = iconRect.width - 5;
        int h = iconRect.height - 6;
        g.translate(x, y);
        g.drawRect(0, 0, w - 1, h - 1);
        if (selectionState == SOME_SELECTED) {
            g.fillRect(4, 4, w - 8, h - 8);
        }
        g.translate(-x, -y);
    }
}

