/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.image;

import gov.nist.isg.archiver.DirectoryArchiver;
import gov.nist.isg.archiver.FilesArchiver;
import gov.nist.isg.pyramidio.BufferedImageReader;
import gov.nist.isg.pyramidio.PartialImageReader;
import gov.nist.isg.pyramidio.ProgressCallback;
import gov.nist.isg.pyramidio.ScalablePyramidBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class TileViewer {
    private static final String LEAFLET_DEEP_ZOOM_SCRIPT = "/*\n * Leaflet-DeepZoom 2.0.0\n * Displaying DeepZoom tiles with Leaflet 1.x\n * by Al Farisi, Indokreatif Teknologi\n * License: ISC ( https://en.wikipedia.org/wiki/ISC_license )\n * https://github.com/alfarisi/leaflet-deepzoom\n */\n\nL.TileLayer.DeepZoom = L.TileLayer.extend({\n    options: {\n        width: -1,\n        height: -1,\n        imageFormat: 'jpg',\n        tileSize: 256,\n        maxZoom: undefined\n    },\n\n    initialize: function (url, options) {\n        var options = L.setOptions(this, options);\n        this._url = url;\n\n        if (options.width < 0 || options.height < 0) {\n            throw new Error('The user must set the Width and Height of the image');\n        }\n\n        var imageSize = L.point(options.width, options.height),\n                tileSize = options.tileSize;\n\n        this._imageSize = [imageSize];\n        this._gridSize = [this._getGridSize(imageSize)];\n\n        var maxZoomCustom = $max-zoom;\n        while ((imageSize.x > 0 || imageSize.y > 0) && maxZoomCustom > 0) {\n            maxZoomCustom--;\n            imageSize = imageSize.divideBy(2).floor();\n            this._imageSize.push(imageSize);\n            this._gridSize.push(this._getGridSize(imageSize));\n        }\n\n        this._imageSize.reverse();\n        this._gridSize.reverse();\n\n        options.maxNativeZoom = this._gridSize.length - 1;\n\n        if (typeof options.maxZoom == 'undefined') {\n            options.maxZoom = options.maxNativeZoom;\n        }\n\n        var maxZoomGrid = this._gridSize[options.maxNativeZoom];\n        var southWest = map.unproject([0, options.height], options.maxNativeZoom);\n        var northEast = map.unproject([options.width, 0], options.maxNativeZoom);\n        options.bounds = new L.LatLngBounds(southWest, northEast);\n    },\n\n    _getGridSize: function (imageSize) {\n        var tileSize = this.options.tileSize;\n        return L.point(Math.ceil(imageSize.x / tileSize), Math.ceil(imageSize.y / tileSize));\n    },\n\n    _addTile: function (coords, container) {\n        var tilePos = this._getTilePos(coords),\n                key = this._tileCoordsToKey(coords);\n\n        var tile = this.createTile(this._wrapCoords(coords), L.bind(this._tileReady, this, coords));\n\n        this._initTile(tile);\n\n        var imageSize = this._imageSize[this._getZoomForUrl()],\n                gridSize = this._gridSize[this._getZoomForUrl()],\n                tileSize = this.options.tileSize;\n\n        if (coords.x === gridSize.x - 1) {\n            tile.style.width = imageSize.x - (tileSize * (gridSize.x - 1)) + 'px';\n        }\n\n        if (coords.y === gridSize.y - 1) {\n            tile.style.height = imageSize.y - (tileSize * (gridSize.y - 1)) + 'px';\n        }\n\n        if (this.createTile.length < 2) {\n            L.Util.requestAnimFrame(L.bind(this._tileReady, this, coords, null, tile));\n        }\n\n        L.DomUtil.setPosition(tile, tilePos);\n\n        this._tiles[key] = {\n            el: tile,\n            coords: coords,\n            current: true\n        };\n\n        container.appendChild(tile);\n        this.fire('tileloadstart', {\n            tile: tile,\n            coords: coords\n        });\n    },\n\n    getTileUrl: function (tilePoint) {\n        return this._url + this._getZoomForUrl() + '/' + tilePoint.x + '_' + tilePoint.y + '.' + this.options.imageFormat;\n    }\n\n});\n\nL.tileLayer.deepzoom = function (url, options) {\n    return new L.TileLayer.DeepZoom(url, options);\n};";

    public static boolean createLeafletDeepZoomHTML(File htmlFile, String imagesFolderName, int maxZoom, int imageWidth, int imageHeight) {
        boolean success = true;
        String htmlString = "<!DOCTYPE html>\n<html lang=\"en\">\n    <head>\n        <meta charset=\"utf-8\">\n        <link rel=\"shortcut icon\" href=\"https://www.maltego.com/favicon.ico\" />\n        <title>Maltego Tiled Browser Image</title>\n        <link rel='stylesheet' href='https://unpkg.com/leaflet@1.4.0/dist/leaflet.css' />\n        <style type='text/css'>\n            html, body, #image2d {\n                width: 100%;\n                height: 100%;\n                padding: 0;\n                margin: 0;\n            }\n        </style>\n    </head>\n\n    <body>\n\n        <div id='image2d'>\n        <center><img src='https://www.maltego.com/favicon.ico' alt=' Maltego Tiled Browser Image uses JavaScript files from the internet. An active internet connection is required.'></center>\n        </div>\n        <script type='text/javascript' src='https://unpkg.com/leaflet@1.4.0/dist/leaflet.js'></script>\n        <script type='text/javascript'>\n            $deep-zoom-script\n        </script>  \n\n        <script type='text/javascript'>\n\n            var map = L.map('image2d').setView(new L.LatLng(0,0), 0);\n\n            var dzLayer = L.tileLayer.deepzoom('" + imagesFolderName + "/', { \n                width: " + imageWidth + ", \n                height: " + imageHeight + ", \n                minZoom: 6            }).addTo(map);\n\t       map.fitBounds(dzLayer.options.bounds);\n\n        </script>\n        <noscript>\n        <p>Maltego Tiled Browser Image is not available unless JavaScript is enabled.</p>\n        </noscript>\n    </body>\n</html>";
        htmlString = htmlString.replace("$deep-zoom-script", LEAFLET_DEEP_ZOOM_SCRIPT);
        htmlString = htmlString.replace("$max-zoom", maxZoom + "");
        try {
            FileUtils.writeStringToFile((File)htmlFile, (String)htmlString, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException ex) {
            success = false;
        }
        return success;
    }

    public static int createDeepZoomImage(File inImage, File outParent, String outDziName, boolean readInSections, ProgressCallback cb) throws IOException {
        int maxZoom = -1;
        int tileSize = 256;
        ScalablePyramidBuilder spb = new ScalablePyramidBuilder(tileSize, 0, "jpg", "dzi");
        DirectoryArchiver archiver = new DirectoryArchiver(outParent);
        BufferedImageReader pir = new BufferedImageReader(inImage, tileSize, readInSections, cb, false);
        spb.buildPyramid((PartialImageReader)pir, outDziName, (FilesArchiver)archiver);
        File folder = Paths.get(outParent.getPath(), outDziName + "_files").toFile();
        if (folder.isDirectory()) {
            maxZoom = folder.listFiles().length - 1;
            File dziFile = Paths.get(outParent.getPath(), outDziName + ".dzi").toFile();
            if (dziFile.isFile()) {
                dziFile.delete();
            }
        }
        return maxZoom;
    }
}

