/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.progress;

import com.paterva.maltego.util.ui.progress.ProgressController;
import com.paterva.maltego.util.ui.progress.ProgressDescriptor;
import com.paterva.maltego.util.ui.progress.ProgressPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public final class ProgressDialogFactory {
    public static final String CANCEL_OPTION = "cancel";
    public static final String FINISH_OPTION = "finish";
    public static final String UPDATE_OPTION = "update";
    public static final String CANCEL_LOCKOUT_OPTION = "lockout";

    private ProgressDialogFactory() {
    }

    public static ProgressDescriptor createProgressDialog(String title, boolean cancelable) {
        ProgressHandle pDesc = ProgressHandleFactory.createHandle((String)title);
        JComponent progressBar = ProgressHandleFactory.createProgressComponent((ProgressHandle)pDesc);
        ProgressPanel panel = new ProgressPanel(progressBar);
        JButton buttonCancel = new JButton(ProgressDialogFactory.capitalize(CANCEL_OPTION));
        ((Component)buttonCancel).setEnabled(cancelable);
        ProgressDialogCancellationListener progressListener = new ProgressDialogCancellationListener(panel, buttonCancel);
        DialogDescriptor dDesc = new DialogDescriptor((Object)panel, title, true, new Object[]{buttonCancel}, (Object)buttonCancel, 0, null, (ActionListener)progressListener, false);
        dDesc.setNoDefaultClose(true);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dDesc);
        if (dialog instanceof JDialog) {
            JDialog jDialog = (JDialog)dialog;
            jDialog.setDefaultCloseOperation(0);
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            jDialog.getRootPane().unregisterKeyboardAction(stroke);
        }
        ProgressDescriptorImpl descriptor = new ProgressDescriptorImpl(dialog, pDesc);
        if (progressListener != null) {
            progressListener.setController(descriptor.getController());
            dialog.addPropertyChangeListener(progressListener);
        }
        dialog.pack();
        dialog.setResizable(true);
        return descriptor;
    }

    public static String capitalize(String text) {
        return StringUtils.capitalize((String)text);
    }

    private static class ProgressDialogCancellationListener
    implements ActionListener,
    PropertyChangeListener {
        private static final String CANCELED = "Canceled...";
        private final Component _component;
        private final ProgressPanel _panel;
        private ProgressController _controller;

        public ProgressDialogCancellationListener(ProgressPanel panel, Component component) {
            if (component == null) {
                throw new NullPointerException("component");
            }
            if (panel == null) {
                throw new NullPointerException("panel");
            }
            this._component = component;
            this._panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getID() == 1001 && this._component.equals(e.getSource())) {
                this._component.setEnabled(false);
                this._controller.setCanceled();
                this._panel.getMessageComponent().setText(CANCELED);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (ProgressDialogFactory.FINISH_OPTION.equals(propertyName)) {
                this._component.setEnabled(false);
                this._panel.getMessageComponent().setText("Finishing...");
            } else if (ProgressDialogFactory.CANCEL_OPTION.equals(propertyName)) {
                this._component.setEnabled(false);
                this._panel.getMessageComponent().setText(CANCELED);
            } else if (ProgressDialogFactory.UPDATE_OPTION.equals(propertyName)) {
                JLabel label = this._panel.getMessageComponent();
                label.setText(String.valueOf(evt.getNewValue()));
            } else if (ProgressDialogFactory.CANCEL_LOCKOUT_OPTION.equals(propertyName)) {
                this._component.setEnabled(false);
            }
        }

        public void setController(ProgressController controller) {
            this._controller = controller;
        }
    }

    private static class ProgressDescriptorImpl
    implements ProgressDescriptor {
        private final Dialog _dialog;
        private final ProgressController _controller;

        public ProgressDescriptorImpl(Dialog dialog, ProgressHandle progress) {
            if (dialog == null) {
                throw new NullPointerException("dialog");
            }
            if (progress == null) {
                throw new NullPointerException("progress");
            }
            this._dialog = dialog;
            this._controller = new ProgressController(progress, dialog);
        }

        @Override
        public Component getGUIComponent() {
            return this._dialog;
        }

        @Override
        public ProgressController getController() {
            return this._controller;
        }
    }
}

