/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.convert.TabularGraphPartFactory;
import com.paterva.maltego.graph.table.io.convert.TabularGraphTypes;
import com.paterva.maltego.graph.table.io.convert.TabularTranslator;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphEntityType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightEntity;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightLink;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLinkType;
import com.paterva.maltego.tabular.transforms.run.AbstractTabularTransformRunner;
import com.paterva.maltego.tabular.transforms.run.MaltegoToLightEntities;
import com.paterva.maltego.transform.runner.api.MatchingRuleUpdater;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.collections.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TabularTransformSearchRunner
extends AbstractTabularTransformRunner {
    private static final Logger LOG = Logger.getLogger(TabularTransformSearchRunner.class.getName());
    private final Map<MaltegoEntity, String> searchTexts;
    private final Map<LinkEntityIDs, MaltegoLink> translatedLinks = new HashMap<LinkEntityIDs, MaltegoLink>();

    public TabularTransformSearchRunner(TransformRunContext ctx, MatchingRuleUpdater matchingRuleUpdater, List<TabularTransformSource> sources) {
        super(ctx, matchingRuleUpdater, sources);
        this.searchTexts = this.getSearchTexts(ctx.getInputEntities().values());
    }

    @Override
    protected TabularGraphPartFactory createPartFactory() {
        return new GlobalSearchPartFactory(this.getTypes());
    }

    @Override
    protected void processRow(TabularGraphIterator rowIterator) throws Exception {
        List<TabularGraphLightweightEntity> lightEntities = this.getRowEntities(rowIterator);
        if (!lightEntities.isEmpty()) {
            this.processEntities(lightEntities);
        }
    }

    private void processEntities(List<TabularGraphLightweightEntity> lightEntities) throws Exception {
        Map<MaltegoEntity, List<MaltegoEntity>> entities;
        MaltegoToLightEntities matches = this.getMatches(lightEntities);
        if (!matches.isEmpty() && !(entities = this.createOutputEntities(matches)).isEmpty()) {
            List<LinkEntityIDs> entityIDs = this.getLinkEntityIDs(entities);
            Map<MaltegoLink, LinkEntityIDs> links = this.createLinks(entityIDs);
            this.sendResults(entities, links);
        }
    }

    private List<LinkEntityIDs> getLinkEntityIDs(Map<MaltegoEntity, List<MaltegoEntity>> inputToOutputEntities) {
        ArrayList<LinkEntityIDs> entityIDs = new ArrayList<LinkEntityIDs>();
        for (Map.Entry<MaltegoEntity, List<MaltegoEntity>> entry : inputToOutputEntities.entrySet()) {
            MaltegoEntity inputEntity = entry.getKey();
            List<MaltegoEntity> outputEntities = entry.getValue();
            outputEntities.forEach(entity -> entityIDs.add(new LinkEntityIDs((EntityID)inputEntity.getID(), (EntityID)entity.getID())));
        }
        return entityIDs;
    }

    private Map<MaltegoLink, LinkEntityIDs> createLinks(List<LinkEntityIDs> links) {
        ArrayList<LinkEntityIDs> newLinks = new ArrayList<LinkEntityIDs>(links);
        newLinks.removeAll(this.translatedLinks.keySet());
        Map newCreatedLinks = this.createGenericLinks(newLinks);
        newCreatedLinks.entrySet().forEach(entry -> this.translatedLinks.put((LinkEntityIDs)entry.getValue(), (MaltegoLink)entry.getKey()));
        return links.stream().collect(Collectors.toMap(entityIDs -> this.translatedLinks.get(entityIDs), Function.identity()));
    }

    private MaltegoToLightEntities getMatches(List<TabularGraphLightweightEntity> entities) throws Exception {
        MaltegoToLightEntities matches = new MaltegoToLightEntities();
        for (Map.Entry<MaltegoEntity, String> entry : this.searchTexts.entrySet()) {
            MaltegoEntity maltegoEntity = entry.getKey();
            String searchText = entry.getValue();
            for (TabularGraphLightweightEntity entity : entities) {
                TabularGraphEntityType type = (TabularGraphEntityType)entity.type;
                if (!this.searchMatch(type, entity.row, searchText)) continue;
                MapUtils.addToList((Map)matches, (Object)maltegoEntity, (Object)entity);
            }
        }
        return matches;
    }

    private boolean searchMatchAny(TabularGraphEntityType type, List<Object> row) throws TabularTranslator.RowImportException, TypeInstantiationException {
        Args.notNull((Object)type, (String)"type");
        Args.notNull(row, (String)"row");
        for (String searchText : this.searchTexts.values()) {
            if (!this.searchMatch(type, row, searchText)) continue;
            return true;
        }
        return false;
    }

    private boolean searchMatch(TabularGraphEntityType type, List<Object> row, String searchText) throws TabularTranslator.RowImportException, TypeInstantiationException {
        Args.notNull((Object)type, (String)"type");
        Args.notNull(row, (String)"row");
        Args.notNull((Object)searchText, (String)"searchText");
        for (int column : type.tabularEntity.getColumns()) {
            String cellValueLowerCase;
            Object cellValue = row.get(column);
            if (cellValue == null || !(cellValueLowerCase = cellValue.toString().toLowerCase()).contains(searchText)) continue;
            return true;
        }
        return false;
    }

    private Map<MaltegoEntity, String> getSearchTexts(Collection<MaltegoEntity> inputEntities) {
        return inputEntities.stream().filter(entity -> StringUtils.isNotBlank((CharSequence)entity.getValueString())).collect(Collectors.toMap(Function.identity(), entity -> entity.getValueString().toLowerCase()));
    }

    static {
        LOG.setLevel(Level.ALL);
    }

    private class GlobalSearchPartFactory
    extends TabularGraphPartFactory {
        public GlobalSearchPartFactory(TabularGraphTypes types) {
            super(types);
        }

        protected boolean shouldAdd(TabularGraphEntityType type, List<Object> row) throws Exception {
            Args.notNull((Object)type, (String)"type");
            Args.notNull(row, (String)"row");
            return TabularTransformSearchRunner.this.searchMatchAny(type, row);
        }

        protected boolean shouldAdd(TabularGraphLinkType type, TabularGraphLightweightLink lightLink) throws Exception {
            return false;
        }
    }
}

