/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.manager.TasManagerTopComponent;
import com.paterva.maltego.transform.manager.TransformManagerTopComponent;
import com.paterva.maltego.transform.manager.api.TransformManager;
import com.paterva.maltego.transform.manager.localv2.NewLocalTransformAction;
import com.paterva.maltego.transform.manager.sets.TransformSetManagerTopComponent;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class TransformManagerController
extends TransformManager {
    @Override
    public void open() {
        this.open(null, null, null);
    }

    private void open(String selectTransform, String selectTas, String selectSet) {
        final TransformManagerTopComponent transforms = new TransformManagerTopComponent(selectTransform);
        final TasManagerTopComponent tases = new TasManagerTopComponent(selectTas);
        final TransformSetManagerTopComponent sets = new TransformSetManagerTopComponent(selectSet);
        sets.setPreferredSize(new Dimension(900, 700));
        final JTabbedPane pane = new JTabbedPane();
        pane.add("All Transforms", (Component)((Object)transforms));
        pane.add("Transform Servers", (Component)((Object)tases));
        pane.add("Transform Sets", (Component)((Object)sets));
        if (selectTransform != null) {
            pane.setSelectedComponent((Component)((Object)transforms));
        } else if (selectTas != null) {
            pane.setSelectedComponent((Component)((Object)tases));
        } else if (selectSet != null) {
            pane.setSelectedComponent((Component)((Object)sets));
        }
        pane.addChangeListener(new ChangeListener(){
            private Component _lastComponent;
            {
                this._lastComponent = transforms;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                Component newComponent = pane.getSelectedComponent();
                if (this._lastComponent == tases) {
                    if (newComponent == transforms) {
                        transforms.refresh();
                    } else if (newComponent == sets) {
                        sets.refresh();
                    }
                }
                this._lastComponent = newComponent;
            }
        });
        JButton closeButton = new JButton("Close");
        PanelWithMatteBorderAllSides outerPanel = new PanelWithMatteBorderAllSides((LayoutManager)new BorderLayout());
        outerPanel.add(pane);
        DialogDescriptor dd = new DialogDescriptor((Object)outerPanel, "Transform Manager", true, (Object[])new JButton[]{closeButton}, (Object)closeButton, 0, HelpCtx.DEFAULT_HELP, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        transforms.saveTransformSettings();
        tases.saveTasSettings();
        sets.saveTransformSets();
    }

    @Override
    public void openTransform(String transform) {
        this.open(transform, null, null);
    }

    @Override
    public void openSet(String set) {
        this.open(null, null, set);
    }

    @Override
    public void openTas(String tas) {
        this.open(null, tas, null);
    }

    @Override
    public void importTransforms() {
        this.open();
    }

    @Override
    public TransformDefinition createTransform(String type) {
        return ((NewLocalTransformAction)SystemAction.get(NewLocalTransformAction.class)).newTransform(type);
    }

    @Override
    public TransformDefinition createTransform() {
        return ((NewLocalTransformAction)SystemAction.get(NewLocalTransformAction.class)).newTransform();
    }
}

