/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.transforms;

import com.paterva.maltego.importexport.ConfigNode;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.manager.imex.transforms.TransformConfig;
import com.paterva.maltego.transform.manager.imex.transforms.TransformExistInfo;
import com.paterva.maltego.transform.manager.imex.transforms.TransformNode;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class TransformServerNode
extends ConfigNode {
    public TransformServerNode(TransformConfig transformConfig, TransformServerInfo server, TransformExistInfo existInfo) {
        this(server, (Children)new TransformChildren(transformConfig, server.getTransforms(), existInfo), new InstanceContent());
        this.setSelectedNonRecursive(transformConfig.hasSelectedTransforms(server));
    }

    private TransformServerNode(TransformServerInfo server, Children children, InstanceContent content) {
        super(children, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)server);
        content.add((Object)this);
        this.setDisplayName(server.getDisplayName());
        this.setShortDescription(server.getDescription());
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TAS.png");
    }

    private static class TransformChildren
    extends Children.Keys<TransformDescriptor> {
        private TransformConfig _config;
        private TransformExistInfo _existInfo;

        public TransformChildren(TransformConfig config, Collection<String> transformNames, TransformExistInfo existInfo) {
            this._config = config;
            this._existInfo = existInfo;
            ArrayList<TransformDescriptor> transforms = new ArrayList<TransformDescriptor>(transformNames.size());
            TransformDescriptor[] allTransforms = (TransformDescriptor[])config.getAll();
            block0: for (String name : transformNames) {
                for (TransformDescriptor transform : allTransforms) {
                    if (!transform.getName().equals(name)) continue;
                    transforms.add(transform);
                    continue block0;
                }
            }
            this.setKeys(transforms);
        }

        protected Node[] createNodes(TransformDescriptor transform) {
            TransformNode transformNode = new TransformNode(this._config, transform, this._existInfo);
            transformNode.setSelectedNonRecursive(this._config.isSelected(transform));
            return new Node[]{transformNode};
        }
    }
}

