/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.util.Objects;

class ShiftedFloatingBounds
implements FloatingBounds {
    private final FloatingBounds prevBounds;
    private final int shiftLeft;
    private final int shiftRight;
    private final int shiftY;

    public ShiftedFloatingBounds(FloatingBounds prevBounds, int shiftLeft, int shiftRight, int shiftY) {
        this.prevBounds = prevBounds;
        this.shiftLeft = shiftLeft;
        this.shiftRight = shiftRight;
        this.shiftY = shiftY;
    }

    @Override
    public int getClearY(int y) {
        return this.prevBounds.getClearY(y - this.shiftY) + this.shiftY;
    }

    @Override
    public int getFirstClearY(int y) {
        return this.prevBounds.getFirstClearY(y - this.shiftY) + this.shiftY;
    }

    @Override
    public int getLeft(int y) {
        return this.prevBounds.getLeft(y - this.shiftY) + this.shiftLeft;
    }

    @Override
    public int getLeftClearY(int y) {
        return this.prevBounds.getLeftClearY(y - this.shiftY) + this.shiftY;
    }

    @Override
    public int getRight(int y) {
        return this.prevBounds.getRight(y - this.shiftY) + this.shiftRight;
    }

    @Override
    public int getRightClearY(int y) {
        return this.prevBounds.getRightClearY(y - this.shiftY) + this.shiftY;
    }

    @Override
    public int getMaxY() {
        return this.prevBounds.getMaxY() + this.shiftY;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShiftedFloatingBounds)) {
            return false;
        }
        ShiftedFloatingBounds other = (ShiftedFloatingBounds)obj;
        return this.shiftY == other.shiftY && this.shiftLeft == other.shiftLeft && this.shiftRight == other.shiftRight && Objects.equals(this.prevBounds, other.prevBounds);
    }

    public int hashCode() {
        return this.shiftY ^ this.shiftLeft ^ this.shiftRight;
    }
}

