/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNodeGen;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;

@ImportStatic(value={JSConfig.class})
public abstract class OrdinaryToPrimitiveNode
extends JavaScriptBaseNode {
    private final JSToPrimitiveNode.Hint hint;
    private final JSContext context;
    private final ConditionProfile toStringFunctionProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile valueOfFunctionProfile = ConditionProfile.createBinaryProfile();
    @Node.Child
    private PropertyNode getToStringNode;
    @Node.Child
    private PropertyNode getValueOfNode;
    @Node.Child
    private IsCallableNode isCallableNode;
    @Node.Child
    private JSFunctionCallNode callToStringNode;
    @Node.Child
    private JSFunctionCallNode callValueOfNode;
    @Node.Child
    private IsPrimitiveNode isPrimitiveNode;
    @Node.Child
    private ForeignObjectPrototypeNode foreignObjectPrototypeNode;

    protected OrdinaryToPrimitiveNode(JSContext context, JSToPrimitiveNode.Hint hint) {
        assert (hint == JSToPrimitiveNode.Hint.String || hint == JSToPrimitiveNode.Hint.Number);
        this.hint = hint;
        this.context = context;
        this.isCallableNode = IsCallableNode.create();
        this.isPrimitiveNode = IsPrimitiveNode.create();
    }

    public abstract Object execute(Object var1);

    @Specialization(guards={"isJSObject(object)"})
    protected Object doObject(DynamicObject object) {
        if (this.hint == JSToPrimitiveNode.Hint.String) {
            return this.doHintString(object);
        }
        assert (this.hint == JSToPrimitiveNode.Hint.Number);
        return this.doHintNumber(object);
    }

    @Specialization(guards={"isForeignObject(object)"}, limit="InteropLibraryLimit")
    protected Object doForeign(Object object, @CachedLibrary(value="object") InteropLibrary interop) {
        if (this.hint == JSToPrimitiveNode.Hint.String) {
            return this.doForeignHintString(object, interop);
        }
        assert (this.hint == JSToPrimitiveNode.Hint.Number);
        return this.doForeignHintNumber(object, interop);
    }

    public static OrdinaryToPrimitiveNode createHintString(JSContext context) {
        return OrdinaryToPrimitiveNode.create(context, JSToPrimitiveNode.Hint.String);
    }

    public static OrdinaryToPrimitiveNode createHintNumber(JSContext context) {
        return OrdinaryToPrimitiveNode.create(context, JSToPrimitiveNode.Hint.Number);
    }

    public static OrdinaryToPrimitiveNode create(JSContext context, JSToPrimitiveNode.Hint hint) {
        return OrdinaryToPrimitiveNodeGen.create(context, hint);
    }

    protected Object doHintString(DynamicObject object) {
        Object result;
        Object result2;
        Object toString = this.getToString().executeWithTarget(object);
        if (this.toStringFunctionProfile.profile(this.isCallableNode.executeBoolean(toString)) && this.isPrimitiveNode.executeBoolean(result2 = this.callToStringNode.executeCall(JSArguments.createZeroArg(object, toString)))) {
            return result2;
        }
        Object valueOf = this.getValueOf().executeWithTarget(object);
        if (this.valueOfFunctionProfile.profile(this.isCallableNode.executeBoolean(valueOf)) && this.isPrimitiveNode.executeBoolean(result = this.callValueOfNode.executeCall(JSArguments.createZeroArg(object, valueOf)))) {
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    protected Object doHintNumber(DynamicObject object) {
        Object result;
        Object result2;
        assert (JSGuards.isJSObject(object));
        Object valueOf = this.getValueOf().executeWithTarget(object);
        if (this.valueOfFunctionProfile.profile(this.isCallableNode.executeBoolean(valueOf)) && this.isPrimitiveNode.executeBoolean(result2 = this.callValueOfNode.executeCall(JSArguments.createZeroArg(object, valueOf)))) {
            return result2;
        }
        Object toString = this.getToString().executeWithTarget(object);
        if (this.toStringFunctionProfile.profile(this.isCallableNode.executeBoolean(toString)) && this.isPrimitiveNode.executeBoolean(result = this.callToStringNode.executeCall(JSArguments.createZeroArg(object, toString)))) {
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    protected Object doForeignHintString(Object object, InteropLibrary interop) {
        Object result;
        if (interop.hasMembers(object) && interop.isMemberInvocable(object, "toString")) {
            Object result2;
            try {
                result2 = JSRuntime.importValue(interop.invokeMember(object, "toString", new Object[0]));
            }
            catch (InteropException e) {
                result2 = null;
            }
            if (result2 != null && this.isPrimitiveNode.executeBoolean(result2)) {
                return result2;
            }
        }
        DynamicObject proto = this.getForeignObjectPrototype(object);
        Object func = this.getToString().executeWithTarget(proto);
        if (this.toStringFunctionProfile.profile(this.isCallableNode.executeBoolean(func)) && this.isPrimitiveNode.executeBoolean(result = this.callToStringNode.executeCall(JSArguments.createZeroArg(object, func)))) {
            return result;
        }
        if (interop.hasMembers(object) && interop.isMemberInvocable(object, "valueOf")) {
            try {
                result = JSRuntime.importValue(interop.invokeMember(object, "valueOf", new Object[0]));
            }
            catch (InteropException e) {
                result = null;
            }
            if (result != null && this.isPrimitiveNode.executeBoolean(result)) {
                return result;
            }
        }
        if (this.valueOfFunctionProfile.profile(this.isCallableNode.executeBoolean(func = this.getValueOf().executeWithTarget(proto))) && this.isPrimitiveNode.executeBoolean(result = this.callValueOfNode.executeCall(JSArguments.createZeroArg(object, func)))) {
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    protected Object doForeignHintNumber(Object object, InteropLibrary interop) {
        Object result;
        if (interop.hasMembers(object) && interop.isMemberInvocable(object, "valueOf")) {
            Object result2;
            try {
                result2 = JSRuntime.importValue(interop.invokeMember(object, "valueOf", new Object[0]));
            }
            catch (InteropException e) {
                result2 = null;
            }
            if (result2 != null && this.isPrimitiveNode.executeBoolean(result2)) {
                return result2;
            }
        }
        DynamicObject proto = this.getForeignObjectPrototype(object);
        Object func = this.getValueOf().executeWithTarget(proto);
        if (this.valueOfFunctionProfile.profile(this.isCallableNode.executeBoolean(func)) && this.isPrimitiveNode.executeBoolean(result = this.callValueOfNode.executeCall(JSArguments.createZeroArg(object, func)))) {
            return result;
        }
        if (interop.hasMembers(object) && interop.isMemberInvocable(object, "toString")) {
            try {
                result = JSRuntime.importValue(interop.invokeMember(object, "toString", new Object[0]));
            }
            catch (InteropException e) {
                result = null;
            }
            if (result != null && this.isPrimitiveNode.executeBoolean(result)) {
                return result;
            }
        }
        if (this.toStringFunctionProfile.profile(this.isCallableNode.executeBoolean(func = this.getToString().executeWithTarget(proto))) && this.isPrimitiveNode.executeBoolean(result = this.callToStringNode.executeCall(JSArguments.createZeroArg(object, func)))) {
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    private PropertyNode getToString() {
        if (this.getToStringNode == null || this.callToStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getToStringNode = (PropertyNode)this.insert(PropertyNode.createMethod(this.context, null, "toString"));
            this.callToStringNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        return this.getToStringNode;
    }

    private PropertyNode getValueOf() {
        if (this.getValueOfNode == null || this.callValueOfNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getValueOfNode = (PropertyNode)this.insert(PropertyNode.createMethod(this.context, null, "valueOf"));
            this.callValueOfNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        return this.getValueOfNode;
    }

    private DynamicObject getForeignObjectPrototype(Object truffleObject) {
        assert (JSRuntime.isForeignObject(truffleObject));
        if (this.foreignObjectPrototypeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.foreignObjectPrototypeNode = (ForeignObjectPrototypeNode)this.insert(ForeignObjectPrototypeNode.create());
        }
        return this.foreignObjectPrototypeNode.executeDynamicObject(truffleObject);
    }
}

