/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public final class Boundaries {
    private Boundaries() {
    }

    @CompilerDirectives.TruffleBoundary
    public static String javaToString(Object value) {
        return value.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringValueOf(long l) {
        return String.valueOf(l);
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringValueOf(int i) {
        return String.valueOf(i);
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringValueOf(double d) {
        return String.valueOf(d);
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringValueOf(Object o) {
        return String.valueOf(o);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static String stringValueOf(char[] chars) {
        return String.valueOf(chars);
    }

    @CompilerDirectives.TruffleBoundary
    public static Integer integerValueOf(String s) {
        return Integer.valueOf(s);
    }

    @CompilerDirectives.TruffleBoundary
    public static Double doubleValueOf(String s) {
        return Double.valueOf(s);
    }

    @CompilerDirectives.TruffleBoundary
    public static Float floatValueOf(String s) {
        return Float.valueOf(s);
    }

    @CompilerDirectives.TruffleBoundary
    public static Long longValueOf(String s) {
        return Long.valueOf(s);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static String builderToString(StringBuilder res) {
        return res.toString();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void builderAppend(StringBuilder sb, int intValue) {
        sb.append(intValue);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void builderAppend(StringBuilder sb, long longValue) {
        sb.append(longValue);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void builderAppend(StringBuilder sb, CharSequence seq) {
        sb.append(seq);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void builderAppend(StringBuilder sb, String str) {
        sb.append(str);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void builderAppend(StringBuilder sb, char chr) {
        sb.append(chr);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void builderAppend(StringBuilder sb, CharSequence seq, int start, int end) {
        sb.append(seq, start, end);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void builderAppend(StringBuilder sb, String str, int start, int end) {
        sb.append(str, start, end);
    }

    @CompilerDirectives.TruffleBoundary
    public static char charAt(CharSequence cs, int idx) {
        return cs.charAt(idx);
    }

    @CompilerDirectives.TruffleBoundary
    public static CharSequence subSequence(CharSequence s, int begin, int end) {
        return s.subSequence(begin, end);
    }

    @CompilerDirectives.TruffleBoundary
    public static CharSequence subSequence(CharSequence s, int begin) {
        return s.subSequence(begin, s.length());
    }

    @CompilerDirectives.TruffleBoundary
    public static String charSequenceToString(CharSequence value) {
        return value.toString();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static String substring(String s, int begin, int end) {
        return s.substring(begin, end);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static String substring(String s, int begin) {
        return s.substring(begin);
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringFormat(String format, Object ... params) {
        return String.format(format, params);
    }

    public static int stringIndexOf(String s, String pattern) {
        return s.indexOf(pattern);
    }

    public static int stringIndexOf(String s, String pattern, int startPos) {
        return s.indexOf(pattern, startPos);
    }

    public static int stringIndexOf(String s, char pattern) {
        return s.indexOf(pattern);
    }

    public static int stringIndexOf(String s, char pattern, int startPos) {
        return s.indexOf(pattern, startPos);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int stringLastIndexOf(String s, String pattern) {
        return s.lastIndexOf(pattern);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int stringLastIndexOf(String s, String pattern, int startPos) {
        return s.lastIndexOf(pattern, startPos);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int stringLastIndexOf(String s, char pattern) {
        return s.lastIndexOf(pattern);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int stringLastIndexOf(String s, char pattern, int startPos) {
        return s.lastIndexOf(pattern, startPos);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int stringCompareTo(String a, String b) {
        return a.compareTo(b);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static boolean stringStartsWith(String s, String pattern) {
        return s.startsWith(pattern);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static boolean stringStartsWith(String s, String pattern, int startPos) {
        return s.startsWith(pattern, startPos);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static boolean stringEndsWith(String s, String pattern) {
        return s.endsWith(pattern);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int stringCodePointAt(String s, int pos) {
        return s.codePointAt(pos);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static String stringConcat(String left, String right) {
        return left.concat(right);
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringToLowerCase(String s, Locale locale) {
        return s.toLowerCase(locale);
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringToUpperCase(String s, Locale locale) {
        return s.toUpperCase(locale);
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringReplaceAll(String s, String regex, String replacement) {
        return s.replaceAll(regex, replacement);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean characterIsDigit(char ch) {
        return Character.isDigit(ch);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean characterIsUpperCase(char ch) {
        return Character.isUpperCase(ch);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equals(Object a, Object b) {
        return a.equals(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> Set<Map.Entry<K, V>> mapEntrySet(Map<K, V> map) {
        return map.entrySet();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> HashMap<K, V> hashMapCreate() {
        return new HashMap();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapPut(Map<K, V> map, K key, V value) {
        return map.put(key, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapPutIfAbsent(Map<K, V> map, K key, V value) {
        return map.putIfAbsent(key, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> boolean mapContainsKey(Map<K, V> map, Object key) {
        return map.containsKey(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapGet(Map<K, V> map, Object key) {
        return map.get(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapRemove(Map<K, V> map, Object key) {
        return map.remove(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> T listGet(List<T> list, int index) {
        return list.get(index);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void listSet(List<T> list, int index, T value) {
        list.set(index, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> int listSize(List<T> list) {
        return list.size();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> int listIndexOf(List<T> list, T element) {
        return list.indexOf(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void listAdd(List<T> list, T element) {
        list.add(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void listAddAll(List<T> list, List<T> addList) {
        list.addAll(addList);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean listContains(List<T> list, T element) {
        return list.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> Object[] listToArray(List<T> list) {
        return list.toArray();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean iteratorHasNext(Iterator<T> it) {
        return it.hasNext();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> T iteratorNext(Iterator<T> it) {
        return it.next();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> Iterator<T> iterator(Iterable<T> iterable) {
        return iterable.iterator();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> EconomicSet<T> economicSetCreate() {
        return EconomicSet.create();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean economicSetAdd(EconomicSet<T> economicSet, T element) {
        return economicSet.add(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean economicSetContains(EconomicSet<T> economicSet, T element) {
        return economicSet.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> EconomicMap<K, V> economicMapCreate() {
        return EconomicMap.create();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V economicMapPut(EconomicMap<K, V> map, K key, V value) {
        return (V)map.put(key, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> boolean economicMapContainsKey(EconomicMap<K, V> map, K key) {
        return map.containsKey(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V economicMapGet(EconomicMap<K, V> map, K key) {
        return (V)map.get(key);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static byte[] byteBufferArray(ByteBuffer buffer) {
        return buffer.array();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void byteBufferPutSlice(ByteBuffer dst, int dstPos, ByteBuffer src, int srcPos, int srcLimit) {
        ByteBuffer slice = Boundaries.byteBufferSlice(src, srcPos, srcLimit);
        ByteBuffer dstDup = dst.duplicate();
        BufferUtil.asBaseBuffer(dstDup).position(dstPos);
        dstDup.put(slice);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static ByteBuffer byteBufferSlice(ByteBuffer buf, int pos, int limit) {
        ByteBuffer dup = buf.duplicate();
        BufferUtil.asBaseBuffer(dup).position(pos).limit(limit);
        return dup.slice();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static ByteBuffer byteBufferDuplicate(ByteBuffer buffer) {
        return buffer.duplicate();
    }
}

