/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.js.runtime.array.BigEndianByteBufferAccess;
import com.oracle.truffle.js.runtime.array.ByteBufferAccess;
import com.oracle.truffle.js.runtime.array.LittleEndianByteBufferAccess;
import com.oracle.truffle.js.runtime.array.NativeByteBufferAccess;
import com.oracle.truffle.js.runtime.array.NativeUnsafeByteBufferAccess;
import com.oracle.truffle.js.runtime.array.ReservedUnsafeByteBufferAccess;
import java.nio.ByteOrder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ByteBufferSupport {
    private static final ByteBufferAccess LITTLE_ENDIAN;
    private static final ByteBufferAccess BIG_ENDIAN;
    private static final ByteBufferAccess NATIVE_ORDER;

    private ByteBufferSupport() {
    }

    static ByteBufferAccess littleEndian() {
        return LITTLE_ENDIAN;
    }

    static ByteBufferAccess bigEndian() {
        return BIG_ENDIAN;
    }

    static ByteBufferAccess nativeOrder() {
        return NATIVE_ORDER;
    }

    static {
        boolean unaligned;
        String arch = System.getProperty("os.arch");
        boolean bl = unaligned = arch.equals("amd64") || arch.equals("aarch64") || arch.equals("x86_64");
        if (unaligned) {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                LITTLE_ENDIAN = NativeUnsafeByteBufferAccess.INSTANCE;
                BIG_ENDIAN = ReservedUnsafeByteBufferAccess.INSTANCE;
            } else {
                LITTLE_ENDIAN = ReservedUnsafeByteBufferAccess.INSTANCE;
                BIG_ENDIAN = NativeUnsafeByteBufferAccess.INSTANCE;
            }
            NATIVE_ORDER = NativeUnsafeByteBufferAccess.INSTANCE;
        } else {
            LITTLE_ENDIAN = LittleEndianByteBufferAccess.INSTANCE;
            BIG_ENDIAN = BigEndianByteBufferAccess.INSTANCE;
            NATIVE_ORDER = NativeByteBufferAccess.INSTANCE;
        }
    }
}

