#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Oneshot
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240910.2

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='oneshot'
GAME_NAME='Oneshot'

ARCHIVE_BASE_0_NAME='OneShot.AppImage'
ARCHIVE_BASE_0_MD5='165fe1ea589d835b1dedc9947d43eb8f'
ARCHIVE_BASE_0_SIZE='360168'
ARCHIVE_BASE_0_VERSION='1.0-itch.2020.06.19'
ARCHIVE_BASE_0_URL='https://futurecat.itch.io/oneshot'

CONTENT_PATH_DEFAULT='usr/bin'
CONTENT_LIBS_BIN_PATH='usr/lib'
CONTENT_LIBS_BIN_FILES='
libruby.so.2.5
libxfconf-0.so.2'
CONTENT_GAME_BIN_FILES='
_______
oneshot'
CONTENT_GAME_DATA_FILES='
Audio
Data
Fonts
Graphics
Languages
testing_saves
testing_saves_postgame
Wallpaper
_______.png'
CONTENT_DOC_DATA_PATH='usr/share/doc'
CONTENT_DOC_DATA_FILES='
*/copyright'

## The game engine fails to follow symlinks, leading to crashes
APP_MAIN_PREFIX_TYPE='none'
APP_MAIN_EXE='oneshot'
APP_MAIN_ICON='_______.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libcrypt.so.1
libc.so.6
libdbus-glib-1.so.2
libdl.so.2
libgcc_s.so.1
libgdk-x11-2.0.so.0
libgio-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Force the use of system-provided SDL
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
# Force the use of the system SDL library
export SDL_DYNAMIC_API='$(path_libraries_system)/libSDL2-2.0.so.0'
"

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
